/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "qdialogos.h"
#include <qglobal.h>
#include <qmessagebox.h>
#include <qstring.h>
#include <qfiledialog.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qurl.h>

#ifdef HAVE_KDELIBS3
#include <kfiledialog.h>
#endif

class Preview : public QLabel, public QFilePreview 
{
public:
	Preview( QWidget *parent=0 ) : QLabel( parent ) {
		setMinimumSize(40,40);
		setAlignment( AlignCenter | AlignHCenter | WordBreak );
	}

	void previewUrl( const QUrl &u ) {
		QString path = u.path();
		QPixmap pix( path );
		if ( pix.isNull() )
			setText( "Preview" );
		else
			setPixmap( pix );
	}
};



void Dialogos::mensaje( QWidget *parent, const QString& titulo, const QString& mensaje) {
	QMessageBox::warning( parent, titulo, mensaje );
}


QString Dialogos::cargar( const QString& initially, const QString& filter,
                          QWidget * parent, const char * name) {
#ifdef HAVE_KDELIBS3
	return KFileDialog::getOpenFileName( initially, filter, parent, name );
#else
	return QFileDialog::getOpenFileName( initially, filter, parent, name );
#endif
}

QString Dialogos::grabar( const QString & startWith,
                          const QString & filter,
                          QWidget * parent, const char * name) {
#ifdef HAVE_KDELIBS3
	return KFileDialog::getSaveFileName( startWith, filter, parent, name );
#else
	return QFileDialog::getSaveFileName( startWith, filter, parent, name );
#endif
}

QString Dialogos::cargarIcono( const QString& initially, const QString& filter,
                               QWidget * parent, const char * name) {
#ifdef HAVE_KDELIBS3
	return cargar( initially, filter, parent, name );
#else
	//return cargar( initially, filter, parent, name );
	QString resultado;
	QFileDialog *dialog = new QFileDialog( initially, filter, 0, name, true );
	Preview * preview_widget=new Preview(dialog);
	dialog->setContentsPreviewEnabled( true );
	dialog->setContentsPreview(preview_widget, preview_widget);
	dialog->setPreviewMode( QFileDialog::Contents );
	
	if (dialog->exec() == QFileDialog::Accepted) {
		resultado= dialog->selectedFile();
	}
	delete dialog;

	return resultado;
#endif
}

