/*
 * actions.c
 */

#include <stdlib.h>
#include "defines.h"
#include "variables.h"
#include "dialogs.h"
#include "mainwindow.h"
#include "tools.h"
#include "popedit.h"
#include "actions.h"


void quit_app()
{
        FREE(command);
        FREE(notif_cmd);
        FREE(config_file);
        FREE(light_color);
        free_mbox(&mboxes);
        gtk_main_quit();
}


void set_list()
{
        MailBox *box = mboxes;
        gchar *text_line[COLS];
        int row = 0, r = 0;

        gtk_clist_clear(GTK_CLIST(filelist));
        selected_row = -1;
        gtk_clist_freeze(GTK_CLIST(filelist));
        while (box)
        {
                text_line[0] = (r == boxnum) ? "X" : "";
                text_line[1] = box->type ? box->type : "ERROR";
                text_line[2] = box->entry ? box->entry : "ERROR";
                text_line[3] = box->username ? box->username : "";
                text_line[4] = box->password ? box->password : "";
                text_line[5] = box->folder ? box->folder : "";
                row = gtk_clist_append(GTK_CLIST(filelist), text_line);
                gtk_clist_set_row_data(GTK_CLIST(filelist), row, (gpointer)box);
                box = box->next;
                r++;
        }
        gtk_clist_thaw(GTK_CLIST(filelist));
        list_unsel_cb(GTK_CLIST(filelist), 0, 0, NULL, NULL);
}

void set_values()
{
        char text[MAXSTRLEN];

        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wid_backlight), backlight);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wid_blink),
                                     switch_authorized);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wid_runonce), run_once);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wid_testsize), test_size);
        if (light_color) gtk_entry_set_text(GTK_ENTRY(wid_color), light_color);
        if (command) gtk_entry_set_text(GTK_ENTRY(wid_command), command);
        if (notif_cmd) gtk_entry_set_text(GTK_ENTRY(wid_notify), notif_cmd);
        memset(text, 0, MAXSTRLEN);
        snprintf(text, MAXSTRLEN - 1, "%d", update_interval);
        gtk_entry_set_text(GTK_ENTRY(wid_interval), text);
        memset(text, 0, MAXSTRLEN);
        snprintf(text, MAXSTRLEN - 1, "%d", check_delay);
        gtk_entry_set_text(GTK_ENTRY(wid_checkdelay), text);

        set_list();
}


void save_datas()
{
        char *value = gtk_entry_get_text(GTK_ENTRY(wid_interval));

        update_interval = atoi(value);
        value = gtk_entry_get_text(GTK_ENTRY(wid_checkdelay));
        check_delay = atoi(value);
        light_color = gtk_entry_get_text(GTK_ENTRY(wid_color));
        command = gtk_entry_get_text(GTK_ENTRY(wid_command));
        notif_cmd = gtk_entry_get_text(GTK_ENTRY(wid_notify));
        backlight = GTK_TOGGLE_BUTTON(wid_backlight)->active;
        switch_authorized = GTK_TOGGLE_BUTTON(wid_blink)->active;
        run_once = GTK_TOGGLE_BUTTON(wid_runonce)->active;
        test_size = GTK_TOGGLE_BUTTON(wid_testsize)->active;

        save_cfgfile();
}


/* finition de la cration des nouvelles boites */

void do_add_box(const char *btype, const char *box)
{
        char *boxline = xmalloc(strlen(btype) + strlen(box) + 3);

        sprintf(boxline, "%s %s", btype, box);
        mbox_add(&mboxes, boxline);
        set_list();
        FREE(boxline);
}

void do_addmbox(GtkWidget *widget, void *fs)
{
        char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
        do_add_box("MBOX", filename);
}


void do_addmaildir(GtkWidget *widget, void *fs)
{
        char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
        do_add_box("MAILDIR", filename);
}


void do_addpop3(GtkWidget *widget, void *txt)
{
        char *datas = gtk_entry_get_text(GTK_ENTRY(txt));
        do_add_box("POP3", datas);
}


void do_addhotmail(GtkWidget *widget, void *txt)
{
        char *datas = gtk_entry_get_text(GTK_ENTRY(txt));
        do_add_box("HOTMAIL", datas);
}


void do_addmh(GtkWidget *widget, void *fs)
{
        char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
        do_add_box("MH", filename);
}


void do_addimap(GtkWidget *widget, void *txt)
{
        char *datas = gtk_entry_get_text(GTK_ENTRY(txt));
        do_add_box("IMAP", datas);
}


/* dialogues de cration de boites */

void add_mbox()
{
        file_dialog("Add local mail box...", NULL, NULL, do_addmbox, NULL);
}


void add_maildir()
{
        file_dialog("Add Maildir mail box...", NULL, NULL, do_addmaildir, NULL);
}


void add_pop3()
{
        pop_edit("Add POP3 mail box...", NULL, NULL, NULL, NULL, do_addpop3);
}


void add_hotmail()
{
        pop_edit("Add Hotmail mail box...", NULL, NULL, NULL, NULL, do_addhotmail);
}


void add_mh()
{
        file_dialog("Add MH mail box...", NULL, NULL, do_addmh, NULL);
}


void add_imap()
{
        pop_edit("Add IMAP mail box...", NULL, NULL, NULL, NULL, do_addimap);
}


/* fonctions de modifications d'entres */

void update_current_box(const char *e, const char *u, const char *p, const char *f)
{
        MailBox *box;

        box = (MailBox *)gtk_clist_get_row_data(GTK_CLIST(filelist), selected_row);
        FREE(box->entry);
        FREE(box->username);
        FREE(box->password);
        FREE(box->folder);
        box->entry = e ? xstrdup(e) : xstrdup("ERROR");
        box->username = u ? xstrdup(u) : NULL;
        box->password = p ? xstrdup(p) : NULL;
        box->folder = f ? xstrdup(f) : NULL;
        set_list();
}


void do_change_file(GtkWidget *widget, void *fs)
{
        char *filename = gtk_file_selection_get_filename(GTK_FILE_SELECTION(fs));
        update_current_box(filename, NULL, NULL, NULL);
}


void do_change_dist(GtkWidget *widget, void *txt)
{
        char *datas = gtk_entry_get_text(GTK_ENTRY(txt));
        char e[MAXSTRLEN + 1], u[MAXSTRLEN + 1];
        char p[MAXSTRLEN + 1], f[MAXSTRLEN + 1];

        sscanf(datas, "%s %s %s %s", e, u, p, f);
        update_current_box(e, u, p, f);
}


void edit_entry()
{
        MailBox *box;
        /*
                ok_dialog("Not yet implemented.",
                          "Sorry, this function is not yet implemented !");
        */
        box = (MailBox *)gtk_clist_get_row_data(GTK_CLIST(filelist), selected_row);
        if (strcmp(box->type, "MBOX") == 0)
                file_dialog("Edit local mail box...",
                            box->entry, NULL, do_change_file, NULL);
        if (strcmp(box->type, "MAILDIR") == 0)
                file_dialog("Edit Maildir mail box...",
                            box->entry, NULL, do_change_file, NULL);
        if (strcmp(box->type, "MH") == 0)
                file_dialog("Edit MH mail box...",
                            box->entry, NULL, do_change_file, NULL);
        if (strcmp(box->type, "IMAP") == 0)
                pop_edit("Edit IMAP mail box...",
                         box->entry, box->username, box->password, box->folder,
                         do_change_dist);
        if (strcmp(box->type, "POP3") == 0)
                pop_edit("Edit POP3 mail box...",
                         box->entry, box->username, box->password, box->folder,
                         do_change_dist);
        if (strcmp(box->type, "HOTMAIL") == 0)
                pop_edit("Edit Hotmail mail box...",
                         box->entry, box->username, box->password, box->folder,
                         do_change_dist);
}


void set_default()
{
        MailBox *def, *box;
        int num = 0, row;

        /* get previous default box */
        def = mboxes;
        while (num != boxnum)
        {
                def = def->next;
                num++;
        }
        /* get actual row for previous default box */
        row = gtk_clist_find_row_from_data(GTK_CLIST(filelist), (gpointer)def);
        /* get selected default box */
        box = (MailBox *)gtk_clist_get_row_data(GTK_CLIST(filelist), selected_row);
        /* set text in both rows */
        gtk_clist_set_text(GTK_CLIST(filelist), row, 0, "");
        gtk_clist_set_text(GTK_CLIST(filelist), selected_row, 0, "X");
        /* get new default box number */
        num = 0;
        def = mboxes;
        while (def && (def != box))
        {
                def = def->next;
                num++;
        }
        if (def && (def == box)) boxnum = num;
}


void remove_box()
{
        MailBox *def, *box, *prev;
        int num = 0;

        def = mboxes;
        while (num != boxnum)
        {
                def = def->next;
                num++;
        }

        box = (MailBox *)gtk_clist_get_row_data(GTK_CLIST(filelist), selected_row);
        if (def == box) boxnum = 0;
        prev = mboxes;
        while (prev && (prev->next != box))
        {
                prev = prev->next;
        }
        if (box == mboxes)
        {
                mboxes = box->next;
        }
        else if (prev != NULL)
        {
                prev->next = box->next;
        }
        else
        {
                fprintf(stderr, "Error when removing mail box...\n");
        }
        FREE(box->entry);
        FREE(box->username);
        FREE(box->password);
        FREE(box->folder);
        FREE(box);
        set_list();
}

