/*
 *  keys.h
 *
 *  This file is part of the WFA compression project
 *  Copyright (C) 1994-1998 Ullrich Hafner <hafner@bigfoot.de>,
 *                          department of computer science, chair II
 */

/*
 *  $Date: 2000/01/09 17:31:29 $
 *  $Author: hafner $
 *  $Revision: 1.7 $
 *  $State: Exp $
 */

#ifndef _KEYS_H
#define _KEYS_H

#include <gtk/gtk.h>
#include <proplist.h>

typedef struct key_widget
{
   GtkWidget	*control;
   GtkWidget	*shift;
   GtkWidget	*mod[5];
   GtkWidget	*lcontrol;
   GtkWidget	*lshift;
   GtkWidget	*lmod[5];
   GtkWidget	*keyname;
   GtkWidget	*combo;
   GtkWidget	*toggle;
   char		*keytext;
   void		*data;
   void		(*update) (const struct key_widget *);
} key_widget_t;

GtkWidget *
key_dialog (const char *keytext, GtkTooltips *tooltips, const char *infotext,
	    void (*update) (const key_widget_t *data), void *data);
void
update_keywidget (key_widget_t *kw, const char *keytext);
const char **
modifier_list (void);

#endif /* not _KEYS_H */

