#include <string.h>
#include <stdio.h>
#include "common.h"

char errmsg[256];
int CardInfo::counter;
int CardInfo::reverse=0;

//--------------------------

const char* Time::tostr() const {
  static char buf[20];
  
  if(tv.tv_sec==0) {
    strcpy(buf,"?");
  } else {
    time_t s=tv.tv_sec;
    tm* t=localtime(&s);

    sprintf(buf,"%.4i-%.2i-%-.2i %.2i:%.2i:%.2i", 
            t->tm_year+1900,t->tm_mon+1,t->tm_mday,t->tm_hour,t->tm_min,t->tm_sec);
  }
  	  
  return buf;	 
}     

//--------------------------

int int64_compare(const void* a,const void* b) {
  if(*((int64*)a) <= *((int64*)b))
    if(*((int64*)a) == *((int64*)b))
      return 0;
    else
      return -1;
  else
    return 1;
}

//--------------------------

const char* mac_addr::tostr() const {
  static char buf[MAC_ADDR_LEN*3+20];
  buf[0]='\x0';
  
  for(int a=0; a<MAC_ADDR_LEN; a++) {
    sprintf(buf+strlen(buf),"%.2x",ea.addr[a]);
    if(a!=MAC_ADDR_LEN-1) strcat(buf,":");
  }
  
  return buf;	   
}

int mac_addr::getmaxlen_tostr() {
  return MAC_ADDR_LEN*3-1;
}  

void mac_addr::setZero() {
  memset(&ea,0,sizeof(ea));
};  

int mac_addr::fromstr(const char* c) {

#if MAC_ADDR_LEN != 6
  #error Please adjust this code
#endif  

  unsigned a0,a1,a2,a3,a4,a5;
  if(sscanf(c,"%2x:%2x:%2x:%2x:%2x:%2x",&a0,&a1,&a2,&a3,&a4,&a5)==6) {
    ea.addr[0]=a0; ea.addr[1]=a1;
    ea.addr[2]=a2; ea.addr[3]=a3;
    ea.addr[4]=a4; ea.addr[5]=a5;
    return 0;
  } else
   return -1;
}

int mac_addr::isBrdCast() {
  for(int a=0; a<MAC_ADDR_LEN; a++) {
    if(ea.addr[a]!=0xff) return 0;
  }
  return 1;
}  

//--------------------------

const char* ip_addr::tostr(int comp) const {
  static char buf[42];
  unsigned long l=ntohl(ia.s_addr);
  
  buf[0]='\x0';
  for(int a=comp-1; a>=0; a--) {
    sprintf(buf+strlen(buf),"%i",(l>>(a*8)) & 0xFF);
    if(a!=0) strcat(buf,".");
  }
  
  return buf;
}

int ip_addr::getmaxlen_tostr(int comp) {
  return comp*4-1;
}

int ip_addr::fromstr(const char* c) {
  #ifdef USE_LIB_CONVERT
    return inet_aton(c,&ia) ? 0 : -1;
  #else
    unsigned a0,a1,a2,a3;
    if(sscanf(c,"%3u.%3u.%3u.%3u",&a0,&a1,&a2,&a3)==4) {
      ia.s_addr=htonl((a0<<24)+(a1<<16)+(a2<<8)+a3);
      return 0;
    } else {
      return -1;
    }
  #endif
}

void ip_addr::setZero() {
  memset(&ia,0,sizeof(ia));
};
