'\"
'\" Copyright (c) 1993-1997 Bell Labs Innovations for Lucent Technologies
'\" Copyright (c) 1997 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" RCS: @(#) $Id: namespace.n,v 1.1.1.1 2001/07/08 17:46:18 jwhite Exp $
'\" 
.so man.macros
.TH namespace n 8.0 Tcl "Tcl Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
namespace \- create and manipulate contexts for commands and variables
.SH SYNOPSIS
\fBnamespace \fR?\fIoption\fR? ?\fIarg ...\fR?
.BE

.SH DESCRIPTION
.PP
The \fBnamespace\fR command lets you create, access, and destroy
separate contexts for commands and variables.
See the section \fBWHAT IS A NAMESPACE?\fR below
for a brief overview of namespaces.
The legal \fIoption\fR's are listed below.
Note that you can abbreviate the \fIoption\fR's.
.TP
\fBnamespace children \fR?\fInamespace\fR? ?\fIpattern\fR?
Returns a list of all child namespaces that belong to the
namespace \fInamespace\fR.
If \fInamespace\fR is not specified,
then the children are returned for the current namespace.
This command returns fully-qualified names,
which start with \fB::\fR.
If the optional \fIpattern\fR is given,
then this command returns only the names that match the glob-style pattern.
The actual pattern used is determined as follows:
a pattern that starts with \fB::\fR is used directly,
otherwise the namespace \fInamespace\fR
(or the fully-qualified name of the current namespace)
is prepended onto the the pattern.
.TP
\fBnamespace code \fIscript\fR
Captures the current namespace context for later execution
of the script \fIscript\fR.
It returns a new script in which \fIscript\fR has been wrapped
in a \fBnamespace code\fR command.
The new script has two important properties.
First, it can be evaluated in any namespace and will cause
\fIscript\fR to be evaluated in the current namespace
(the one where the \fBnamespace code\fR command was invoked).
Second, additional arguments can be appended to the resulting script
and they will be passed to \fIscript\fR as additional arguments.
For example, suppose the command
\fBset script [namespace code {foo bar}]\fR
is invoked in namespace \fB::a::b\fR.
Then \fBeval "$script x y"\fR
can be executed in any namespace (assuming the value of
\fBscript\fR has been passed in properly)
and will have the same effect as the command
\fBnamespace eval ::a::b {foo bar x y}\fR.
This command is needed because
extensions like Tk normally execute callback scripts
in the global namespace.
A scoped command captures a command together with its namespace context
in a way that allows it to be executed properly later.
See the section \fBSCOPED VALUES\fR for some examples
of how this is used to create callback scripts.
.TP
\fBnamespace current\fR
Returns the fully-qualified name for the current namespace.
The actual name of the global namespace is ``''
(i.e., an empty string),
but this command returns \fB::\fR for the global namespace
as a convenience to programmers.
.TP
\fBnamespace delete \fR?\fInamespace namespace ...\fR?
Each namespace \fInamespace\fR is deleted
and all variables, procedures, and child namespaces
contained in the namespace are deleted.
If a procedure is currently executing inside the namespace,
the namespace will be kept alive until the procedure returns;
however, the namespace is marked to prevent other code from
looking it up by name.
If a namespace doesn't exist, this command returns an error.
If no namespace names are given, this command does nothing.
.TP
\fBnamespace eval\fR \fInamespace arg\fR ?\fIarg ...\fR?
Activates a namespace called \fInamespace\fR and evaluates some code
in that context.
If the namespace does not already exist, it is created.
If more than one \fIarg\fR argument is specified,
the arguments are concatenated together with a space between each one
in the same fashion as the \fBeval\fR command,
and the result is evaluated.
.br
.sp
If \fInamespace\fR has leading namespace qualifiers
and any leading namespaces do not exist,
they are automatically created.
.TP
\fBnamespace export \fR?\-\fBclear\fR? ?\fIpattern pattern ...\fR?
Specifies which commands are exported from a namespace.
The exported commands are those that can be later imported
into another namespace using a \fBnamespace import\fR command.
Both commands defined in a namespace and
commands the namespace has previously imported
can be exported by a namespace.
The commands do not have to be defined
at the time the \fBnamespace export\fR command is executed.
Each \fIpattern\fR may contain glob-style special characters,
but it may not include any namespace qualifiers.
That is, the pattern can only specify commands
in the current (exporting) namespace.
Each \fIpattern\fR is appended onto the namespace's list of export patterns.
If the \-\fBclear\fR flag is given,
the namespace's export pattern list is reset to empty before any
\fIpattern\fR arguments are appended.
If no \fIpattern\fRs are given and the \-\fBclear\fR flag isn't given,
this command returns the namespace's current export list.
.TP
\fBnamespace forget \fR?\fIpattern pattern ...\fR?
Removes previously imported commands from a namespace.
Each \fIpattern\fR is a qualified name such as
\fBfoo::x\fR or \fBa::b::p*\fR.
Qualified names contain \fB::\fRs and qualify a name
with the name of one or more namespaces.
Each \fIpattern\fR is qualified with the name of an exporting namespace
and may have glob-style special characters in the command name
at the end of the qualified name.
Glob characters may not appear in a namespace name.
This command first finds the matching exported commands.
It then checks whether any of those those commands
were previously imported by the current namespace.
If so, this command deletes the corresponding imported commands. 
In effect, this un-does the action of a \fBnamespace import\fR command.
.TP
\fBnamespace import \fR?\fB\-force\fR? ?\fIpattern\fR \fIpattern ...\fR?
Imports commands into a namespace.
Each \fIpattern\fR is a qualified name like
\fBfoo::x\fR or \fBa::p*\fR.
That is, it includes the name of an exporting namespace
and may have glob-style special characters in the command name
at the end of the qualified name.
Glob characters may not appear in a namespace name.
All the commands that match a \fIpattern\fR string
and which are currently exported from their namespace
are added to the current namespace.
This is done by creating a new command in the current namespace
that points to the exported command in its original namespace;
when the new imported command is called, it invokes the exported command.
This command normally returns an error
if an imported command conflicts with an existing command.
However, if the \-\fBforce\fR option is given,
imported commands will silently replace existing commands.
The \fBnamespace import\fR command has snapshot semantics:
that is, only requested commands that are currently defined
in the exporting namespace are imported.
In other words, you can import only the commands that are in a namespace
at the time when the \fBnamespace import\fR command is executed.
If another command is defined and exported in this namespace later on,
it will not be imported.
.TP
\fBnamespace inscope\fR \fInamespace arg\fR ?\fIarg ...\fR?
Executes a script in the context of a particular namespace.
This command is not expected to be used directly by programmers;
calls to it are generated implicitly when applications
use \fBnamespace code\fR commands to create callback scripts
that the applications then register with, e.g., Tk widgets.
The \fBnamespace inscope\fR command is much like the \fBnamespace eval\fR
command except that it has \fBlappend\fR semantics
and the namespace must already exist.
It treats the first argument as a list,
and appends any arguments after the first
onto the end as proper list elements.
\fBnamespace inscope ::foo a x y z\fR
is equivalent to
\fBnamespace eval ::foo [concat a [list x y z]]\fR
This \fBlappend\fR semantics is important because many callback scripts
are actually prefixes.
.TP
\fBnamespace origin \fIcommand\fR
Returns the fully-qualified name of the original command
to which the imported command \fIcommand\fR refers.
When a command is imported into a namespace,
a new command is created in that namespace
that points to the actual command in the exporting namespace.
If a command is imported into a sequence of namespaces
\fIa, b,...,n\fR where each successive namespace
just imports the command from the previous namespace,
this command returns the fully-qualified name of the original command
in the first namespace, \fIa\fR.
If \fIcommand\fR does not refer to an imported command,
the command's own fully-qualified name is returned.
.TP
\fBnamespace parent\fR ?\fInamespace\fR?
Returns the fully-qualified name of the parent namespace
for namespace \fInamespace\fR.
If \fInamespace\fR is not specified,
the fully-qualified name of the current namespace's parent is returned.
.TP
\fBnamespace qualifiers\fR \fIstring\fR
Returns any leading namespace qualifiers for \fIstring\fR.
Qualifiers are namespace names separated by \fB::\fRs.
For the \fIstring\fR \fB::foo::bar::x\fR,
this command returns \fB::foo::bar\fR,
and for \fB::\fR it returns an empty string.
This command is the complement of the \fBnamespace tail\fR command.
Note that it does not check whether the
namespace names are, in fact,
the names of currently defined namespaces.
.TP
\fBnamespace tail\fR \fIstring\fR
Returns the simple name at the end of a qualified string.
Qualifiers are namespace names separated by \fB::\fRs.
For the \fIstring\fR \fB::foo::bar::x\fR,
this command returns \fBx\fR,
and for \fB::\fR it returns an empty string.
This command is the complement of the \fBnamespace qualifiers\fR command.
It does not check whether the namespace names are, in fact,
the names of currently defined namespaces.
.TP
\fBnamespace which\fR ?\-\fBcommand\fR? ?\-\fBvariable\fR? \fIname\fR
Looks up \fIname\fR as either a command or variable
and returns its fully-qualified name.
For example, if \fIname\fR does not exist in the current namespace
but does exist in the global namespace,
this command returns a fully-qualified name in the global namespace.
If the command or variable does not exist,
this command returns an empty string.  If the variable has been
created but not defined, such as with the \fBvariable\fR command
or through a \fBtrace\fR on the variable, this command will return the 
fully-qualified name of the variable.
If no flag is given, \fIname\fR is treated as a command name.
See the section \fBNAME RESOLUTION\fR below for an explanation of
the rules regarding name resolution.

.SH "WHAT IS A NAMESPACE?"
.PP
A namespace is a collection of commands and variables.
It encapsulates the commands and variables to ensure that they
won't interfere with the commands and variables of other namespaces.
Tcl has always had one such collection,
which we refer to as the \fIglobal namespace\fR.
The global namespace holds all global variables and commands.
The \fBnamespace eval\fR command lets you create new namespaces.
For example,
.CS
\fBnamespace eval Counter {
    namespace export bump
    variable num 0

    proc bump {} {
        variable num
        incr num
    }
}\fR
.CE
creates a new namespace containing the variable \fBnum\fR and
the procedure \fBbump\fR.
The commands and variables in this namespace are separate from
other commands and variables in the same program.
If there is a command named \fBbump\fR in the global namespace,
for example, it will be different from the command \fBbump\fR
in the \fBCounter\fR namespace.
.PP
Namespace variables resemble global variables in Tcl.
They exist outside of the procedures in a namespace
but can be accessed in a procedure via the \fBvariable\fR command,
as shown in the example above.
.PP
Namespaces are dynamic.
You can add and delete commands and variables at any time,
so you can build up the contents of a
namespace over time using a series of \fBnamespace eval\fR commands.
For example, the following series of commands has the same effect
as the namespace definition shown above:
.CS
\fBnamespace eval Counter {
    variable num 0
    proc bump {} {
        variable num
        return [incr num]
    }
}
namespace eval Counter {
    proc test {args} {
        return $args
    }
}
namespace eval Counter {
    rename test ""
}\fR
.CE
Note that the \fBtest\fR procedure is added to the \fBCounter\fR namespace,
and later removed via the \fBrename\fR command.
.PP
Namespaces can have other namespaces within them,
so they nest hierarchically.
A nested namespace is encapsulated inside its parent namespace
and can not interfere with other namespaces.

.SH "QUALIFIED NAMES"
.PP
Each namespace has a textual name such as
\fBhistory\fR or \fB::safe::interp\fR.
Since namespaces may nest,
qualified names are used to refer to
commands, variables, and child namespaces contained inside namespaces.
Qualified names are similar to the hierarchical path names for
Unix files or Tk widgets,
except that \fB::\fR is used as the separator
instead of \fB/\fR or \fB.\fR.
The topmost or global namespace has the name ``'' (i.e., an empty string),
although \fB::\fR is a synonym.
As an example, the name \fB::safe::interp::create\fR
refers to the command \fBcreate\fR in the namespace \fBinterp\fR
that is a child of of namespace \fB::safe\fR,
which in turn is a child of the global namespace \fB::\fR.
.PP
If you want to access commands and variables from another namespace,
you must use some extra syntax.
Names must be qualified by the namespace that contains them.
From the global namespace,
we might access the \fBCounter\fR procedures like this:
.CS
\fBCounter::bump 5
Counter::Reset\fR
.CE
We could access the current count like this:
.CS
\fBputs "count = $Counter::num"\fR
.CE
When one namespace contains another, you may need more than one
qualifier to reach its elements.
If we had a namespace \fBFoo\fR that contained the namespace \fBCounter\fR,
you could invoke its \fBbump\fR procedure
from the global namespace like this:
.CS
\fBFoo::Counter::bump 3\fR
.CE
.PP
You can also use qualified names when you create and rename commands.
For example, you could add a procedure to the \fBFoo\fR
namespace like this:
.CS
\fBproc Foo::Test {args} {return $args}\fR
.CE
And you could move the same procedure to another namespace like this:
.CS
\fBrename Foo::Test Bar::Test\fR
.CE
.PP
There are a few remaining points about qualified names
that we should cover.
Namespaces have nonempty names except for the global namespace.
\fB::\fR is disallowed in simple command, variable, and namespace names
except as a namespace separator.
Extra \fB:\fRs in a qualified name are ignored;
that is, two or more \fB:\fRs are treated as a namespace separator.
A trailing \fB::\fR in a qualified variable or command name
refers to the variable or command named {}.
However, a trailing \fB::\fR in a qualified namespace name is ignored.

.SH "NAME RESOLUTION"
.PP
In general, all Tcl commands that take variable and command names
support qualified names.
This means you can give qualified names to such commands as
\fBset\fR, \fBproc\fR, \fBrename\fR, and \fBinterp alias\fR.
If you provide a fully-qualified name that starts with a \fB::\fR,
there is no question about what command, variable, or namespace
you mean.
However, if the name does not start with a \fB::\fR
(i.e., is \fIrelative\fR), 
Tcl follows a fixed rule for looking it up:
Command and variable names are always resolved
by looking first in the current namespace,
and then in the global namespace.
Namespace names, on the other hand, are always resolved
by looking in only the current namespace.
.PP
In the following example,
.CS
\fBset traceLevel 0
namespace eval Debug {
    printTrace $traceLevel
}\fR
.CE
Tcl looks for \fBtraceLevel\fR in the namespace \fBDebug\fR
and then in the global namespace.
It looks up the command \fBprintTrace\fR in the same way.
If a variable or command name is not found in either context,
the name is undefined.
To make this point absolutely clear, consider the following example:
.CS
\fBset traceLevel 0
namespace eval Foo {
    variable traceLevel 3

    namespace eval Debug {
        printTrace $traceLevel
    }
}\fR
.CE
Here Tcl looks for \fBtraceLevel\fR first in the namespace \fBFoo::Debug\fR.
Since it is not found there, Tcl then looks for it 
in the global namespace.
The variable \fBFoo::traceLevel\fR is completely ignored
during the name resolution process.
.PP
You can use the \fBnamespace which\fR command to clear up any question
about name resolution.
For example, the command:
.CS
\fBnamespace eval Foo::Debug {namespace which \-variable traceLevel}\fR
.CE
returns \fB::traceLevel\fR.
On the other hand, the command,
.CS
\fBnamespace eval Foo {namespace which \-variable traceLevel}\fR
.CE
returns \fB::Foo::traceLevel\fR.
.PP
As mentioned above,
namespace names are looked up differently
than the names of variables and commands.
Namespace names are always resolved in the current namespace.
This means, for example,
that a \fBnamespace eval\fR command that creates a new namespace
always creates a child of the current namespace
unless the new namespace name begins with a \fB::\fR.
.PP
Tcl has no access control to limit what variables, commands,
or namespaces you can reference.
If you provide a qualified name that resolves to an element
by the name resolution rule above,
you can access the element.
.PP
You can access a namespace variable
from a procedure in the same namespace
by using the \fBvariable\fR command.
Much like the \fBglobal\fR command,
this creates a local link to the namespace variable.
If necessary, it also creates the variable in the current namespace
and initializes it.
Note that the \fBglobal\fR command only creates links
to variables in the global namespace.
It is not necessary to use a \fBvariable\fR command
if you always refer to the namespace variable using an
appropriate qualified name.

.SH "IMPORTING COMMANDS"
.PP
Namespaces are often used to represent libraries.
Some library commands are used so frequently
that it is a nuisance to type their qualified names.
For example, suppose that all of the commands in a package
like BLT are contained in a namespace called \fBBlt\fR.
Then you might access these commands like this:
.CS
\fBBlt::graph .g \-background red
Blt::table . .g 0,0\fR
.CE
If you use the \fBgraph\fR and \fBtable\fR commands frequently,
you may want to access them without the \fBBlt::\fR prefix.
You can do this by importing the commands into the current namespace,
like this:
.CS
\fBnamespace import Blt::*\fR
.CE
This adds all exported commands from the \fBBlt\fR namespace
into the current namespace context, so you can write code like this:
.CS
\fBgraph .g \-background red
table . .g 0,0\fR
.CE
The \fBnamespace import\fR command only imports commands
from a namespace that that namespace exported
with a \fBnamespace export\fR command.
.PP
Importing \fIevery\fR command from a namespace is generally
a bad idea since you don't know what you will get.
It is better to import just the specific commands you need.
For example, the command
.CS
\fBnamespace import Blt::graph Blt::table\fR
.CE
imports only the \fBgraph\fR and \fBtable\fR commands into the
current context.
.PP
If you try to import a command that already exists, you will get an
error.  This prevents you from importing the same command from two
different packages.  But from time to time (perhaps when debugging),
you may want to get around this restriction.  You may want to
reissue the \fBnamespace import\fR command to pick up new commands
that have appeared in a namespace.  In that case, you can use the
\fB\-force\fR option, and existing commands will be silently overwritten:
.CS
\fBnamespace import \-force Blt::graph Blt::table\fR
.CE
If for some reason, you want to stop using the imported commands,
you can remove them with an \fBnamespace forget\fR command, like this:
.CS
\fBnamespace forget Blt::*\fR
.CE
This searches the current namespace for any commands imported from \fBBlt\fR.
If it finds any, it removes them.  Otherwise, it does nothing.
After this, the \fBBlt\fR commands must be accessed with the \fBBlt::\fR
prefix.
.PP
When you delete a command from the exporting namespace like this:
.CS
\fBrename Blt::graph ""\fR
.CE
the command is automatically removed from all namespaces that import it.

.SH "EXPORTING COMMANDS"
You can export commands from a namespace like this:
.CS
\fBnamespace eval Counter {
    namespace export bump reset
    variable Num 0
    variable Max 100

    proc bump {{by 1}} {
        variable Num
        incr Num $by
        Check
        return $Num
    }
    proc reset {} {
        variable Num
        set Num 0
    }
    proc Check {} {
        variable Num
        variable Max
        if {$Num > $Max} {
            error "too high!"
        }
    }
}\fR
.CE
The procedures \fBbump\fR and \fBreset\fR are exported,
so they are included when you import from the \fBCounter\fR namespace,
like this:
.CS
\fBnamespace import Counter::*\fR
.CE
However, the \fBCheck\fR procedure is not exported,
so it is ignored by the import operation.
.PP
The \fBnamespace import\fR command only imports commands
that were declared as exported by their namespace.
The \fBnamespace export\fR command specifies what commands
may be imported by other namespaces.
If a \fBnamespace import\fR command specifies a command
that is not exported, the command is not imported.

.SH "SEE ALSO"
variable(n)

.SH KEYWORDS
exported, internal, variable
