#!/bin/sh
#----------------------------------------------------------------------------
#  build.sh
#   This script will perform the standard configure and make
#  instructions requried to build the tcl/tk static support  
#  libraries generally used in CodeWeavers config tools
#  (e.g. winesetuptk, pluginsetup)
#----------------------------------------------------------------------------
prefix=$PWD/local

(cd tcl8.3.2/unix && ./configure --disable-shared --prefix=$prefix && make install)
if test $? -ne 0 ; then exit 1 ; fi

(cd tk8.3.2/unix && ./configure --disable-shared --prefix=$prefix --with-tcl=$prefix/lib && make install)
if test $? -ne 0 ; then exit 1 ; fi

(cd itcl3.1.0 && ./configure --disable-shared --prefix=$prefix --with-tcl=$prefix/lib --with-tk=$prefix/lib && make && make install)
if test $? -ne 0 ; then exit 1 ; fi

(cd mktclapp && make install)
if test $? -ne 0 ; then exit 1 ; fi
