package tapi32;

use strict;

require Exporter;

use wine;
use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);
@EXPORT = qw();
@EXPORT_OK = qw();

my $module_declarations = {
    "lineAccept" => ["long",  ["long", "str", "long"]],
    "lineAddProvider" => ["long",  ["str", "long", "ptr"]],
    "lineAddToConference" => ["long",  ["long", "long"]],
    "lineAnswer" => ["long",  ["long", "str", "long"]],
    "lineBlindTransfer" => ["long",  ["long", "str", "long"]],
    "lineClose" => ["long",  ["long"]],
    "lineCompleteCall" => ["long",  ["long", "ptr", "long", "long"]],
    "lineCompleteTransfer" => ["long",  ["long", "long", "ptr", "long"]],
    "lineConfigDialog" => ["long",  ["long", "long", "str"]],
    "lineConfigDialogEdit" => ["long",  ["long", "long", "str", "ptr", "long", "ptr"]],
    "lineConfigProvider" => ["long",  ["long", "long"]],
    "lineDeallocateCall" => ["long",  ["long"]],
    "lineDevSpecific" => ["long",  ["long", "long", "long", "ptr", "long"]],
    "lineDevSpecificFeature" => ["long",  ["long", "long", "ptr", "long"]],
    "lineDial" => ["long",  ["long", "str", "long"]],
    "lineDrop" => ["long",  ["long", "str", "long"]],
    "lineForward" => ["long",  ["long", "long", "long", "ptr", "long", "ptr", "ptr"]],
    "lineGatherDigits" => ["long",  ["long", "long", "str", "long", "str", "long", "long"]],
    "lineGenerateDigits" => ["long",  ["long", "long", "str", "long"]],
    "lineGenerateTone" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "lineGetAddressCaps" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "lineGetAddressID" => ["long",  ["long", "ptr", "long", "str", "long"]],
    "lineGetAddressStatus" => ["long",  ["long", "long", "ptr"]],
    "lineGetAppPriority" => ["long",  ["str", "long", "ptr", "long", "ptr", "ptr"]],
    "lineGetCallInfo" => ["long",  ["long", "ptr"]],
    "lineGetCallStatus" => ["long",  ["long", "ptr"]],
    "lineGetConfRelatedCalls" => ["long",  ["long", "ptr"]],
    "lineGetCountry" => ["long",  ["long", "long", "ptr"]],
    "lineGetDevCaps" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "lineGetDevConfig" => ["long",  ["long", "ptr", "str"]],
    "lineGetID" => ["long",  ["long", "long", "long", "long", "ptr", "str"]],
    "lineGetIcon" => ["long",  ["long", "str", "ptr"]],
    "lineGetLineDevStatus" => ["long",  ["long", "ptr"]],
    "lineGetNewCalls" => ["long",  ["long", "long", "long", "ptr"]],
    "lineGetNumRings" => ["long",  ["long", "long", "ptr"]],
    "lineGetProviderList" => ["long",  ["long", "ptr"]],
    "lineGetRequest" => ["long",  ["long", "long", "ptr"]],
    "lineGetStatusMessages" => ["long",  ["long", "ptr", "ptr"]],
    "lineGetTranslateCaps" => ["long",  ["long", "long", "ptr"]],
    "lineHandoff" => ["long",  ["long", "str", "long"]],
    "lineHold" => ["long",  ["long"]],
    "lineInitialize" => ["long",  ["ptr", "long", "ptr", "str", "ptr"]],
    "lineMakeCall" => ["long",  ["long", "ptr", "str", "long", "ptr"]],
    "lineMonitorDigits" => ["long",  ["long", "long"]],
    "lineMonitorMedia" => ["long",  ["long", "long"]],
    "lineMonitorTones" => ["long",  ["long", "ptr", "long"]],
    "lineNegotiateAPIVersion" => ["long",  ["long", "long", "long", "long", "ptr", "ptr"]],
    "lineNegotiateExtVersion" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "lineOpen" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long", "long", "ptr"]],
    "linePark" => ["long",  ["long", "long", "str", "ptr"]],
    "linePickup" => ["long",  ["long", "long", "ptr", "str", "str"]],
    "linePrepareAddToConference" => ["long",  ["long", "ptr", "ptr"]],
    "lineRedirect" => ["long",  ["long", "str", "long"]],
    "lineRegisterRequestRecipient" => ["long",  ["long", "long", "long", "long"]],
    "lineReleaseUserUserInfo" => ["long",  ["long"]],
    "lineRemoveFromConference" => ["long",  ["long"]],
    "lineRemoveProvider" => ["long",  ["long", "long"]],
    "lineSecureCall" => ["long",  ["long"]],
    "lineSendUserUserInfo" => ["long",  ["long", "str", "long"]],
    "lineSetAppPriority" => ["long",  ["str", "long", "ptr", "long", "str", "long"]],
    "lineSetAppSpecific" => ["long",  ["long", "long"]],
    "lineSetCallParams" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "lineSetCallPrivilege" => ["long",  ["long", "long"]],
    "lineSetCurrentLocation" => ["long",  ["long", "long"]],
    "lineSetDevConfig" => ["long",  ["long", "ptr", "long", "str"]],
    "lineSetMediaControl" => ["long",  ["long", "long", "long", "long", "ptr", "long", "ptr", "long", "ptr", "long", "ptr", "long"]],
    "lineSetMediaMode" => ["long",  ["long", "long"]],
    "lineSetNumRings" => ["long",  ["long", "long", "long"]],
    "lineSetStatusMessages" => ["long",  ["long", "long", "long"]],
    "lineSetTerminal" => ["long",  ["long", "long", "long", "long", "long", "long", "long"]],
    "lineSetTollList" => ["long",  ["long", "long", "str", "long"]],
    "lineSetupConference" => ["long",  ["long", "long", "ptr", "ptr", "long", "ptr"]],
    "lineSetupTransfer" => ["long",  ["long", "ptr", "ptr"]],
    "lineShutdown" => ["long",  ["long"]],
    "lineSwapHold" => ["long",  ["long", "long"]],
    "lineTranslateAddress" => ["long",  ["long", "long", "long", "str", "long", "long", "ptr"]],
    "lineTranslateDialog" => ["long",  ["long", "long", "long", "long", "str"]],
    "lineUncompleteCall" => ["long",  ["long", "long"]],
    "lineUnhold" => ["long",  ["long"]],
    "lineUnpark" => ["long",  ["long", "long", "ptr", "str"]],
    "phoneClose" => ["long",  ["long"]],
    "phoneConfigDialog" => ["long",  ["long", "long", "str"]],
    "phoneDevSpecific" => ["long",  ["long", "ptr", "long"]],
    "phoneGetButtonInfo" => ["long",  ["long", "long", "ptr"]],
    "phoneGetData" => ["long",  ["long", "long", "ptr", "long"]],
    "phoneGetDevCaps" => ["long",  ["long", "long", "long", "long", "ptr"]],
    "phoneGetDisplay" => ["long",  ["long", "ptr"]],
    "phoneGetGain" => ["long",  ["long", "long", "ptr"]],
    "phoneGetHookSwitch" => ["long",  ["long", "ptr"]],
    "phoneGetID" => ["long",  ["long", "ptr", "str"]],
    "phoneGetIcon" => ["long",  ["long", "str", "ptr"]],
    "phoneGetLamp" => ["long",  ["long", "long", "ptr"]],
    "phoneGetRing" => ["long",  ["long", "ptr", "ptr"]],
    "phoneGetStatus" => ["long",  ["long", "ptr"]],
    "phoneGetStatusMessages" => ["long",  ["long", "ptr", "ptr", "ptr"]],
    "phoneGetVolume" => ["long",  ["long", "long", "ptr"]],
    "phoneInitialize" => ["long",  ["ptr", "long", "ptr", "str", "ptr"]],
    "phoneNegotiateAPIVersion" => ["long",  ["long", "long", "long", "long", "ptr", "ptr"]],
    "phoneNegotiateExtVersion" => ["long",  ["long", "long", "long", "long", "long", "ptr"]],
    "phoneOpen" => ["long",  ["long", "long", "ptr", "long", "long", "long", "long"]],
    "phoneSetButtonInfo" => ["long",  ["long", "long", "ptr"]],
    "phoneSetData" => ["long",  ["long", "long", "ptr", "long"]],
    "phoneSetDisplay" => ["long",  ["long", "long", "long", "str", "long"]],
    "phoneSetGain" => ["long",  ["long", "long", "long"]],
    "phoneSetHookSwitch" => ["long",  ["long", "long", "long"]],
    "phoneSetLamp" => ["long",  ["long", "long", "long"]],
    "phoneSetRing" => ["long",  ["long", "long", "long"]],
    "phoneSetStatusMessages" => ["long",  ["long", "long", "long", "long"]],
    "phoneSetVolume" => ["long",  ["long", "long", "long"]],
    "phoneShutdown" => ["long",  ["long"]],
    "tapiGetLocationInfo" => ["long",  ["str", "str"]],
    "tapiRequestMakeCall" => ["long",  ["str", "str", "str", "str"]]
};

&wine::declare("tapi32",%$module_declarations);
push @EXPORT, map { "&" . $_; } sort(keys(%$module_declarations));
1;
