/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import org.freehep.graphicsio.font.truetype.TTFInput;

public class TTFMemoryInput
extends TTFInput {
    private byte[] data;
    private int pointer;

    public TTFMemoryInput(byte[] byArray) {
        this.data = byArray;
    }

    public void seek(long l2) {
        this.pointer = (int)l2;
    }

    long getPointer() {
        return this.pointer;
    }

    public byte readChar() {
        return this.data[this.pointer++];
    }

    public int readRawByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    public int readByte() {
        return this.data[this.pointer++] & 0xFF;
    }

    public short readShort() {
        byte by = this.data[this.pointer++];
        return (short)(by << 8 | this.data[this.pointer++]);
    }

    public int readUShort() {
        return this.data[this.pointer++] << 8 | this.data[this.pointer++];
    }

    public int readLong() {
        byte by = this.data[this.pointer++];
        return (short)(by << 24 | this.data[this.pointer++] << 16 | this.data[this.pointer++] << 8 | this.data[this.pointer++]);
    }

    public long readULong() {
        byte[] byArray = new byte[4];
        this.readFully(byArray);
        long l2 = 0L;
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            l2 |= (long)((byArray[3 - i2] & 0xFF) << 8 * i2);
        }
        return l2;
    }

    public void readFully(byte[] byArray) {
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.data[this.pointer++];
        }
    }
}

