/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.font.truetype;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.freehep.graphicsio.font.truetype.TTFInput;
import org.freehep.graphicsio.font.truetype.TTFTable;

public abstract class TTFFont {
    private Map entry = new HashMap();

    public abstract int getFontVersion();

    void newTable(String string, TTFInput tTFInput) throws IOException {
        this.entry.put(string, this.initTable(string, tTFInput));
    }

    private Object initTable(String string, TTFInput tTFInput) throws IOException {
        TTFTable tTFTable = null;
        for (int i2 = 0; i2 < TTFTable.TT_TAGS.length; ++i2) {
            if (!string.equals(TTFTable.TT_TAGS[i2])) continue;
            try {
                tTFTable = (TTFTable)TTFTable.TABLE_CLASSES[i2].newInstance();
                tTFTable.init(this, tTFInput);
                return tTFTable;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return null;
            }
        }
        System.err.println("Table '" + string + "' ignored.");
        return null;
    }

    public void show() {
        System.out.println("Tables:");
        Iterator iterator = this.entry.values().iterator();
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public TTFTable getTable(String string) throws IOException {
        TTFTable tTFTable = (TTFTable)this.entry.get(string);
        if (!tTFTable.isRead()) {
            tTFTable.read();
        }
        return tTFTable;
    }

    public void readAll() throws IOException {
        Iterator iterator = this.entry.values().iterator();
        while (iterator.hasNext()) {
            TTFTable tTFTable = (TTFTable)iterator.next();
            if (tTFTable == null || tTFTable.isRead()) continue;
            tTFTable.read();
        }
    }

    public void close() throws IOException {
    }
}

