/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.IOException;
import java.io.OutputStream;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.graphics.EPSGraphics;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.objects.ConstructionObject;

public class MyGraphicsEPS
extends MyGraphics {
    EPSGraphics G;
    public static int MaxR = 1000000;
    double LineWidth = 1.0;
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsEPS(OutputStream outputStream, int n, int n2) {
        this.G = new EPSGraphics(outputStream, n, n2, 0, true);
    }

    public void setLineWidth(double d2) {
        this.LineWidth = d2;
        this.G.setLineWidth(d2);
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
        this.G.setColor(color);
        this.G.fillRect(n, n2, n3, n4);
    }

    public void setColor(Color color) {
        this.G.setColor(color);
    }

    public void setColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.getColorType() == 2) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setFillColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.getColorType() != 1) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            this.setColor(constructionObject);
            constructionObject.setColorType(n);
        } else {
            this.setColor(constructionObject);
        }
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.G.drawRect(d2, d3, d4, d5);
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        if (constructionObject.getColorType() == 1) {
            this.drawThickLine(d2, d3, d4, d5);
        } else if (constructionObject.getColorType() == 2) {
            this.drawThinLine(d2, d3, d4, d5);
        } else {
            this.drawLine(d2, d3, d4, d5);
        }
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.G.drawLine(d2, d3, d4, d5);
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.G.drawLine(d2, d3, d4, d5);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinLine(double d2, double d3, double d4, double d5) {
        this.G.setDash(4.0, 4.0);
        this.G.drawLine(d2, d3, d4, d5);
        this.G.clearDash();
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.G.drawArc(d2, d3, d4, d5, d6, d7);
    }

    public void drawThickArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.G.setLineWidth(3.0 * this.LineWidth);
        this.drawArc(d2 + 1.0, d3 + 1.0, d4 - 2.0, d4 - 2.0, d6, d7);
        this.G.setLineWidth(this.LineWidth);
    }

    public void drawThinArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.G.setDash(4.0, 4.0);
        this.drawArc(d2 + 1.0, d3 + 1.0, d4 - 2.0, d4 - 2.0, d6, d7);
        this.G.clearDash();
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        if (constructionObject.getColorType() == 1) {
            this.drawThickArc(d2, d3, d4, d5, d6, d7);
        } else if (constructionObject.getColorType() == 2) {
            this.drawThinArc(d2, d3, d4, d5, d6, d7);
        } else {
            this.drawArc(d2, d3, d4, d5, d6, d7);
        }
    }

    public void drawString(String string, double d2, double d3) {
        this.G.drawString(string, d2, d3);
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        if (d4 < (double)MaxR) {
            this.G.drawOval(d2, d3, d4, d5);
        }
    }

    public void drawThickOval(double d2, double d3, double d4, double d5) {
        this.drawOval(d2, d3, d4, d5);
        this.drawOval(d2 - 1.0, d3 - 1.0, d4 + 2.0, d5 + 2.0);
        this.drawOval(d2 + 1.0, d3 + 1.0, d4 - 2.0, d5 - 2.0);
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.setColor(constructionObject);
        if (constructionObject.getColorType() == 1) {
            this.drawThickOval(d2, d3, d4, d5);
        } else {
            this.drawOval(d2, d3, d4, d5);
        }
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        this.G.fillRect(d2, d3, d4, d5);
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawRect(d2, d3, d4, d5);
        }
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        if (bl3) {
            this.G.fillArc(d2, d3, d4, d5, d6, d7);
        } else {
            this.G.fillChord(d2, d3, d4, d5, d6, d7);
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawArc(d2, d3, d4, d5, d6, d7);
        }
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        if (d4 >= (double)MaxR) {
            return;
        }
        this.setFillColor(constructionObject);
        this.G.fillOval(d2, d3, d4, d5);
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawOval(d2, d3, d4, d5);
        }
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        if (constructionObject.getColorType() != 3) {
            this.setFillColor(constructionObject);
            this.G.fillPolygon(dArray, dArray2, n);
        }
        if (bl) {
            this.setColor(constructionObject);
            this.G.drawPolygon(dArray, dArray2, n);
        }
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
    }

    public void close() throws IOException {
        this.G.close();
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public void setFont(int n, boolean bl) {
        this.G.setFont(new Font(Global.getParameter("font.name", "dialog"), bl ? 1 : 0, n));
    }

    public FontMetrics getFontMetrics() {
        return this.G.getFontMetrics();
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String string) {
        return this.getFontMetrics().stringWidth(string);
    }

    public int stringHeight(String string) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String string, double d2, double d3) {
        this.drawString(string, d2, d3 + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String string) {
        return this.getFontMetrics().getAscent();
    }
}

