/*
 * Decompiled with CFR 0.152.
 */
package rene.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Calendar;
import rene.util.PngEncoder;

public class TestEncoder
extends Frame {
    String message;
    String timeStr;
    Image clockImage = null;
    int hour;
    int minute;
    boolean encodeAlpha;
    int filter;
    int compressionLevel;
    int pixelDepth;
    String filename;
    boolean fileSaved = false;

    public TestEncoder(String string) {
        super(string);
        this.setSize(200, 200);
    }

    public void drawClockImage(int n, int n2) {
        Font font = new Font("Helvetica", 0, 9);
        Graphics graphics = this.clockImage.getGraphics();
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        if (n < 12) {
            graphics.setColor(new Color(255, 255, 192));
        } else {
            graphics.setColor(new Color(192, 192, 255));
        }
        graphics.fillOval(10, 10, 80, 80);
        graphics.setColor(Color.black);
        graphics.drawOval(10, 10, 80, 80);
        graphics.drawOval(48, 48, 4, 4);
        graphics.setFont(font);
        graphics.drawString("12", 50 - fontMetrics.stringWidth("12") / 2, 11 + fontMetrics.getAscent());
        graphics.drawString("3", 88 - fontMetrics.stringWidth("3"), 50 + fontMetrics.getAscent() / 2);
        graphics.drawString("6", 50 - fontMetrics.stringWidth("6") / 2, 88);
        graphics.drawString("9", 12, 50 + fontMetrics.getAscent() / 2);
        int n3 = 50;
        int n4 = 50;
        double d2 = -((n %= 12) * 30 + n2 / 2) + 90;
        int n5 = (int)((double)n3 + 28.0 * Math.cos(d2 *= Math.PI / 180));
        int n6 = (int)((double)n4 - 28.0 * Math.sin(d2));
        graphics.drawLine(n3, n4, n5, n6);
        d2 = -(n2 * 6) + 90;
        d2 = d2 * Math.PI / 180.0;
        n5 = (int)((double)n3 + 35.0 * Math.cos(d2));
        n6 = (int)((double)n4 - 35.0 * Math.sin(d2));
        graphics.drawLine(n3, n4, n5, n6);
    }

    public void addAlphaToImage() {
        int n = 100;
        int n2 = 100;
        int n3 = 0;
        int[] nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(this.clockImage, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        for (int i = 0; i < n * n2; ++i) {
            if (i % n == 0) {
                n3 = n3 >> 24 & 0xFF;
                if ((n3 += 2) > 255) {
                    n3 = 255;
                }
                n3 = n3 << 24 & 0xFF000000;
            }
            nArray[i] = nArray[i] & 0xFFFFFF | n3;
        }
        this.clockImage = this.createImage(new MemoryImageSource(n, n2, nArray, 0, n));
    }

    public void paint(Graphics graphics) {
        if (this.clockImage == null) {
            this.clockImage = this.createImage(100, 100);
        }
        if (this.clockImage != null) {
            if (!this.fileSaved) {
                this.drawClockImage(this.hour, this.minute);
                if (this.encodeAlpha) {
                    this.addAlphaToImage();
                }
                this.saveClockImage();
                this.fileSaved = true;
            }
            graphics.drawImage(this.clockImage, 50, 20, null);
        }
        if (this.message != null) {
            graphics.drawString(this.message, 10, 140);
        }
    }

    protected static void usage() {
        System.out.print("Usage: TestEncoder -alpha -filter n -compress c");
        System.out.println("-alpha means to use alpha encoding (default none)");
        System.out.println("n is filter number 0=none (default), 1=sub, 2=up");
        System.out.println("c is compression factor (0-9); 1 default");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        TestEncoder testEncoder = new TestEncoder("Test PNG Alpha/Filter Encoder");
        int n = 0;
        testEncoder.encodeAlpha = false;
        testEncoder.filter = 0;
        testEncoder.pixelDepth = 24;
        testEncoder.compressionLevel = 1;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-alpha")) {
                testEncoder.encodeAlpha = true;
                ++n;
                continue;
            }
            if (stringArray[n].equals("-filter")) {
                if (n != stringArray.length - 1) {
                    try {
                        testEncoder.filter = Integer.parseInt(stringArray[n + 1]);
                    }
                    catch (Exception exception) {
                        TestEncoder.usage();
                        break;
                    }
                }
                n += 2;
                continue;
            }
            if (stringArray[n].equals("-compress")) {
                if (n != stringArray.length - 1) {
                    try {
                        testEncoder.compressionLevel = Integer.parseInt(stringArray[n + 1]);
                    }
                    catch (Exception exception) {
                        TestEncoder.usage();
                        break;
                    }
                }
                n += 2;
                continue;
            }
            TestEncoder.usage();
            break;
        }
        if (testEncoder.pixelDepth == 8) {
            testEncoder.encodeAlpha = false;
        }
        testEncoder.doYourThing();
    }

    public void doYourThing() {
        Calendar calendar = Calendar.getInstance();
        this.hour = calendar.get(10);
        if (calendar.get(9) == 1) {
            this.hour += 12;
        }
        this.hour %= 24;
        this.minute = calendar.get(12);
        this.timeStr = Integer.toString(this.minute);
        if (this.minute < 10) {
            this.timeStr = "0" + this.timeStr;
        }
        this.timeStr = Integer.toString(this.hour) + this.timeStr;
        if (this.hour < 10) {
            this.timeStr = "0" + this.timeStr;
        }
        this.filename = this.encodeAlpha ? "alphaclock" : "clock";
        this.filename = this.filename + this.timeStr + "_f" + this.filter + this.compressionLevel + ".png";
        this.message = "File: " + this.filename;
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        };
        this.addWindowListener(windowAdapter);
        this.show();
    }

    public void saveClockImage() {
        PngEncoder pngEncoder = new PngEncoder(this.clockImage, this.encodeAlpha, this.filter, this.compressionLevel);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.filename);
            byte[] byArray = pngEncoder.pngEncode();
            if (byArray == null) {
                System.out.println("Null image");
            } else {
                fileOutputStream.write(byArray);
            }
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

