target= tabvaleur1 tabvaleur2 tabvaleur3

\language{fr}
\range{-5..5}
\author{Fabrice Guerimand}
\email{fwguerima@free.fr}
\computeanswer{no}
\format{html}
\precision{10000}


#if #TARGET(tabvaleur1)
 \title{Tableau de valeurs (cas linaire)}
 \integer{lcoef=randint(1..3)}
\text{lcoef=3}
 \text{fonction=\lcoef*x}
 \real{xmin=0}
 \real{xmax=min(10/\lcoef,10)}
#endif

#if #TARGET(tabvaleur2)
 \title{Tableau de valeurs (cas affine)}
 \integer{a=randitem(2,-2,3,-3)}
 \text{lcoef=randint(1..3)}
 \text{fonction=\lcoef*x+\a}
 \real{xmin=max(0,-\a/\lcoef)}
 \real{xmax=min((10-\a)/\lcoef,10)}
#endif

#if #TARGET(tabvaleur3)
 \title{Tableau de valeurs (quelconque)}
 \text{lcoef=randint(1..4)}
 \text{fonction=\lcoef/10*x^2,\lcoef*sqrt(x)}
 \integer{ch=randitem(1,2)}
 \text{fonction=item(\ch,\fonction)}
 \real{xmin=1}
 \if{\ch=2}{
  \real{xmax=min(10,(10/\lcoef)^2)}
 }{
  \real{xmax=min(sqrt(100/\lcoef),10)}
 }
#endif

\text{size=6}

\text{dessin=slib(draw/repere 500,500,20,0,10,0,10,0.2,0.2,black,grey)}
\text{tmp=row(1,\dessin)}
\text{ox=item(1,\tmp)}
\text{oy=item(2,\tmp)}
\text{tmp=row(2,\dessin)}
\text{ex=item(1,\tmp)}
\text{ey=item(2,\tmp)}
\text{dessin=wims(line 3 to -1 of \dessin)}
\text{dessin=\dessin
text black,\ox-10,\oy+2,medium,O
text black,\ox+\ex-5,\oy+2,medium,1
text black,\ox-10,\oy+\ey-5,medium,1}
\function{trx=(x-(\ox))/\ex}
\function{try=x*(\ey)+(\oy)}

\function{g=simplify(evalue(\try,x=evalue(\f,x=\trx)))}
\text{don=row(\ordre[\i],\donnees)}
\function{g=simplify(evalue(\try,x=evalue(\fonction,x=\trx)))}

\integer{xmin=ceil(\xmin)}
\integer{xmax=floor(\xmax-1)}
\text{val=wims(values v for v=\xmin to \xmax)}
\text{nbval=items(\val)}
\if{\nbval<3}{\text{val=\val,\val,\val}}
\text{val=shuffle(\val)}
\text{b=shuffle(1,2,3,4)}
\text{x=simplify(max(\val[1],1)),simplify(\val[2]+0.2*\b[1]),simplify(\val[3]+0.2*\b[2])}
\text{y=}
\text{ys=}
\text{lt=A,B,C}
\for{i=1 to 3}{
 \real{tmp=evalue(\fonction,x=\x[\i])}
 \integer{X=\ox+\ex*\x[\i]}
 \integer{Y=\oy+\ey*\tmp}
 \real{y2=floor(\tmp*5)/5}
 \text{y=wims(append item \y2 to \y)}
 \real{y3=\y2=\tmp?\y2:\y2+0.2}
 \text{ys=wims(append item \y3 to \ys)}
 \text{dessin=\dessin
linewidth=1
line \X-4,\Y+4,\X+4,\Y-4,red
line \X+4,\Y+4,\X-4,\Y-4,red
text red,\X-10,\Y-10,medium,\lt[\i]}
}

\text{figure=draw(500,500
\dessin
plot blue,\g)}

\statement{<br>
<center>
<table width=95%>
 <tr>
  <td width=25% valign=top>
   Par lecture graphique, complter le tableau des coordonnes des points :<p><p>
   <center><table border=1>
    <tr>
     <td>&nbsp;</td>
     <td align=center><b>A</b></td>
     <td align=center><b>B</b></td>
     <td align=center><b>C</b></td>
    </tr>
    <tr>
     <td><b>x</b></td>
     <td>\embed{r1,\size}</td>
     <td>\embed{r3,\size}</td>
     <td>\embed{r5,\size}</td>
    </tr>
    <tr>
     <td><b>y</b></td>
     <td>\embed{r2,\size}</td>
     <td>\embed{r4,\size}</td>
     <td>\embed{r6,\size}</td>
    </tr>     
   </table></center>
  </td>
  <td align=center width=75%><img src=\figure></td>
 </tr>
</table>}

\reply{Abscisse de \(\A)}{\x[1]}{type=numexp}
\reply{Ordonne de \(\A)}{\y[1],\ys[1]}{type=range}
\reply{Abscisse de \(\B)}{\x[2]}{type=numexp}
\reply{Ordonne de \(\B)}{\y[2],\ys[2]}{type=range}
\reply{Abscisse de \(\C)}{\x[3]}{type=numexp}
\reply{Ordonne de \(\C)}{\y[3],\ys[3]}{type=range}