# mod_ls.pl

sub mod_ls_directives
{
local $rv = [
	[ 'DirFakeGroup', 0, 2, 'virtual anon global', 1.15 ],
	[ 'DirFakeMode', 0, 2, 'virtual anon global', 1.16 ],
	[ 'DirFakeUser', 0, 2, 'virtual anon global', 1.15 ],
	[ 'LsDefaultOptions', 0, 2, 'virtual anon global', 1.16 ],
	[ 'ShowDotFiles', 0, 2, 'virtual anon global', 0.99 ],
	];
return &make_directives($rv, $_[0], "mod_ls");
}

sub edit_DirFakeGroup
{
return (1, $text{'mod_ls_fakegroup'},
	&choice_input($_[0]->{'value'}, "DirFakeGroup", "",
		      "$text{'yes'},on", "$text{'no'},off",
		      "$text{'default'},"));
}
sub save_DirFakeGroup
{
return &parse_choice("DirFakeGroup", "");
}

sub edit_DirFakeUser
{
return (1, $text{'mod_ls_fakeuser'},
	&choice_input($_[0]->{'value'}, "DirFakeUser", "",
		      "$text{'yes'},on", "$text{'no'},off",
		      "$text{'default'},"));
}
sub save_DirFakeUser
{
return &parse_choice("DirFakeUser", "");
}

sub edit_DirFakeMode
{
return (1, $text{'mod_ls_fakemode'},
	&opt_input($_[0]->{'value'}, "DirFakeMode", $text{'mod_ls_nofake'}, 5));
}
sub save_DirFakeMode
{
return &parse_opt("DirFakeMode", '0[0-7]{3}', $text{'mod_ls_efakemode'});
}

sub edit_LsDefaultOptions
{
return (1, $text{'mod_ls_ls'},
	&opt_input($_[0]->{'value'}, "LsDefaultOptions", $text{'default'}, 20));
}
sub save_LsDefaultOptions
{
return &parse_opt("LsDefaultOptions", '\S', $text{'mod_ls_els'});
}

sub edit_ShowDotFiles
{
return (1, $text{'mod_ls_dotfiles'},
	&choice_input($_[0]->{'value'}, "ShowDotFiles", "",
		      "$text{'yes'},on", "$text{'no'},off",
		      "$text{'default'},"));
}
sub save_ShowDotFiles
{
return &parse_choice("ShowDotFiles", "");
}


