#!/usr/local/bin/perl
# index.cgi
# Display a list of domains managed by this module

require './virtual-server-lib.pl';

if ($single_domain_mode) {
	# This user can edit just a single domain, so show only a menu of
	# icons for options he can use
	$d = &get_domain($access{'domains'});
	&ui_print_header(&domain_in($d), $text{'index_title2'}, "", undef, 1,1);
	@links = ( "list_users.cgi?dom=$access{'domains'}",
		   "list_aliases.cgi?dom=$access{'domains'}" );
	@titles = ( $text{'users_title'}, $text{'aliases_title'} );
	@icons = ( "images/users.gif", "images/aliases.gif" );
	&icons_table(\@links, \@titles, \@icons);
	&ui_print_footer("/", $text{'index'});
	exit;
	}

&ui_print_header(undef, $text{'index_title'}, "", "index", 1, 1, 0,
	undef, undef, undef, &text('index_version', $module_info{'version'}));

# Check if server configuration has been checked
@cst = stat($module_config_file);
if ($cst[9] > $config{'last_check'}) {
	# Not since last config change .. force it now
	print "<form action=check.cgi>\n";
	print "<b>$text{'index_needcheck'}</b><p>\n";
	print "<input type=submit value='$text{'index_srefresh'}'></form>\n";

	if (@plugins) {
		print "<form action=edit_newplugin.cgi>\n";
		print "<input type=submit value='$text{'index_plugins'}'>\n";
		print "</form>\n";
		}

	&ui_print_footer("/", $text{'index'});
	exit;
	}

# Setup the default templates
&ensure_template("domain-template");
&ensure_template("subdomain-template");
&ensure_template("user-template");
&ensure_template("local-template");
&ensure_template("bw-template");
&ensure_template("warnbw-template");
&ensure_template("framefwd-template");

# Display local users
if ($config{'localgroup'} && $access{'local'}) {
	print &ui_subheading($text{'index_header1'});
	@lusers = &list_domain_users(undef, 0, 1);
	if (@lusers) {
		print "<a href='edit_user.cgi?new=1&dom=0'>",
		      "$text{'index_uadd'}</a><br>\n";
		&users_table(\@lusers);
		}
	else {
		print "<b>$text{'index_nousers'}</b><p>\n";
		}
	print "<a href='edit_user.cgi?new=1&dom=0'>",
	      "$text{'index_uadd'}</a><p>\n";
	print "<hr>\n";
	}

# Display domains
print &ui_subheading($text{'index_header2'});
@alldoms = &list_domains();
@doms = grep { &can_edit_domain($_) } @alldoms;
if ($config{'display_max'} && @doms > $config{'display_max'}) {
	# Too many domains to display, so show a search form
	print "<b>$text{'index_toomany'}</b><p>\n";
	print "<form action=search.cgi>\n";
	print "<b>$text{'index_search'}</b>\n";
	print "<select name=field>\n";
	print "<option value=dom checked>$text{'index_search_dom'}\n";
	print "<option value=user>$text{'index_search_user'}\n";
	print "<option value=ip>$text{'index_search_ip'}\n";
	print "<option value=parent>$text{'index_search_parent'}\n";
	print "</select> <b>$text{'index_contains'}</b>\n";
	print "<input name=what size=30>\n";
	print "<input type=submit value='$text{'index_searchok'}'></form>\n";

	print "<form action=domain_form.cgi>\n" if ($access{'create'});
	}
elsif (@doms) {
	# Show domains in a table
	print "<form action=domain_form.cgi>\n" if ($access{'create'});
	&create_links(1);
	&domains_table(\@doms);
	}
else {
	print "<form action=domain_form.cgi>\n" if ($access{'create'});
	if (@alldoms) {
		print "<b>$text{'index_none2'}</b><p>\n";
		}
	else {
		print "<b>$text{'index_none'}</b><p>\n";
		}
	}
&create_links(2);
print "</form>\n" if ($access{'create'});
print "<p>\n";

# Show icons for editing various templates
if (&master_admin()) {
	print "<hr>\n";
	print &ui_subheading($text{'index_header3'});
	@tmpls = ( 'tmpl', 'user',
		   $config{'localgroup'} ? ( 'local' ) : ( ),
		   'bw', 'plugin', 'fields' );
	@tlinks = map { "edit_new${_}.cgi" } @tmpls;
	@ttitles = map { $text{"new${_}_title"} } @tmpls;
	@ticons = map { "images/new${_}.gif" } @tmpls;
	&icons_table(\@tlinks, \@ttitles, \@ticons, 5);
	}

# Show current status
if (&master_admin()) {
	print "<hr>\n";
	print &ui_subheading($text{'index_sheader'});
	print "<table width=100%>\n";

	# Show enabled features and plugins
	print "<tr> <td nowrap><b>$text{'index_sfeatures'}</b></td> <td>\n";
	print join(", ", (map { $text{"feature_".$_} }
		          grep { $config{$_} && $_ ne "unix" && $_ ne "dir" }
				@features),
			 (map { &plugin_call($_, "feature_name") }
			      @plugins)
		  );
	print "</td> </tr>\n";

	@dis = grep { !$config{$_} } @opt_features;
	if (@dis) {
		# Show disabled features
		print "<tr> <td nowrap><b>$text{'index_snfeatures'}</b></td> <td>\n";
		print join(", ", map { $text{"feature_".$_} }
				 @dis),"</td> </tr>\n";
		}

	print "<tr> <td nowrap><b>$text{'index_squotas'}</b></td> <td>\n";
	if (!$config{'quotas'}) {
		# Quotas manually disabled
		print "$text{'index_squotas1'}\n";
		}
	elsif ($config{'home_quotas'} &&
	       $config{'home_quotas'} eq $config{'mail_quotas'}) {
		# Both quota filesystems are the same
		print &text($config{'group_quotas'} ? 'index_squotas5g' : 'index_squotas5', "<tt>$config{'home_quotas'}</tt>"),"\n";
		}
	elsif ($config{'home_quotas'} && $config{'mail_quotas'}) {
		# Quota filesystems are different
		print &text($config{'group_quotas'} ? 'index_squotas4g' : 'index_squotas4', "<tt>$config{'home_quotas'}</tt>", "<tt>$config{'mail_quotas'}</tt>"),"\n";
		}
	elsif ($config{'home_quotas'}) {
		# Only for home
		print &text($config{'group_quotas'} ? 'index_squotas3g' : 'index_squotas3', "<tt>$config{'home_quotas'}</tt>"),"\n";
		}
	else {
		# Not active at all
		print "$text{'index_squotas2'}\n";
		}
	print "</td> </tr>\n";

	if ($config{'mail'}) {
		print "<tr nowrap> <td><b>$text{'index_smail'}</b></td> <td>\n";
		print &mail_system_name();
		print "</td> </tr>\n";
		}

	print "<tr><form action=check.cgi>\n";
	print "<td colspan=2 align=right><input type=submit value='$text{'index_srefresh'}'></td> </form></tr>\n";

	print "</table>\n";
	}

# Show backup and restore buttons
if (&master_admin()) {
	print "<hr>\n";
	print &ui_subheading($text{'index_header4'});
	print "<table width=100%>\n";

	# Button to backup now
	print "<form action=backup_form.cgi>\n";
	print "<tr> <td><input type=submit value='$text{'index_backup'}'></td>\n";
	print "<td>$text{'index_backupdesc'}</td> </tr>\n";
	print "</form>\n";

	# Button to setup scheduled backup
	print "<form action=backup_form.cgi>\n";
	print "<input type=hidden name=sched value=1>\n";
	print "<tr> <td><input type=submit value='$text{'index_sched'}'></td>\n";
	print "<td>$text{'index_scheddesc'}</td> </tr>\n";
	print "</form>\n";

	# Button to restore
	print "<form action=restore_form.cgi>\n";
	print "<tr> <td><input type=submit value='$text{'index_restore'}'></td>\n";
	print "<td>$text{'index_restoredesc'}</td> </tr>\n";
	print "</form>\n";

	print "</table>\n";
	}

# Show start/stop buttons
if ($access{'stop'}) {
	print "<hr>\n";
	print "<table width=100%>\n";

	if ($config{'web'}) {
		$apid = &get_apache_pid();
		if (!$apid || !kill(0, $apid)) {
			# Apache is down .. offer to start it
			&ss_form("start_apache.cgi", $text{'index_astart'},
						     $text{'index_astartdesc'});
			}
		else {
			# Apache is up .. offer to stop it
			&ss_form("stop_apache.cgi", $text{'index_astop'},
						    $text{'index_astopdesc'});
			}
		}

	if ($config{'dns'}) {
		$bpid = &get_bind_pid();
		if (!$bpid || !kill(0, $bpid)) {
			# BIND is down .. offer to start it
			&ss_form("start_bind.cgi", $text{'index_bstart'},
						   $text{'index_bstartdesc'});
			}
		else {
			# BIND is up .. offer to stop it
			&ss_form("stop_bind.cgi", $text{'index_bstop'},
						  $text{'index_bstopdesc'});
			}
		}

	if ($config{'mail'}) {
		if (!&is_mail_running()) {
			# Mail server is down .. offer to start it
			&ss_form("start_mail.cgi", $text{'index_mstart'},
						   $text{'index_mstartdesc'});
			}
		else {
			# Mail server is up .. offer to stop it
			&ss_form("stop_mail.cgi", $text{'index_mstop'},
						  $text{'index_mstopdesc'});
			}
		}

	print "</table>\n";
	}

&ui_print_footer("/", $text{'index'});

sub ss_form
{
print "<form action=$_[0]> <tr>\n";
if ($_[0] =~ /^start/) {
	print "<td><img src=images/down.gif></td>\n";
	}
else {
	print "<td><img src=images/up.gif></td>\n";
	}
print "<td><input type=submit value='$_[1]'></td>\n";
print "<td>$_[2]</td> </tr></form>\n";
}

# create_links(num)
sub create_links
{
if ($access{'create'}) {
	if ($access{'create'} == 2) {
		# Can just add sub-server
		$can_add = 1;
		$parentdom = &get_domain_by("user", $base_remote_user);
		if ($parentdom && !&master_admin()) {
			($dcount, $dmax) = &count_domains($parentdom);
			$can_add = 0 if ($dcount > $dmax);
			}
		print "<input type=submit name=add$_[0] value='$text{'index_add1'}'>\n" if ($can_add);
		}
	else {
		# Can add either master or sub-server
		print "<input type=submit name=add$_[0] value='$text{'index_add2'}'>\n";
		print "<select name=parentuser$_[0]>\n";
		print "<option value=''>$text{'index_newuser'}\n";
		foreach $u (sort(&unique(map { $_->{'user'} }
					 grep { $_->{'unix'} } @doms))) {
			print "<option>$u\n";
			}
		print "</select>\n";
		}
	if ($access{'import'}) {
		print "<input type=submit name=import value='$text{'index_import'}'>\n";
		}
	}
}

