#ifndef TIME_WARP_EVENT_SET_FACTORY_H
#define TIME_WARP_EVENT_SET_FACTORY_H

// Copyright (c) 1994-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// BECAUSE THE PROGRAM IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY 
// FOR THE PROGRAM, TO THE EXTENT PERMITTED BY APPLICABLE LAW.  EXCEPT 
// PARTIES PROVIDE THE PROGRAM "AS IS" WITHOUT WARRANTY OF ANY KIND, 
// EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE 
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
// PURPOSE.  THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE 
// PROGRAM IS WITH YOU.  SHOULD THE PROGRAM PROVE DEFECTIVE, YOU ASSUME 
// THE COST OF ALL NECESSARY SERVICING, REPAIR OR CORRECTION. 

// IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING 
// WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR 
// REDISTRIBUTE THE PROGRAM AS PERMITTED ABOVE, BE LIABLE TO YOU FOR 
// DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL OR CONSEQUENTIAL 
// DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE PROGRAM 
// (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING RENDERED 
// INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A FAILURE OF 
// THE PROGRAM TO OPERATE WITH ANY OTHER PROGRAMS), EVEN IF SUCH HOLDER 
// OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. 

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "TimeWarpEventSet.h"
#include "SimulationObject.h"
#include "SimulationManager.h"
#include "Configurer.h"

class Event;

/** The TimeWarpEventSetFactory class.

    This is the class interface for the various Time Warp event set
    implementations that are available in the Simulation kernel. The
    specific event set implementation is hidden from the other
    components of the simulation kernel by the aggregation of the
    event set implemetations in this class interface ( factory
    pattern).  All event set implementations must be derived from the
    TimeWarpEventSet abstract base class.
    
*/
class TimeWarpEventSetFactory : virtual public Configurer {
   
public:
   
  /**@name Public Class Methods of TimeWarpEventSetFactory. */
  //@{

  /// Destructor.
  virtual ~TimeWarpEventSetFactory(){};

  Configurable *allocate( SimulationConfiguration &configuration,
			  Configurable *parent ) const;

  static const TimeWarpEventSetFactory *instance();
      
  //@} // End of Public Class Methods of TimeWarpEventSetFactory.
   
protected:
   
  /**@name Protected Class Methods of TimeWarpEventSetFactory. */
  //@{
      
  /// Default Constructor.
  TimeWarpEventSetFactory(){};
   
  //@} // End of Protected Class Methods of TimeWarpEventSetFactory.
};

#endif
