#include "EventMessage.h"
#include "Event.h"
#include "DeserializerManager.h"

Serializable *
EventMessage::deserialize( SerializedInstance *data ){
  unsigned int source = data->getUnsigned();
  unsigned int dest = data->getUnsigned();
  Event *event = dynamic_cast<Event *>(data->getSerializable());
  const string gvtInfo = data->getString();

  return new EventMessage( source,
			   dest,
			   event,
			   gvtInfo );
}

const string &
EventMessage::getEventMessageType(){
  static string eventMessageType = "EventMessage";
  return eventMessageType;
}

void 
EventMessage::registerDeserializer(){
  DeserializerManager::instance()->registerDeserializer( getEventMessageType(),
                                                         &EventMessage::deserialize );
}
