// $Workfile: CS508LDR.HPP $ $Date: 2/25/98 7:57a $ - Copyright (C) 1996,1997 by jbm Electronics, Inc.

/*------------------------------------ Revision History -----------------------------------------------------------------

  02/15/97 - (dl ) Began creating this file.

------------------------------------------------------------------------------------------------------------------------*/

#ifndef __CS508LDR_HPP
 #define __CS508LDR_HPP

 #ifndef __NOCONIO
   #include <iostream.h>
   #include <iomanip.h>
 #endif

 #include "gtypes.h"

#ifdef OS2
 #include "os2defs.h"
 #include "hpcioctl.hpp"
#endif

 #include "s508ldr.h"

/*-------------------------- Class cS508Loader ------------------

------------------------------------------------*/

 class cS508Loader
      {
       /*---------------------- class cS508Loader --------------------------*\
       |                                                                     |
       | The cS508Loader class defines the interface to the Sangoma          |
       | s508 communication adapter. This interface is provided for          |
       | downloading the adapter code to the adapter memory.                 |
       |                                                                     |
       | Access to the s508 hardware is through an 8K window in the hosts    |
       | memory. The s508 has 256Kbytes of memory which can be accessed in   |
       | 8K segments, hence the 8K window. Different memory segments on the  |
       | s508 is accessible by telling the card to 'move' a different        |
       | segment into the window.                                            |
       |                                                                     |
       | For OS/2, we use JBM's memory access driver, to open this 8K window.|
       | This driver must be left open because we are constantly accessing   |
       | the card via the window or through reading/writing to the s508      |
       | I/O port addresses. The destructor for this class will close the    |
       | device driver.                                                      |
       |                                                                     |
       | The code is loaded in to the adapter memory at offset 0x0100. The   |
       | operation checks for the card at the specified I/O address. The     |
       | adapter memory is cleared first and then the code copied to the     |
       | adapter. The processor is then instructed to jump to address 0x0100.|
       | The 8k segment on the adapter starting at 0xE000 is moved into the  |
       | window on the host machine.                                         |
       |                                                                     |
       |                                                                     |
       |    Ŀ                                  |
       |           cS508Loader                                             |
       |    Ĵ                                  |
       |                                                                   |
       |                                                                   |
       |                                      |
       \*-------------------------------------------------------------------*/


       public:                                                                                                        /*
               ----------------- VARIABLES ----------------------------------------------------------------------------*/

                                                                                                                       /*
               ----------------- FUNCTIONS ----------------------------------------------------------------------------*/

               cS508Loader(USHORT,ULONG,USHORT,UBYTE *);        // Constructor takes a configuration as a parameter
                                                                // Parm 1 is the I/O port address
                                                                // Parm 2 is the window segment address
                                                                // Parm 3 is the number of bytes of code to load
                                                                // Parm 4 is the pointer to the buffer containg the code

               ~cS508Loader(void);                              // Destructor

               USHORT DownLoadCode(void);                       // Main subroutine to download code to adapter


       protected:                                                                                                      /*
               ----------------- VARIABLES ----------------------------------------------------------------------------*/

               void *c_vp_windowbase;                // Void pointer to frame relay memory access window
                                                                                                                       /*
               ----------------- FUNCTIONS ----------------------------------------------------------------------------*/

       private:                                                                                                        /*
               ----------------- VARIABLES ----------------------------------------------------------------------------*/

#ifdef OS2
               HFILE   c_T_filehandle;               // Handle to opened PDD.
#endif
               UBYTE c_uc_windowsegaddr,
                     c_uc_SDLAcfg,                   // communication configuration
                     * c_ucp_codebuffer,
                     * c_ucA3_508NMIcode;            // Pointer to an array to hold
                                                     // JP 100 op-code for the NMI


               USHORT c_us_ioportaddr,
                      c_us_codebufferlen;

               ULONG c_ul_windowphysaddr;

                                                                                                               /*
               ----------------- FUNCTIONS ----------------------------------------------------------------------------*/

               void SetMemoryWindow(ULONG);                       // Move an 8K block of 508 Adapter memory into
                                                                  // the window memory area. Takes a physical address pointer
                                                                  // to determine which 8K block to move to.

               void Write2IOPort(USHORT,USHORT);                  // Write a value to a specified I/O Port address.
                                                                  // Parm 1 is value to write to I/O port
                                                                  // Parm 2 is I/O port address

               void Copy2Adapter(USHORT,UBYTE *,ULONG);           // Transfer the adapter code from the buffer to the adapter
                                                                  // Parm 1 is the length of buffer
                                                                  // Parm 2 is a pointer to the buffer
                                                                  // Parm 3 is destination address

               void EraseAdapter(void);                           // Erase first 64K of adapter memory.

               UBYTE ReadIOPort(USHORT);                          // Read the register at the specified IO address
                                                                  // Parm 1 is I/O port address

               USHORT GetWindowAddress(void);                     // Calculate the value to tell the adapter process what
                                                                  // memory address the window will be

               ULONG FormatPtr2MemoryWindow(ULONG);               // Takes a pointer to the physical adapter memory and
                                                                  // changes it to an offset within the window memory area.

               cS508Loader(cS508Loader &);                        // Copy constructor is unavailable to the general public!

               void operator = (cS508Loader &);                   // Assignment operator is unavailable to the general public!

      };

 #include "cs508ldr.ipp"

#endif  // __CS508LDR_HPP
