/* $Id: w3mimg.h,v 1.1.2.1 2002/07/22 13:23:57 suto Exp $ */
#include "config.h"

#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <limits.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#ifdef HAVE_SYS_SELECT_H
#include <sys/select.h>
#endif

#ifdef USE_W3MIMG_FB
#include "w3mimg/fb/fb.h"
#include "w3mimg/fb/fb_img.h"
#endif

typedef struct _W3MImage {
  struct _W3MImage *next, *prev;
  void *pixmap; /* driver specific */
  int index;
  int width;
  int height;
  int queued;
} W3MImage;

typedef struct _w3mimg_opts {
  int defined_bg, defined_x, defined_y, defined_test, defined_debug, defined_ignore_exposure;
  char *background;
} w3mimg_opts;

typedef struct _w3mimg_desc {
  void *priv; /* driver specific data */
  int width, height, depth; /* window width, height, and depth */
  int offset_x, offset_y; /* offset */
  int clipped, alldirty, flush_delay, flush_dirty;
  int serv_fd, stdin_fd;
  void (*init_func)(struct _w3mimg_desc *);
  void (*free_func)(struct _w3mimg_desc *, W3MImage *);
  void (*load_func)(struct _w3mimg_desc *, W3MImage *, char *, int, int);
  void (*clip_func)(struct _w3mimg_desc *, char *);
  void (*clear_func)(struct _w3mimg_desc *);
  int (*flush_start_hook)(struct _w3mimg_desc *);
  void (*show_func)(struct _w3mimg_desc *, W3MImage *, int, int, int, int, int, int);
  int (*clip_test)(struct _w3mimg_desc *, W3MImage *, int, int, int, int);
  void (*flush_end_hook)(struct _w3mimg_desc *);
  void (*serv_write)(struct _w3mimg_desc *);
  void (*serv_read)(struct _w3mimg_desc *);
  void (*serv_sync)(struct _w3mimg_desc *);
  void (*serv_idle)(struct _w3mimg_desc *);
  void (*serv_close)(struct _w3mimg_desc *);
} w3mimg_desc;

typedef struct _w3mimg_line {
  char *v;
  int n, n_max;
} w3mimg_line;

enum {
  w3mimg_line_continued,
  w3mimg_line_eol,
  w3mimg_line_eof,
};

extern void w3mimg_exit(int status, FILE *out, const char *frmt, ...);
extern void w3mimg_draw(w3mimg_desc *desc, char *buf);
extern void w3mimg_clip(w3mimg_desc *desc);
extern void w3mimg_clear(w3mimg_desc *desc);
extern void w3mimg_flush(w3mimg_desc *desc);
extern void w3mimg_clear_one(char *p);
extern int w3mimg_gets(w3mimg_desc *desc, w3mimg_line *l, int doread);
extern void w3mimg_get_option(int argc, char **argv, w3mimg_desc *desc, w3mimg_opts *opts);

#ifdef USE_W3MIMG_X11
extern w3mimg_desc *w3mimg_x11open(w3mimg_desc *desc, w3mimg_opts *opts);
#endif
#ifdef USE_W3MIMG_FB
extern w3mimg_desc *w3mimg_fbopen(w3mimg_desc *desc, w3mimg_opts *opts);
#endif

extern w3mimg_desc *w3mimg_open(w3mimg_desc *desc, w3mimg_opts *opts);
