/* GiMd2Viewer - Quake2 model viewer
 * Copyright (C) 1998  Lionel ULMER <bbrox@mygale.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "global.h"
#include "images.h"

#ifndef VRENGD


#define TO_SHORT(h, a) (h. ## a ## _l | (h. ## a ## _h << 8))

typedef struct {
  u_int8 Manufacturer;
  u_int8 Version;
  u_int8 Encoding;
  u_int8 BitsPerPixel;
  u_int8 Xmin_l; u_int8 Xmin_h;
  u_int8 Ymin_l; u_int8 Ymin_h;
  u_int8 Xmax_l; u_int8 Xmax_h;
  u_int8 Ymax_l; u_int8 Ymax_h;
  u_int8 HDPI_l; u_int8 HDPI_h;
  u_int8 VDPI_l; u_int8 VDPI_h;
  u_int8 Colormap[48];
  u_int8 Reserved;
  u_int8 NPlanes;
  u_int8 BytesPerLine_l; u_int8 BytesPerLine_h;
  u_int8 PaletteInfo_l; u_int8 PaletteInfo_h;
  u_int8 HScreenSize_l; u_int8 HScreeSize_h;
  u_int8 VScreenSize_l; u_int8 VScreeSize_h;
  u_int8 Filler[54];
} PcxInfo;

typedef struct {
  u_int8 r;
  u_int8 g;
  u_int8 b;
} PcxColor;


Image *
loadPCX(void *th, ReadImageFunc read_func, DisplayImageFunc display_func)
{
  PcxInfo pcxheader;
  u_int16 xsize, ysize, bpl;
  u_int8 *img, *tmp, *tmp2;
  Image *image;
  PcxColor palette[256];

  /* Fool proofing */
  if (th == NULL)
    return NULL;

  httpClearBuf();

  /* Loads the header */
  read_func(th, (char *) &pcxheader, sizeof(pcxheader));

  /* Test if this is really a PCX file */
  if (pcxheader.Manufacturer != 0x0A) {
    trace(DBG_FORCE, "loadPCX: not a PCX format: %x", pcxheader.Manufacturer);
    return NULL;
  }

  /* Only decode one type of PCX */
  if ((pcxheader.Version != 0x05) || (pcxheader.BitsPerPixel != 8) ||
      (pcxheader.NPlanes != 0x01))
    return NULL;
 
  /* Gets the image dimentions */
  xsize = (TO_SHORT(pcxheader, Xmax) - TO_SHORT(pcxheader, Xmin)) + 1;
  ysize = (TO_SHORT(pcxheader, Ymax) - TO_SHORT(pcxheader, Ymin)) + 1;
  bpl = TO_SHORT(pcxheader, BytesPerLine);
 
  /* Temporary indexed buffer */
  img = (u_int8 *) malloc(xsize * ysize);
  
  /* Start decoding the file */
  tmp = img;
  for (int y = 0; y < ysize; y++) {
    int count = 0;
    u_int8 data = 0x00;
  
    /* Decodes one line */
    int x = 0;
    while (x < bpl) {
      if (count > 0) {
	if (x < xsize)
	  *(tmp++) = data;
	x++;
	count--;
      } else {
	data = httpGetC(th, read_func);
	if ((data & 0xC0) == 0xC0) {
	  count = data & 0x3F;
	  data = httpGetC(th, read_func);
	} else {
	  count = 1;
	}
      }
    }
  }

  /* Decodes the palette */
  if (httpGetC(th, read_func) != 0x0C) {
    free(img); img = NULL;
    return NULL;
  }
  for (int i = 0; i < 256; i++) {
    palette[i].r = httpGetC(th, read_func);
    palette[i].g = httpGetC(th, read_func);
    palette[i].b = httpGetC(th, read_func);
  }

  /* Allocates memory */
  if ((image = newImage(xsize, ysize, IMAGE_RGB, IMAGE_FIX)) == NULL)
    return (Image *) NULL;
  
  /* Converts the indexed buffer to RGB */
  tmp = img;
  tmp2 = image->pixmap;
  for (int x = 0; x < xsize * ysize; x++) {
    *(tmp2++) = palette[*tmp].r;
    *(tmp2++) = palette[*tmp].g;
    *(tmp2++) = palette[*tmp].b;
    tmp++;
  }
  free(img); img = NULL;
  
  display_func(th, image);
  return image;
}

#endif /* !VRENGD */
