
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#ifndef __BONETRIANGLE_H__
#define __BONETRIANGLE_H__

#include "boneCommon.h"
#include "boneVertex.h"

   class TRIANGLE
    {
     public :

     //------------------------------
     // Datas for the triangle class
     VERTEX * vertex1; float u1, v1; int index1;
     VERTEX * vertex2; float u2, v2; int index2;
     VERTEX * vertex3; float u3, v3; int index3;
     VECT3D initialNormal;
     VECT3D currentNormal;
     float colorRed, colorGreen, colorBlue, colorAlpha; // Initial colors
     float finalRed, finalGreen, finalBlue, finalAlpha; // Projected colors

     //----------------------
     // Construct / destruct
     inline TRIANGLE ( void )
      {
       vertex1 = NULL;
       vertex2 = NULL;
       vertex3 = NULL;

       initialNormal.reset ();
       currentNormal.reset ();

       setColor ();
      }

     inline ~TRIANGLE ( void ) { }

     //-----------------
     // Accessing datas
     void addVertex ( VERTEX * zeVertex, int index, float u=-1.0f, float v=-1.0f )
      {
       if (( u == -1.0 ) && ( v == -1.0 ))
        {
	 u = zeVertex -> initialPosition.x / 3.0f;
	 v = zeVertex -> initialPosition.y / 3.0f;
	}
	    if ( vertex1 == NULL ) { vertex1 = zeVertex; index1 = index; u1 = u; v1 = v; }
       else if ( vertex2 == NULL ) { vertex2 = zeVertex; index2 = index; u2 = u; v2 = v; }
       else if ( vertex3 == NULL ) { vertex3 = zeVertex; index3 = index; u3 = u; v3 = v; }
      }

     void rebuildNormal ( void )
      {
       VECT3D edge1;
       VECT3D edge2;
       edge1 = vertex1->initialPosition - vertex2->initialPosition;
       edge2 = vertex1->initialPosition - vertex3->initialPosition;
       initialNormal.crossProduct ( edge1, edge2 );
       initialNormal.normalize ();
       currentNormal = initialNormal;
      }

     void setColor ( float r=0.5f, float g=0.5f, float b=0.5f, float a=1.0f )
      {
       colorRed   = finalRed   = r;
       colorGreen = finalGreen = g;
       colorBlue  = finalBlue  = b;
       colorAlpha = finalAlpha = a;
      }
    };

#endif
