#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* projectMovementOnObject */
#include "web.h"

#include "zv.h"		/* parseGeometry */
#include "helpers.h"


const WClass Web::wclass(WEB_TYPE, "Web", Web::creator);


/* create from a fileline */
void Web::creator(char *l)
{
  new Web(l);
}

Web::Web(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, WEB_TYPE, VR_STILL);
} 

/* object intersects: projection */
void Web::whenIntersect(WObject *pcur, WObject *pold)
{
  if (projectMovementOnObject(pcur->pos, pold->pos, this->pos))
    updateReplica(pcur, pold->pos);
  else 
    copyPositionAndBB(pold, pcur);
}

/* browser */
static
void webOpen(Web *po, void *data, time_t sec, time_t usec)
{
  char *purl;

  trace(DBG_TOOL, "Wmgt: browser on %s", po->name.url);
  purl = strrchr(po->name.url, '.');
  purl++;
  if (!strncasecmp(purl, "wrl", 3) || !strncasecmp(purl, "vrm", 3))
    startvrml(po->name.url);
  else
    startbrowser(po->name.url);
}

void webInitFuncList(void)
{
  setMethodFunc(WEB_TYPE, 0, WO_ACTION webOpen, "Open");
}

#endif /* !VRENGD */
