#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "user.h"
#include "zv.h"		/* parseGeometry */
#include "step.h"


const WClass Step::wclass(STEP_TYPE, "Step", Step::creator);


/* create a step from a fileline */
void Step::creator(char *l)
{
  new Step(l);
}

Step::Step(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  initializeObject(this, STEP_TYPE, VR_STILL);
} 

/* object intersects: up */
void Step::whenIntersect(WObject *pcur, WObject *pold)
{
  if (pcur->noh.type == USER_TYPE) {
    pcur->pos.z += STEP_SIZE;	/* up */
    updateObjectIn3D(pcur);
    updateBB(pcur);
  }
  else
    copyPositionAndBB(pold, pcur);
}

void stepInitFuncList(void) { }

#endif /* !VRENGD */
