#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "col.h"	/* COL_ONCE */
#include "ftp.h"

#include "zv.h"		/* parseGeometry */


const WClass Ftp::wclass(FTP_TYPE, "Ftp", Ftp::creator);


/* ftp initialization from a file */
void Ftp::creator(char *l)
{
  new Ftp(l);
}

Ftp::Ftp(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  l = parseURL(l, this);
  soh = parseGeometry(l);

  initializeObject(this, FTP_TYPE, VR_STILL);
  nature.collision = COL_ONCE;
} 

/* intersection: stop */
void Ftp::whenIntersect(WObject *pcur, WObject *pold)
{
  copyPositionAndBB(pold, pcur);
}

/* get */
static
void ftpGet(Ftp *po, void *data, time_t sec, time_t usec)
{
  char *pfile = strrchr(po->name.url, '/');
  pfile++;

  switch (fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for wget");
    return;
  case 0:
    execlp("wget", "wget", "-cO", pfile, po->name.url, (char *) NULL);
    trace(DBG_FORCE, "can't exec wget");
    exit(1);
  default:
    return;
  }
}

void ftpInitFuncList(void)
{
  setMethodFunc(FTP_TYPE, 0, WO_ACTION ftpGet, "Get");
}

#endif /* !VRENGD */
