#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "grid.h"
#include "parse.h"
#include "user.h"	/* USER_TYPE */
#include "aoi.h"

#include "zv.h"		/* parseGeometry */
#include "gui.h"	/* selectedObjectDeletion */
#include "helpers.h"
#include "channel.h"	/* Channel */


const WClass Aoi::wclass(AOI_TYPE, "Aoi", Aoi::creator);

/* Note:
 * Intersection with AoI object must be manage by VREng general intersection
 * procedure (see col.c).  That's why AoI does not need any 
 * "whenIntersect" function.  Therefore, the procedure initAoiFuncList 
 * below sets this member to NULL.  The main reason for this is that AoI
 * are objects we want to be able to go through. The only event we are 
 * interested in is when a collision occurs.
 */

Aoi * currentAoi;  /* Points to current AoI we're in */


/* AoI creation from file */
void Aoi::creator(char *l)
{
  new Aoi(l);
}

Aoi::Aoi(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  strcpy(chan, l); l = strtok(NULL, SEP);
  if ((soh = parseGeometry(l)) == NULL)
    return;

  initializeObject(this, AOI_TYPE, VR_STILL);

  /* AoI are not visible stuf */
#define AOI_VISIBLE /* to be uncommented if hard debugging time */
#ifndef AOI_VISIBLE
  setSolidVisible(soh, FALSE);
#endif
  currentAoi = 0;
} 

/*
 * Function aoiEnter:
 *
 * Perform action to be done while entering a new Area of Interest:
 *  - leaving previous one with aoiQuit() call
 *  - initializing the network on new AoI's mcast chan_str
 *  - initializing the only mobile object we know for now in 
 *      this AoI: local user's avatar
 *
 * Unique callee is generalIntersect() (col.c) 
 */
void aoiEnter(Aoi *newAoi)
{
  Channel *pchan;
  
  notice("Avatar \"%s\" enters in %s",
	  worlds->plocaluser->name.instance_name, newAoi->chan);
  //DAXC notice("Avatar \"%s\" enters %s (ie. %s)",
  //DAXC   worlds->plocaluser->name.instance_name, newAoi->id, newAoi->chan);
  
  /* Quit current AoI (network shutdown) */
  aoiQuit();

  /* Make new AoI the current one */
  currentAoi = newAoi;

  /* Initializing network with new AoI's mcast group (cf. channel.c vreng.c) */
  if ((pchan = allocChannel()) == NULL)
    return;
  if ((cnt_fd = openChannel(pchan, currentAoi->chan, &tab_fd)) <= 0)
    return;

  /* Initializing local user's avatar */
  //DAX updateObjectIn3D(worlds->plocaluser);
  //DAX updateBB(worlds->plocaluser);
  //DAX mobilelist = addObjectToList(worlds->plocaluser, mobilelist);
  //DAX insertObjectIntoGrid(worlds->plocaluser);
  initializeObject(worlds->plocaluser, USER_TYPE, VR_MOBILE);
  createNetObject((NetObject *) worlds->plocaluser, VR_VOLATILE);

  worlds->plocaluser->move.ttl = 0.0;

  /* Showing other VREng processes we are there (no latency) */
  declareObjCreation(&(worlds->plocaluser->noh));

  /* To do here: broadcast a query on new AoI to see who is there with
   * minimal latency.  In the current solution, we discover
   * other mobile objets in the new AoI only thanks to heart beats,
   * which may be quite long for AoI uses (however it may be
   * ok when entering a World).
   */

  /* Interface stuff */
  GuiUpdateUser(worlds->plocaluser);
  updateObjectIn3D(worlds->plocaluser);
  updateCameraFromObject(worlds->plocaluser);
}

/*
 * Function aoiQuit
 *
 * Perform actions to be done while leaving an Area of Interest:
 *  - Remove all mobile object from network (leaving only static ones)
 *  - Shutdown the network
 *
 * Unique callee is aoiEnter() ... (see above)
 */
void aoiQuit(void)
{
  ObjectList *list = NULL;

  /* Freeing only mobile object we're responsible for */
  for (list = mobilelist; list; ) {
    ObjectList *next = list->next; /* handling next obj while freeing list */

    /* Skipping local user object (as we do not want to remove it) */
    if (list->pobject == worlds->plocaluser) {
      list = next;
      continue;
    }
    /* Deleting mobile object from grid */
    deleteObjectFromGrid(list->pobject);

    /* Closing 3D */
    deleteSolidFromList(list->pobject->soh);

    /* Closing interface */
    if (list->pobject->noh.type == USER_TYPE) {
      GuiRemoveUser((User *)list->pobject);
    }
    selectedObjectDeletion(list->pobject->soh);

    /* Closing network part of object */
    trace(DBG_WMGT, "quitaoi %s", list->pobject->ptrgui);
    if (!(list->pobject->noh.permanent))
      declareObjDeletion(&(list->pobject->noh));
    deleteNetObject((NetObject*) (list->pobject));

    /* Perform some clean up */
    delete list->pobject;
    free(list);

    /* Managing loop */
    list = next;
  }
  mobilelist = NULL;

  /* Explicit declaration to network so that there is minimal latency
     on other VREng processes to see user leaving previous AoI */
  declareObjDeletion(&(worlds->plocaluser->noh));
  deleteNetObject(&(worlds->plocaluser->noh));

  /* Ok to close multicast socket now as we do not need it anymore */
  closeChannel(getCurrentChannel());
}

void aoiInitFuncList(void) { }

#endif /* !VRENGD */
