#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "user.h"
#include "wmgt.h"

#include "zv.h"		/* getSolidBB */


/* update an object Bounding Box */
void updateBB(WObject *po)
{
  getSolidBB(po->soh, &(po->pos.bbcenter), &(po->pos.bbsize));
  //trace(DBG_FORCE, "updateBB: soh=%p obj=%p", po->soh, po->soh->object);
}

/* save current position and Bounding Box of an object */
void copyPosAndBB(WObject *psrc, Pos &newpos)
{
  newpos = psrc->pos;
}

/* save current position and Bounding Box of an object */
void copyPositionAndBB(WObject *psrc, WObject *pdst)
{
  if (psrc==NULL || pdst==NULL) {
    trace(DBG_FORCE, "copyPositionAndBB: psrc || pdst is NULL");
    return;
  }
#if 0
  *pdst = *psrc;
#else
  pdst->noh.type = psrc->noh.type;
  pdst->pos = psrc->pos;
#endif
}

/* update an object in 3D module */
void updateObjectIn3D(WObject *po)
{
  if (!po->soh)
    return;
  M4 matrix = MulM4(TranslateM4(po->pos.x, po->pos.y, po->pos.z),
			        /* RotateM4(po->pos.az, UZ) */
				MulM4(RotateM4(po->pos.az, UZ),
			              RotateM4(po->pos.ax, UX)
                                     )
                   );
  setSolidPosition(po->soh, &matrix);
}

/* update camera in 3D module */
void updateCameraFromObject(WObject *po)
{
  M4 matrix = MulM4(RotateM4(-M_PI_2, UX),
                  MulM4(RotateM4(M_PI_2, UZ),
                        MulM4(RotateM4(po->pos.ax, UX),
                              MulM4(RotateM4(po->pos.ay, UY),
                                    MulM4(RotateM4(-po->pos.az, UZ),
                                          TranslateM4(-po->pos.x, -po->pos.y, -(po->pos.z + 0.5 * USER_DEFAULTHEIGHT))
                                         )
                                   )
                             )
                       )
                 );
  setCameraPosition(&matrix);
}

/* set a WObject pointer to this object in the Solid */
void setObjectToSolid(WObject *po)
{
  if (po->soh)
    po->soh->object = po;
} 

/* get a WObject pointer from this Solid */
WObject * getObjectFromSolid(Solid *solid)
{
  WObject *po = solid ? solid->object : NULL;

  return po;
}

#endif /* !VRENGD */
