#ifndef CHANNEL_H
#define CHANNEL_H

#include "global.h"
#include "net.h"

#define MANAGER_MODE	0
#define WORLD_MODE	1

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/*
 * Channel
 */
typedef struct _Channel {
  u_int32	ssrc;			/* ssrcid */
  u_int32	group;			/* group address */
  u_int8	ttl;			/* ttl scope */
  int		sd[5];			/* sockets descriptors */
  struct sockaddr_in * sa[3];		/* sockets addresses */
  struct sockaddr_in sin_mcast_rtp;	/* RTP datas */
  struct sockaddr_in sin_mcast_rtcp;	/* RTCP datas */
  struct sockaddr_in sin_ucast_data;	/* UDP datas */
  struct ip_mreq mreq;			/* IGMP */
  struct _Session *session;
  struct _Channel *next;
} Channel;

extern int *tab_fd, *tab_manager_fd;
extern int cnt_fd, cnt_manager_fd;

/*** channels ***/
extern Channel *pchannel_curr;		/* current channel */
extern Channel *pchannel_manager;	/* manager channel */

/* unicast tunnel: Multicast Unicast Proxy (MUP) */
extern boolean mup;
extern char * mupname;
extern u_int32 mupaddr;
extern u_int16 mupctrlport;
extern u_int16 mupdataport;


void clearChannelsList(void);
Channel * allocChannel(void);
void freeChannel(Channel *);
int openChannel(Channel *, const char *, int **);
void closeChannel(Channel *);
void quitChannel(Channel *);
char * joinChannel(const char *);
char * joinManagerChannel(const char *);
char * joinDaemonChannel(const char *);
int getfdbysa(struct sockaddr_in *, int);
int getFdSendRTP(struct sockaddr_in *);
int getFdSendRTCP(struct sockaddr_in *);
struct sockaddr_in * getsabysa(struct sockaddr_in *, int);
struct sockaddr_in * getSaRTCP(struct sockaddr_in *);
Channel * getChannelbysa(struct sockaddr_in *);
struct _Channel * getCurrentChannel(void);
struct _Channel * getManagerChannel(void);

char * getvrgroup(const char *);
u_int16 getvrport(const char *);
u_int8 getCurrentTtl(void);
u_int8 getvrttl(const char *);
char * newvrmc(const char *);
char * createmc(char *, u_int16, u_int8);
int getworldid(const char *);


#endif /* CHANNEL_H */
