/*
 * Xterm tool
 *
 * Philippe Dax
 * Oct 1997
 */

#ifndef VRENGD

#include "global.h"
#include "xterm.h"


/* global variable */
int xtermtool = SSH_TOOL;

static int xtermpid = -1;


void startxterm(const char *host)
{
  trace(DBG_TOOL, "xterm: host=%s", host);
  switch (xtermpid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for xterm");
    break;
  case 0:
    if (xtermtool == SSH_TOOL)
      execlp("xterm", "xterm", "-title", host, "-e", "ssh", host, (char *) NULL);
    if (xtermtool == TELNET_TOOL)
      execlp("xterm", "xterm", "-title", host, "-e", "telnet", host, (char *) NULL);
    trace(DBG_TOOL, "can't exec xterm");
    exit(1);
  default:
    break;
  }
}

void quitxterm(void)
{
  if (xtermpid > 0)
    kill(xtermpid, SIGKILL);
}

#endif /* !VRENGD */
