/*
 * Browser vrml
 *
 * Philippe Dax
 * Fev 1998
 */

#ifndef VRENGD

#include "global.h"
#include "browsers.h"


/* global variable */
int vrmltool = WEBSPACE_TOOL;

static int vrmlpid = -1;


static
void startwebspace(const char *name, const char *url)
{
  switch (vrmlpid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", name);
    break;
  case 0:
    execlp(name, name, url, (char *) NULL);
    trace(DBG_TOOL, "can't exec %s", name);
    exit(1);
  default:
    break;
  }
}

static
void startvrweb(const char *name, const char *url)
{
  switch (vrmlpid = fork()) {
  case -1:
    trace(DBG_TOOL, "can't fork for %s", name);
    break;
  case 0:
    execlp(name, name, url, (char *) NULL);
    trace(DBG_TOOL, "can't exec %s", name);
    exit(1);
  default:
    break;
  }
}

void startvrml(const char *url)
{
  trace(DBG_TOOL, "vrmltool=%d url=%s", vrmltool, url);
  if (vrmltool == WEBSPACE_TOOL)
    startwebspace("webspace", url);
  if (vrmltool == VRWEB_TOOL)
    startvrweb("vrweb", url);
  else trace(DBG_TOOL, "unknown browser");
}

void quitvrml(void)
{
  if (vrmlpid > 0) {
    kill(vrmlpid, SIGKILL);
    vrmlpid = -1;
  }
}

#endif /* !VRENGD */
