#include "global.h"


#define MY_NETDB
#undef MALLOC_MUTEX

#if !defined(VRENGD) && defined(MALLOC_MUTEX)
static Vpthread_mutex_t malloc_mutex;
#endif


void initResolve(void)
{
#if !defined(VRENGD) && defined(MALLOC_MUTEX)
  static boolean done = FALSE;

  if (done)
    return;
  initMutex(&malloc_mutex);
  done = TRUE;
  return;
#endif
}

struct hostent *
my_gethostbyname(const char *hostname)
{
  struct hostent *hptmp, *hp;

  if ((hptmp = gethostbyname(hostname)) == NULL)
    return((struct hostent *) NULL);
  trace(DBG_HTTP, "my_gethostbyname: hostname=%s hptmp=%x", hostname, hptmp);

#if defined(MY_NETDB)
#if defined(MALLOC_MUTEX)
  lockMutex(&malloc_mutex);
#endif
  if ((hp = (struct hostent *) malloc(sizeof(struct hostent))) != NULL) {
    trace(DBG_HTTP, "my_gethostbyname: hp=%x", hp);
    memcpy(hp, hptmp, sizeof(struct hostent));
  }
#if defined(MALLOC_MUTEX)
  unlockMutex(&malloc_mutex);
#endif
#else
  hp = hptmp;
#endif
  return hp;
}

struct hostent *
my_gethostbyname_r(const char *hostname)
{
  struct hostent *hptmp, h_r, *hp;
  char buf[512];
#if defined(LINUX) || defined(HPUX)
  int err;
  struct hostent *res;
#else
  int res;
#endif

#if HAVE_GETHOSTBYNAME_R
#if defined(LINUX) || defined(HPUX)
  hptmp = (struct hostent *) gethostbyname_r(hostname, (struct hostent *) &h_r, buf, sizeof(buf), (struct hostent **) &res, &err);
#else
  hptmp = gethostbyname_r(hostname, &h_r, buf, sizeof(buf), &res);
#endif
#else /* HAVE_GETHOSTBYADDR_R */
  hptmp = gethostbyname(hostname);
#endif /* HAVE_GETHOSTBYADDR_R */
  if (hptmp == NULL)
    return((struct hostent *) NULL);

#if defined(MY_NETDB)
  if ((hp = (struct hostent *) malloc(sizeof(struct hostent))) != NULL)
    memcpy(hp, hptmp, sizeof(struct hostent));
#else
  hp = hptmp;
#endif
  return hp;
}

struct hostent *
my_gethostbyaddr(const char *addr)
{
  struct hostent *hptmp, *hp;

  if ((hptmp = gethostbyaddr(addr, sizeof(struct in_addr), AF_INET)) == NULL)
    return((struct hostent *) NULL);

#if defined(MY_NETDB)
  if ((hp = (struct hostent *) malloc(sizeof(struct hostent))) != NULL)
    memcpy(hp, hptmp, sizeof(struct hostent));
#else
  hp = hptmp;
#endif
  return hp;
}

struct hostent *
my_gethostbyaddr_r(const char *addr)
{
  struct hostent *hptmp, *hp;
#if HAVE_GETHOSTBYADDR_R
  struct hostent h_r;
#if defined(LINUX) || defined(HPUX)
  int err;
  struct hostent *res;
#else
  int res;
#endif
  char buf[512];

#if defined(LINUX) || defined(HPUX)
  hptmp = (struct hostent *) gethostbyaddr_r(addr, sizeof(struct in_addr), AF_INET, (struct hostent *) &h_r, buf, sizeof(buf), (struct hostent **) &res, &err);
#else
  hptmp = gethostbyaddr_r(addr, sizeof(struct in_addr), AF_INET, &h_r, buf, sizeof(buf), &res);
#endif
#else /* HAVE_GETHOSTBYADDR_R */
  hptmp = gethostbyaddr(addr, sizeof(struct in_addr), AF_INET);
#endif /* HAVE_GETHOSTBYADDR_R */
  if (hptmp == NULL)
    return((struct hostent *) NULL);

#if defined(MY_NETDB)
  if ((hp = (struct hostent *) malloc(sizeof(struct hostent))) != NULL)
    memcpy(hp, hptmp, sizeof(struct hostent));
#else
  hp = hptmp;
#endif
  return hp;
}

struct servent *
my_getservbyname(const char *service)
{
  struct servent *sptmp, *sp;

  if ((sptmp = getservbyname(service, NULL)) == NULL)
    return((struct servent *) NULL);

#if defined(MY_NETDB)
  if ((sp = (struct servent *) malloc(sizeof(struct servent))) != NULL)
    memcpy(sp, sptmp, sizeof(struct servent));
#else
  sp = sptmp;
#endif
  return sp;
}

struct servent *
my_getservbyname_r(const char *service)
{
  struct servent *sptmp, *sp;
#if HAVE_GETSERVBYNAME_R
  struct servent s_r;
  char buf[512];
#if defined(LINUX) || defined(HPUX)
  struct servent *res;

  sptmp = (struct servent *) getservbyname_r(service, NULL, (struct servent *) &s_r, buf, sizeof(buf), (struct servent **) &res);
#else
  sptmp = getservbyname_r(service, NULL, &s_r, buf, sizeof(buf));
#endif
#else /* HAVE_GETSERVBYNAME_R */
  sptmp = getservbyname(service, NULL);
#endif /* HAVE_GETSERVBYNAME_R */
  if (sptmp == NULL)
    return((struct servent *) NULL);

#if defined(MY_NETDB)
  if ((sp = (struct servent *) malloc(sizeof(struct servent))) != NULL)
    memcpy(sp, sptmp, sizeof(struct servent));
#else
  sp = sptmp;
#endif
  return sp;
}

void my_free_netdb(void *pstruct)
{
#ifdef MY_NETDB
  trace(DBG_HTTP, "my_free: pstruct=%x", pstruct);
  free(pstruct);
#endif
}
