#ifndef HTTP_H
#define HTTP_H

#include "global.h"
#include "thread.h"


#define URLBAD  0
#define URLHTTP 1
#define URLFTP  2
#define URLFILE 3
#define URLTELNET 4
#define URLSIP	5
#define URLRTSP	6
#define URLSMIL	7

#define MAXNCBUF	512
#define MAXBUF		256
#define MAXREAD		4096

#define TELNETPORT	23
#define HTTPPORT	80

#define TCPEOF		0
#define BADSEND		-1
#define BADREAD 	-2
#define BADSOCKET	-3
#define BADCONNECT	-4
#define BADURL		-5
#define BADNAME		-6
#define BADSERV		-7
#define BADHANDLE	-8

#define HTTP_OK     200

#define HTTP_PROXY  "http_proxy"
#define NO_PROXY    "no_proxy"


typedef struct _HttpCon {
  int fd;
  int bptr;
  int bl;
  char buf[MAXNCBUF];
} HttpCon;

typedef int (*ReadImageFunc) (void *handle, char *buf, int length);

void * launchThread(void *tl);
int resolve(char *hoststr, char *portstr, struct sockaddr_in *sa);
int httpOpen(const char *url, void (*callback)(void *, void *), void *, int);
void httpClose(void *handle);
int httpRead(void *handle, char *buf, int size);
void httpClearBuf(void);
int httpGetChar(void *handle);
u_int8 httpGetByte(void *handle);
u_int8 httpGetC(void *handle, ReadImageFunc read_func);
u_int32 httpGetInt(void *handle);
float httpGetFloat(void *handle);
int httpGetLine(void *handle, char *line);
int httpFread(char *ptr, int size, int nitems, void *handle);
u_int32 httpGetBuf(void *handle, char *buf, int maxlen);
u_int32 httpSkip(void *handle, int32 skiplen);


#endif  /* HTTP_H */
