
// stats.h
// prototypes, etc. for use by voxbolib
// Copyright (c) 2008-2009 by The VoxBo Development Team

// This file is part of VoxBo
// 
// VoxBo is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// VoxBo is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with VoxBo.  If not, see <http://www.gnu.org/licenses/>.
// 
// For general information on VoxBo, including the latest complete
// source code and binary distributions, manual, and associated files,
// see the VoxBo home page at: http://www.voxbo.org/
// 
// original version written by Dan Kimberg
// substantial code merged in from Kosh Banerjee

#ifndef VBSTATS_H
#define VBSTATS_H

using namespace std;

#include "vbio.h"

typedef pair<double,double> tval;

tval calc_ttest(VB_Vector &vec,bitmask &bm);
tval calc_ttest(VB_Vector &v1,VB_Vector &v2);
tval calc_welchs(VB_Vector &vec,bitmask &bm);
tval calc_welchs(VB_Vector &v1,VB_Vector &v2);
tval t_to_p_z(tval res,bool twotailed=0);
VBVoxel find_fdr_thresh(Tes &vol,double q);

#endif // VBSTATS_H
