/*********************************************************************
 *
 * Authors: Vincenzo Ciaschini - Vincenzo.Ciaschini@cnaf.infn.it 
 *
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010.
 * See http://www.eu-egee.org/partners/ for details on the copyright holders.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Parts of this code may be based upon or even include verbatim pieces,
 * originally written by other people, in which case the original header
 * follows.
 *
 *********************************************************************/
#ifndef VOMS_FORMAT_H
#define VOMS_FORMAT_H

#include <string>
#include <openssl/pem.h>

/* format.c */
struct collection {
  std::string user;
  std::string userca;
  std::string server;
  std::string serverca;
  std::string voname;
  std::string date1;
  std::string date2;
  int    datalen;
  std::string data;
  std::string uri;
};

extern bool unformat(const std::string data, const EVP_PKEY *key,
		     collection &results);
extern bool format(const std::string data, const std::string user,
		   const std::string userca, const std::string server,
		   const std::string serverca, const EVP_PKEY *key, int valid,
		   const std::string voname, const std::string uri,
		   std::string &formatted);
#endif
