/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <SchematicWindow.h>

#include <Strings.h>
#include <MainWindow.h>
#include <SchematicFrame.h>

#include <iostream.h>

SchematicWindow* SchematicWindow::instance_ = 0;
const int SchematicWindow::borderWidth_ = 10;
//-----------------------------------------------------------------
SchematicWindow::SchematicWindow( QWidget* parent )
  : QScrollView(parent, Strings::SchematicWindowName),
    frame_(0)
 
{
  ASSERT( instance_ == 0 );
  instance_ = this;
  
  frame_ = new SchematicFrame( viewport() );
  frame_->setBackgroundColor( white );
  addChild( frame_, borderWidth_, borderWidth_ );
  frame_->hide();
  setResizePolicy( QScrollView::Manual );
}

//-----------------------------------------------------------------
SchematicWindow::~SchematicWindow()
{
  instance_ = 0;
}

//-----------------------------------------------------------------
SchematicWindow* SchematicWindow::instance()
{
  return instance_;
}

//-----------------------------------------------------------------
void SchematicWindow::setSchematicSize( uint width, uint height )
{
  resizeContents( width + 2*borderWidth_, height + 2*borderWidth_ );
}
