/*
 * ===========================
 * VDK Visual Development Kit
 * Version 2.0.3
 * January 2003
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _vdkhlbuttonbar_h
// put your code below here
#define _vdkhlbuttonbar_h
#include <vdk/siglisthandle.h>
#include <vdk/vdkhlbutton.h>
#include <vdk/frame.h>
#include <vdk/vdkprops.h>

typedef VDKList <VDKHLButton> BList;
typedef VDKListIterator <VDKHLButton> ButtonListIterator;
class VDKHLButtonBar: public VDKFrame
{
  protected:
  BList blist;
  bool OnClick (VDKObject* sender);
  public:
    VDKHLButtonBar (VDKForm* owner, 
      int mode = h_box, 
      int shadow = shadow_none);
  virtual ~ VDKHLButtonBar ();
  BList* ButtonList() { return &blist; }
  void AddButton (const char** pixdata, 
                  const char* tip = NULL,
                  const char* text = NULL);
  void AddButton (const char* pixfile, 
                  const char* tip = NULL,
                  const char* text = NULL);
  VDKHLButton* operator[](int n);
  VDKReadWriteValueProp <VDKHLButtonBar, int> ButtonPressed;
  DECLARE_SIGNAL_LIST (VDKHLButtonBar);
};

//
#endif

