/*  Higlight code	
*  Copyright (C) 1999,2000,2001 by:
* Mikael Hermansson <mikeh@bahnhof.se>
* some changes is written by Chris Phelps <reninet.com>
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <string.h>
#include <time.h>
#include <gtk/gtk.h>

#include <vdk/gtksourcebuffer.h>

#ifndef UNDO_MAX
#define UNDO_MAX 5
#endif

static GtkWidgetClass *parent_class = NULL;


void gtk_source_buffer_undo_array(GtkSourceBuffer *buf, GPtrArray *array);

void move_cursor(GtkTextBuffer *buf,GtkTextIter *iter ,GtkTextMark *mark,gpointer data);
void property_text_insert(GtkTextBuffer *text,GtkTextIter *iter,const gchar *txt,gint len);
void property_text_insert_after(GtkTextBuffer *text,GtkTextIter *iter,const gchar *txt,gint len);
void property_text_remove(GtkTextBuffer *text,GtkTextIter *iter,GtkTextIter *end);
void property_text_remove_after(GtkTextBuffer *text,GtkTextIter *iter,GtkTextIter *end);
void begin_user_action(GtkTextBuffer *buf);
void end_user_action(GtkTextBuffer *buf);


static void gtk_source_buffer_class_init(GtkSourceBufferClass *_class);
static void gtk_source_buffer_init(GtkSourceBuffer *_class);

static void remove_all_tags(GtkSourceBuffer *text,GtkTextIter *iter,GtkTextIter *iter2);
void check_pattern(GtkSourceBuffer *text,const char *txt,gint len,GtkTextIter *iter);
gint get_syntax_end(const char *text,gint pos,Regex *reg,GtkSourceBufferMatch *m);
void check_syntax(GtkSourceBuffer *text,GtkTextIter *start,GtkTextIter *end);
void check_brackets(GtkTextBuffer *text,GtkTextIter *end);

gint gtk_source_buffer_undo_append(GtkSourceBuffer *buf, gint typ,const GtkTextIter *iter1,const GtkTextIter *iter2);

void update_syntax_regex(GtkSourceBuffer *buf);

/* soon deprecated */
gint get_tag_start(GtkTextTag *tag,GtkTextIter *iter);
gint get_tag_end(GtkTextTag *tag,GtkTextIter *iter);
GtkSyntaxTag* is_syntax_tag (GList *list, GtkTextIter *iter);

typedef struct _IterBox
{
  GtkTextIter *iter1;
  GtkTextIter *iter2;
}IterBox;

void
remove_tag_func (GtkTextTag *tag, gpointer data)
{
  IterBox *iters = (IterBox *)data;
  gtk_text_buffer_remove_tag(gtk_text_iter_get_buffer(iters->iter1),tag,iters->iter1,iters->iter2); 
};

void
remove_all_tags(GtkSourceBuffer *text,GtkTextIter *iter,GtkTextIter *iter2)
{
  GtkTextTagTable *tagtable;
  IterBox iters;

  iters.iter1 = iter;
  iters.iter2 = iter2;
  tagtable = gtk_text_buffer_get_tag_table(GTK_TEXT_BUFFER(text));

  //  g_print("remove all tags (if there is) between %d and %d\n",gtk_text_iter_get_offset(iter),gtk_text_iter_get_offset(iter2));

  gtk_text_tag_table_foreach (tagtable, remove_tag_func, &iters);
}


gint
get_tag_start(GtkTextTag *tag,GtkTextIter *iter)
{
  gint count = 0;
  do
  {
    count++;
    if (gtk_text_iter_begins_tag(iter,tag))
        break;

  } while (gtk_text_iter_backward_char(iter));
        g_print("tag is started at offset %d\n",gtk_text_iter_get_offset(iter));
  
  return count;
}

gint
get_tag_end(GtkTextTag *tag,GtkTextIter *iter)
{
  gint count = 0;
  do
  {
    count++;
    if (gtk_text_iter_ends_tag(iter,tag))
        break;

  } while (gtk_text_iter_forward_char(iter));
        g_print("tag is started at offset %d\n",gtk_text_iter_get_offset(iter));
  
  return count;
}

void update_syntax_regex (GtkSourceBuffer *buf)
{
  GString *str;
  GList *cur;
  GtkSyntaxTag *tag;
  str = g_string_new("");
  cur = gtk_source_buffer_get_first_syntax_tag (buf);
  while(cur)   {
    tag=GTK_SYNTAX_TAG(cur->data);
    g_string_append(str,tag->start);
    
    cur=gtk_source_buffer_get_next_syntax_tag(cur);
    if(cur)
      g_string_append(str,"\\|");
  };

  gtk_source_compile_regex (str->str, &buf->reg_syntax_all);
  g_string_free(str, TRUE);        
}

GtkSyntaxTag*
gtk_source_buffer_iter_has_syntax_tag (GtkTextIter *iter)
{
  GSList *list = gtk_text_iter_get_tags(iter);
  
  while(list)  {  
     if (GTK_IS_SYNTAX_TAG(list->data))    
          return GTK_SYNTAX_TAG(list->data);

      list = g_slist_next (list);
  };
  return NULL;
}

/* this new code is directly ported from Codecommander */

void move_cursor(GtkTextBuffer *buffer, GtkTextIter *iter, GtkTextMark *m, gpointer data)
{
  GtkSourceBuffer *sbuf = GTK_SOURCE_BUFFER(buffer);
  GtkTextIter iter1,iter2;

  if(m != gtk_text_buffer_get_insert(buffer))
    return ;

  if (sbuf->mark)  {
    gtk_text_buffer_get_iter_at_mark(buffer,&iter1,sbuf->mark);
    iter2=iter1;
    gtk_text_iter_forward_char(&iter2);
    gtk_text_buffer_remove_tag(buffer,GTK_SOURCE_BUFFER(buffer)->exselect_tag,&iter1,&iter2);
  }
  if(gtk_source_buffer_iter_has_syntax_tag( iter))
    return ;

  if(gtk_source_buffer_find_bracket_match(iter))  {  
    if(!sbuf->mark)
      sbuf->mark = gtk_text_buffer_create_mark (buffer,NULL ,iter,FALSE);
    else  
      gtk_text_buffer_move_mark(buffer,sbuf->mark,iter);

    iter2=*iter;
    gtk_text_iter_forward_char(&iter2);
    gtk_text_buffer_apply_tag(buffer,GTK_SOURCE_BUFFER(buffer)->exselect_tag,iter,&iter2);
  }  
 
}

void property_text_insert(GtkTextBuffer *text,GtkTextIter *curpos,const gchar *txt,gint len)
{
  GtkSyntaxTag *tag;
  GtkTextIter start, end;
  GtkSourceBuffer *source = GTK_SOURCE_BUFFER(text);

  g_return_if_fail (text != NULL);
  g_return_if_fail (GTK_IS_SOURCE_BUFFER (text));

/*  if(!GTK_SOURCE_BUFFER(text)->highlight)    return ;	*/

  if (!GTK_SOURCE_BUFFER(text)->reg_syntax_all.len)
    update_syntax_regex(GTK_SOURCE_BUFFER (text));

  start=*curpos;
  end=*curpos;
  gtk_text_iter_forward_chars(&end,len);

    /* we have connected AFTER insert thats wy iterator points to end */
    /* we need to update startiter to point to txt startpos instead :-) */
/*  gtk_text_iter_backward_chars(&start,len);*/

  if ( gtk_source_buffer_get_n_syntax_tag(GTK_SOURCE_BUFFER(text)) ) 
    { 
      tag = gtk_source_buffer_iter_has_syntax_tag(&start);
      if (!tag)  {
          /* no syntax found we refresh from */ 
        /*start of first instered line to end of last inserted line */

          gtk_text_iter_set_line_offset(&start,0);
      //    end=start;
          gtk_text_iter_forward_line(&end);
         /* if(gtk_text_iter_get_offset(&end) < gtk_text_iter_get_offset(&oldend))
            end = oldend;
 */
      }
      else  {
        gint scount,ecount;
        scount = get_tag_start(GTK_TEXT_TAG(tag),&start);
        ecount = get_tag_end(GTK_TEXT_TAG(tag),&end);
/*        if (scount > tag->reg_start.len && ecount > tag->reg_end.len)
         { g_print ("in syntax interval\n"); return ; } */
       }
    }
    else        
       gtk_text_buffer_get_bounds(text,&start,&end);

  remove_all_tags(GTK_SOURCE_BUFFER(text),&start,&end);

  source->refresh_start = gtk_text_iter_get_offset(&start) ;
  source->refresh_length = gtk_text_iter_get_offset(&end)  - source->refresh_start;

  if(source->refresh_length < len)
    source->refresh_length=len;

/*  if(GTK_SOURCE_BUFFER(text)->highlight)
    check_syntax(GTK_SOURCE_BUFFER(text), &start, &end);

  GTK_SOURCE_BUFFER(text)->highlight=FALSE;
*/

}

void property_text_insert_after(GtkTextBuffer *text,GtkTextIter *iter,const gchar *txt,gint len)
{
  GtkTextIter undostart=*iter;
  GtkTextIter start=*iter; 
  GtkTextIter end=*iter; 
  GtkSourceBuffer *source = GTK_SOURCE_BUFFER (text);

  if (!source->refresh_length)
    return ;

  
  gtk_text_iter_set_offset(&start, source->refresh_start); 
  end=start;

  gtk_text_iter_forward_chars(&end, source->refresh_length); 

  gtk_text_iter_backward_chars(&undostart,len);
  gtk_source_buffer_undo_append(source,UNDO_TYPE_REMOVE_RANGE,&undostart, iter);

  source->refresh_start = 0;
  source->refresh_length = 0;

  check_syntax(source, &start, &end);  
}

void property_text_remove(GtkTextBuffer *text,GtkTextIter *iter,GtkTextIter *iter2)
{
  GtkTextIter start = *iter;
  GtkTextIter end = *iter2;
  GtkSourceBuffer *source = GTK_SOURCE_BUFFER (text);
  GtkSyntaxTag *tag;

  start=*iter;
  end=*iter2;
  /* need to work on this */
    /* first check if iter holds a tag */
   /* if true then iterate backward until tag change */
   /* then iterate iter2 forward until tag change */
   /* remove tags and update from new start and end iters */
  /* if no tags from we iterate from line begin to iter2 line end */
   /* also check if syntax tag if true then ignore and let widgert take care */

  gtk_source_buffer_undo_append(source,UNDO_TYPE_INSERT_TEXT,iter, iter2);

  if (gtk_source_buffer_get_n_syntax_tag(GTK_SOURCE_BUFFER(text)) ) 
    { 
      tag = gtk_source_buffer_iter_has_syntax_tag(&start);
      if (!tag)  {
          /* no syntax found we refresh from */ 
        /*start of first instered line to end of last inserted line */

          gtk_text_iter_set_line_offset(&start,0);
          end=start;
          gtk_text_iter_forward_line(&end);
          if(gtk_text_iter_get_offset(&end) < gtk_text_iter_get_offset(iter2))
            end = *iter2;
      }
      else  {
        gint scount,ecount;
        scount = get_tag_start(GTK_TEXT_TAG(tag),&start);
        ecount = get_tag_end(GTK_TEXT_TAG(tag),&end);
        if (scount > tag->reg_start.len && ecount > tag->reg_end.len)
          return ;  
       }
    }


  source->refresh_start = gtk_text_iter_get_offset(&start) ;
  source->refresh_length = gtk_text_iter_get_offset(&end)  - source->refresh_start;

  remove_all_tags(GTK_SOURCE_BUFFER(text),&start,&end);
}

void property_text_remove_after(GtkTextBuffer *text,GtkTextIter *iter,GtkTextIter *iter2)
{
  GtkTextIter start=*iter; 
  GtkTextIter end=*iter2; 
  GtkSourceBuffer *source = GTK_SOURCE_BUFFER (text);

  if (!source->refresh_length)
    return ;

  g_print("restart %d end %d\n",gtk_text_iter_get_offset(iter),gtk_text_iter_get_offset(iter2));
  
  gtk_text_iter_set_offset(&start, source->refresh_start); 
  end=start;

  gtk_text_iter_forward_chars(&end, source->refresh_length); 


  source->refresh_start = 0;
  source->refresh_length = 0;

  check_syntax(source, &start, &end);  
}


/* we need to optimize this crap its very slow */
/* if the start and end interval is to big */

void 
check_syntax(GtkSourceBuffer *text,GtkTextIter *iter1,GtkTextIter *iter2)
{
  gchar test[64];
  gchar *txt;
  time_t t,t2;
  GtkTextIter curiter,curiter2,iterrealend;
  GtkSyntaxTag *tag;
  gint s,pos,oldpos,z,len,offset;
  gboolean found=FALSE;
  GList *list,*table;
  GtkSourceBufferMatch m;

  list=table=gtk_source_buffer_get_first_syntax_tag(text);
  if(!table)
    return;


  /* this is UGLY :-/ but the only way to parse the text */ 
   /* is to make a memcpy of the textbuffer */

  gtk_text_buffer_get_end_iter(GTK_TEXT_BUFFER(text), &iterrealend);
  txt=gtk_text_buffer_get_slice(GTK_TEXT_BUFFER(text),iter1,&iterrealend,TRUE);  

  oldpos=0;
  pos=0;
  curiter=*iter1;  
  curiter2=curiter;
  offset=gtk_text_iter_get_offset(iter1);
  len=gtk_text_iter_get_offset(iter2);
  len-=offset;

  strncpy(test,txt, len < 63  ? len : 63 );
  test[63]=0;
  if (len < 63)
    test[len] = '\0';

  //  g_print("check_syntax %d, %d [%s]\n",offset,len + offset,test);

  time(&t);

/*
  strncpy(test,txt, 63);
  if (len < 63)
  test[len] = '\0';

  g_print("[%s]\n",test);

  time(&t);
	
  check_pattern(text,txt , len, &curiter);

  time(&t2);
  g_print("elapsed time %d\n",t2-t);
  g_free(txt);

  return ;

*/

  while(pos < len)
  {
//    gtk_text_iter_set_offset(&curiter,pos+offset);
    /* check for syntax any syntax highlight */
    s=gtk_source_buffer_regex_search(txt,pos,&text->reg_syntax_all,TRUE,&m);
    if(s < 0 ||  s > len)	break ; /* not found */



    /* if there is text segments before syntax, check pattern to... */
    if (pos < s)	check_pattern(text,&txt[pos],s-pos,&curiter);

    pos=m.endpos;
    gtk_text_iter_forward_chars(&curiter,m.endpos-oldpos);
    oldpos=pos;

    list=table;
    while(list)
    {    
      tag=GTK_SYNTAX_TAG(list->data);
      if(gtk_source_buffer_regex_match(txt,s,len,&tag->reg_start)  > 0 && txt[s-1] != '\\')
      {
	    if((z = get_syntax_end(txt,pos,&tag->reg_end,&m)) >= 0 )
		  pos=m.endpos;			
        else if(z == 0) continue;
        else  pos=gtk_text_buffer_get_char_count(GTK_TEXT_BUFFER(text))-offset; 

/*        g_print("applied syntax tag [%s] at startpos %d endpos %d\n",sentry->key,s,i);*/

        gtk_text_iter_set_offset(&curiter,s+offset);

//        gtk_text_iter_forward_chars(&curiter,pos-s);
        curiter2=curiter;
        gtk_text_iter_forward_chars(&curiter2,pos-s);

        /* make sure ALL tags between syntax start/end is removed */
        /* we only remove if syntax start/end is more than endpos */
        if(s > len+offset || pos > len+offset)   {
	  //           g_print("remove all tags between %d and %d\n",s,pos);
          remove_all_tags(GTK_SOURCE_BUFFER(text),&curiter,&curiter2);
        }

        gtk_text_buffer_apply_tag(GTK_TEXT_BUFFER(text),GTK_TEXT_TAG(tag),&curiter,&curiter2);
        curiter=curiter2;        
          
        found=TRUE;
        break;
      }
      else if(txt[s-1] == '\\') found = TRUE;

      list=gtk_source_buffer_get_next_syntax_tag(list);
    };
    if(!found)  {
        pos++;
        gtk_text_iter_forward_chars(&curiter,1);
        list=table;
      }
  };
  
  if(pos < len) {
    //gtk_text_iter_get_offset(&curiter,i); 
    check_pattern(text,&txt[pos],len-pos,&curiter);
  }
  if(txt)
  g_free(txt);


  time(&t2);
  // g_print("elapsed time %d\n",t2-t);
}

void
check_pattern(GtkSourceBuffer *text,const char *txt,gint len,GtkTextIter *iter)
{
  GtkTextIter curiter=*iter;
  GtkTextIter curiter2=curiter;
  GtkPatternTag *tag;
  gint i=0,max_length=0,endpos=0;
  GList *table,*list;
  gboolean found=FALSE;

  table =list = gtk_source_buffer_get_first_pattern_tag (text);
  if(!table)  {
    g_print("no patterns????????\n");
    return;
  }
  max_length=gtk_text_buffer_get_char_count(GTK_TEXT_BUFFER(text));
  if(len > max_length)  {
    g_warning("THIS IS BUGGY end [%d] is more than text->length [%d]\n",len,max_length);
    len=strlen(txt);
  }

  i=0;
  while(i < len)
  {
    found=FALSE;
    while(list) {
      tag=GTK_PATTERN_TAG(list->data);      
      if((endpos=gtk_source_buffer_regex_match(txt,i,len,&tag->reg_pattern) ) > 0 && len >= i + endpos)
      {
        curiter2=curiter;
        gtk_text_iter_forward_chars(&curiter2,endpos);

/*        g_print("applied pattern tag [] at startpos %d endpos %d\n",pos,endpos+pos);*/

        gtk_text_buffer_apply_tag(GTK_TEXT_BUFFER(text),GTK_TEXT_TAG(tag),&curiter,&curiter2);

   	   i+=endpos;
        curiter=curiter2;

        found=TRUE;
        break;
      }
      list = gtk_source_buffer_get_next_pattern_tag (list);
    };
    if(!found) {
       list = table; /*  reset to first pattern match and try on next character */
       gtk_text_iter_forward_chars(&curiter,1);
        i++;
      }
  };  
  g_list_free (table);
}

gint 
get_syntax_end(const char *txt,gint pos,Regex *reg,GtkSourceBufferMatch *m)
{
//  curiter=*iter2;
  int ret= pos;
  do  {
    ret=gtk_source_buffer_regex_search(txt,m->endpos,reg,TRUE,m);
    if(ret < 0)
      return -1;
    } while(m->endpos && txt[ m->endpos-2] == '\\' );

  return ret;
}

GtkTextBuffer *
gtk_source_buffer_new(GtkTextTagTable *table)
{
  GObject *text;
  text = g_object_new (GTK_TYPE_SOURCE_BUFFER,NULL);

  if (table)
    {
      g_print("setup\n");
      GTK_TEXT_BUFFER(text)->tag_table = table;
      g_object_ref (G_OBJECT (GTK_TEXT_BUFFER(text)->tag_table));
    }

  return GTK_TEXT_BUFFER(text);
}

static void 
gtk_source_buffer_class_init(GtkSourceBufferClass *_class)
{
  GObjectClass *object_class;
  GtkWidgetClass *widget_class;
  
  object_class = (GObjectClass*) _class;
  widget_class = (GtkWidgetClass*) _class;
  parent_class = g_type_parent (GTK_TYPE_TEXT_BUFFER);

}

static void 
gtk_source_buffer_init(GtkSourceBuffer *text)
{
  text->check_brackets=FALSE;
  text->highlight=TRUE;
  text->exselect_tag=gtk_text_buffer_create_tag(GTK_TEXT_BUFFER(text),"exselect",NULL);
  g_object_set(G_OBJECT(text->exselect_tag),"foreground","gray",NULL);
  g_object_set(G_OBJECT(text->exselect_tag),"weight",PANGO_WEIGHT_BOLD,NULL);
  text->mark = NULL;
  text->undo_list = text->undo_current = NULL;
  text->undo_count = text->redo_count = 0;
  text->undo_max = UNDO_MAX;
  text->undo_processing_array = NULL;

/*
  gtk_signal_connect(GTK_OBJECT(text),"move_to_column", 
      				GTK_SIGNAL_FUNC(check_brackets),NULL);	
  gtk_signal_connect(GTK_OBJECT(text),"move_to_row", 
      				GTK_SIGNAL_FUNC(check_brackets),NULL);	
*/
  g_signal_connect_closure(G_OBJECT(text),"delete_range", 
      				g_cclosure_new((GCallback) property_text_remove,NULL,NULL),
                          FALSE);	
  g_signal_connect_closure(G_OBJECT(text),"delete_range", 
      				g_cclosure_new((GCallback) property_text_remove_after,NULL,NULL),
                          TRUE);	
  g_signal_connect_closure(G_OBJECT(text),"insert_text",
						g_cclosure_new((GCallback) property_text_insert,NULL,NULL)
                              ,FALSE);	
  g_signal_connect_closure(G_OBJECT(text),"insert_text",
						g_cclosure_new((GCallback) property_text_insert_after,NULL,NULL)
                              ,TRUE);	

  g_signal_connect_closure(G_OBJECT(text),"begin_user_action",
						g_cclosure_new((GCallback) begin_user_action,NULL,NULL)
                              ,FALSE);	
  g_signal_connect_closure(G_OBJECT(text),"end_user_action",
						g_cclosure_new((GCallback) end_user_action,NULL,NULL)
                              ,FALSE);	

  g_signal_connect_closure(G_OBJECT(text),"mark_set", 
      				g_cclosure_new((GCallback) move_cursor,NULL,NULL),
                          TRUE);	

/* 
 gtk_signal_connect(GTK_OBJECT(text),"property_mark",
						GTK_SIGNAL_FUNC(property_mark),NULL);	
  */
}

void
gtk_source_buffer_set_check_brackets(GtkSourceBuffer *text,gboolean set)
{
  g_return_if_fail (text != NULL);
  g_return_if_fail (GTK_IS_SOURCE_BUFFER (text));

  text->check_brackets=set;
}

void
gtk_source_buffer_set_highlight(GtkSourceBuffer *text,gboolean set)
{
  GtkTextIter iter1,iter2;
  g_return_if_fail (text != NULL);
  g_return_if_fail (GTK_IS_SOURCE_BUFFER (text));
  
  text->highlight=set;

  gtk_text_buffer_get_bounds(GTK_TEXT_BUFFER(text),&iter1,&iter2);  
  if(text->highlight)  {
    property_text_insert(GTK_TEXT_BUFFER(text),&iter1,"",0);    
  }

/*  gtk_widget_queue_draw(GTK_WIDGET(text));*/
}

GtkType 
gtk_source_buffer_get_type(void)
{
	static GType our_type=0;

	if(!our_type)
	{
      static const GTypeInfo our_info =
      {
        sizeof (GtkSourceBufferClass),
        (GBaseInitFunc) NULL,
        (GBaseFinalizeFunc) NULL,
        (GClassInitFunc) gtk_source_buffer_class_init,
        NULL,           /* class_finalize */
        NULL,           /* class_data */
        sizeof (GtkSourceBuffer),
        0,              /* n_preallocs */
        (GInstanceInitFunc) gtk_source_buffer_init
      };

      our_type = g_type_register_static (GTK_TYPE_TEXT_BUFFER,
                                         "GtkSourceBuffer",
                                         &our_info,
                                         0);
	}
	return our_type;
}




gint
gtk_source_buffer_regex_search (const char *txt, gint pos, Regex *regex,
	     gboolean forward, 
		GtkSourceBufferMatch *m)
{
  gint len;
  g_return_val_if_fail (regex != NULL, -1);
  g_return_val_if_fail (m != NULL, -1);

  len=strlen(txt);  
  m->startpos = re_search (&regex->buf,txt,len,
			 pos,
			 (forward ? len - pos : -pos),
			 &regex->reg);

  if (m->startpos > -1) m->endpos = regex->reg.end[0];

  return m->startpos;    
}

void
get_tags_func (GtkTextTag *tag, gpointer data)
{
  GList** list = (GList **)data;
  *list=g_list_append(*list, tag);
};

GList *
gtk_source_buffer_get_tags(GtkSourceBuffer *buf)
{
  GtkTextTagTable *table=NULL;
  GList *list=NULL;

  g_return_val_if_fail (GTK_IS_SOURCE_BUFFER (buf), NULL);
  
  table = gtk_text_buffer_get_tag_table (GTK_TEXT_BUFFER(buf));
  gtk_text_tag_table_foreach (table, get_tags_func, &list);
  list=g_list_first(list);

  return list;
}

gint
gtk_source_buffer_get_n_syntax_tag (GtkSourceBuffer *buf)
{
  gint n = 0;
  GList *list = NULL;
  g_return_val_if_fail (GTK_IS_SOURCE_BUFFER (buf), 0);

  list = gtk_source_buffer_get_first_syntax_tag (buf);
  while(list)  
    {
      n++;
      list = gtk_source_buffer_get_next_syntax_tag(list);
    };

  return n;
}

GList*
gtk_source_buffer_get_first_pattern_tag (GtkSourceBuffer *buf)
{
  GList *list = NULL;
  g_return_val_if_fail (GTK_IS_SOURCE_BUFFER (buf), NULL);
  
  list = gtk_source_buffer_get_tags (buf);
  while(list && list->data) 
   {
      if(GTK_IS_PATTERN_TAG (list->data))   
        return list;

      list=g_list_next(list);
    };

  g_print("no pattern tags installed???");
  return NULL;
}

GList*
gtk_source_buffer_get_first_syntax_tag (GtkSourceBuffer *buf)
{
  GList *list;
  g_return_val_if_fail (GTK_IS_SOURCE_BUFFER (buf),NULL);

  list = gtk_source_buffer_get_tags (buf);
  while(list) 
   {
      if(GTK_IS_SYNTAX_TAG (list->data))   
        return list;

      list=g_list_next(list);
    };

  return NULL;
}

GList *
gtk_source_buffer_get_next_pattern_tag (GList *list)
{
  while(list)  {
    list=g_list_next (list);
    if(list && list->data && GTK_IS_PATTERN_TAG (list->data))   
      return list;
  };
  return NULL;
}

GList*
gtk_source_buffer_get_next_syntax_tag (GList *list)
{
  while(list)  {
    list=g_list_next (list);
    if(list && GTK_IS_SYNTAX_TAG (list->data))   
      return list;
  };
  return NULL;
}

/* regex_match -- tries to match regex at the 'pos' position in the
 * text. It returns the number of chars matched, or -1 if no match.
 * Warning!  The number matched can be 0, if the regex matches the
 * empty string.  The reason for workin on GtkSCText is the same as in
 * regex_search. */
gint
gtk_source_buffer_regex_match (const char *txt, gint pos,gint stop, Regex *regex)
{

  g_return_val_if_fail (regex != NULL, -1);


  return re_match (&regex->buf,
           txt, 
          stop,
		    pos,  	     
		      &regex->reg);
}

/* below code is ported from glibber copyright Chris Phelps <chicane@reninet.com> */

gboolean 
gtk_source_buffer_find_bracket_match(GtkTextIter *orig)
{
  GtkTextIter iter = *orig;
   gunichar base_char = 0;
   gunichar search_char = 0;
   gunichar cur_char = 0;
   gint addition = -1;
   gint counter = 0;
   gboolean found = FALSE;


    gtk_text_iter_backward_char(&iter);
   cur_char = gtk_text_iter_get_char(&iter);

   base_char = cur_char;
   switch((int)base_char)
   {
      case '{': addition = 1;
                search_char = '}';
                break;
      case '(': addition = 1;
                search_char = ')';
                break;
      case '[': addition = 1;
                search_char = ']';
                break;
      case '<': addition = 1;
                search_char = '>';
                break;
      case '}': addition = -1;
                search_char = '{';
                break;
      case ')': addition = -1;
                search_char = '(';
                break;
      case ']': addition = -1;
                search_char = '[';
                break;
      case '>': addition = -1;
                search_char = '<';
                break;
      default : addition = 0;
                break;
   }
   if(!addition) return(FALSE);

   do
   {
      gtk_text_iter_forward_chars(&iter,addition);

       cur_char = gtk_text_iter_get_char(&iter);
      if(cur_char == search_char && !counter)
      {
         found = TRUE;
         break;
      }
      if(cur_char == base_char)
         counter++;
      else if(cur_char == search_char)
         counter--;
   }
   //   while(!gtk_text_iter_is_end(&iter) && !gtk_text_iter_is_first(&iter));
      while(!gtk_text_iter_is_end(&iter) && !gtk_text_iter_is_start(&iter));

   if(found) *orig=iter;

   return(found);
}

/* gtk_source_buffer_convert_to_html */
/* converts the hihlighted sourcebuffer to an html document */

gchar *
gtk_source_buffer_convert_to_html(GtkSourceBuffer *buf,const gchar *htmltitle)
{
  char txt[3];
  GtkTextIter iter;
  gboolean bold=FALSE,italic=FALSE,underline=FALSE;   
  GString *str=NULL;
  GSList *list=NULL;
  GtkTextTag *tag=NULL;
  gunichar c=0;
  txt[1]=0;
  tag=NULL;

  g_return_val_if_fail (GTK_IS_SOURCE_BUFFER (buf), NULL);

  gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(buf),&iter,0);

  str = g_string_new("<html>\n");
  g_string_append(str,"<head>\n");
  g_string_sprintfa(str,"<title>%s</title>\n",htmltitle ? htmltitle : "GtkSourceView converter");
  g_string_append(str,"</head>\n"); 
  g_string_append(str,"<body>\n"); 
  g_string_append(str,"<pre>"); 


   while(!gtk_text_iter_is_end(&iter))
  {
    c=gtk_text_iter_get_char(&iter);

    if(!tag)
    {
      list=gtk_text_iter_get_toggled_tags(&iter,TRUE);
      if(list && g_slist_last(list)->data)  {
        if(g_slist_length(list) > 1)
          g_print("TODO: There are %d tags at this position!\nTODO: we need to check for highest priority tag\n",g_slist_length(list));

        tag=GTK_TEXT_TAG(g_slist_last(list)->data);
        g_slist_free(list);
      }
      if(tag && !gtk_text_iter_ends_tag(&iter,tag))
      {
        GdkColor *col=NULL;
        GValue val={0,};
        g_value_init(&val,0/*GTK_TYPE_GDK_COLOR*/); 
        g_object_get_property(G_OBJECT(tag),"foreground_gdk",&val);
        col=g_value_peek_pointer(&val);
        if (col)
          g_string_sprintfa(str,"<font color=#%X%X%X>",col->red,col->green,col->blue);

        g_value_unset(&val);
        g_value_init(&val,G_TYPE_ENUM);
        g_object_get_property(G_OBJECT(tag),"weight",&val);
        if(g_value_get_enum(&val) == PANGO_WEIGHT_BOLD) {
          g_string_append(str,"<b>");
          bold=TRUE;
         }

        g_value_unset(&val);
        g_value_init(&val,G_TYPE_BOOLEAN);
        g_object_get_property(G_OBJECT(tag),"style",&val);
        if(g_value_get_boolean(&val) ) {
          g_string_append(str,"<i>");
          italic=TRUE;
         }
      }
    }    

    if(c=='<')
      g_string_append(str,"&lt");    
    else if(c=='>')
      g_string_append(str,"&gt");    
    else  
    {
      txt[0]=c;
      g_string_append(str,txt); 
    }

    gtk_text_iter_forward_char(&iter);
    if(tag && gtk_text_iter_ends_tag(&iter,tag))
    {
      if(bold)
        g_string_append(str,"</b>");
      if(italic)
        g_string_append(str,"</i>");
      if(underline)
        g_string_append(str,"</u>");

      g_string_append(str,"</font>");
      tag=NULL;
      
      bold=italic=underline=FALSE;
    }
  };

  g_string_append(str,"</pre>"); 
  g_string_append(str,"</body>");
  g_string_append(str,"</html>");

  return g_string_free(str,FALSE);
}


/***************************************************************************/
/*                       undo implementation                              */
/***************************************************************************/

static void
undo_free(gpointer data, gpointer userdata)
{
  gint i=0;
  GPtrArray *array = (GPtrArray *)data;

  for(i=0; i < array->len ;i++)
    if(((UndoObject*)g_ptr_array_index(array,i))->data)
      g_free(((UndoObject*)g_ptr_array_index(array,i))->data);            

  /* free array and UndoObject segment */
  g_ptr_array_free(array,TRUE);
};

void
begin_user_action(GtkTextBuffer *buf)
{
  GtkSourceBuffer *sbuf; 
  //  g_print("undo array init (begin)\n");
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));
  g_return_if_fail(GTK_SOURCE_BUFFER(buf)->undo_processing_array == NULL);

  sbuf=GTK_SOURCE_BUFFER(buf); 
  sbuf->undo_processing_array=g_ptr_array_sized_new(2);
  // g_print("undo array init (begin)\n");
}

void
end_user_action(GtkTextBuffer *buf)
{
  GtkSourceBuffer *sbuf; 
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));
  g_return_if_fail(GTK_SOURCE_BUFFER(buf)->undo_processing_array != NULL);

  sbuf=GTK_SOURCE_BUFFER(buf); 

  if (sbuf->undo_count == sbuf->undo_max)  
  {
    undo_free(g_list_first(sbuf->undo_list)->data,NULL);
    sbuf->undo_list = g_list_delete_link(sbuf->undo_list,g_list_first(sbuf->undo_list));
  }

  sbuf->undo_list = g_list_append(sbuf->undo_list, sbuf->undo_processing_array);
  sbuf->undo_current = g_list_last(sbuf->undo_list); 
  sbuf->undo_count++;
  sbuf->undo_processing_array = NULL;

  // g_print("undo array added\n");
}


void
gtk_source_buffer_clear_undo_stack(GtkSourceBuffer *buf)
{
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));

  if (buf->undo_list)
  {
    g_list_foreach(buf->undo_list,(GFunc)undo_free,NULL);
    g_list_free(buf->undo_list);
    buf->undo_list =buf->undo_current=NULL;
    buf->undo_count = buf->redo_count  = 0;
  }
}

void
gtk_source_buffer_set_max_undo_stack(GtkSourceBuffer *buf, gint max)
{
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));

  gtk_source_buffer_clear_undo_stack(buf);  
  buf->undo_max = max;
}

void
gtk_source_buffer_undo(GtkSourceBuffer *buf)
{
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));
  
  if(!buf->undo_count || !buf->undo_current) 
    return ;

  gtk_source_buffer_undo_array(buf,(GPtrArray *)buf->undo_current->data);

  buf->undo_count--;
  undo_free(buf->undo_current->data,NULL);
  buf->undo_list = g_list_delete_link(buf->undo_list,buf->undo_current);
  buf->undo_current = g_list_last(buf->undo_list);

}

void
gtk_source_buffer_undo_array(GtkSourceBuffer *buf, GPtrArray *array)
{
  gint i=0;
  GtkTextIter iter,iter2;
  UndoObject *undo=NULL;
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));

  if(!array || !array->len)
    return ;

  for(i=0;i < array->len;i++)
  {
    undo = (UndoObject *)g_ptr_array_index(array, i);
    if(!undo)  
    {
      g_warning("undo stack error???????\n");  
      return ;
    }

    g_print("undo typ %d offset %d len %d\n",undo->type,undo->offset,undo->len); 
    if(undo->type == UNDO_TYPE_INSERT_TEXT)
    {
      gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(buf),&iter,undo->offset);
      gtk_text_buffer_insert(GTK_TEXT_BUFFER(buf),&iter,(const gchar *)undo->data,undo->len);
      iter2=iter;
    }
    else if(undo->type == UNDO_TYPE_REMOVE_RANGE)
    {
     gtk_text_buffer_get_iter_at_offset(GTK_TEXT_BUFFER(buf),&iter,undo->offset);
      iter2=iter;
      gtk_text_iter_forward_chars(&iter2,undo->len);
      gtk_text_buffer_delete(GTK_TEXT_BUFFER(buf),&iter,&iter2);
    }
    else
      g_print("undo type not supported");

/*    gtk_text_buffer_move_mark (buf,gtk_text_buffer_get_mark(buf,"insert"),&iter2);*/
  }
}

void
gtk_source_buffer_redo(GtkSourceBuffer *buf)
{
  g_return_if_fail(GTK_IS_SOURCE_BUFFER(buf));

  if(!buf->redo_count) 
    return ;

  g_print("TODO: implement redo\n");

/*
  gtk_source_buffer_undo_array(buf,(GPtrArray *)buf->redo_array);
  buf->redo_count--;
*/

}

gint
gtk_source_buffer_get_undo_count(GtkSourceBuffer *buf)
{
  g_return_val_if_fail(GTK_IS_SOURCE_BUFFER(buf), 0);

  return buf->undo_count;
}

gint
gtk_source_buffer_get_redo_count(GtkSourceBuffer *buf)
{
  g_return_val_if_fail(GTK_IS_SOURCE_BUFFER(buf), 0);

  return buf->redo_count;
}

gint
gtk_source_buffer_undo_append(GtkSourceBuffer *buf,gint typ,const GtkTextIter *iter1,const GtkTextIter *iter2)
{
  UndoObject *undo = NULL;

  g_return_val_if_fail(GTK_IS_SOURCE_BUFFER(buf), 0);

  if( !buf->undo_processing_array)
    return 0;

  if(!buf->undo_max)
    return 0;

  undo=g_new(UndoObject,1);
  undo->type = typ;
  if(typ == UNDO_TYPE_REMOVE_RANGE)
  {
    undo->offset = gtk_text_iter_get_offset(iter1);
    undo->len = gtk_text_iter_get_offset(iter2) - undo->offset;
    undo->data = NULL; 
  }  
  else if(typ == UNDO_TYPE_INSERT_TEXT)
  {
    undo->offset = gtk_text_iter_get_offset(iter1);
    undo->len = gtk_text_iter_get_offset(iter2) - undo->offset;
    undo->data = gtk_text_buffer_get_slice(GTK_TEXT_BUFFER (buf), iter1, iter2, TRUE);
  }
  else
    g_warning("Undo type not supported :-/\n");

  g_ptr_array_add(buf->undo_processing_array,undo);
  
  return buf->undo_processing_array->len;
}
