/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include "vdk/evbrowser.h"
#include "vdk/forms.h"

/*
 */
VDKEventBrowser::VDKEventBrowser(VDKForm* owner, 
				 unsigned int tick):
  VDKObject(owner),tick(tick)
{
timerId = 0;
started = false; 
owner->Objects().add(this);
EventType = no_event;
RemoveEvent = false;
}
/*
 */
VDKEventBrowser::~VDKEventBrowser()
{
if(started)
  gtk_timeout_remove(timerId);
}
/*
 */
void VDKEventBrowser::Stop()
{
if(! timerId)
  return;
else 
  {
    gtk_timeout_remove(timerId);
    started = false;
    timerId = 0;
  }
}
/*
 */
void VDKEventBrowser::Start()
{
if(!started)
  {
    timerId = gtk_timeout_add(tick,VDKEventBrowser::HandleTimerTick,this);
    started = true;
  }
} 
/*
 */
int  VDKEventBrowser::HandleTimerTick(gpointer obj)
{
  GdkEvent* event = NULL;
  VDKEventBrowser* browser = (VDKEventBrowser*) obj;
  VDKForm* owner = browser->Owner();
  if((browser->EventType != no_event) && (event = gdk_event_get()) )
    {
      GdkEvent* copy = gdk_event_copy (event);
      if((VDKEvent) copy->type == browser->EventType) 
	{  
	  browser->Event = copy;
	  if(owner->Window()->window == copy->any.window)
	    owner->VDKSignalResponse(NULL,event_browser_signal,obj,obj,false);
	  gdk_event_free(copy);
	  if(!browser->RemoveEvent)
	    gdk_event_put(event);
	}
      else
	gdk_event_put(event);
      gdk_event_free(event);
    } 
  browser->Event = NULL;
  return TRUE;
}

