/* vbfutils.c generated by valac 0.12.1.1-323029-dirty, the Vala compiler
 * generated from vbfutils.vala, do not modify */

/*
 *  vbfutils.vala - Vala Build Framework library
 *  
 *  Copyright (C) 2008 - Andrea Del Signore <sejerpz@tin.it>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <glib/gstdio.h>
#include <config.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))



void vbf_utils_log_message (const gchar* log_domain, const gchar* format, va_list args);
void vbf_utils_trace (const gchar* format, ...);
gboolean vbf_utils_is_autotools_project (const gchar* path);
gboolean vbf_utils_is_waf_project (const gchar* path);
gboolean vbf_utils_is_cmake_project (const gchar* path);
gboolean vbf_utils_is_simple_make_project (const gchar* path);
gchar* vbf_utils_guess_package_vapi (const gchar* using_name, gchar** vapi_dirs, int vapi_dirs_length1);
gboolean vbf_utils_is_vala_source (const gchar* filename);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


/**
 * This function shouldn't be used directly but just wrapped with a private one that
 * will specify the correct log domain. See the function trace (...) in this same source 
 */
inline void vbf_utils_log_message (const gchar* log_domain, const gchar* format, va_list args) {
	g_return_if_fail (log_domain != NULL);
	g_return_if_fail (format != NULL);
	g_logv (log_domain, G_LOG_LEVEL_INFO, format, args);
}


inline void vbf_utils_trace (const gchar* format, ...) {
	va_list va;
	va_list va2;
	g_return_if_fail (format != NULL);
	va_start (va, format);
	va_copy (va2, va);
	vbf_utils_log_message ("ValaBuildFramework", format, va2);
	va_end (va2);
	va_end (va);
}


static gchar* bool_to_string (gboolean self) {
	gchar* result = NULL;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}


gboolean vbf_utils_is_autotools_project (const gchar* path) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* config_file;
	gchar* _tmp1_ = NULL;
	gchar* autogen_file;
	gboolean res;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_build_filename (path, "configure.ac", NULL);
	config_file = _tmp0_;
	_tmp1_ = g_build_filename (path, "autogen.sh", NULL);
	autogen_file = _tmp1_;
	res = FALSE;
	_tmp3_ = g_file_test (config_file, G_FILE_TEST_EXISTS);
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp4_;
		_tmp4_ = g_file_test (autogen_file, G_FILE_TEST_EXISTS);
		_tmp2_ = _tmp4_;
	}
	if (_tmp2_) {
		gchar* _tmp5_ = NULL;
		gchar* file;
		gboolean _tmp6_;
		_tmp5_ = g_build_filename (path, "Makefile.am", NULL);
		file = _tmp5_;
		_tmp6_ = g_file_test (file, G_FILE_TEST_EXISTS);
		if (_tmp6_) {
			res = TRUE;
		}
		_g_free0 (file);
	}
	_tmp7_ = bool_to_string (res);
	_tmp8_ = _tmp7_;
	vbf_utils_trace ("vbfutils.vala:59: project at: %s is autotools %s", path, _tmp8_);
	_g_free0 (_tmp8_);
	result = res;
	_g_free0 (autogen_file);
	_g_free0 (config_file);
	return result;
}


gboolean vbf_utils_is_waf_project (const gchar* path) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* file;
	gboolean res;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_build_filename (path, "wscript", NULL);
	file = _tmp0_;
	res = FALSE;
	_tmp1_ = g_file_test (file, G_FILE_TEST_EXISTS);
	if (_tmp1_) {
		res = TRUE;
	}
	_tmp2_ = bool_to_string (res);
	_tmp3_ = _tmp2_;
	vbf_utils_trace ("vbfutils.vala:72: project at: %s is waf %s", path, _tmp3_);
	_g_free0 (_tmp3_);
	result = res;
	_g_free0 (file);
	return result;
}


gboolean vbf_utils_is_cmake_project (const gchar* path) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* file;
	gboolean res;
	gboolean _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_build_filename (path, "CMakeLists.txt", NULL);
	file = _tmp0_;
	res = FALSE;
	_tmp1_ = g_file_test (file, G_FILE_TEST_EXISTS);
	if (_tmp1_) {
		res = TRUE;
	}
	_tmp2_ = bool_to_string (res);
	_tmp3_ = _tmp2_;
	vbf_utils_trace ("vbfutils.vala:85: project at: %s is cmake %s", path, _tmp3_);
	_g_free0 (_tmp3_);
	result = res;
	_g_free0 (file);
	return result;
}


gboolean vbf_utils_is_simple_make_project (const gchar* path) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* makefile;
	gchar* _tmp1_ = NULL;
	gchar* makefile_am;
	gchar* _tmp2_ = NULL;
	gchar* makefile_in;
	gboolean res;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_val_if_fail (path != NULL, FALSE);
	_tmp0_ = g_build_filename (path, "Makefile", NULL);
	makefile = _tmp0_;
	_tmp1_ = g_build_filename (path, "Makefile.am", NULL);
	makefile_am = _tmp1_;
	_tmp2_ = g_build_filename (path, "Makefile.in", NULL);
	makefile_in = _tmp2_;
	res = FALSE;
	_tmp5_ = g_file_test (makefile, G_FILE_TEST_EXISTS);
	if (_tmp5_) {
		gboolean _tmp6_;
		_tmp6_ = g_file_test (makefile_in, G_FILE_TEST_EXISTS);
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp7_;
		_tmp7_ = g_file_test (makefile_am, G_FILE_TEST_EXISTS);
		_tmp3_ = !_tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		res = TRUE;
	}
	_tmp8_ = bool_to_string (res);
	_tmp9_ = _tmp8_;
	vbf_utils_trace ("vbfutils.vala:102: project at: %s is simple make %s", path, _tmp9_);
	_g_free0 (_tmp9_);
	result = res;
	_g_free0 (makefile_in);
	_g_free0 (makefile_am);
	_g_free0 (makefile);
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch3_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch3_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally3;
	__catch3_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_ = NULL;
	gchar* end;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	if (end == NULL) {
		result = maxlen;
		return result;
	} else {
		result = (glong) (end - str);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= 0) {
		_tmp0_ = len >= 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		glong _tmp1_;
		_tmp1_ = string_strnlen ((gchar*) self, offset + len);
		string_length = _tmp1_;
	} else {
		gint _tmp2_;
		_tmp2_ = strlen (self);
		string_length = (glong) _tmp2_;
	}
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


gchar* vbf_utils_guess_package_vapi (const gchar* using_name, gchar** vapi_dirs, int vapi_dirs_length1) {
	gchar* result = NULL;
	gchar** real_using_names = NULL;
	gint real_using_names_length1 = 0;
	gint _real_using_names_size_ = 0;
	gchar* vapi_file;
	gboolean _tmp0_ = FALSE;
	gchar* curr = NULL;
	gchar** dirs = NULL;
	gint dirs_length1 = 0;
	gint _dirs_size_ = 0;
	gint dir_count;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* thirdy_party_vapi_dir;
	gboolean _tmp13_;
	gboolean thirdy_party_vapi_dir_bool;
	gchar** _tmp14_ = NULL;
	gchar* _tmp15_;
	gchar* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (using_name != NULL, NULL);
	vapi_file = NULL;
	if (g_strcmp0 (using_name, "Gtk") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (using_name, "Gtk+") == 0;
	}
	if (_tmp0_) {
		gchar** _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = g_new0 (gchar*, 2 + 1);
		real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
		real_using_names = _tmp1_;
		real_using_names_length1 = 2;
		_real_using_names_size_ = 2;
		_tmp2_ = g_strdup ("gtk+-2.0");
		_tmp3_ = _tmp2_;
		_g_free0 (real_using_names[0]);
		real_using_names[0] = _tmp3_;
		_tmp4_ = g_strdup ("gtk+");
		_tmp5_ = _tmp4_;
		_g_free0 (real_using_names[1]);
		real_using_names[1] = _tmp5_;
	} else {
		gchar** _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = g_new0 (gchar*, 1 + 1);
		real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
		real_using_names = _tmp6_;
		real_using_names_length1 = 1;
		_real_using_names_size_ = 1;
		_tmp7_ = g_strdup (using_name);
		_tmp8_ = _tmp7_;
		_g_free0 (real_using_names[0]);
		real_using_names[0] = _tmp8_;
	}
	dir_count = 1;
	if (vapi_dirs != NULL) {
		dir_count = dir_count + vapi_dirs_length1;
	}
	_tmp9_ = g_strdup_printf ("vala-%s", VALA_VERSION);
	_tmp10_ = _tmp9_;
	_tmp11_ = string_replace (VALA_VAPIDIR, _tmp10_, "vala");
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	thirdy_party_vapi_dir = _tmp12_;
	_tmp13_ = g_file_test (thirdy_party_vapi_dir, G_FILE_TEST_IS_DIR);
	thirdy_party_vapi_dir_bool = _tmp13_;
	if (thirdy_party_vapi_dir_bool) {
		dir_count++;
	}
	_tmp14_ = g_new0 (gchar*, dir_count + 1);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	dirs = _tmp14_;
	dirs_length1 = dir_count;
	_dirs_size_ = dir_count;
	_tmp15_ = g_strdup (VALA_VAPIDIR);
	_tmp16_ = _tmp15_;
	_g_free0 (dirs[0]);
	dirs[0] = _tmp16_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp17_;
			_tmp17_ = TRUE;
			while (TRUE) {
				gchar* _tmp18_;
				gchar* _tmp19_;
				if (!_tmp17_) {
					i++;
				}
				_tmp17_ = FALSE;
				if (!(i < vapi_dirs_length1)) {
					break;
				}
				_tmp18_ = g_strdup (vapi_dirs[i]);
				_tmp19_ = _tmp18_;
				_g_free0 (dirs[i + 1]);
				dirs[i + 1] = _tmp19_;
			}
		}
	}
	if (thirdy_party_vapi_dir_bool) {
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp20_ = g_strdup (thirdy_party_vapi_dir);
		_tmp21_ = _tmp20_;
		_g_free0 (dirs[dirs_length1 - 1]);
		dirs[dirs_length1 - 1] = _tmp21_;
	}
	{
		gchar** real_using_name_collection;
		int real_using_name_collection_length1;
		int real_using_name_it;
		real_using_name_collection = real_using_names;
		real_using_name_collection_length1 = real_using_names_length1;
		for (real_using_name_it = 0; real_using_name_it < real_using_names_length1; real_using_name_it = real_using_name_it + 1) {
			gchar* _tmp22_;
			gchar* real_using_name;
			_tmp22_ = g_strdup (real_using_name_collection[real_using_name_it]);
			real_using_name = _tmp22_;
			{
				gchar* _tmp23_;
				gchar* filename;
				gchar* _tmp24_ = NULL;
				gchar* lowercase_filename;
				gchar* _tmp25_ = NULL;
				gchar* lowercase_using_name;
				gchar* _tmp26_;
				gchar* lib_filename;
				gchar* _tmp27_;
				gchar* lib_lowercase_filename;
				gchar* _tmp28_;
				gchar* lib_lowercase_using_name;
				_tmp23_ = g_strconcat (real_using_name, ".vapi", NULL);
				filename = _tmp23_;
				_tmp24_ = g_utf8_strdown (filename, (gssize) (-1));
				lowercase_filename = _tmp24_;
				_tmp25_ = g_utf8_strdown (real_using_name, (gssize) (-1));
				lowercase_using_name = _tmp25_;
				_tmp26_ = g_strconcat ("lib", filename, NULL);
				lib_filename = _tmp26_;
				_tmp27_ = g_strconcat ("lib", lowercase_filename, NULL);
				lib_lowercase_filename = _tmp27_;
				_tmp28_ = g_strconcat ("lib", lowercase_using_name, NULL);
				lib_lowercase_using_name = _tmp28_;
				{
					gchar** vapi_dir_collection;
					int vapi_dir_collection_length1;
					int vapi_dir_it;
					vapi_dir_collection = dirs;
					vapi_dir_collection_length1 = dirs_length1;
					for (vapi_dir_it = 0; vapi_dir_it < dirs_length1; vapi_dir_it = vapi_dir_it + 1) {
						gchar* _tmp29_;
						gchar* vapi_dir;
						_tmp29_ = g_strdup (vapi_dir_collection[vapi_dir_it]);
						vapi_dir = _tmp29_;
						{
							GDir* _tmp30_ = NULL;
							GDir* dir;
							_tmp30_ = g_dir_open (vapi_dir, (guint) 0, &_inner_error_);
							dir = _tmp30_;
							if (_inner_error_ != NULL) {
								_g_free0 (vapi_dir);
								_g_free0 (lib_lowercase_using_name);
								_g_free0 (lib_lowercase_filename);
								_g_free0 (lib_filename);
								_g_free0 (lowercase_using_name);
								_g_free0 (lowercase_filename);
								_g_free0 (filename);
								_g_free0 (real_using_name);
								goto __catch4_g_error;
							}
							while (TRUE) {
								const gchar* _tmp31_ = NULL;
								gchar* _tmp32_;
								gchar* _tmp33_ = NULL;
								gchar* curr_file;
								gboolean _tmp34_ = FALSE;
								gboolean _tmp35_ = FALSE;
								gboolean _tmp36_ = FALSE;
								gboolean _tmp37_ = FALSE;
								gboolean _tmp38_ = FALSE;
								_tmp31_ = g_dir_read_name (dir);
								_tmp32_ = g_strdup (_tmp31_);
								_g_free0 (curr);
								curr = _tmp32_;
								if (!(curr != NULL)) {
									break;
								}
								_tmp33_ = g_locale_to_utf8 (curr, (gssize) (-1), NULL, NULL, NULL);
								curr_file = _tmp33_;
								if (g_strcmp0 (curr_file, filename) == 0) {
									_tmp38_ = TRUE;
								} else {
									_tmp38_ = g_strcmp0 (curr_file, lib_filename) == 0;
								}
								if (_tmp38_) {
									_tmp37_ = TRUE;
								} else {
									_tmp37_ = g_strcmp0 (curr_file, lowercase_filename) == 0;
								}
								if (_tmp37_) {
									_tmp36_ = TRUE;
								} else {
									_tmp36_ = g_strcmp0 (curr_file, lib_lowercase_filename) == 0;
								}
								if (_tmp36_) {
									_tmp35_ = TRUE;
								} else {
									gboolean _tmp39_;
									_tmp39_ = g_str_has_prefix (curr_file, lowercase_using_name);
									_tmp35_ = _tmp39_;
								}
								if (_tmp35_) {
									_tmp34_ = TRUE;
								} else {
									gboolean _tmp40_;
									_tmp40_ = g_str_has_prefix (curr_file, lib_lowercase_using_name);
									_tmp34_ = _tmp40_;
								}
								if (_tmp34_) {
									gboolean _tmp41_ = FALSE;
									if (vapi_file == NULL) {
										_tmp41_ = TRUE;
									} else {
										gint _tmp42_;
										gint _tmp43_;
										_tmp42_ = strlen (vapi_file);
										_tmp43_ = strlen (curr);
										_tmp41_ = _tmp42_ > (_tmp43_ - 5);
									}
									if (_tmp41_) {
										gint _tmp44_;
										gchar* _tmp45_ = NULL;
										_tmp44_ = strlen (curr);
										_tmp45_ = string_substring (curr, (glong) 0, (glong) (_tmp44_ - 5));
										_g_free0 (vapi_file);
										vapi_file = _tmp45_;
									}
								} else {
									gboolean _tmp46_;
									_tmp46_ = string_contains (curr, "-");
									if (_tmp46_) {
										gchar* _tmp47_ = NULL;
										gboolean _tmp48_ = FALSE;
										gboolean _tmp49_ = FALSE;
										gboolean _tmp50_ = FALSE;
										gboolean _tmp51_ = FALSE;
										gboolean _tmp52_ = FALSE;
										_tmp47_ = string_replace (curr_file, "-", "");
										_g_free0 (curr_file);
										curr_file = _tmp47_;
										if (g_strcmp0 (curr_file, filename) == 0) {
											_tmp52_ = TRUE;
										} else {
											_tmp52_ = g_strcmp0 (curr_file, lib_filename) == 0;
										}
										if (_tmp52_) {
											_tmp51_ = TRUE;
										} else {
											_tmp51_ = g_strcmp0 (curr_file, lowercase_filename) == 0;
										}
										if (_tmp51_) {
											_tmp50_ = TRUE;
										} else {
											_tmp50_ = g_strcmp0 (curr_file, lib_lowercase_filename) == 0;
										}
										if (_tmp50_) {
											_tmp49_ = TRUE;
										} else {
											gboolean _tmp53_;
											_tmp53_ = g_str_has_prefix (curr_file, lowercase_using_name);
											_tmp49_ = _tmp53_;
										}
										if (_tmp49_) {
											_tmp48_ = TRUE;
										} else {
											gboolean _tmp54_;
											_tmp54_ = g_str_has_prefix (curr_file, lib_lowercase_using_name);
											_tmp48_ = _tmp54_;
										}
										if (_tmp48_) {
											gboolean _tmp55_ = FALSE;
											if (vapi_file == NULL) {
												_tmp55_ = TRUE;
											} else {
												gint _tmp56_;
												gint _tmp57_;
												_tmp56_ = strlen (vapi_file);
												_tmp57_ = strlen (curr);
												_tmp55_ = _tmp56_ > (_tmp57_ - 5);
											}
											if (_tmp55_) {
												gint _tmp58_;
												gchar* _tmp59_ = NULL;
												_tmp58_ = strlen (curr);
												_tmp59_ = string_substring (curr, (glong) 0, (glong) (_tmp58_ - 5));
												_g_free0 (vapi_file);
												vapi_file = _tmp59_;
											}
										}
									}
								}
								_g_free0 (curr_file);
							}
							_g_dir_close0 (dir);
							_g_free0 (vapi_dir);
						}
					}
				}
				_g_free0 (lib_lowercase_using_name);
				_g_free0 (lib_lowercase_filename);
				_g_free0 (lib_filename);
				_g_free0 (lowercase_using_name);
				_g_free0 (lowercase_filename);
				_g_free0 (filename);
				_g_free0 (real_using_name);
			}
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_critical ("vbfutils.vala:182: error: %s", err->message);
		_g_error_free0 (err);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (thirdy_party_vapi_dir);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (curr);
		_g_free0 (vapi_file);
		real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = vapi_file;
	_g_free0 (thirdy_party_vapi_dir);
	dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (curr);
	real_using_names = (_vala_array_free (real_using_names, real_using_names_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


gboolean vbf_utils_is_vala_source (const gchar* filename) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp1_ = g_str_has_suffix (filename, ".vala");
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_;
		_tmp2_ = g_str_has_suffix (filename, ".vapi");
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



