/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};

static gint ValaMemberAccess_private_offset;
static gpointer vala_member_access_parent_class = NULL;

static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static void vala_member_access_real_get_error_types (ValaCodeNode* base,
                                              ValaCollection* collection,
                                              ValaSourceReference* source_reference);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);
static GType vala_member_access_get_type_once (void);

static inline gpointer
vala_member_access_get_instance_private (ValaMemberAccess* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMemberAccess_private_offset);
}

ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}

void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}

gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_pointer_member_access;
	return result;
}

void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}

gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_prototype_access;
	return result;
}

void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}

gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_tainted_access;
	return result;
}

void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}

gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_creation_member;
	return result;
}

void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}

gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_qualified;
	return result;
}

void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}

/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, NULL);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}

ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}

ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}

/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}

/**
 * Returns the list of generic type arguments.
 *
 * @return type argument list
 */
ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gpointer _tmp12_;
			ValaDataType* _tmp13_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = vala_list_get (_tmp11_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp12_;
			_tmp13_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}

static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	gchar* result = NULL;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}

static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}

static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaDataType* _tmp7_;
				gboolean _tmp8_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->type_argument_list;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->type_argument_list;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaDataType*) _tmp6_;
				_tmp8_ = _tmp7_ == old_type;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp8_) {
					ValaList* _tmp9_;
					_tmp9_ = self->priv->type_argument_list;
					vala_list_set (_tmp9_, i, new_type);
					return;
				}
			}
		}
	}
}

static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	method = VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL;
	_tmp2_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp3_ = _tmp2_;
	if (VALA_IS_CONSTANT (_tmp3_)) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp7_)) {
			ValaExpression* _tmp8_;
			ValaExpression* _tmp9_;
			_tmp8_ = vala_member_access_get_inner (self);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			ValaExpression* _tmp10_;
			ValaExpression* _tmp11_;
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			_tmp10_ = vala_member_access_get_inner (self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp4_ = VALA_IS_CONSTANT (_tmp13_);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp14_ = FALSE;
			ValaMethod* _tmp15_;
			_tmp15_ = method;
			if (_tmp15_ != NULL) {
				gboolean _tmp16_ = FALSE;
				ValaMethod* _tmp17_;
				ValaMemberBinding _tmp18_;
				ValaMemberBinding _tmp19_;
				_tmp17_ = method;
				_tmp18_ = vala_method_get_binding (_tmp17_);
				_tmp19_ = _tmp18_;
				if (_tmp19_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp16_ = TRUE;
				} else {
					gboolean _tmp20_;
					_tmp20_ = self->priv->_prototype_access;
					_tmp16_ = _tmp20_;
				}
				_tmp14_ = _tmp16_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				result = TRUE;
				return result;
			} else {
				result = FALSE;
				return result;
			}
		}
	}
}

static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	c = VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL;
	_tmp2_ = c;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		ValaConstant* _tmp4_;
		_tmp4_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp4_)) {
			_tmp3_ = TRUE;
		} else {
			ValaConstant* _tmp5_;
			ValaDataType* _tmp6_;
			ValaDataType* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp5_ = c;
			_tmp6_ = vala_constant_get_type_reference (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = vala_data_type_get_nullable (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp3_ = !_tmp9_;
		}
		result = _tmp3_;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static void
vala_member_access_real_get_error_types (ValaCodeNode* base,
                                         ValaCollection* collection,
                                         ValaSourceReference* source_reference)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
	}
}

static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp18_;
	gboolean _tmp606_ = FALSE;
	gboolean _tmp607_ = FALSE;
	gboolean _tmp608_ = FALSE;
	ValaExpression* _tmp609_;
	ValaExpression* _tmp610_;
	ValaSymbol* _tmp638_;
	ValaSymbol* _tmp639_;
	ValaSymbol* _tmp693_;
	ValaSymbol* _tmp694_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp732_;
	ValaSymbol* _tmp733_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp734_;
	ValaSymbol* _tmp735_;
	ValaCodeNode* parent = NULL;
	ValaCodeNode* _tmp1124_;
	ValaSymbol* _tmp1125_;
	ValaSymbol* _tmp1127_;
	ValaVersionAttribute* _tmp1128_;
	ValaVersionAttribute* _tmp1129_;
	ValaSourceReference* _tmp1130_;
	ValaSourceReference* _tmp1131_;
	gboolean _tmp1132_ = FALSE;
	ValaSymbolAccessibility _tmp1133_;
	gboolean _tmp1189_ = FALSE;
	gboolean _tmp1216_ = FALSE;
	gboolean _tmp1217_ = FALSE;
	ValaDataType* _tmp1496_;
	ValaDataType* _tmp1497_;
	gboolean _tmp1500_;
	gboolean _tmp1501_;
	gboolean _tmp1502_;
	gboolean result = FALSE;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gpointer _tmp16_;
			ValaDataType* _tmp17_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = vala_list_get (_tmp15_, _type_arg_index);
			type_arg = (ValaDataType*) _tmp16_;
			_tmp17_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp17_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp18_ = self->priv->_qualified;
	if (_tmp18_) {
		ValaNamespace* _tmp19_;
		ValaNamespace* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		const gchar* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp19_ = vala_code_context_get_root (context);
		_tmp20_ = _tmp19_;
		base_symbol = (ValaSymbol*) _tmp20_;
		_tmp21_ = base_symbol;
		_tmp22_ = vala_symbol_get_scope (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_member_name;
		_tmp25_ = vala_scope_lookup (_tmp23_, _tmp24_);
		_tmp26_ = _tmp25_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp26_);
		_vala_code_node_unref0 (_tmp26_);
	} else {
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp27_ = vala_member_access_get_inner (self);
		_tmp28_ = _tmp27_;
		if (_tmp28_ == NULL) {
			const gchar* _tmp29_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSemanticAnalyzer* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean _tmp140_ = FALSE;
			ValaSymbol* _tmp141_;
			ValaSymbol* _tmp142_;
			_tmp29_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp29_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp30_;
				ValaSemanticAnalyzer* _tmp31_;
				_tmp30_ = vala_code_context_get_analyzer (context);
				_tmp31_ = _tmp30_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp31_)) {
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp33_ = _tmp32_;
					vala_report_error (_tmp33_, "This access invalid outside of instance methods");
					result = FALSE;
					return result;
				}
			}
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_semantic_analyzer_get_current_symbol (_tmp35_);
			_tmp37_ = _tmp36_;
			base_symbol = _tmp37_;
			method_found = FALSE;
			_tmp38_ = vala_code_context_get_analyzer (context);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_semantic_analyzer_get_current_symbol (_tmp39_);
			_tmp41_ = _tmp40_;
			sym = _tmp41_;
			while (TRUE) {
				gboolean _tmp42_ = FALSE;
				ValaSymbol* _tmp43_;
				ValaSymbol* _tmp89_;
				const gchar* _tmp90_;
				ValaSymbol* _tmp91_;
				ValaSymbol* _tmp92_;
				gboolean _tmp93_ = FALSE;
				gboolean _tmp94_ = FALSE;
				ValaSymbol* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp134_;
				ValaSymbol* _tmp135_;
				ValaSymbol* _tmp137_;
				ValaSymbol* _tmp138_;
				ValaSymbol* _tmp139_;
				_tmp43_ = sym;
				if (_tmp43_ != NULL) {
					ValaSymbol* _tmp44_;
					ValaSymbol* _tmp45_;
					_tmp44_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp45_ = _tmp44_;
					_tmp42_ = _tmp45_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (!_tmp42_) {
					break;
				}
				if (!method_found) {
					ValaSymbol* _tmp46_;
					_tmp46_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp46_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp47_;
						ValaCreationMethod* _tmp48_;
						ValaParameter* _tmp49_;
						ValaParameter* _tmp50_;
						_tmp47_ = sym;
						cm = G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
						_tmp48_ = cm;
						_tmp49_ = vala_method_get_this_parameter ((ValaMethod*) _tmp48_);
						_tmp50_ = _tmp49_;
						this_parameter = _tmp50_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
					} else {
						ValaSymbol* _tmp51_;
						_tmp51_ = sym;
						if (VALA_IS_PROPERTY (_tmp51_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp52_;
							ValaProperty* _tmp53_;
							ValaParameter* _tmp54_;
							ValaParameter* _tmp55_;
							ValaProperty* _tmp56_;
							ValaMemberBinding _tmp57_;
							ValaMemberBinding _tmp58_;
							ValaProperty* _tmp59_;
							ValaMemberBinding _tmp60_;
							ValaMemberBinding _tmp61_;
							_tmp52_ = sym;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp53_ = prop;
							_tmp54_ = vala_property_get_this_parameter (_tmp53_);
							_tmp55_ = _tmp54_;
							this_parameter = _tmp55_;
							_tmp56_ = prop;
							_tmp57_ = vala_property_get_binding (_tmp56_);
							_tmp58_ = _tmp57_;
							may_access_instance_members = _tmp58_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp59_ = prop;
							_tmp60_ = vala_property_get_binding (_tmp59_);
							_tmp61_ = _tmp60_;
							may_access_klass_members = _tmp61_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
						} else {
							ValaSymbol* _tmp62_;
							_tmp62_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp62_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp63_;
								ValaConstructor* _tmp64_;
								ValaParameter* _tmp65_;
								ValaParameter* _tmp66_;
								ValaConstructor* _tmp67_;
								ValaMemberBinding _tmp68_;
								ValaMemberBinding _tmp69_;
								_tmp63_ = sym;
								c = G_TYPE_CHECK_INSTANCE_CAST (_tmp63_, VALA_TYPE_CONSTRUCTOR, ValaConstructor);
								_tmp64_ = c;
								_tmp65_ = vala_constructor_get_this_parameter (_tmp64_);
								_tmp66_ = _tmp65_;
								this_parameter = _tmp66_;
								_tmp67_ = c;
								_tmp68_ = vala_constructor_get_binding (_tmp67_);
								_tmp69_ = _tmp68_;
								may_access_instance_members = _tmp69_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
							} else {
								ValaSymbol* _tmp70_;
								_tmp70_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp70_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp71_;
									ValaDestructor* _tmp72_;
									ValaParameter* _tmp73_;
									ValaParameter* _tmp74_;
									ValaDestructor* _tmp75_;
									ValaMemberBinding _tmp76_;
									ValaMemberBinding _tmp77_;
									_tmp71_ = sym;
									d = G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_DESTRUCTOR, ValaDestructor);
									_tmp72_ = d;
									_tmp73_ = vala_destructor_get_this_parameter (_tmp72_);
									_tmp74_ = _tmp73_;
									this_parameter = _tmp74_;
									_tmp75_ = d;
									_tmp76_ = vala_destructor_get_binding (_tmp75_);
									_tmp77_ = _tmp76_;
									may_access_instance_members = _tmp77_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
								} else {
									ValaSymbol* _tmp78_;
									_tmp78_ = sym;
									if (VALA_IS_METHOD (_tmp78_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp79_;
										ValaMethod* _tmp80_;
										ValaParameter* _tmp81_;
										ValaParameter* _tmp82_;
										ValaMethod* _tmp83_;
										ValaMemberBinding _tmp84_;
										ValaMemberBinding _tmp85_;
										ValaMethod* _tmp86_;
										ValaMemberBinding _tmp87_;
										ValaMemberBinding _tmp88_;
										_tmp79_ = sym;
										m = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_METHOD, ValaMethod);
										_tmp80_ = m;
										_tmp81_ = vala_method_get_this_parameter (_tmp80_);
										_tmp82_ = _tmp81_;
										this_parameter = _tmp82_;
										_tmp83_ = m;
										_tmp84_ = vala_method_get_binding (_tmp83_);
										_tmp85_ = _tmp84_;
										may_access_instance_members = _tmp85_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp86_ = m;
										_tmp87_ = vala_method_get_binding (_tmp86_);
										_tmp88_ = _tmp87_;
										may_access_klass_members = _tmp88_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
									}
								}
							}
						}
					}
				}
				_tmp89_ = sym;
				_tmp90_ = self->priv->_member_name;
				_tmp91_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp89_, _tmp90_);
				_tmp92_ = _tmp91_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp92_);
				_vala_code_node_unref0 (_tmp92_);
				_tmp95_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp96_ = _tmp95_;
				if (_tmp96_ == NULL) {
					ValaSymbol* _tmp97_;
					_tmp97_ = sym;
					_tmp94_ = VALA_IS_TYPESYMBOL (_tmp97_);
				} else {
					_tmp94_ = FALSE;
				}
				if (_tmp94_) {
					_tmp93_ = may_access_instance_members;
				} else {
					_tmp93_ = FALSE;
				}
				if (_tmp93_) {
					ValaParameter* _tmp98_;
					ValaDataType* _tmp99_;
					ValaDataType* _tmp100_;
					const gchar* _tmp101_;
					ValaSymbol* _tmp102_;
					ValaSymbol* _tmp103_;
					gboolean _tmp104_ = FALSE;
					ValaSymbol* _tmp105_;
					ValaSymbol* _tmp106_;
					_tmp98_ = this_parameter;
					_tmp99_ = vala_variable_get_variable_type ((ValaVariable*) _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = self->priv->_member_name;
					_tmp102_ = vala_data_type_get_member (_tmp100_, _tmp101_);
					_tmp103_ = _tmp102_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp103_);
					_vala_code_node_unref0 (_tmp103_);
					_tmp105_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp106_ = _tmp105_;
					if (_tmp106_ != NULL) {
						ValaSymbol* _tmp107_;
						ValaSymbol* _tmp108_;
						_tmp107_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp108_ = _tmp107_;
						_tmp104_ = vala_member_access_is_instance_symbol (_tmp108_);
					} else {
						_tmp104_ = FALSE;
					}
					if (_tmp104_) {
						ValaSourceReference* _tmp109_;
						ValaSourceReference* _tmp110_;
						ValaMemberAccess* _tmp111_;
						ValaMemberAccess* _tmp112_;
						ValaExpression* _tmp113_;
						ValaExpression* _tmp114_;
						ValaParameter* _tmp115_;
						ValaDataType* _tmp116_;
						ValaDataType* _tmp117_;
						ValaDataType* _tmp118_;
						ValaDataType* _tmp119_;
						ValaExpression* _tmp120_;
						ValaExpression* _tmp121_;
						ValaDataType* _tmp122_;
						ValaDataType* _tmp123_;
						ValaExpression* _tmp124_;
						ValaExpression* _tmp125_;
						ValaParameter* _tmp126_;
						ValaExpression* _tmp127_;
						ValaExpression* _tmp128_;
						ValaDataType* _tmp129_;
						ValaDataType* _tmp130_;
						const gchar* _tmp131_;
						ValaSymbol* _tmp132_;
						ValaSymbol* _tmp133_;
						_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp110_ = _tmp109_;
						_tmp111_ = vala_member_access_new (NULL, "this", _tmp110_);
						_tmp112_ = _tmp111_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp112_);
						_vala_code_node_unref0 (_tmp112_);
						_tmp113_ = vala_member_access_get_inner (self);
						_tmp114_ = _tmp113_;
						_tmp115_ = this_parameter;
						_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
						_tmp117_ = _tmp116_;
						_tmp118_ = vala_data_type_copy (_tmp117_);
						_tmp119_ = _tmp118_;
						vala_expression_set_value_type (_tmp114_, _tmp119_);
						_vala_code_node_unref0 (_tmp119_);
						_tmp120_ = vala_member_access_get_inner (self);
						_tmp121_ = _tmp120_;
						_tmp122_ = vala_expression_get_value_type (_tmp121_);
						_tmp123_ = _tmp122_;
						vala_data_type_set_value_owned (_tmp123_, FALSE);
						_tmp124_ = vala_member_access_get_inner (self);
						_tmp125_ = _tmp124_;
						_tmp126_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp125_, (ValaSymbol*) _tmp126_);
						_tmp127_ = vala_member_access_get_inner (self);
						_tmp128_ = _tmp127_;
						_tmp129_ = vala_expression_get_value_type (_tmp128_);
						_tmp130_ = _tmp129_;
						_tmp131_ = self->priv->_member_name;
						_tmp132_ = vala_data_type_get_member (_tmp130_, _tmp131_);
						_tmp133_ = _tmp132_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp133_);
						_vala_code_node_unref0 (_tmp133_);
					}
				}
				_tmp134_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp135_ = _tmp134_;
				if (_tmp135_ == NULL) {
					ValaSymbol* _tmp136_;
					_tmp136_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp136_)) {
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp137_ = sym;
				_tmp138_ = vala_symbol_get_parent_symbol (_tmp137_);
				_tmp139_ = _tmp138_;
				sym = _tmp139_;
			}
			_tmp141_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp142_ = _tmp141_;
			if (_tmp142_ == NULL) {
				ValaSourceReference* _tmp143_;
				ValaSourceReference* _tmp144_;
				_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp144_ = _tmp143_;
				_tmp140_ = _tmp144_ != NULL;
			} else {
				_tmp140_ = FALSE;
			}
			if (_tmp140_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp145_;
					ValaSourceReference* _tmp146_;
					ValaList* _tmp147_;
					ValaList* _tmp148_;
					ValaList* _tmp149_;
					gint _ns_size = 0;
					ValaList* _tmp150_;
					gint _tmp151_;
					gint _tmp152_;
					gint _ns_index = 0;
					_tmp145_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_source_reference_get_using_directives (_tmp146_);
					_tmp148_ = _tmp147_;
					_tmp149_ = _vala_iterable_ref0 (_tmp148_);
					_ns_list = _tmp149_;
					_tmp150_ = _ns_list;
					_tmp151_ = vala_collection_get_size ((ValaCollection*) _tmp150_);
					_tmp152_ = _tmp151_;
					_ns_size = _tmp152_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp153_;
						gint _tmp154_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp155_;
						gpointer _tmp156_;
						ValaUsingDirective* _tmp157_;
						gboolean _tmp158_;
						gboolean _tmp159_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp160_;
						ValaSymbol* _tmp161_;
						ValaSymbol* _tmp162_;
						ValaScope* _tmp163_;
						ValaScope* _tmp164_;
						const gchar* _tmp165_;
						ValaSymbol* _tmp166_;
						ValaSymbol* _tmp167_;
						_ns_index = _ns_index + 1;
						_tmp153_ = _ns_index;
						_tmp154_ = _ns_size;
						if (!(_tmp153_ < _tmp154_)) {
							break;
						}
						_tmp155_ = _ns_list;
						_tmp156_ = vala_list_get (_tmp155_, _ns_index);
						ns = (ValaUsingDirective*) _tmp156_;
						_tmp157_ = ns;
						_tmp158_ = vala_code_node_get_error ((ValaCodeNode*) _tmp157_);
						_tmp159_ = _tmp158_;
						if (_tmp159_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp160_ = ns;
						_tmp161_ = vala_using_directive_get_namespace_symbol (_tmp160_);
						_tmp162_ = _tmp161_;
						_tmp163_ = vala_symbol_get_scope (_tmp162_);
						_tmp164_ = _tmp163_;
						_tmp165_ = self->priv->_member_name;
						_tmp166_ = vala_scope_lookup (_tmp164_, _tmp165_);
						local_sym = _tmp166_;
						_tmp167_ = local_sym;
						if (_tmp167_ != NULL) {
							gboolean _tmp168_ = FALSE;
							ValaSymbol* _tmp169_;
							ValaSymbol* _tmp170_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp208_;
							ValaExpression* _tmp209_;
							ValaExpression* _tmp210_;
							ValaSymbol* _tmp211_;
							_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp170_ = _tmp169_;
							if (_tmp170_ != NULL) {
								ValaSymbol* _tmp171_;
								ValaSymbol* _tmp172_;
								ValaSymbol* _tmp173_;
								_tmp171_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp172_ = _tmp171_;
								_tmp173_ = local_sym;
								_tmp168_ = _tmp172_ != _tmp173_;
							} else {
								_tmp168_ = FALSE;
							}
							if (_tmp168_) {
								ValaSourceReference* _tmp174_;
								ValaSourceReference* _tmp175_;
								const gchar* _tmp176_;
								ValaSymbol* _tmp177_;
								ValaSymbol* _tmp178_;
								gchar* _tmp179_;
								gchar* _tmp180_;
								ValaSymbol* _tmp181_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								gchar* _tmp184_;
								gchar* _tmp185_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp175_ = _tmp174_;
								_tmp176_ = self->priv->_member_name;
								_tmp177_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp178_ = _tmp177_;
								_tmp179_ = vala_symbol_get_full_name (_tmp178_);
								_tmp180_ = _tmp179_;
								_tmp181_ = local_sym;
								_tmp182_ = vala_symbol_get_full_name (_tmp181_);
								_tmp183_ = _tmp182_;
								_tmp184_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp176_, _tmp180_, _tmp183_);
								_tmp185_ = _tmp184_;
								vala_report_error (_tmp175_, _tmp185_);
								_g_free0 (_tmp185_);
								_g_free0 (_tmp183_);
								_g_free0 (_tmp180_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								return result;
							}
							_tmp186_ = local_sym;
							_tmp187_ = vala_symbol_get_parent_symbol (_tmp186_);
							_tmp188_ = _tmp187_;
							inner_sym = _tmp188_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp189_ = FALSE;
								ValaSymbol* _tmp190_;
								ValaMemberAccess* _tmp194_;
								ValaSymbol* _tmp195_;
								const gchar* _tmp196_;
								const gchar* _tmp197_;
								ValaSourceReference* _tmp198_;
								ValaSourceReference* _tmp199_;
								ValaMemberAccess* _tmp200_;
								ValaMemberAccess* _tmp201_;
								ValaMemberAccess* _tmp202_;
								ValaExpression* _tmp203_;
								ValaExpression* _tmp204_;
								ValaSymbol* _tmp205_;
								ValaSymbol* _tmp206_;
								ValaSymbol* _tmp207_;
								_tmp190_ = inner_sym;
								if (_tmp190_ != NULL) {
									ValaSymbol* _tmp191_;
									const gchar* _tmp192_;
									const gchar* _tmp193_;
									_tmp191_ = inner_sym;
									_tmp192_ = vala_symbol_get_name (_tmp191_);
									_tmp193_ = _tmp192_;
									_tmp189_ = _tmp193_ != NULL;
								} else {
									_tmp189_ = FALSE;
								}
								if (!_tmp189_) {
									break;
								}
								_tmp194_ = inner_ma;
								_tmp195_ = inner_sym;
								_tmp196_ = vala_symbol_get_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp199_ = _tmp198_;
								_tmp200_ = vala_member_access_new (NULL, _tmp197_, _tmp199_);
								_tmp201_ = _tmp200_;
								vala_member_access_set_inner (_tmp194_, (ValaExpression*) _tmp201_);
								_vala_code_node_unref0 (_tmp201_);
								_tmp202_ = inner_ma;
								_tmp203_ = vala_member_access_get_inner (_tmp202_);
								_tmp204_ = _tmp203_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp205_ = inner_sym;
								_tmp206_ = vala_symbol_get_parent_symbol (_tmp205_);
								_tmp207_ = _tmp206_;
								inner_sym = _tmp207_;
							}
							_tmp208_ = inner_ma;
							vala_member_access_set_qualified (_tmp208_, TRUE);
							_tmp209_ = vala_member_access_get_inner (self);
							_tmp210_ = _tmp209_;
							vala_code_node_check ((ValaCodeNode*) _tmp210_, context);
							_tmp211_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp211_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
		} else {
			ValaExpression* _tmp212_;
			ValaExpression* _tmp213_;
			gboolean _tmp214_;
			gboolean _tmp215_;
			ValaExpression* _tmp216_;
			ValaExpression* _tmp217_;
			ValaDataType* _tmp218_;
			ValaDataType* _tmp219_;
			ValaExpression* _tmp237_;
			ValaExpression* _tmp238_;
			gboolean _tmp253_ = FALSE;
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			gboolean _tmp262_ = FALSE;
			ValaExpression* _tmp263_;
			ValaExpression* _tmp264_;
			gboolean _tmp285_ = FALSE;
			ValaExpression* _tmp286_;
			ValaExpression* _tmp287_;
			gboolean _tmp306_ = FALSE;
			ValaSymbol* _tmp307_;
			ValaSymbol* _tmp308_;
			gboolean _tmp342_ = FALSE;
			gboolean _tmp343_ = FALSE;
			ValaSymbol* _tmp344_;
			ValaSymbol* _tmp345_;
			gboolean _tmp577_ = FALSE;
			ValaSymbol* _tmp578_;
			ValaSymbol* _tmp579_;
			_tmp212_ = vala_member_access_get_inner (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_code_node_get_error ((ValaCodeNode*) _tmp213_);
			_tmp215_ = _tmp214_;
			if (_tmp215_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				return result;
			}
			_tmp216_ = vala_member_access_get_inner (self);
			_tmp217_ = _tmp216_;
			_tmp218_ = vala_expression_get_value_type (_tmp217_);
			_tmp219_ = _tmp218_;
			if (VALA_IS_POINTER_TYPE (_tmp219_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp220_;
				ValaExpression* _tmp221_;
				ValaDataType* _tmp222_;
				ValaDataType* _tmp223_;
				gboolean _tmp224_ = FALSE;
				ValaPointerType* _tmp225_;
				_tmp220_ = vala_member_access_get_inner (self);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_expression_get_value_type (_tmp221_);
				_tmp223_ = _tmp222_;
				pointer_type = VALA_IS_POINTER_TYPE (_tmp223_) ? ((ValaPointerType*) _tmp223_) : NULL;
				_tmp225_ = pointer_type;
				if (_tmp225_ != NULL) {
					ValaPointerType* _tmp226_;
					ValaDataType* _tmp227_;
					ValaDataType* _tmp228_;
					_tmp226_ = pointer_type;
					_tmp227_ = vala_pointer_type_get_base_type (_tmp226_);
					_tmp228_ = _tmp227_;
					_tmp224_ = VALA_IS_VALUE_TYPE (_tmp228_);
				} else {
					_tmp224_ = FALSE;
				}
				if (_tmp224_) {
					ValaExpression* _tmp229_;
					ValaExpression* _tmp230_;
					ValaSourceReference* _tmp231_;
					ValaSourceReference* _tmp232_;
					ValaPointerIndirection* _tmp233_;
					ValaPointerIndirection* _tmp234_;
					ValaExpression* _tmp235_;
					ValaExpression* _tmp236_;
					_tmp229_ = vala_member_access_get_inner (self);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp232_ = _tmp231_;
					_tmp233_ = vala_pointer_indirection_new (_tmp230_, _tmp232_);
					_tmp234_ = _tmp233_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp234_);
					_vala_code_node_unref0 (_tmp234_);
					_tmp235_ = vala_member_access_get_inner (self);
					_tmp236_ = _tmp235_;
					vala_code_node_check ((ValaCodeNode*) _tmp236_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
			}
			_tmp237_ = vala_member_access_get_inner (self);
			_tmp238_ = _tmp237_;
			if (VALA_IS_MEMBER_ACCESS (_tmp238_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp239_;
				ValaExpression* _tmp240_;
				ValaMemberAccess* _tmp241_;
				gboolean _tmp242_;
				_tmp239_ = vala_member_access_get_inner (self);
				_tmp240_ = _tmp239_;
				ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp240_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
				_tmp241_ = ma;
				_tmp242_ = _tmp241_->priv->_prototype_access;
				if (_tmp242_) {
					ValaSourceReference* _tmp243_;
					ValaSourceReference* _tmp244_;
					ValaExpression* _tmp245_;
					ValaExpression* _tmp246_;
					ValaSymbol* _tmp247_;
					ValaSymbol* _tmp248_;
					gchar* _tmp249_;
					gchar* _tmp250_;
					gchar* _tmp251_;
					gchar* _tmp252_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_member_access_get_inner (self);
					_tmp246_ = _tmp245_;
					_tmp247_ = vala_expression_get_symbol_reference (_tmp246_);
					_tmp248_ = _tmp247_;
					_tmp249_ = vala_symbol_get_full_name (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp250_);
					_tmp252_ = _tmp251_;
					vala_report_error (_tmp244_, _tmp252_);
					_g_free0 (_tmp252_);
					_g_free0 (_tmp250_);
					result = FALSE;
					return result;
				}
			}
			_tmp254_ = vala_member_access_get_inner (self);
			_tmp255_ = _tmp254_;
			if (VALA_IS_CAST_EXPRESSION (_tmp255_)) {
				ValaExpression* _tmp256_;
				ValaExpression* _tmp257_;
				gboolean _tmp258_;
				gboolean _tmp259_;
				_tmp256_ = vala_member_access_get_inner (self);
				_tmp257_ = _tmp256_;
				_tmp258_ = vala_cast_expression_get_is_silent_cast (G_TYPE_CHECK_INSTANCE_CAST (_tmp257_, VALA_TYPE_CAST_EXPRESSION, ValaCastExpression));
				_tmp259_ = _tmp258_;
				_tmp253_ = _tmp259_;
			} else {
				_tmp253_ = FALSE;
			}
			if (_tmp253_) {
				ValaSourceReference* _tmp260_;
				ValaSourceReference* _tmp261_;
				_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp261_ = _tmp260_;
				vala_report_warning (_tmp261_, "Access to possible `null'. Perform a check or use an unsafe cast.");
			}
			_tmp263_ = vala_member_access_get_inner (self);
			_tmp264_ = _tmp263_;
			if (VALA_IS_MEMBER_ACCESS (_tmp264_)) {
				_tmp262_ = TRUE;
			} else {
				ValaExpression* _tmp265_;
				ValaExpression* _tmp266_;
				_tmp265_ = vala_member_access_get_inner (self);
				_tmp266_ = _tmp265_;
				_tmp262_ = VALA_IS_BASE_ACCESS (_tmp266_);
			}
			if (_tmp262_) {
				ValaExpression* _tmp267_;
				ValaExpression* _tmp268_;
				ValaSymbol* _tmp269_;
				ValaSymbol* _tmp270_;
				gboolean _tmp271_ = FALSE;
				ValaSymbol* _tmp272_;
				ValaSymbol* _tmp273_;
				_tmp267_ = vala_member_access_get_inner (self);
				_tmp268_ = _tmp267_;
				_tmp269_ = vala_expression_get_symbol_reference (_tmp268_);
				_tmp270_ = _tmp269_;
				base_symbol = _tmp270_;
				_tmp272_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp273_ = _tmp272_;
				if (_tmp273_ == NULL) {
					gboolean _tmp274_ = FALSE;
					ValaSymbol* _tmp275_;
					_tmp275_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp275_)) {
						_tmp274_ = TRUE;
					} else {
						ValaSymbol* _tmp276_;
						_tmp276_ = base_symbol;
						_tmp274_ = VALA_IS_TYPESYMBOL (_tmp276_);
					}
					_tmp271_ = _tmp274_;
				} else {
					_tmp271_ = FALSE;
				}
				if (_tmp271_) {
					ValaSymbol* _tmp277_;
					ValaScope* _tmp278_;
					ValaScope* _tmp279_;
					const gchar* _tmp280_;
					ValaSymbol* _tmp281_;
					ValaSymbol* _tmp282_;
					ValaExpression* _tmp283_;
					ValaExpression* _tmp284_;
					_tmp277_ = base_symbol;
					_tmp278_ = vala_symbol_get_scope (_tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = self->priv->_member_name;
					_tmp281_ = vala_scope_lookup (_tmp279_, _tmp280_);
					_tmp282_ = _tmp281_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp282_);
					_vala_code_node_unref0 (_tmp282_);
					_tmp283_ = vala_member_access_get_inner (self);
					_tmp284_ = _tmp283_;
					if (VALA_IS_BASE_ACCESS (_tmp284_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp286_ = vala_member_access_get_inner (self);
			_tmp287_ = _tmp286_;
			if (VALA_IS_MEMBER_ACCESS (_tmp287_)) {
				ValaExpression* _tmp288_;
				ValaExpression* _tmp289_;
				ValaSymbol* _tmp290_;
				ValaSymbol* _tmp291_;
				_tmp288_ = vala_member_access_get_inner (self);
				_tmp289_ = _tmp288_;
				_tmp290_ = vala_expression_get_symbol_reference (_tmp289_);
				_tmp291_ = _tmp290_;
				_tmp285_ = VALA_IS_TYPEPARAMETER (_tmp291_);
			} else {
				_tmp285_ = FALSE;
			}
			if (_tmp285_) {
				ValaExpression* _tmp292_;
				ValaExpression* _tmp293_;
				ValaExpression* _tmp294_;
				ValaExpression* _tmp295_;
				ValaSymbol* _tmp296_;
				ValaSymbol* _tmp297_;
				ValaGenericType* _tmp298_;
				ValaGenericType* _tmp299_;
				ValaExpression* _tmp300_;
				ValaExpression* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				ValaSourceReference* _tmp304_;
				ValaSourceReference* _tmp305_;
				_tmp292_ = vala_member_access_get_inner (self);
				_tmp293_ = _tmp292_;
				_tmp294_ = vala_member_access_get_inner (self);
				_tmp295_ = _tmp294_;
				_tmp296_ = vala_expression_get_symbol_reference (_tmp295_);
				_tmp297_ = _tmp296_;
				_tmp298_ = vala_generic_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp297_, VALA_TYPE_TYPEPARAMETER, ValaTypeParameter));
				_tmp299_ = _tmp298_;
				vala_expression_set_value_type (_tmp293_, (ValaDataType*) _tmp299_);
				_vala_code_node_unref0 (_tmp299_);
				_tmp300_ = vala_member_access_get_inner (self);
				_tmp301_ = _tmp300_;
				_tmp302_ = vala_expression_get_value_type (_tmp301_);
				_tmp303_ = _tmp302_;
				_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp305_ = _tmp304_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp303_, _tmp305_);
			}
			_tmp307_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp308_ = _tmp307_;
			if (_tmp308_ == NULL) {
				ValaExpression* _tmp309_;
				ValaExpression* _tmp310_;
				ValaDataType* _tmp311_;
				ValaDataType* _tmp312_;
				_tmp309_ = vala_member_access_get_inner (self);
				_tmp310_ = _tmp309_;
				_tmp311_ = vala_expression_get_value_type (_tmp310_);
				_tmp312_ = _tmp311_;
				_tmp306_ = _tmp312_ != NULL;
			} else {
				_tmp306_ = FALSE;
			}
			if (_tmp306_) {
				gboolean _tmp313_;
				ValaSymbol* _tmp340_;
				ValaSymbol* _tmp341_;
				_tmp313_ = self->priv->_pointer_member_access;
				if (_tmp313_) {
					ValaExpression* _tmp314_;
					ValaExpression* _tmp315_;
					ValaDataType* _tmp316_;
					ValaDataType* _tmp317_;
					const gchar* _tmp318_;
					ValaSymbol* _tmp319_;
					ValaSymbol* _tmp320_;
					_tmp314_ = vala_member_access_get_inner (self);
					_tmp315_ = _tmp314_;
					_tmp316_ = vala_expression_get_value_type (_tmp315_);
					_tmp317_ = _tmp316_;
					_tmp318_ = self->priv->_member_name;
					_tmp319_ = vala_data_type_get_pointer_member (_tmp317_, _tmp318_);
					_tmp320_ = _tmp319_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp320_);
					_vala_code_node_unref0 (_tmp320_);
				} else {
					ValaExpression* _tmp321_;
					ValaExpression* _tmp322_;
					ValaDataType* _tmp323_;
					ValaDataType* _tmp324_;
					ValaTypeSymbol* _tmp325_;
					ValaTypeSymbol* _tmp326_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					ValaDataType* _tmp335_;
					ValaDataType* _tmp336_;
					const gchar* _tmp337_;
					ValaSymbol* _tmp338_;
					ValaSymbol* _tmp339_;
					_tmp321_ = vala_member_access_get_inner (self);
					_tmp322_ = _tmp321_;
					_tmp323_ = vala_expression_get_value_type (_tmp322_);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_data_type_get_type_symbol (_tmp324_);
					_tmp326_ = _tmp325_;
					if (_tmp326_ != NULL) {
						ValaExpression* _tmp327_;
						ValaExpression* _tmp328_;
						ValaDataType* _tmp329_;
						ValaDataType* _tmp330_;
						ValaTypeSymbol* _tmp331_;
						ValaTypeSymbol* _tmp332_;
						_tmp327_ = vala_member_access_get_inner (self);
						_tmp328_ = _tmp327_;
						_tmp329_ = vala_expression_get_value_type (_tmp328_);
						_tmp330_ = _tmp329_;
						_tmp331_ = vala_data_type_get_type_symbol (_tmp330_);
						_tmp332_ = _tmp331_;
						base_symbol = (ValaSymbol*) _tmp332_;
					}
					_tmp333_ = vala_member_access_get_inner (self);
					_tmp334_ = _tmp333_;
					_tmp335_ = vala_expression_get_value_type (_tmp334_);
					_tmp336_ = _tmp335_;
					_tmp337_ = self->priv->_member_name;
					_tmp338_ = vala_data_type_get_member (_tmp336_, _tmp337_);
					_tmp339_ = _tmp338_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp339_);
					_vala_code_node_unref0 (_tmp339_);
				}
				_tmp340_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp341_ = _tmp340_;
				if (_tmp341_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp345_ = _tmp344_;
			if (_tmp345_ == NULL) {
				ValaExpression* _tmp346_;
				ValaExpression* _tmp347_;
				ValaDataType* _tmp348_;
				ValaDataType* _tmp349_;
				_tmp346_ = vala_member_access_get_inner (self);
				_tmp347_ = _tmp346_;
				_tmp348_ = vala_expression_get_value_type (_tmp347_);
				_tmp349_ = _tmp348_;
				_tmp343_ = _tmp349_ != NULL;
			} else {
				_tmp343_ = FALSE;
			}
			if (_tmp343_) {
				ValaExpression* _tmp350_;
				ValaExpression* _tmp351_;
				ValaDataType* _tmp352_;
				ValaDataType* _tmp353_;
				gboolean _tmp354_;
				gboolean _tmp355_;
				_tmp350_ = vala_member_access_get_inner (self);
				_tmp351_ = _tmp350_;
				_tmp352_ = vala_expression_get_value_type (_tmp351_);
				_tmp353_ = _tmp352_;
				_tmp354_ = vala_data_type_get_is_dynamic (_tmp353_);
				_tmp355_ = _tmp354_;
				_tmp342_ = _tmp355_;
			} else {
				_tmp342_ = FALSE;
			}
			if (_tmp342_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp356_;
				ValaExpression* _tmp357_;
				ValaDataType* _tmp358_;
				ValaDataType* _tmp359_;
				ValaObjectType* _tmp360_;
				ValaCodeNode* _tmp361_;
				ValaCodeNode* _tmp362_;
				ValaSymbol* _tmp525_;
				ValaSymbol* _tmp526_;
				ValaSymbol* _tmp575_;
				ValaSymbol* _tmp576_;
				_tmp356_ = vala_member_access_get_inner (self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_expression_get_value_type (_tmp357_);
				_tmp359_ = _tmp358_;
				_tmp360_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp359_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp360_;
				_tmp361_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp362_ = _tmp361_;
				if (VALA_IS_METHOD_CALL (_tmp362_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp363_;
					ValaCodeNode* _tmp364_;
					ValaMethodCall* _tmp365_;
					ValaExpression* _tmp366_;
					ValaExpression* _tmp367_;
					_tmp363_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp364_ = _tmp363_;
					invoc = G_TYPE_CHECK_INSTANCE_CAST (_tmp364_, VALA_TYPE_METHOD_CALL, ValaMethodCall);
					_tmp365_ = invoc;
					_tmp366_ = vala_method_call_get_call (_tmp365_);
					_tmp367_ = _tmp366_;
					if (_tmp367_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp368_;
						ValaDataType* _tmp369_;
						ValaDataType* _tmp370_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp385_;
						ValaExpression* _tmp386_;
						ValaDataType* _tmp387_;
						ValaDataType* _tmp388_;
						const gchar* _tmp389_;
						ValaDataType* _tmp390_;
						ValaSourceReference* _tmp391_;
						ValaSourceReference* _tmp392_;
						ValaDynamicMethod* _tmp393_;
						ValaDynamicMethod* _tmp394_;
						ValaMethodCall* _tmp395_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp396_;
						ValaErrorType* _tmp397_;
						ValaDynamicMethod* _tmp398_;
						ValaErrorType* _tmp399_;
						ValaDynamicMethod* _tmp400_;
						ValaDynamicMethod* _tmp401_;
						ValaParameter* _tmp402_;
						ValaParameter* _tmp403_;
						ValaDynamicMethod* _tmp404_;
						ValaObjectType* _tmp405_;
						ValaDataType* _tmp406_;
						ValaDataType* _tmp407_;
						ValaParameter* _tmp408_;
						ValaParameter* _tmp409_;
						ValaObjectType* _tmp410_;
						ValaTypeSymbol* _tmp411_;
						ValaTypeSymbol* _tmp412_;
						ValaScope* _tmp413_;
						ValaScope* _tmp414_;
						ValaDynamicMethod* _tmp415_;
						ValaDynamicMethod* _tmp416_;
						_tmp368_ = invoc;
						_tmp369_ = vala_expression_get_target_type ((ValaExpression*) _tmp368_);
						_tmp370_ = _tmp369_;
						if (_tmp370_ != NULL) {
							ValaMethodCall* _tmp371_;
							ValaDataType* _tmp372_;
							ValaDataType* _tmp373_;
							ValaDataType* _tmp374_;
							ValaDataType* _tmp375_;
							_tmp371_ = invoc;
							_tmp372_ = vala_expression_get_target_type ((ValaExpression*) _tmp371_);
							_tmp373_ = _tmp372_;
							_tmp374_ = vala_data_type_copy (_tmp373_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp374_;
							_tmp375_ = ret_type;
							vala_data_type_set_value_owned (_tmp375_, TRUE);
						} else {
							ValaMethodCall* _tmp376_;
							ValaCodeNode* _tmp377_;
							ValaCodeNode* _tmp378_;
							_tmp376_ = invoc;
							_tmp377_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp376_);
							_tmp378_ = _tmp377_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp378_)) {
								ValaVoidType* _tmp379_;
								_tmp379_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp379_;
							} else {
								ValaExpression* _tmp380_;
								ValaExpression* _tmp381_;
								ValaDataType* _tmp382_;
								ValaDataType* _tmp383_;
								ValaDataType* _tmp384_;
								_tmp380_ = vala_member_access_get_inner (self);
								_tmp381_ = _tmp380_;
								_tmp382_ = vala_expression_get_value_type (_tmp381_);
								_tmp383_ = _tmp382_;
								_tmp384_ = vala_data_type_copy (_tmp383_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp384_;
							}
						}
						_tmp385_ = vala_member_access_get_inner (self);
						_tmp386_ = _tmp385_;
						_tmp387_ = vala_expression_get_value_type (_tmp386_);
						_tmp388_ = _tmp387_;
						_tmp389_ = self->priv->_member_name;
						_tmp390_ = ret_type;
						_tmp391_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp392_ = _tmp391_;
						_tmp393_ = vala_dynamic_method_new (_tmp388_, _tmp389_, _tmp390_, _tmp392_, NULL);
						m = _tmp393_;
						_tmp394_ = m;
						_tmp395_ = invoc;
						vala_dynamic_method_set_invocation (_tmp394_, _tmp395_);
						_tmp396_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp396_;
						_tmp397_ = err;
						vala_error_type_set_dynamic_error (_tmp397_, TRUE);
						_tmp398_ = m;
						_tmp399_ = err;
						vala_method_add_error_type ((ValaMethod*) _tmp398_, (ValaDataType*) _tmp399_);
						_tmp400_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp400_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp401_ = m;
						_tmp402_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp403_ = _tmp402_;
						vala_callable_add_parameter ((ValaCallable*) _tmp401_, _tmp403_);
						_vala_code_node_unref0 (_tmp403_);
						_tmp404_ = m;
						_tmp405_ = dynamic_object_type;
						_tmp406_ = vala_data_type_copy ((ValaDataType*) _tmp405_);
						_tmp407_ = _tmp406_;
						_tmp408_ = vala_parameter_new ("this", _tmp407_, NULL);
						_tmp409_ = _tmp408_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp404_, _tmp409_);
						_vala_code_node_unref0 (_tmp409_);
						_vala_code_node_unref0 (_tmp407_);
						_tmp410_ = dynamic_object_type;
						_tmp411_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp410_);
						_tmp412_ = _tmp411_;
						_tmp413_ = vala_symbol_get_scope ((ValaSymbol*) _tmp412_);
						_tmp414_ = _tmp413_;
						_tmp415_ = m;
						vala_scope_add (_tmp414_, NULL, (ValaSymbol*) _tmp415_);
						_tmp416_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp416_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
				} else {
					ValaCodeNode* _tmp417_;
					ValaCodeNode* _tmp418_;
					_tmp417_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp418_ = _tmp417_;
					if (VALA_IS_ASSIGNMENT (_tmp418_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp419_;
						ValaCodeNode* _tmp420_;
						ValaAssignment* _tmp421_;
						ValaExpression* _tmp422_;
						ValaExpression* _tmp423_;
						_tmp419_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp420_ = _tmp419_;
						a = G_TYPE_CHECK_INSTANCE_CAST (_tmp420_, VALA_TYPE_ASSIGNMENT, ValaAssignment);
						_tmp421_ = a;
						_tmp422_ = vala_assignment_get_left (_tmp421_);
						_tmp423_ = _tmp422_;
						if (_tmp423_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							ValaDynamicProperty* prop = NULL;
							ValaExpression* _tmp424_;
							ValaExpression* _tmp425_;
							ValaDataType* _tmp426_;
							ValaDataType* _tmp427_;
							const gchar* _tmp428_;
							ValaSourceReference* _tmp429_;
							ValaSourceReference* _tmp430_;
							ValaDynamicProperty* _tmp431_;
							ValaDynamicProperty* _tmp432_;
							ValaDynamicProperty* _tmp433_;
							ValaDynamicProperty* _tmp434_;
							ValaSourceReference* _tmp435_;
							ValaSourceReference* _tmp436_;
							ValaPropertyAccessor* _tmp437_;
							ValaPropertyAccessor* _tmp438_;
							ValaDynamicProperty* _tmp439_;
							ValaExpression* _tmp440_;
							ValaExpression* _tmp441_;
							ValaDataType* _tmp442_;
							ValaDataType* _tmp443_;
							ValaTypeSymbol* _tmp444_;
							ValaTypeSymbol* _tmp445_;
							ValaScope* _tmp446_;
							ValaScope* _tmp447_;
							ValaObjectType* _tmp448_;
							ValaTypeSymbol* _tmp449_;
							ValaTypeSymbol* _tmp450_;
							ValaScope* _tmp451_;
							ValaScope* _tmp452_;
							ValaDynamicProperty* _tmp453_;
							ValaDynamicProperty* _tmp454_;
							_tmp424_ = vala_member_access_get_inner (self);
							_tmp425_ = _tmp424_;
							_tmp426_ = vala_expression_get_value_type (_tmp425_);
							_tmp427_ = _tmp426_;
							_tmp428_ = self->priv->_member_name;
							_tmp429_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp430_ = _tmp429_;
							_tmp431_ = vala_dynamic_property_new (_tmp427_, _tmp428_, _tmp430_, NULL);
							prop = _tmp431_;
							_tmp432_ = prop;
							vala_symbol_set_access ((ValaSymbol*) _tmp432_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp433_ = prop;
							_tmp434_ = prop;
							_tmp435_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp434_);
							_tmp436_ = _tmp435_;
							_tmp437_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp436_, NULL);
							_tmp438_ = _tmp437_;
							vala_property_set_set_accessor ((ValaProperty*) _tmp433_, _tmp438_);
							_vala_code_node_unref0 (_tmp438_);
							_tmp439_ = prop;
							_tmp440_ = vala_member_access_get_inner (self);
							_tmp441_ = _tmp440_;
							_tmp442_ = vala_expression_get_value_type (_tmp441_);
							_tmp443_ = _tmp442_;
							_tmp444_ = vala_data_type_get_type_symbol (_tmp443_);
							_tmp445_ = _tmp444_;
							_tmp446_ = vala_symbol_get_scope ((ValaSymbol*) _tmp445_);
							_tmp447_ = _tmp446_;
							vala_symbol_set_owner ((ValaSymbol*) _tmp439_, _tmp447_);
							_tmp448_ = dynamic_object_type;
							_tmp449_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp448_);
							_tmp450_ = _tmp449_;
							_tmp451_ = vala_symbol_get_scope ((ValaSymbol*) _tmp450_);
							_tmp452_ = _tmp451_;
							_tmp453_ = prop;
							vala_scope_add (_tmp452_, NULL, (ValaSymbol*) _tmp453_);
							_tmp454_ = prop;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp454_);
							_vala_code_node_unref0 (prop);
						}
					} else {
						gboolean _tmp455_ = FALSE;
						gboolean _tmp456_ = FALSE;
						ValaCodeNode* _tmp457_;
						ValaCodeNode* _tmp458_;
						_tmp457_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp458_ = _tmp457_;
						if (VALA_IS_MEMBER_ACCESS (_tmp458_)) {
							ValaExpression* _tmp459_;
							ValaExpression* _tmp460_;
							_tmp459_ = vala_member_access_get_inner (self);
							_tmp460_ = _tmp459_;
							_tmp456_ = VALA_IS_MEMBER_ACCESS (_tmp460_);
						} else {
							_tmp456_ = FALSE;
						}
						if (_tmp456_) {
							ValaCodeNode* _tmp461_;
							ValaCodeNode* _tmp462_;
							ValaCodeNode* _tmp463_;
							ValaCodeNode* _tmp464_;
							_tmp461_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp462_ = _tmp461_;
							_tmp463_ = vala_code_node_get_parent_node (_tmp462_);
							_tmp464_ = _tmp463_;
							_tmp455_ = VALA_IS_METHOD_CALL (_tmp464_);
						} else {
							_tmp455_ = FALSE;
						}
						if (_tmp455_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp465_;
							ValaCodeNode* _tmp466_;
							gboolean _tmp467_ = FALSE;
							ValaMemberAccess* _tmp468_;
							const gchar* _tmp469_;
							_tmp465_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp466_ = _tmp465_;
							ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp466_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
							_tmp468_ = ma;
							_tmp469_ = _tmp468_->priv->_member_name;
							if (g_strcmp0 (_tmp469_, "connect") == 0) {
								_tmp467_ = TRUE;
							} else {
								ValaMemberAccess* _tmp470_;
								const gchar* _tmp471_;
								_tmp470_ = ma;
								_tmp471_ = _tmp470_->priv->_member_name;
								_tmp467_ = g_strcmp0 (_tmp471_, "connect_after") == 0;
							}
							if (_tmp467_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp472_;
								ValaExpression* _tmp473_;
								ValaDataType* _tmp474_;
								ValaDataType* _tmp475_;
								const gchar* _tmp476_;
								ValaVoidType* _tmp477_;
								ValaVoidType* _tmp478_;
								ValaSourceReference* _tmp479_;
								ValaSourceReference* _tmp480_;
								ValaDynamicSignal* _tmp481_;
								ValaDynamicSignal* _tmp482_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp483_;
								ValaCodeNode* _tmp484_;
								ValaCodeNode* _tmp485_;
								ValaCodeNode* _tmp486_;
								ValaMethodCall* _tmp487_;
								ValaMethodCall* _tmp488_;
								ValaList* _tmp489_;
								gint _tmp490_;
								gint _tmp491_;
								ValaDynamicSignal* _tmp517_;
								ValaObjectType* _tmp518_;
								ValaTypeSymbol* _tmp519_;
								ValaTypeSymbol* _tmp520_;
								ValaScope* _tmp521_;
								ValaScope* _tmp522_;
								ValaDynamicSignal* _tmp523_;
								ValaDynamicSignal* _tmp524_;
								_tmp472_ = vala_member_access_get_inner (self);
								_tmp473_ = _tmp472_;
								_tmp474_ = vala_expression_get_value_type (_tmp473_);
								_tmp475_ = _tmp474_;
								_tmp476_ = self->priv->_member_name;
								_tmp477_ = vala_void_type_new (NULL);
								_tmp478_ = _tmp477_;
								_tmp479_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp480_ = _tmp479_;
								_tmp481_ = vala_dynamic_signal_new (_tmp475_, _tmp476_, (ValaDataType*) _tmp478_, _tmp480_, NULL);
								_tmp482_ = _tmp481_;
								_vala_code_node_unref0 (_tmp478_);
								s = _tmp482_;
								_tmp483_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp484_ = _tmp483_;
								_tmp485_ = vala_code_node_get_parent_node (_tmp484_);
								_tmp486_ = _tmp485_;
								_tmp487_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp486_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp487_;
								_tmp488_ = mcall;
								_tmp489_ = vala_method_call_get_argument_list (_tmp488_);
								_tmp490_ = vala_collection_get_size ((ValaCollection*) _tmp489_);
								_tmp491_ = _tmp490_;
								if (_tmp491_ > 0) {
									ValaDynamicSignal* _tmp492_;
									ValaMethodCall* _tmp493_;
									ValaList* _tmp494_;
									gpointer _tmp495_;
									ValaExpression* _tmp496_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp497_;
									ValaExpression* _tmp498_;
									ValaExpression* _tmp499_;
									gboolean _tmp500_ = FALSE;
									gboolean _tmp501_ = FALSE;
									ValaMemberAccess* _tmp502_;
									_tmp492_ = s;
									_tmp493_ = mcall;
									_tmp494_ = vala_method_call_get_argument_list (_tmp493_);
									_tmp495_ = vala_list_get (_tmp494_, 0);
									_tmp496_ = (ValaExpression*) _tmp495_;
									vala_dynamic_signal_set_handler (_tmp492_, _tmp496_);
									_vala_code_node_unref0 (_tmp496_);
									_tmp497_ = s;
									_tmp498_ = vala_dynamic_signal_get_handler (_tmp497_);
									_tmp499_ = _tmp498_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp499_) ? ((ValaMemberAccess*) _tmp499_) : NULL;
									_tmp502_ = arg;
									if (_tmp502_ == NULL) {
										_tmp501_ = TRUE;
									} else {
										ValaMemberAccess* _tmp503_;
										_tmp503_ = arg;
										_tmp501_ = !vala_code_node_check ((ValaCodeNode*) _tmp503_, context);
									}
									if (_tmp501_) {
										_tmp500_ = TRUE;
									} else {
										ValaMemberAccess* _tmp504_;
										ValaSymbol* _tmp505_;
										ValaSymbol* _tmp506_;
										_tmp504_ = arg;
										_tmp505_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp504_);
										_tmp506_ = _tmp505_;
										_tmp500_ = !VALA_IS_METHOD (_tmp506_);
									}
									if (_tmp500_) {
										ValaDynamicSignal* _tmp507_;
										ValaExpression* _tmp508_;
										ValaExpression* _tmp509_;
										ValaSourceReference* _tmp510_;
										ValaSourceReference* _tmp511_;
										ValaDynamicSignal* _tmp512_;
										gchar* _tmp513_;
										gchar* _tmp514_;
										gchar* _tmp515_;
										gchar* _tmp516_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp507_ = s;
										_tmp508_ = vala_dynamic_signal_get_handler (_tmp507_);
										_tmp509_ = _tmp508_;
										_tmp510_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp509_);
										_tmp511_ = _tmp510_;
										_tmp512_ = s;
										_tmp513_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp512_);
										_tmp514_ = _tmp513_;
										_tmp515_ = g_strdup_printf ("Invalid handler for `%s'", _tmp514_);
										_tmp516_ = _tmp515_;
										vala_report_error (_tmp511_, _tmp516_);
										_g_free0 (_tmp516_);
										_g_free0 (_tmp514_);
									}
								}
								_tmp517_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp517_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp518_ = dynamic_object_type;
								_tmp519_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp518_);
								_tmp520_ = _tmp519_;
								_tmp521_ = vala_symbol_get_scope ((ValaSymbol*) _tmp520_);
								_tmp522_ = _tmp521_;
								_tmp523_ = s;
								vala_scope_add (_tmp522_, NULL, (ValaSymbol*) _tmp523_);
								_tmp524_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp524_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
						}
					}
				}
				_tmp525_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp526_ = _tmp525_;
				if (_tmp526_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp527_;
					ValaExpression* _tmp528_;
					ValaDataType* _tmp529_;
					ValaDataType* _tmp530_;
					const gchar* _tmp531_;
					ValaSourceReference* _tmp532_;
					ValaSourceReference* _tmp533_;
					ValaDynamicProperty* _tmp534_;
					ValaDataType* _tmp535_;
					ValaDataType* _tmp536_;
					ValaDynamicProperty* _tmp547_;
					ValaDynamicProperty* _tmp548_;
					ValaDynamicProperty* _tmp549_;
					ValaDataType* _tmp550_;
					ValaDataType* _tmp551_;
					ValaDataType* _tmp552_;
					ValaDataType* _tmp553_;
					ValaDynamicProperty* _tmp554_;
					ValaSourceReference* _tmp555_;
					ValaSourceReference* _tmp556_;
					ValaPropertyAccessor* _tmp557_;
					ValaPropertyAccessor* _tmp558_;
					ValaDynamicProperty* _tmp559_;
					ValaExpression* _tmp560_;
					ValaExpression* _tmp561_;
					ValaDataType* _tmp562_;
					ValaDataType* _tmp563_;
					ValaTypeSymbol* _tmp564_;
					ValaTypeSymbol* _tmp565_;
					ValaScope* _tmp566_;
					ValaScope* _tmp567_;
					ValaObjectType* _tmp568_;
					ValaTypeSymbol* _tmp569_;
					ValaTypeSymbol* _tmp570_;
					ValaScope* _tmp571_;
					ValaScope* _tmp572_;
					ValaDynamicProperty* _tmp573_;
					ValaDynamicProperty* _tmp574_;
					_tmp527_ = vala_member_access_get_inner (self);
					_tmp528_ = _tmp527_;
					_tmp529_ = vala_expression_get_value_type (_tmp528_);
					_tmp530_ = _tmp529_;
					_tmp531_ = self->priv->_member_name;
					_tmp532_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp533_ = _tmp532_;
					_tmp534_ = vala_dynamic_property_new (_tmp530_, _tmp531_, _tmp533_, NULL);
					prop = _tmp534_;
					_tmp535_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp536_ = _tmp535_;
					if (_tmp536_ != NULL) {
						ValaDynamicProperty* _tmp537_;
						ValaDataType* _tmp538_;
						ValaDataType* _tmp539_;
						_tmp537_ = prop;
						_tmp538_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp539_ = _tmp538_;
						vala_property_set_property_type ((ValaProperty*) _tmp537_, _tmp539_);
					} else {
						ValaDynamicProperty* _tmp540_;
						ValaExpression* _tmp541_;
						ValaExpression* _tmp542_;
						ValaDataType* _tmp543_;
						ValaDataType* _tmp544_;
						ValaDataType* _tmp545_;
						ValaDataType* _tmp546_;
						_tmp540_ = prop;
						_tmp541_ = vala_member_access_get_inner (self);
						_tmp542_ = _tmp541_;
						_tmp543_ = vala_expression_get_value_type (_tmp542_);
						_tmp544_ = _tmp543_;
						_tmp545_ = vala_data_type_copy (_tmp544_);
						_tmp546_ = _tmp545_;
						vala_property_set_property_type ((ValaProperty*) _tmp540_, _tmp546_);
						_vala_code_node_unref0 (_tmp546_);
					}
					_tmp547_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp547_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp548_ = prop;
					_tmp549_ = prop;
					_tmp550_ = vala_property_get_property_type ((ValaProperty*) _tmp549_);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_data_type_copy (_tmp551_);
					_tmp553_ = _tmp552_;
					_tmp554_ = prop;
					_tmp555_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp554_);
					_tmp556_ = _tmp555_;
					_tmp557_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp553_, NULL, _tmp556_, NULL);
					_tmp558_ = _tmp557_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp548_, _tmp558_);
					_vala_code_node_unref0 (_tmp558_);
					_vala_code_node_unref0 (_tmp553_);
					_tmp559_ = prop;
					_tmp560_ = vala_member_access_get_inner (self);
					_tmp561_ = _tmp560_;
					_tmp562_ = vala_expression_get_value_type (_tmp561_);
					_tmp563_ = _tmp562_;
					_tmp564_ = vala_data_type_get_type_symbol (_tmp563_);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_symbol_get_scope ((ValaSymbol*) _tmp565_);
					_tmp567_ = _tmp566_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp559_, _tmp567_);
					_tmp568_ = dynamic_object_type;
					_tmp569_ = vala_data_type_get_type_symbol ((ValaDataType*) _tmp568_);
					_tmp570_ = _tmp569_;
					_tmp571_ = vala_symbol_get_scope ((ValaSymbol*) _tmp570_);
					_tmp572_ = _tmp571_;
					_tmp573_ = prop;
					vala_scope_add (_tmp572_, NULL, (ValaSymbol*) _tmp573_);
					_tmp574_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp574_);
					_vala_code_node_unref0 (prop);
				}
				_tmp575_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp576_ = _tmp575_;
				if (_tmp576_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp578_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp579_ = _tmp578_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp579_)) {
				ValaExpression* _tmp580_;
				ValaExpression* _tmp581_;
				ValaSymbol* _tmp582_;
				ValaSymbol* _tmp583_;
				_tmp580_ = vala_member_access_get_inner (self);
				_tmp581_ = _tmp580_;
				_tmp582_ = vala_expression_get_symbol_reference (_tmp581_);
				_tmp583_ = _tmp582_;
				_tmp577_ = VALA_IS_VARIABLE (_tmp583_);
			} else {
				_tmp577_ = FALSE;
			}
			if (_tmp577_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp584_;
				ValaSemanticAnalyzer* _tmp585_;
				ValaExpression* _tmp586_;
				ValaExpression* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaSymbol* _tmp589_;
				ValaDataType* _tmp590_;
				ValaArrayType* _tmp591_;
				gboolean _tmp592_ = FALSE;
				ValaArrayType* _tmp593_;
				_tmp584_ = vala_code_context_get_analyzer (context);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_member_access_get_inner (self);
				_tmp587_ = _tmp586_;
				_tmp588_ = vala_expression_get_symbol_reference (_tmp587_);
				_tmp589_ = _tmp588_;
				_tmp590_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp585_, _tmp589_, TRUE);
				_tmp591_ = VALA_IS_ARRAY_TYPE (_tmp590_) ? ((ValaArrayType*) _tmp590_) : NULL;
				if (_tmp591_ == NULL) {
					_vala_code_node_unref0 (_tmp590_);
				}
				inner_type = _tmp591_;
				_tmp593_ = inner_type;
				if (_tmp593_ != NULL) {
					ValaArrayType* _tmp594_;
					gboolean _tmp595_;
					gboolean _tmp596_;
					_tmp594_ = inner_type;
					_tmp595_ = vala_array_type_get_inline_allocated (_tmp594_);
					_tmp596_ = _tmp595_;
					_tmp592_ = _tmp596_;
				} else {
					_tmp592_ = FALSE;
				}
				if (_tmp592_) {
					ValaSourceReference* _tmp597_;
					ValaSourceReference* _tmp598_;
					_tmp597_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp598_ = _tmp597_;
					vala_report_error (_tmp598_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp599_ = FALSE;
					ValaArrayType* _tmp600_;
					_tmp600_ = inner_type;
					if (_tmp600_ != NULL) {
						ValaArrayType* _tmp601_;
						gboolean _tmp602_;
						gboolean _tmp603_;
						_tmp601_ = inner_type;
						_tmp602_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp601_);
						_tmp603_ = _tmp602_;
						_tmp599_ = !_tmp603_;
					} else {
						_tmp599_ = FALSE;
					}
					if (_tmp599_) {
						ValaSourceReference* _tmp604_;
						ValaSourceReference* _tmp605_;
						_tmp604_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp605_ = _tmp604_;
						vala_report_error (_tmp605_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp609_ = vala_member_access_get_inner (self);
	_tmp610_ = _tmp609_;
	if (_tmp610_ == NULL) {
		ValaSymbol* _tmp611_;
		ValaSymbol* _tmp612_;
		_tmp611_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp612_ = _tmp611_;
		_tmp608_ = _tmp612_ == NULL;
	} else {
		_tmp608_ = FALSE;
	}
	if (_tmp608_) {
		ValaDataType* _tmp613_;
		ValaDataType* _tmp614_;
		_tmp613_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp614_ = _tmp613_;
		_tmp607_ = _tmp614_ != NULL;
	} else {
		_tmp607_ = FALSE;
	}
	if (_tmp607_) {
		ValaDataType* _tmp615_;
		ValaDataType* _tmp616_;
		ValaTypeSymbol* _tmp617_;
		ValaTypeSymbol* _tmp618_;
		_tmp615_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp616_ = _tmp615_;
		_tmp617_ = vala_data_type_get_type_symbol (_tmp616_);
		_tmp618_ = _tmp617_;
		_tmp606_ = VALA_IS_ENUM (_tmp618_);
	} else {
		_tmp606_ = FALSE;
	}
	if (_tmp606_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp619_;
		ValaDataType* _tmp620_;
		ValaTypeSymbol* _tmp621_;
		ValaTypeSymbol* _tmp622_;
		_tmp619_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp620_ = _tmp619_;
		_tmp621_ = vala_data_type_get_type_symbol (_tmp620_);
		_tmp622_ = _tmp621_;
		enum_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp622_, VALA_TYPE_ENUM, ValaEnum);
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp623_;
			ValaList* _tmp624_;
			ValaList* _tmp625_;
			gint _val_size = 0;
			ValaList* _tmp626_;
			gint _tmp627_;
			gint _tmp628_;
			gint _val_index = 0;
			_tmp623_ = enum_type;
			_tmp624_ = vala_enum_get_values (_tmp623_);
			_tmp625_ = _vala_iterable_ref0 (_tmp624_);
			_val_list = _tmp625_;
			_tmp626_ = _val_list;
			_tmp627_ = vala_collection_get_size ((ValaCollection*) _tmp626_);
			_tmp628_ = _tmp627_;
			_val_size = _tmp628_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp629_;
				gint _tmp630_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp631_;
				gpointer _tmp632_;
				const gchar* _tmp633_;
				ValaEnumValue* _tmp634_;
				const gchar* _tmp635_;
				const gchar* _tmp636_;
				_val_index = _val_index + 1;
				_tmp629_ = _val_index;
				_tmp630_ = _val_size;
				if (!(_tmp629_ < _tmp630_)) {
					break;
				}
				_tmp631_ = _val_list;
				_tmp632_ = vala_list_get (_tmp631_, _val_index);
				val = (ValaEnumValue*) _tmp632_;
				_tmp633_ = self->priv->_member_name;
				_tmp634_ = val;
				_tmp635_ = vala_symbol_get_name ((ValaSymbol*) _tmp634_);
				_tmp636_ = _tmp635_;
				if (g_strcmp0 (_tmp633_, _tmp636_) == 0) {
					ValaEnumValue* _tmp637_;
					_tmp637_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp637_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
	}
	_tmp638_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp639_ = _tmp638_;
	if (_tmp639_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp640_;
		ValaSymbol* base_type = NULL;
		gboolean _tmp641_ = FALSE;
		ValaExpression* _tmp642_;
		ValaExpression* _tmp643_;
		gchar* base_type_package = NULL;
		gchar* _tmp663_;
		gboolean _tmp664_ = FALSE;
		ValaSymbol* _tmp665_;
		ValaSourceReference* _tmp680_;
		ValaSourceReference* _tmp681_;
		const gchar* _tmp682_;
		const gchar* _tmp683_;
		const gchar* _tmp684_;
		gchar* _tmp685_;
		gchar* _tmp686_;
		ValaInvalidType* _tmp687_;
		ValaInvalidType* _tmp688_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp640_ = g_strdup ("(null)");
		base_type_name = _tmp640_;
		base_type = NULL;
		_tmp642_ = vala_member_access_get_inner (self);
		_tmp643_ = _tmp642_;
		if (_tmp643_ != NULL) {
			ValaExpression* _tmp644_;
			ValaExpression* _tmp645_;
			ValaDataType* _tmp646_;
			ValaDataType* _tmp647_;
			_tmp644_ = vala_member_access_get_inner (self);
			_tmp645_ = _tmp644_;
			_tmp646_ = vala_expression_get_value_type (_tmp645_);
			_tmp647_ = _tmp646_;
			_tmp641_ = _tmp647_ != NULL;
		} else {
			_tmp641_ = FALSE;
		}
		if (_tmp641_) {
			ValaExpression* _tmp648_;
			ValaExpression* _tmp649_;
			ValaDataType* _tmp650_;
			ValaDataType* _tmp651_;
			gchar* _tmp652_;
			ValaExpression* _tmp653_;
			ValaExpression* _tmp654_;
			ValaDataType* _tmp655_;
			ValaDataType* _tmp656_;
			ValaTypeSymbol* _tmp657_;
			ValaTypeSymbol* _tmp658_;
			_tmp648_ = vala_member_access_get_inner (self);
			_tmp649_ = _tmp648_;
			_tmp650_ = vala_expression_get_value_type (_tmp649_);
			_tmp651_ = _tmp650_;
			_tmp652_ = vala_code_node_to_string ((ValaCodeNode*) _tmp651_);
			_g_free0 (base_type_name);
			base_type_name = _tmp652_;
			_tmp653_ = vala_member_access_get_inner (self);
			_tmp654_ = _tmp653_;
			_tmp655_ = vala_expression_get_value_type (_tmp654_);
			_tmp656_ = _tmp655_;
			_tmp657_ = vala_data_type_get_type_symbol (_tmp656_);
			_tmp658_ = _tmp657_;
			base_type = (ValaSymbol*) _tmp658_;
		} else {
			ValaSymbol* _tmp659_;
			_tmp659_ = base_symbol;
			if (_tmp659_ != NULL) {
				ValaSymbol* _tmp660_;
				gchar* _tmp661_;
				ValaSymbol* _tmp662_;
				_tmp660_ = base_symbol;
				_tmp661_ = vala_symbol_get_full_name (_tmp660_);
				_g_free0 (base_type_name);
				base_type_name = _tmp661_;
				_tmp662_ = base_symbol;
				base_type = _tmp662_;
			}
		}
		_tmp663_ = g_strdup ("");
		base_type_package = _tmp663_;
		_tmp665_ = base_type;
		if (_tmp665_ != NULL) {
			ValaSymbol* _tmp666_;
			gboolean _tmp667_;
			gboolean _tmp668_;
			_tmp666_ = base_type;
			_tmp667_ = vala_symbol_get_external_package (_tmp666_);
			_tmp668_ = _tmp667_;
			_tmp664_ = _tmp668_;
		} else {
			_tmp664_ = FALSE;
		}
		if (_tmp664_) {
			ValaSymbol* _tmp669_;
			ValaSourceReference* _tmp670_;
			ValaSourceReference* _tmp671_;
			ValaSourceFile* _tmp672_;
			ValaSourceFile* _tmp673_;
			const gchar* _tmp674_;
			const gchar* _tmp675_;
			gchar* _tmp676_;
			const gchar* _tmp677_;
			_tmp669_ = base_symbol;
			_tmp670_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp669_);
			_tmp671_ = _tmp670_;
			_tmp672_ = vala_source_reference_get_file (_tmp671_);
			_tmp673_ = _tmp672_;
			_tmp674_ = vala_source_file_get_package_name (_tmp673_);
			_tmp675_ = _tmp674_;
			_tmp676_ = g_strdup (_tmp675_);
			_g_free0 (base_type_package);
			base_type_package = _tmp676_;
			_tmp677_ = base_type_package;
			if (_tmp677_ != NULL) {
				const gchar* _tmp678_;
				gchar* _tmp679_;
				_tmp678_ = base_type_package;
				_tmp679_ = g_strdup_printf (" (%s)", _tmp678_);
				_g_free0 (base_type_package);
				base_type_package = _tmp679_;
			}
		}
		_tmp680_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp681_ = _tmp680_;
		_tmp682_ = self->priv->_member_name;
		_tmp683_ = base_type_name;
		_tmp684_ = base_type_package;
		_tmp685_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'%s", _tmp682_, _tmp683_, _tmp684_);
		_tmp686_ = _tmp685_;
		vala_report_error (_tmp681_, _tmp686_);
		_g_free0 (_tmp686_);
		_tmp687_ = vala_invalid_type_new ();
		_tmp688_ = _tmp687_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp688_);
		_vala_code_node_unref0 (_tmp688_);
		result = FALSE;
		_g_free0 (base_type_package);
		_g_free0 (base_type_name);
		return result;
	} else {
		ValaSymbol* _tmp689_;
		ValaSymbol* _tmp690_;
		gboolean _tmp691_;
		gboolean _tmp692_;
		_tmp689_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp690_ = _tmp689_;
		_tmp691_ = vala_code_node_get_error ((ValaCodeNode*) _tmp690_);
		_tmp692_ = _tmp691_;
		if (_tmp692_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp693_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp694_ = _tmp693_;
	if (VALA_IS_SIGNAL (_tmp694_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp695_;
		ValaSymbol* _tmp696_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp703_;
		ValaCodeNode* _tmp704_;
		ValaCodeNode* _tmp705_;
		gboolean _tmp706_ = FALSE;
		gboolean _tmp707_ = FALSE;
		gboolean _tmp708_ = FALSE;
		ValaCodeNode* _tmp709_;
		_tmp695_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp696_ = _tmp695_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp697_;
			ValaCodeNode* _tmp698_;
			ValaCodeNode* _tmp699_;
			ValaCodeNode* _tmp700_;
			ValaCodeNode* _tmp701_;
			ValaCodeNode* _tmp702_;
			_tmp697_ = ma;
			_tmp698_ = vala_code_node_get_parent_node (_tmp697_);
			_tmp699_ = _tmp698_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp699_)) {
				break;
			}
			_tmp700_ = ma;
			_tmp701_ = vala_code_node_get_parent_node (_tmp700_);
			_tmp702_ = _tmp701_;
			ma = _tmp702_;
		}
		_tmp703_ = ma;
		_tmp704_ = vala_code_node_get_parent_node (_tmp703_);
		_tmp705_ = _tmp704_;
		parent = _tmp705_;
		_tmp709_ = parent;
		if (_tmp709_ != NULL) {
			ValaCodeNode* _tmp710_;
			_tmp710_ = parent;
			_tmp708_ = !VALA_IS_ELEMENT_ACCESS (_tmp710_);
		} else {
			_tmp708_ = FALSE;
		}
		if (_tmp708_) {
			ValaCodeNode* _tmp711_;
			ValaExpression* _tmp712_;
			ValaExpression* _tmp713_;
			_tmp711_ = ma;
			_tmp712_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp711_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp713_ = _tmp712_;
			_tmp707_ = !VALA_IS_BASE_ACCESS (_tmp713_);
		} else {
			_tmp707_ = FALSE;
		}
		if (_tmp707_) {
			gboolean _tmp714_ = FALSE;
			ValaCodeNode* _tmp715_;
			_tmp715_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp715_)) {
				_tmp714_ = TRUE;
			} else {
				ValaCodeNode* _tmp716_;
				ValaList* _tmp717_;
				_tmp716_ = parent;
				_tmp717_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp714_ = vala_collection_contains ((ValaCollection*) _tmp717_, (ValaExpression*) self);
			}
			_tmp706_ = _tmp714_;
		} else {
			_tmp706_ = FALSE;
		}
		if (_tmp706_) {
			ValaSignal* _tmp718_;
			ValaAttribute* _tmp719_;
			_tmp718_ = sig;
			_tmp719_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp718_, "HasEmitter");
			if (_tmp719_ != NULL) {
				ValaSignal* _tmp720_;
				ValaSignal* _tmp721_;
				ValaMethod* _tmp722_;
				ValaMethod* _tmp723_;
				_tmp720_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp720_, context)) {
					result = FALSE;
					return result;
				}
				_tmp721_ = sig;
				_tmp722_ = vala_signal_get_emitter (_tmp721_);
				_tmp723_ = _tmp722_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp723_);
			} else {
				ValaSourceReference* _tmp724_;
				ValaSourceReference* _tmp725_;
				ValaSymbol* _tmp726_;
				ValaSymbol* _tmp727_;
				gchar* _tmp728_;
				gchar* _tmp729_;
				gchar* _tmp730_;
				gchar* _tmp731_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp724_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp725_ = _tmp724_;
				_tmp726_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp727_ = _tmp726_;
				_tmp728_ = vala_symbol_get_full_name (_tmp727_);
				_tmp729_ = _tmp728_;
				_tmp730_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp729_);
				_tmp731_ = _tmp730_;
				vala_report_error (_tmp725_, _tmp731_);
				_g_free0 (_tmp731_);
				_g_free0 (_tmp729_);
				result = FALSE;
				return result;
			}
		}
	}
	_tmp732_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp733_ = _tmp732_;
	member = _tmp733_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp734_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp734_, context)) {
		result = FALSE;
		return result;
	}
	_tmp735_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp735_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp736_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp737_;
		ValaSymbol* _tmp738_;
		ValaSymbol* _tmp739_;
		gboolean _tmp740_ = FALSE;
		ValaBlock* _tmp741_;
		_tmp736_ = member;
		local = G_TYPE_CHECK_INSTANCE_CAST (_tmp736_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
		_tmp737_ = local;
		_tmp738_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp737_);
		_tmp739_ = _tmp738_;
		block = VALA_IS_BLOCK (_tmp739_) ? ((ValaBlock*) _tmp739_) : NULL;
		_tmp741_ = block;
		if (_tmp741_ != NULL) {
			ValaBlock* _tmp742_;
			ValaSymbol* _tmp743_;
			ValaSemanticAnalyzer* _tmp744_;
			ValaSemanticAnalyzer* _tmp745_;
			ValaSymbol* _tmp746_;
			ValaSymbol* _tmp747_;
			_tmp742_ = block;
			_tmp743_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp742_);
			_tmp744_ = vala_code_context_get_analyzer (context);
			_tmp745_ = _tmp744_;
			_tmp746_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp745_);
			_tmp747_ = _tmp746_;
			_tmp740_ = _tmp743_ != _tmp747_;
		} else {
			_tmp740_ = FALSE;
		}
		if (_tmp740_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp748_;
			ValaSemanticAnalyzer* _tmp749_;
			ValaSymbol* _tmp750_;
			ValaSymbol* _tmp751_;
			ValaLocalVariable* _tmp762_;
			ValaBlock* _tmp763_;
			_tmp748_ = vala_code_context_get_analyzer (context);
			_tmp749_ = _tmp748_;
			_tmp750_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp749_);
			_tmp751_ = _tmp750_;
			sym = _tmp751_;
			while (TRUE) {
				ValaSymbol* _tmp752_;
				ValaBlock* _tmp753_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp754_;
				ValaMethod* _tmp755_;
				ValaSymbol* _tmp759_;
				ValaSymbol* _tmp760_;
				ValaSymbol* _tmp761_;
				_tmp752_ = sym;
				_tmp753_ = block;
				if (!(_tmp752_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp753_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp754_ = sym;
				method = VALA_IS_METHOD (_tmp754_) ? ((ValaMethod*) _tmp754_) : NULL;
				_tmp755_ = method;
				if (_tmp755_ != NULL) {
					ValaMethod* _tmp756_;
					ValaMethod* _tmp757_;
					ValaLocalVariable* _tmp758_;
					_tmp756_ = method;
					vala_method_set_closure (_tmp756_, TRUE);
					_tmp757_ = method;
					_tmp758_ = local;
					vala_method_add_captured_variable (_tmp757_, _tmp758_);
				}
				_tmp759_ = sym;
				_tmp760_ = vala_symbol_get_parent_symbol (_tmp759_);
				_tmp761_ = _tmp760_;
				sym = _tmp761_;
			}
			_tmp762_ = local;
			vala_local_variable_set_captured (_tmp762_, TRUE);
			_tmp763_ = block;
			vala_block_set_captured (_tmp763_, TRUE);
		}
	} else {
		ValaSymbol* _tmp764_;
		_tmp764_ = member;
		if (VALA_IS_PARAMETER (_tmp764_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp765_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp766_;
			ValaSymbol* _tmp767_;
			ValaSymbol* _tmp768_;
			gboolean _tmp769_ = FALSE;
			gboolean _tmp770_ = FALSE;
			ValaMethod* _tmp771_;
			_tmp765_ = member;
			param = G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_PARAMETER, ValaParameter);
			_tmp766_ = param;
			_tmp767_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp766_);
			_tmp768_ = _tmp767_;
			m = VALA_IS_METHOD (_tmp768_) ? ((ValaMethod*) _tmp768_) : NULL;
			_tmp771_ = m;
			if (_tmp771_ != NULL) {
				ValaMethod* _tmp772_;
				ValaSemanticAnalyzer* _tmp773_;
				ValaSemanticAnalyzer* _tmp774_;
				ValaSymbol* _tmp775_;
				ValaSymbol* _tmp776_;
				_tmp772_ = m;
				_tmp773_ = vala_code_context_get_analyzer (context);
				_tmp774_ = _tmp773_;
				_tmp775_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp774_);
				_tmp776_ = _tmp775_;
				_tmp770_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp772_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp776_;
			} else {
				_tmp770_ = FALSE;
			}
			if (_tmp770_) {
				ValaParameter* _tmp777_;
				ValaMethod* _tmp778_;
				ValaParameter* _tmp779_;
				ValaParameter* _tmp780_;
				_tmp777_ = param;
				_tmp778_ = m;
				_tmp779_ = vala_method_get_this_parameter (_tmp778_);
				_tmp780_ = _tmp779_;
				_tmp769_ = _tmp777_ != _tmp780_;
			} else {
				_tmp769_ = FALSE;
			}
			if (_tmp769_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp781_;
				ValaSemanticAnalyzer* _tmp782_;
				ValaSymbol* _tmp783_;
				ValaSymbol* _tmp784_;
				ValaParameter* _tmp793_;
				ValaMethod* _tmp794_;
				ValaBlock* _tmp795_;
				ValaBlock* _tmp796_;
				ValaParameter* _tmp797_;
				ValaParameterDirection _tmp798_;
				ValaParameterDirection _tmp799_;
				_tmp781_ = vala_code_context_get_analyzer (context);
				_tmp782_ = _tmp781_;
				_tmp783_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp782_);
				_tmp784_ = _tmp783_;
				sym = _tmp784_;
				while (TRUE) {
					ValaSymbol* _tmp785_;
					ValaMethod* _tmp786_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp787_;
					ValaMethod* _tmp788_;
					ValaSymbol* _tmp790_;
					ValaSymbol* _tmp791_;
					ValaSymbol* _tmp792_;
					_tmp785_ = sym;
					_tmp786_ = m;
					if (!(_tmp785_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp786_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp787_ = sym;
					method = VALA_IS_METHOD (_tmp787_) ? ((ValaMethod*) _tmp787_) : NULL;
					_tmp788_ = method;
					if (_tmp788_ != NULL) {
						ValaMethod* _tmp789_;
						_tmp789_ = method;
						vala_method_set_closure (_tmp789_, TRUE);
					}
					_tmp790_ = sym;
					_tmp791_ = vala_symbol_get_parent_symbol (_tmp790_);
					_tmp792_ = _tmp791_;
					sym = _tmp792_;
				}
				_tmp793_ = param;
				vala_parameter_set_captured (_tmp793_, TRUE);
				_tmp794_ = m;
				_tmp795_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp794_);
				_tmp796_ = _tmp795_;
				vala_block_set_captured (_tmp796_, TRUE);
				_tmp797_ = param;
				_tmp798_ = vala_parameter_get_direction (_tmp797_);
				_tmp799_ = _tmp798_;
				if (_tmp799_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp800_;
					ValaSourceReference* _tmp801_;
					ValaParameter* _tmp802_;
					gchar* _tmp803_;
					gchar* _tmp804_;
					gchar* _tmp805_;
					gchar* _tmp806_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp800_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp801_ = _tmp800_;
					_tmp802_ = param;
					_tmp803_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp802_);
					_tmp804_ = _tmp803_;
					_tmp805_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp804_);
					_tmp806_ = _tmp805_;
					vala_report_error (_tmp801_, _tmp806_);
					_g_free0 (_tmp806_);
					_g_free0 (_tmp804_);
				}
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp807_;
				ValaSymbol* _tmp808_;
				ValaSymbol* _tmp809_;
				ValaSymbol* _tmp810_;
				ValaSymbol* _tmp811_;
				gboolean _tmp812_ = FALSE;
				gboolean _tmp813_ = FALSE;
				ValaPropertyAccessor* _tmp814_;
				_tmp807_ = param;
				_tmp808_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp807_);
				_tmp809_ = _tmp808_;
				_tmp810_ = vala_symbol_get_parent_symbol (_tmp809_);
				_tmp811_ = _tmp810_;
				acc = VALA_IS_PROPERTY_ACCESSOR (_tmp811_) ? ((ValaPropertyAccessor*) _tmp811_) : NULL;
				_tmp814_ = acc;
				if (_tmp814_ != NULL) {
					ValaPropertyAccessor* _tmp815_;
					ValaSemanticAnalyzer* _tmp816_;
					ValaSemanticAnalyzer* _tmp817_;
					ValaSymbol* _tmp818_;
					ValaSymbol* _tmp819_;
					_tmp815_ = acc;
					_tmp816_ = vala_code_context_get_analyzer (context);
					_tmp817_ = _tmp816_;
					_tmp818_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp817_);
					_tmp819_ = _tmp818_;
					_tmp813_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp815_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp819_;
				} else {
					_tmp813_ = FALSE;
				}
				if (_tmp813_) {
					ValaParameter* _tmp820_;
					ValaPropertyAccessor* _tmp821_;
					ValaProperty* _tmp822_;
					ValaProperty* _tmp823_;
					ValaParameter* _tmp824_;
					ValaParameter* _tmp825_;
					_tmp820_ = param;
					_tmp821_ = acc;
					_tmp822_ = vala_property_accessor_get_prop (_tmp821_);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_property_get_this_parameter (_tmp823_);
					_tmp825_ = _tmp824_;
					_tmp812_ = _tmp820_ != _tmp825_;
				} else {
					_tmp812_ = FALSE;
				}
				if (_tmp812_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp826_;
					ValaSemanticAnalyzer* _tmp827_;
					ValaSymbol* _tmp828_;
					ValaSymbol* _tmp829_;
					ValaParameter* _tmp838_;
					ValaPropertyAccessor* _tmp839_;
					ValaBlock* _tmp840_;
					ValaBlock* _tmp841_;
					_tmp826_ = vala_code_context_get_analyzer (context);
					_tmp827_ = _tmp826_;
					_tmp828_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp827_);
					_tmp829_ = _tmp828_;
					sym = _tmp829_;
					while (TRUE) {
						ValaSymbol* _tmp830_;
						ValaMethod* _tmp831_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp832_;
						ValaMethod* _tmp833_;
						ValaSymbol* _tmp835_;
						ValaSymbol* _tmp836_;
						ValaSymbol* _tmp837_;
						_tmp830_ = sym;
						_tmp831_ = m;
						if (!(_tmp830_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp831_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp832_ = sym;
						method = VALA_IS_METHOD (_tmp832_) ? ((ValaMethod*) _tmp832_) : NULL;
						_tmp833_ = method;
						if (_tmp833_ != NULL) {
							ValaMethod* _tmp834_;
							_tmp834_ = method;
							vala_method_set_closure (_tmp834_, TRUE);
						}
						_tmp835_ = sym;
						_tmp836_ = vala_symbol_get_parent_symbol (_tmp835_);
						_tmp837_ = _tmp836_;
						sym = _tmp837_;
					}
					_tmp838_ = param;
					vala_parameter_set_captured (_tmp838_, TRUE);
					_tmp839_ = acc;
					_tmp840_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp839_);
					_tmp841_ = _tmp840_;
					vala_block_set_captured (_tmp841_, TRUE);
				}
			}
		} else {
			ValaSymbol* _tmp842_;
			_tmp842_ = member;
			if (VALA_IS_FIELD (_tmp842_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp843_;
				ValaField* _tmp844_;
				ValaSymbolAccessibility _tmp845_;
				ValaSymbolAccessibility _tmp846_;
				ValaField* _tmp847_;
				ValaMemberBinding _tmp848_;
				ValaMemberBinding _tmp849_;
				ValaField* _tmp850_;
				ValaMemberBinding _tmp851_;
				ValaMemberBinding _tmp852_;
				ValaField* _tmp853_;
				ValaDataType* _tmp854_;
				ValaDataType* _tmp855_;
				_tmp843_ = member;
				f = G_TYPE_CHECK_INSTANCE_CAST (_tmp843_, VALA_TYPE_FIELD, ValaField);
				_tmp844_ = f;
				_tmp845_ = vala_symbol_get_access ((ValaSymbol*) _tmp844_);
				_tmp846_ = _tmp845_;
				access = _tmp846_;
				_tmp847_ = f;
				_tmp848_ = vala_field_get_binding (_tmp847_);
				_tmp849_ = _tmp848_;
				instance = _tmp849_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp850_ = f;
				_tmp851_ = vala_field_get_binding (_tmp850_);
				_tmp852_ = _tmp851_;
				klass = _tmp852_ == VALA_MEMBER_BINDING_CLASS;
				_tmp853_ = f;
				_tmp854_ = vala_variable_get_variable_type ((ValaVariable*) _tmp853_);
				_tmp855_ = _tmp854_;
				if (VALA_IS_GENERIC_TYPE (_tmp855_)) {
					generics = TRUE;
				}
			} else {
				ValaSymbol* _tmp856_;
				_tmp856_ = member;
				if (VALA_IS_CONSTANT (_tmp856_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp857_;
					ValaConstant* _tmp858_;
					ValaSymbolAccessibility _tmp859_;
					ValaSymbolAccessibility _tmp860_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp861_;
					ValaSymbol* _tmp862_;
					ValaSymbol* _tmp863_;
					gboolean _tmp864_ = FALSE;
					ValaBlock* _tmp865_;
					_tmp857_ = member;
					c = G_TYPE_CHECK_INSTANCE_CAST (_tmp857_, VALA_TYPE_CONSTANT, ValaConstant);
					_tmp858_ = c;
					_tmp859_ = vala_symbol_get_access ((ValaSymbol*) _tmp858_);
					_tmp860_ = _tmp859_;
					access = _tmp860_;
					_tmp861_ = c;
					_tmp862_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp861_);
					_tmp863_ = _tmp862_;
					block = VALA_IS_BLOCK (_tmp863_) ? ((ValaBlock*) _tmp863_) : NULL;
					_tmp865_ = block;
					if (_tmp865_ != NULL) {
						ValaBlock* _tmp866_;
						ValaSymbol* _tmp867_;
						ValaSemanticAnalyzer* _tmp868_;
						ValaSemanticAnalyzer* _tmp869_;
						ValaSymbol* _tmp870_;
						ValaSymbol* _tmp871_;
						_tmp866_ = block;
						_tmp867_ = vala_semantic_analyzer_find_parent_method_or_property_accessor ((ValaSymbol*) _tmp866_);
						_tmp868_ = vala_code_context_get_analyzer (context);
						_tmp869_ = _tmp868_;
						_tmp870_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp869_);
						_tmp871_ = _tmp870_;
						_tmp864_ = _tmp867_ != _tmp871_;
					} else {
						_tmp864_ = FALSE;
					}
					if (_tmp864_) {
						ValaSourceReference* _tmp872_;
						ValaSourceReference* _tmp873_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp872_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp873_ = _tmp872_;
						vala_report_error (_tmp873_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						return result;
					}
				} else {
					ValaSymbol* _tmp874_;
					_tmp874_ = member;
					if (VALA_IS_METHOD (_tmp874_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp875_;
						ValaMethod* _tmp876_;
						gboolean _tmp877_;
						gboolean _tmp878_;
						ValaMethod* _tmp967_;
						ValaSymbolAccessibility _tmp968_;
						ValaSymbolAccessibility _tmp969_;
						ValaMethod* _tmp970_;
						ValaMethod* _tmp974_;
						ValaMemberBinding _tmp975_;
						ValaMemberBinding _tmp976_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp997_;
						ValaDataType* _tmp998_;
						ValaDataType* _tmp999_;
						gboolean _tmp1000_ = FALSE;
						ValaGenericType* _tmp1001_;
						_tmp875_ = member;
						m = G_TYPE_CHECK_INSTANCE_CAST (_tmp875_, VALA_TYPE_METHOD, ValaMethod);
						_tmp876_ = m;
						_tmp877_ = vala_method_get_is_async_callback (_tmp876_);
						_tmp878_ = _tmp877_;
						if (_tmp878_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp879_;
							ValaSemanticAnalyzer* _tmp880_;
							ValaMethod* _tmp881_;
							ValaMethod* _tmp882_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp883_;
							ValaMethod* _tmp912_;
							ValaSemanticAnalyzer* _tmp913_;
							ValaSemanticAnalyzer* _tmp914_;
							ValaMethod* _tmp915_;
							ValaMethod* _tmp916_;
							ValaMethod* _tmp932_;
							ValaMethod* _tmp933_;
							ValaMethod* _tmp934_;
							ValaSymbol* _tmp935_;
							ValaSymbol* _tmp936_;
							_tmp879_ = vala_code_context_get_analyzer (context);
							_tmp880_ = _tmp879_;
							_tmp881_ = vala_semantic_analyzer_get_current_async_method (_tmp880_);
							_tmp882_ = _tmp881_;
							async_method = _tmp882_;
							is_valid_access = FALSE;
							_tmp883_ = async_method;
							if (_tmp883_ != NULL) {
								ValaMethod* _tmp884_;
								ValaMethod* _tmp885_;
								ValaMethod* _tmp886_;
								_tmp884_ = m;
								_tmp885_ = async_method;
								_tmp886_ = vala_method_get_callback_method (_tmp885_);
								if (_tmp884_ == _tmp886_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp887_ = FALSE;
									ValaMethod* _tmp888_;
									ValaMethod* _tmp889_;
									ValaMethod* _tmp890_;
									_tmp888_ = async_method;
									_tmp889_ = vala_method_get_base_method (_tmp888_);
									_tmp890_ = _tmp889_;
									if (_tmp890_ != NULL) {
										ValaMethod* _tmp891_;
										ValaMethod* _tmp892_;
										ValaMethod* _tmp893_;
										ValaMethod* _tmp894_;
										ValaMethod* _tmp895_;
										_tmp891_ = m;
										_tmp892_ = async_method;
										_tmp893_ = vala_method_get_base_method (_tmp892_);
										_tmp894_ = _tmp893_;
										_tmp895_ = vala_method_get_callback_method (_tmp894_);
										_tmp887_ = _tmp891_ == _tmp895_;
									} else {
										_tmp887_ = FALSE;
									}
									if (_tmp887_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp896_ = FALSE;
										ValaMethod* _tmp897_;
										ValaMethod* _tmp898_;
										ValaMethod* _tmp899_;
										_tmp897_ = async_method;
										_tmp898_ = vala_method_get_base_interface_method (_tmp897_);
										_tmp899_ = _tmp898_;
										if (_tmp899_ != NULL) {
											ValaMethod* _tmp900_;
											ValaMethod* _tmp901_;
											ValaMethod* _tmp902_;
											ValaMethod* _tmp903_;
											ValaMethod* _tmp904_;
											_tmp900_ = m;
											_tmp901_ = async_method;
											_tmp902_ = vala_method_get_base_interface_method (_tmp901_);
											_tmp903_ = _tmp902_;
											_tmp904_ = vala_method_get_callback_method (_tmp903_);
											_tmp896_ = _tmp900_ == _tmp904_;
										} else {
											_tmp896_ = FALSE;
										}
										if (_tmp896_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							if (!is_valid_access) {
								ValaSourceReference* _tmp905_;
								ValaSourceReference* _tmp906_;
								ValaMethod* _tmp907_;
								gchar* _tmp908_;
								gchar* _tmp909_;
								gchar* _tmp910_;
								gchar* _tmp911_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp905_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp906_ = _tmp905_;
								_tmp907_ = m;
								_tmp908_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp907_);
								_tmp909_ = _tmp908_;
								_tmp910_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp909_);
								_tmp911_ = _tmp910_;
								vala_report_error (_tmp906_, _tmp911_);
								_g_free0 (_tmp911_);
								_g_free0 (_tmp909_);
								result = FALSE;
								return result;
							}
							_tmp912_ = async_method;
							_tmp913_ = vala_code_context_get_analyzer (context);
							_tmp914_ = _tmp913_;
							_tmp915_ = vala_semantic_analyzer_get_current_method (_tmp914_);
							_tmp916_ = _tmp915_;
							if (_tmp912_ != _tmp916_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp917_;
								ValaSemanticAnalyzer* _tmp918_;
								ValaMethod* _tmp919_;
								ValaMethod* _tmp920_;
								ValaMethod* _tmp929_;
								ValaBlock* _tmp930_;
								ValaBlock* _tmp931_;
								_tmp917_ = vala_code_context_get_analyzer (context);
								_tmp918_ = _tmp917_;
								_tmp919_ = vala_semantic_analyzer_get_current_method (_tmp918_);
								_tmp920_ = _tmp919_;
								sym = (ValaSymbol*) _tmp920_;
								while (TRUE) {
									ValaSymbol* _tmp921_;
									ValaMethod* _tmp922_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp923_;
									ValaMethod* _tmp924_;
									ValaSymbol* _tmp926_;
									ValaSymbol* _tmp927_;
									ValaSymbol* _tmp928_;
									_tmp921_ = sym;
									_tmp922_ = async_method;
									if (!(_tmp921_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp922_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp923_ = sym;
									method = VALA_IS_METHOD (_tmp923_) ? ((ValaMethod*) _tmp923_) : NULL;
									_tmp924_ = method;
									if (_tmp924_ != NULL) {
										ValaMethod* _tmp925_;
										_tmp925_ = method;
										vala_method_set_closure (_tmp925_, TRUE);
									}
									_tmp926_ = sym;
									_tmp927_ = vala_symbol_get_parent_symbol (_tmp926_);
									_tmp928_ = _tmp927_;
									sym = _tmp928_;
								}
								_tmp929_ = async_method;
								_tmp930_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp929_);
								_tmp931_ = _tmp930_;
								vala_block_set_captured (_tmp931_, TRUE);
							}
							_tmp932_ = async_method;
							_tmp933_ = vala_method_get_callback_method (_tmp932_);
							m = _tmp933_;
							_tmp934_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp934_);
							_tmp935_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp936_ = _tmp935_;
							member = _tmp936_;
						} else {
							ValaMethod* _tmp937_;
							ValaMethod* _tmp938_;
							ValaMethod* _tmp939_;
							_tmp937_ = m;
							_tmp938_ = vala_method_get_base_method (_tmp937_);
							_tmp939_ = _tmp938_;
							if (_tmp939_ != NULL) {
								ValaMethod* _tmp940_;
								ValaMethod* _tmp941_;
								ValaMethod* _tmp942_;
								ValaMethod* _tmp943_;
								ValaSignal* _tmp944_;
								ValaSignal* _tmp945_;
								ValaSymbol* _tmp950_;
								ValaSymbol* _tmp951_;
								_tmp940_ = m;
								_tmp941_ = vala_method_get_base_method (_tmp940_);
								_tmp942_ = _tmp941_;
								m = _tmp942_;
								_tmp943_ = m;
								_tmp944_ = vala_method_get_signal_reference (_tmp943_);
								_tmp945_ = _tmp944_;
								if (_tmp945_ != NULL) {
									ValaMethod* _tmp946_;
									ValaSignal* _tmp947_;
									ValaSignal* _tmp948_;
									_tmp946_ = m;
									_tmp947_ = vala_method_get_signal_reference (_tmp946_);
									_tmp948_ = _tmp947_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp948_);
								} else {
									ValaMethod* _tmp949_;
									_tmp949_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp949_);
								}
								_tmp950_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp951_ = _tmp950_;
								member = _tmp951_;
							} else {
								ValaMethod* _tmp952_;
								ValaMethod* _tmp953_;
								ValaMethod* _tmp954_;
								_tmp952_ = m;
								_tmp953_ = vala_method_get_base_interface_method (_tmp952_);
								_tmp954_ = _tmp953_;
								if (_tmp954_ != NULL) {
									ValaMethod* _tmp955_;
									ValaMethod* _tmp956_;
									ValaMethod* _tmp957_;
									ValaMethod* _tmp958_;
									ValaSignal* _tmp959_;
									ValaSignal* _tmp960_;
									ValaSymbol* _tmp965_;
									ValaSymbol* _tmp966_;
									_tmp955_ = m;
									_tmp956_ = vala_method_get_base_interface_method (_tmp955_);
									_tmp957_ = _tmp956_;
									m = _tmp957_;
									_tmp958_ = m;
									_tmp959_ = vala_method_get_signal_reference (_tmp958_);
									_tmp960_ = _tmp959_;
									if (_tmp960_ != NULL) {
										ValaMethod* _tmp961_;
										ValaSignal* _tmp962_;
										ValaSignal* _tmp963_;
										_tmp961_ = m;
										_tmp962_ = vala_method_get_signal_reference (_tmp961_);
										_tmp963_ = _tmp962_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp963_);
									} else {
										ValaMethod* _tmp964_;
										_tmp964_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp964_);
									}
									_tmp965_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp966_ = _tmp965_;
									member = _tmp966_;
								}
							}
						}
						_tmp967_ = m;
						_tmp968_ = vala_symbol_get_access ((ValaSymbol*) _tmp967_);
						_tmp969_ = _tmp968_;
						access = _tmp969_;
						_tmp970_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp970_)) {
							ValaMethod* _tmp971_;
							ValaMemberBinding _tmp972_;
							ValaMemberBinding _tmp973_;
							_tmp971_ = m;
							_tmp972_ = vala_method_get_binding (_tmp971_);
							_tmp973_ = _tmp972_;
							instance = _tmp973_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp974_ = m;
						_tmp975_ = vala_method_get_binding (_tmp974_);
						_tmp976_ = _tmp975_;
						klass = _tmp976_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp977_;
							ValaList* _tmp978_;
							ValaList* _tmp979_;
							gint _param_size = 0;
							ValaList* _tmp980_;
							gint _tmp981_;
							gint _tmp982_;
							gint _param_index = 0;
							_tmp977_ = m;
							_tmp978_ = vala_callable_get_parameters ((ValaCallable*) _tmp977_);
							_tmp979_ = _vala_iterable_ref0 (_tmp978_);
							_param_list = _tmp979_;
							_tmp980_ = _param_list;
							_tmp981_ = vala_collection_get_size ((ValaCollection*) _tmp980_);
							_tmp982_ = _tmp981_;
							_param_size = _tmp982_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp983_;
								gint _tmp984_;
								ValaParameter* param = NULL;
								ValaList* _tmp985_;
								gpointer _tmp986_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp987_;
								ValaDataType* _tmp988_;
								ValaDataType* _tmp989_;
								gboolean _tmp990_ = FALSE;
								ValaGenericType* _tmp991_;
								_param_index = _param_index + 1;
								_tmp983_ = _param_index;
								_tmp984_ = _param_size;
								if (!(_tmp983_ < _tmp984_)) {
									break;
								}
								_tmp985_ = _param_list;
								_tmp986_ = vala_list_get (_tmp985_, _param_index);
								param = (ValaParameter*) _tmp986_;
								_tmp987_ = param;
								_tmp988_ = vala_variable_get_variable_type ((ValaVariable*) _tmp987_);
								_tmp989_ = _tmp988_;
								generic_type = VALA_IS_GENERIC_TYPE (_tmp989_) ? ((ValaGenericType*) _tmp989_) : NULL;
								_tmp991_ = generic_type;
								if (_tmp991_ != NULL) {
									ValaGenericType* _tmp992_;
									ValaTypeParameter* _tmp993_;
									ValaTypeParameter* _tmp994_;
									ValaSymbol* _tmp995_;
									ValaSymbol* _tmp996_;
									_tmp992_ = generic_type;
									_tmp993_ = vala_generic_type_get_type_parameter (_tmp992_);
									_tmp994_ = _tmp993_;
									_tmp995_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp994_);
									_tmp996_ = _tmp995_;
									_tmp990_ = VALA_IS_TYPESYMBOL (_tmp996_);
								} else {
									_tmp990_ = FALSE;
								}
								if (_tmp990_) {
									generics = TRUE;
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp997_ = m;
						_tmp998_ = vala_callable_get_return_type ((ValaCallable*) _tmp997_);
						_tmp999_ = _tmp998_;
						generic_type = VALA_IS_GENERIC_TYPE (_tmp999_) ? ((ValaGenericType*) _tmp999_) : NULL;
						_tmp1001_ = generic_type;
						if (_tmp1001_ != NULL) {
							ValaGenericType* _tmp1002_;
							ValaTypeParameter* _tmp1003_;
							ValaTypeParameter* _tmp1004_;
							ValaSymbol* _tmp1005_;
							ValaSymbol* _tmp1006_;
							_tmp1002_ = generic_type;
							_tmp1003_ = vala_generic_type_get_type_parameter (_tmp1002_);
							_tmp1004_ = _tmp1003_;
							_tmp1005_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1004_);
							_tmp1006_ = _tmp1005_;
							_tmp1000_ = VALA_IS_TYPESYMBOL (_tmp1006_);
						} else {
							_tmp1000_ = FALSE;
						}
						if (_tmp1000_) {
							generics = TRUE;
						}
					} else {
						ValaSymbol* _tmp1007_;
						_tmp1007_ = member;
						if (VALA_IS_PROPERTY (_tmp1007_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1008_;
							ValaProperty* _tmp1009_;
							ValaProperty* _tmp1010_;
							ValaProperty* _tmp1011_;
							ValaProperty* _tmp1012_;
							ValaProperty* _tmp1028_;
							ValaSymbolAccessibility _tmp1029_;
							ValaSymbolAccessibility _tmp1030_;
							gboolean _tmp1031_;
							gboolean _tmp1032_;
							ValaProperty* _tmp1097_;
							ValaMemberBinding _tmp1098_;
							ValaMemberBinding _tmp1099_;
							ValaProperty* _tmp1100_;
							ValaDataType* _tmp1101_;
							ValaDataType* _tmp1102_;
							_tmp1008_ = member;
							prop = G_TYPE_CHECK_INSTANCE_CAST (_tmp1008_, VALA_TYPE_PROPERTY, ValaProperty);
							_tmp1009_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1009_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp1010_ = prop;
							_tmp1011_ = vala_property_get_base_property (_tmp1010_);
							_tmp1012_ = _tmp1011_;
							if (_tmp1012_ != NULL) {
								ValaProperty* _tmp1013_;
								ValaProperty* _tmp1014_;
								ValaProperty* _tmp1015_;
								ValaProperty* _tmp1016_;
								ValaSymbol* _tmp1017_;
								ValaSymbol* _tmp1018_;
								_tmp1013_ = prop;
								_tmp1014_ = vala_property_get_base_property (_tmp1013_);
								_tmp1015_ = _tmp1014_;
								prop = _tmp1015_;
								_tmp1016_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1016_);
								_tmp1017_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1018_ = _tmp1017_;
								member = _tmp1018_;
							} else {
								ValaProperty* _tmp1019_;
								ValaProperty* _tmp1020_;
								ValaProperty* _tmp1021_;
								_tmp1019_ = prop;
								_tmp1020_ = vala_property_get_base_interface_property (_tmp1019_);
								_tmp1021_ = _tmp1020_;
								if (_tmp1021_ != NULL) {
									ValaProperty* _tmp1022_;
									ValaProperty* _tmp1023_;
									ValaProperty* _tmp1024_;
									ValaProperty* _tmp1025_;
									ValaSymbol* _tmp1026_;
									ValaSymbol* _tmp1027_;
									_tmp1022_ = prop;
									_tmp1023_ = vala_property_get_base_interface_property (_tmp1022_);
									_tmp1024_ = _tmp1023_;
									prop = _tmp1024_;
									_tmp1025_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1025_);
									_tmp1026_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1027_ = _tmp1026_;
									member = _tmp1027_;
								}
							}
							_tmp1028_ = prop;
							_tmp1029_ = vala_symbol_get_access ((ValaSymbol*) _tmp1028_);
							_tmp1030_ = _tmp1029_;
							access = _tmp1030_;
							_tmp1031_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1032_ = _tmp1031_;
							if (_tmp1032_) {
								ValaProperty* _tmp1033_;
								ValaPropertyAccessor* _tmp1034_;
								ValaPropertyAccessor* _tmp1035_;
								ValaProperty* _tmp1043_;
								ValaSymbolAccessibility _tmp1044_;
								ValaSymbolAccessibility _tmp1045_;
								_tmp1033_ = prop;
								_tmp1034_ = vala_property_get_set_accessor (_tmp1033_);
								_tmp1035_ = _tmp1034_;
								if (_tmp1035_ == NULL) {
									ValaSourceReference* _tmp1036_;
									ValaSourceReference* _tmp1037_;
									ValaProperty* _tmp1038_;
									gchar* _tmp1039_;
									gchar* _tmp1040_;
									gchar* _tmp1041_;
									gchar* _tmp1042_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1036_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1037_ = _tmp1036_;
									_tmp1038_ = prop;
									_tmp1039_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1038_);
									_tmp1040_ = _tmp1039_;
									_tmp1041_ = g_strdup_printf ("Property `%s' is read-only", _tmp1040_);
									_tmp1042_ = _tmp1041_;
									vala_report_error (_tmp1037_, _tmp1042_);
									_g_free0 (_tmp1042_);
									_g_free0 (_tmp1040_);
									result = FALSE;
									return result;
								}
								_tmp1043_ = prop;
								_tmp1044_ = vala_symbol_get_access ((ValaSymbol*) _tmp1043_);
								_tmp1045_ = _tmp1044_;
								if (_tmp1045_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1046_;
									ValaPropertyAccessor* _tmp1047_;
									ValaPropertyAccessor* _tmp1048_;
									ValaSymbolAccessibility _tmp1049_;
									ValaSymbolAccessibility _tmp1050_;
									_tmp1046_ = prop;
									_tmp1047_ = vala_property_get_set_accessor (_tmp1046_);
									_tmp1048_ = _tmp1047_;
									_tmp1049_ = vala_symbol_get_access ((ValaSymbol*) _tmp1048_);
									_tmp1050_ = _tmp1049_;
									access = _tmp1050_;
								} else {
									gboolean _tmp1051_ = FALSE;
									ValaProperty* _tmp1052_;
									ValaSymbolAccessibility _tmp1053_;
									ValaSymbolAccessibility _tmp1054_;
									_tmp1052_ = prop;
									_tmp1053_ = vala_symbol_get_access ((ValaSymbol*) _tmp1052_);
									_tmp1054_ = _tmp1053_;
									if (_tmp1054_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1055_;
										ValaPropertyAccessor* _tmp1056_;
										ValaPropertyAccessor* _tmp1057_;
										ValaSymbolAccessibility _tmp1058_;
										ValaSymbolAccessibility _tmp1059_;
										_tmp1055_ = prop;
										_tmp1056_ = vala_property_get_set_accessor (_tmp1055_);
										_tmp1057_ = _tmp1056_;
										_tmp1058_ = vala_symbol_get_access ((ValaSymbol*) _tmp1057_);
										_tmp1059_ = _tmp1058_;
										_tmp1051_ = _tmp1059_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1051_ = FALSE;
									}
									if (_tmp1051_) {
										ValaProperty* _tmp1060_;
										ValaPropertyAccessor* _tmp1061_;
										ValaPropertyAccessor* _tmp1062_;
										ValaSymbolAccessibility _tmp1063_;
										ValaSymbolAccessibility _tmp1064_;
										_tmp1060_ = prop;
										_tmp1061_ = vala_property_get_set_accessor (_tmp1060_);
										_tmp1062_ = _tmp1061_;
										_tmp1063_ = vala_symbol_get_access ((ValaSymbol*) _tmp1062_);
										_tmp1064_ = _tmp1063_;
										access = _tmp1064_;
									}
								}
							} else {
								ValaProperty* _tmp1065_;
								ValaPropertyAccessor* _tmp1066_;
								ValaPropertyAccessor* _tmp1067_;
								ValaProperty* _tmp1075_;
								ValaSymbolAccessibility _tmp1076_;
								ValaSymbolAccessibility _tmp1077_;
								_tmp1065_ = prop;
								_tmp1066_ = vala_property_get_get_accessor (_tmp1065_);
								_tmp1067_ = _tmp1066_;
								if (_tmp1067_ == NULL) {
									ValaSourceReference* _tmp1068_;
									ValaSourceReference* _tmp1069_;
									ValaProperty* _tmp1070_;
									gchar* _tmp1071_;
									gchar* _tmp1072_;
									gchar* _tmp1073_;
									gchar* _tmp1074_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1068_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1069_ = _tmp1068_;
									_tmp1070_ = prop;
									_tmp1071_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1070_);
									_tmp1072_ = _tmp1071_;
									_tmp1073_ = g_strdup_printf ("Property `%s' is write-only", _tmp1072_);
									_tmp1074_ = _tmp1073_;
									vala_report_error (_tmp1069_, _tmp1074_);
									_g_free0 (_tmp1074_);
									_g_free0 (_tmp1072_);
									result = FALSE;
									return result;
								}
								_tmp1075_ = prop;
								_tmp1076_ = vala_symbol_get_access ((ValaSymbol*) _tmp1075_);
								_tmp1077_ = _tmp1076_;
								if (_tmp1077_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1078_;
									ValaPropertyAccessor* _tmp1079_;
									ValaPropertyAccessor* _tmp1080_;
									ValaSymbolAccessibility _tmp1081_;
									ValaSymbolAccessibility _tmp1082_;
									_tmp1078_ = prop;
									_tmp1079_ = vala_property_get_get_accessor (_tmp1078_);
									_tmp1080_ = _tmp1079_;
									_tmp1081_ = vala_symbol_get_access ((ValaSymbol*) _tmp1080_);
									_tmp1082_ = _tmp1081_;
									access = _tmp1082_;
								} else {
									gboolean _tmp1083_ = FALSE;
									ValaProperty* _tmp1084_;
									ValaSymbolAccessibility _tmp1085_;
									ValaSymbolAccessibility _tmp1086_;
									_tmp1084_ = prop;
									_tmp1085_ = vala_symbol_get_access ((ValaSymbol*) _tmp1084_);
									_tmp1086_ = _tmp1085_;
									if (_tmp1086_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1087_;
										ValaPropertyAccessor* _tmp1088_;
										ValaPropertyAccessor* _tmp1089_;
										ValaSymbolAccessibility _tmp1090_;
										ValaSymbolAccessibility _tmp1091_;
										_tmp1087_ = prop;
										_tmp1088_ = vala_property_get_get_accessor (_tmp1087_);
										_tmp1089_ = _tmp1088_;
										_tmp1090_ = vala_symbol_get_access ((ValaSymbol*) _tmp1089_);
										_tmp1091_ = _tmp1090_;
										_tmp1083_ = _tmp1091_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1083_ = FALSE;
									}
									if (_tmp1083_) {
										ValaProperty* _tmp1092_;
										ValaPropertyAccessor* _tmp1093_;
										ValaPropertyAccessor* _tmp1094_;
										ValaSymbolAccessibility _tmp1095_;
										ValaSymbolAccessibility _tmp1096_;
										_tmp1092_ = prop;
										_tmp1093_ = vala_property_get_get_accessor (_tmp1092_);
										_tmp1094_ = _tmp1093_;
										_tmp1095_ = vala_symbol_get_access ((ValaSymbol*) _tmp1094_);
										_tmp1096_ = _tmp1095_;
										access = _tmp1096_;
									}
								}
							}
							_tmp1097_ = prop;
							_tmp1098_ = vala_property_get_binding (_tmp1097_);
							_tmp1099_ = _tmp1098_;
							instance = _tmp1099_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1100_ = prop;
							_tmp1101_ = vala_property_get_property_type (_tmp1100_);
							_tmp1102_ = _tmp1101_;
							if (VALA_IS_GENERIC_TYPE (_tmp1102_)) {
								generics = TRUE;
							}
						} else {
							ValaSymbol* _tmp1103_;
							_tmp1103_ = member;
							if (VALA_IS_SIGNAL (_tmp1103_)) {
								ValaSymbol* _tmp1104_;
								ValaSymbolAccessibility _tmp1105_;
								ValaSymbolAccessibility _tmp1106_;
								instance = TRUE;
								_tmp1104_ = member;
								_tmp1105_ = vala_symbol_get_access (_tmp1104_);
								_tmp1106_ = _tmp1105_;
								access = _tmp1106_;
							} else {
								gboolean _tmp1107_ = FALSE;
								gboolean _tmp1108_;
								_tmp1108_ = self->priv->_creation_member;
								if (!_tmp1108_) {
									ValaSymbol* _tmp1109_;
									_tmp1109_ = member;
									_tmp1107_ = VALA_IS_ERROR_CODE (_tmp1109_);
								} else {
									_tmp1107_ = FALSE;
								}
								if (_tmp1107_) {
									ValaSymbol* _tmp1110_;
									ValaConstant* _tmp1111_;
									ValaConstant* _tmp1112_;
									ValaSymbol* _tmp1113_;
									ValaSymbol* _tmp1114_;
									_tmp1110_ = member;
									_tmp1111_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1110_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1112_ = _tmp1111_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1112_);
									_tmp1113_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1114_ = _tmp1113_;
									member = _tmp1114_;
								}
							}
						}
					}
				}
			}
		}
	}
	parent = (ValaCodeNode*) self;
	while (TRUE) {
		ValaCodeNode* _tmp1115_;
		ValaSymbol* _tmp1116_;
		ValaCodeNode* _tmp1117_;
		ValaCodeNode* _tmp1118_;
		ValaCodeNode* _tmp1119_;
		gboolean _tmp1120_ = FALSE;
		ValaCodeNode* _tmp1121_;
		_tmp1115_ = parent;
		_tmp1116_ = member;
		if (!(_tmp1115_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1116_, VALA_TYPE_CODE_NODE, ValaCodeNode))) {
			break;
		}
		_tmp1117_ = parent;
		_tmp1118_ = vala_code_node_get_parent_node (_tmp1117_);
		_tmp1119_ = _tmp1118_;
		parent = _tmp1119_;
		_tmp1121_ = parent;
		if (_tmp1121_ == NULL) {
			_tmp1120_ = TRUE;
		} else {
			ValaCodeNode* _tmp1122_;
			ValaSymbol* _tmp1123_;
			_tmp1122_ = parent;
			_tmp1123_ = member;
			_tmp1120_ = _tmp1122_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1123_, VALA_TYPE_CODE_NODE, ValaCodeNode);
		}
		if (_tmp1120_) {
			break;
		}
	}
	_tmp1124_ = parent;
	_tmp1125_ = member;
	if (_tmp1124_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp1125_, VALA_TYPE_CODE_NODE, ValaCodeNode)) {
		ValaSymbol* _tmp1126_;
		_tmp1126_ = member;
		vala_symbol_set_used (_tmp1126_, TRUE);
	}
	_tmp1127_ = member;
	_tmp1128_ = vala_symbol_get_version (_tmp1127_);
	_tmp1129_ = _tmp1128_;
	_tmp1130_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1131_ = _tmp1130_;
	vala_version_attribute_check (_tmp1129_, _tmp1131_);
	_tmp1133_ = access;
	if (_tmp1133_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1134_;
		ValaSymbol* _tmp1135_;
		ValaSymbol* _tmp1136_;
		_tmp1134_ = member;
		_tmp1135_ = vala_symbol_get_parent_symbol (_tmp1134_);
		_tmp1136_ = _tmp1135_;
		_tmp1132_ = VALA_IS_TYPESYMBOL (_tmp1136_);
	} else {
		_tmp1132_ = FALSE;
	}
	if (_tmp1132_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1137_;
		ValaSymbol* _tmp1138_;
		ValaSymbol* _tmp1139_;
		gboolean in_subtype = FALSE;
		_tmp1137_ = member;
		_tmp1138_ = vala_symbol_get_parent_symbol (_tmp1137_);
		_tmp1139_ = _tmp1138_;
		target_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp1139_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1140_;
			ValaSemanticAnalyzer* _tmp1141_;
			ValaSymbol* _tmp1142_;
			ValaSymbol* _tmp1143_;
			ValaSymbol* _tmp1144_;
			_tmp1140_ = vala_code_context_get_analyzer (context);
			_tmp1141_ = _tmp1140_;
			_tmp1142_ = vala_semantic_analyzer_get_current_symbol (_tmp1141_);
			_tmp1143_ = _tmp1142_;
			_tmp1144_ = _vala_code_node_ref0 (_tmp1143_);
			this_symbol = _tmp1144_;
			{
				gboolean _tmp1145_ = FALSE;
				_tmp1145_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1150_;
					ValaSymbol* _tmp1151_;
					ValaTypeSymbol* _tmp1152_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1153_;
					gboolean _tmp1154_ = FALSE;
					ValaClass* _tmp1155_;
					if (!_tmp1145_) {
						ValaSymbol* _tmp1146_;
						ValaSymbol* _tmp1147_;
						ValaSymbol* _tmp1148_;
						ValaSymbol* _tmp1149_;
						_tmp1146_ = this_symbol;
						_tmp1147_ = vala_symbol_get_parent_symbol (_tmp1146_);
						_tmp1148_ = _tmp1147_;
						_tmp1149_ = _vala_code_node_ref0 (_tmp1148_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1149_;
					}
					_tmp1145_ = FALSE;
					_tmp1150_ = this_symbol;
					if (!(_tmp1150_ != NULL)) {
						break;
					}
					_tmp1151_ = this_symbol;
					_tmp1152_ = target_type;
					if (_tmp1151_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1152_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1153_ = this_symbol;
					cl = VALA_IS_CLASS (_tmp1153_) ? ((ValaClass*) _tmp1153_) : NULL;
					_tmp1155_ = cl;
					if (_tmp1155_ != NULL) {
						ValaClass* _tmp1156_;
						ValaTypeSymbol* _tmp1157_;
						_tmp1156_ = cl;
						_tmp1157_ = target_type;
						_tmp1154_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1156_, _tmp1157_);
					} else {
						_tmp1154_ = FALSE;
					}
					if (_tmp1154_) {
						in_subtype = TRUE;
						break;
					}
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		if (!in_subtype) {
			ValaSourceReference* _tmp1158_;
			ValaSourceReference* _tmp1159_;
			ValaSymbol* _tmp1160_;
			gchar* _tmp1161_;
			gchar* _tmp1162_;
			gchar* _tmp1163_;
			gchar* _tmp1164_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1159_ = _tmp1158_;
			_tmp1160_ = member;
			_tmp1161_ = vala_symbol_get_full_name (_tmp1160_);
			_tmp1162_ = _tmp1161_;
			_tmp1163_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1162_);
			_tmp1164_ = _tmp1163_;
			vala_report_error (_tmp1159_, _tmp1164_);
			_g_free0 (_tmp1164_);
			_g_free0 (_tmp1162_);
			result = FALSE;
			return result;
		}
	} else {
		ValaSymbolAccessibility _tmp1165_;
		_tmp1165_ = access;
		if (_tmp1165_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1166_;
			ValaSymbol* _tmp1167_;
			ValaSymbol* _tmp1168_;
			gboolean in_target_type = FALSE;
			_tmp1166_ = member;
			_tmp1167_ = vala_symbol_get_parent_symbol (_tmp1166_);
			_tmp1168_ = _tmp1167_;
			target_type = _tmp1168_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1169_;
				ValaSemanticAnalyzer* _tmp1170_;
				ValaSymbol* _tmp1171_;
				ValaSymbol* _tmp1172_;
				ValaSymbol* _tmp1173_;
				_tmp1169_ = vala_code_context_get_analyzer (context);
				_tmp1170_ = _tmp1169_;
				_tmp1171_ = vala_semantic_analyzer_get_current_symbol (_tmp1170_);
				_tmp1172_ = _tmp1171_;
				_tmp1173_ = _vala_code_node_ref0 (_tmp1172_);
				this_symbol = _tmp1173_;
				{
					gboolean _tmp1174_ = FALSE;
					_tmp1174_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1179_;
						ValaSymbol* _tmp1180_;
						ValaSymbol* _tmp1181_;
						if (!_tmp1174_) {
							ValaSymbol* _tmp1175_;
							ValaSymbol* _tmp1176_;
							ValaSymbol* _tmp1177_;
							ValaSymbol* _tmp1178_;
							_tmp1175_ = this_symbol;
							_tmp1176_ = vala_symbol_get_parent_symbol (_tmp1175_);
							_tmp1177_ = _tmp1176_;
							_tmp1178_ = _vala_code_node_ref0 (_tmp1177_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1178_;
						}
						_tmp1174_ = FALSE;
						_tmp1179_ = this_symbol;
						if (!(_tmp1179_ != NULL)) {
							break;
						}
						_tmp1180_ = target_type;
						_tmp1181_ = this_symbol;
						if (_tmp1180_ == _tmp1181_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			if (!in_target_type) {
				ValaSourceReference* _tmp1182_;
				ValaSourceReference* _tmp1183_;
				ValaSymbol* _tmp1184_;
				gchar* _tmp1185_;
				gchar* _tmp1186_;
				gchar* _tmp1187_;
				gchar* _tmp1188_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1182_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1183_ = _tmp1182_;
				_tmp1184_ = member;
				_tmp1185_ = vala_symbol_get_full_name (_tmp1184_);
				_tmp1186_ = _tmp1185_;
				_tmp1187_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1186_);
				_tmp1188_ = _tmp1187_;
				vala_report_error (_tmp1183_, _tmp1188_);
				_g_free0 (_tmp1188_);
				_g_free0 (_tmp1186_);
				result = FALSE;
				return result;
			}
		}
	}
	if (generics) {
		ValaExpression* _tmp1190_;
		ValaExpression* _tmp1191_;
		_tmp1190_ = vala_member_access_get_inner (self);
		_tmp1191_ = _tmp1190_;
		_tmp1189_ = _tmp1191_ != NULL;
	} else {
		_tmp1189_ = FALSE;
	}
	if (_tmp1189_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1192_;
		ValaExpression* _tmp1193_;
		ValaDataType* _tmp1194_;
		ValaDataType* _tmp1195_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1196_;
		ValaExpression* _tmp1197_;
		ValaDataType* _tmp1198_;
		ValaDataType* _tmp1199_;
		ValaPointerType* _tmp1200_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1204_;
		gboolean _tmp1205_ = FALSE;
		gboolean _tmp1206_ = FALSE;
		ValaObjectType* _tmp1207_;
		_tmp1192_ = vala_member_access_get_inner (self);
		_tmp1193_ = _tmp1192_;
		_tmp1194_ = vala_expression_get_value_type (_tmp1193_);
		_tmp1195_ = _tmp1194_;
		instance_type = _tmp1195_;
		_tmp1196_ = vala_member_access_get_inner (self);
		_tmp1197_ = _tmp1196_;
		_tmp1198_ = vala_expression_get_value_type (_tmp1197_);
		_tmp1199_ = _tmp1198_;
		pointer_type = VALA_IS_POINTER_TYPE (_tmp1199_) ? ((ValaPointerType*) _tmp1199_) : NULL;
		_tmp1200_ = pointer_type;
		if (_tmp1200_ != NULL) {
			ValaPointerType* _tmp1201_;
			ValaDataType* _tmp1202_;
			ValaDataType* _tmp1203_;
			_tmp1201_ = pointer_type;
			_tmp1202_ = vala_pointer_type_get_base_type (_tmp1201_);
			_tmp1203_ = _tmp1202_;
			instance_type = _tmp1203_;
		}
		_tmp1204_ = instance_type;
		object_type = VALA_IS_OBJECT_TYPE (_tmp1204_) ? ((ValaObjectType*) _tmp1204_) : NULL;
		_tmp1207_ = object_type;
		if (_tmp1207_ != NULL) {
			ValaObjectType* _tmp1208_;
			ValaObjectTypeSymbol* _tmp1209_;
			ValaObjectTypeSymbol* _tmp1210_;
			_tmp1208_ = object_type;
			_tmp1209_ = vala_object_type_get_object_type_symbol (_tmp1208_);
			_tmp1210_ = _tmp1209_;
			_tmp1206_ = vala_object_type_symbol_has_type_parameters (_tmp1210_);
		} else {
			_tmp1206_ = FALSE;
		}
		if (_tmp1206_) {
			ValaDataType* _tmp1211_;
			_tmp1211_ = instance_type;
			_tmp1205_ = !vala_data_type_has_type_arguments (_tmp1211_);
		} else {
			_tmp1205_ = FALSE;
		}
		if (_tmp1205_) {
			ValaExpression* _tmp1212_;
			ValaExpression* _tmp1213_;
			ValaSourceReference* _tmp1214_;
			ValaSourceReference* _tmp1215_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1212_ = vala_member_access_get_inner (self);
			_tmp1213_ = _tmp1212_;
			_tmp1214_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1213_);
			_tmp1215_ = _tmp1214_;
			vala_report_error (_tmp1215_, "missing generic type arguments");
			result = FALSE;
			return result;
		}
	}
	if (instance) {
		_tmp1217_ = !may_access_instance_members;
	} else {
		_tmp1217_ = FALSE;
	}
	if (_tmp1217_) {
		_tmp1216_ = TRUE;
	} else {
		gboolean _tmp1218_ = FALSE;
		if (klass) {
			_tmp1218_ = !may_access_klass_members;
		} else {
			_tmp1218_ = FALSE;
		}
		_tmp1216_ = _tmp1218_;
	}
	if (_tmp1216_) {
		ValaSymbol* _tmp1219_;
		ValaSymbol* _tmp1220_;
		ValaDataType* _tmp1243_;
		ValaDataType* _tmp1244_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1219_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1220_ = _tmp1219_;
		if (VALA_IS_METHOD (_tmp1220_)) {
			ValaSemanticAnalyzer* _tmp1221_;
			ValaSemanticAnalyzer* _tmp1222_;
			ValaSymbol* _tmp1223_;
			ValaSymbol* _tmp1224_;
			gboolean _tmp1225_;
			gboolean _tmp1226_;
			ValaDataType* _tmp1227_;
			ValaDataType* _tmp1228_;
			_tmp1221_ = vala_code_context_get_analyzer (context);
			_tmp1222_ = _tmp1221_;
			_tmp1223_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1224_ = _tmp1223_;
			_tmp1225_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1226_ = _tmp1225_;
			_tmp1227_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1222_, _tmp1224_, _tmp1226_);
			_tmp1228_ = _tmp1227_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1228_);
			_vala_code_node_unref0 (_tmp1228_);
		} else {
			ValaSymbol* _tmp1229_;
			ValaSymbol* _tmp1230_;
			_tmp1229_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1230_ = _tmp1229_;
			if (VALA_IS_FIELD (_tmp1230_)) {
				ValaSymbol* _tmp1231_;
				ValaSymbol* _tmp1232_;
				ValaFieldPrototype* _tmp1233_;
				ValaFieldPrototype* _tmp1234_;
				_tmp1231_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1232_ = _tmp1231_;
				_tmp1233_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1232_, VALA_TYPE_FIELD, ValaField));
				_tmp1234_ = _tmp1233_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1234_);
				_vala_code_node_unref0 (_tmp1234_);
			} else {
				ValaSymbol* _tmp1235_;
				ValaSymbol* _tmp1236_;
				_tmp1235_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1236_ = _tmp1235_;
				if (VALA_IS_PROPERTY (_tmp1236_)) {
					ValaSymbol* _tmp1237_;
					ValaSymbol* _tmp1238_;
					ValaPropertyPrototype* _tmp1239_;
					ValaPropertyPrototype* _tmp1240_;
					_tmp1237_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1238_ = _tmp1237_;
					_tmp1239_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1238_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1240_ = _tmp1239_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1240_);
					_vala_code_node_unref0 (_tmp1240_);
				} else {
					ValaInvalidType* _tmp1241_;
					ValaInvalidType* _tmp1242_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1241_ = vala_invalid_type_new ();
					_tmp1242_ = _tmp1241_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1242_);
					_vala_code_node_unref0 (_tmp1242_);
				}
			}
		}
		_tmp1243_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1244_ = _tmp1243_;
		if (_tmp1244_ != NULL) {
			ValaDataType* _tmp1245_;
			ValaDataType* _tmp1246_;
			ValaDataType* _tmp1247_;
			ValaDataType* _tmp1248_;
			gboolean _tmp1249_;
			gboolean _tmp1250_;
			_tmp1245_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1246_ = _tmp1245_;
			_tmp1247_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1248_ = _tmp1247_;
			_tmp1249_ = vala_data_type_get_value_owned (_tmp1248_);
			_tmp1250_ = _tmp1249_;
			vala_data_type_set_value_owned (_tmp1246_, _tmp1250_);
		}
	} else {
		gboolean _tmp1251_ = FALSE;
		gboolean _tmp1272_ = FALSE;
		gboolean _tmp1273_ = FALSE;
		gboolean _tmp1274_ = FALSE;
		gboolean _tmp1275_ = FALSE;
		gboolean _tmp1317_ = FALSE;
		gboolean _tmp1318_ = FALSE;
		gboolean _tmp1319_ = FALSE;
		gboolean _tmp1320_ = FALSE;
		gboolean _tmp1321_ = FALSE;
		gboolean _tmp1322_;
		gboolean _tmp1323_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1350_;
		ValaSymbol* _tmp1351_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1352_;
		ValaExpression* _tmp1353_;
		gboolean _tmp1354_ = FALSE;
		gboolean _tmp1355_ = FALSE;
		gboolean _tmp1356_ = FALSE;
		gboolean _tmp1357_ = FALSE;
		gboolean _tmp1358_ = FALSE;
		ValaMethod* _tmp1359_;
		ValaSemanticAnalyzer* _tmp1398_;
		ValaSemanticAnalyzer* _tmp1399_;
		ValaSymbol* _tmp1400_;
		ValaSymbol* _tmp1401_;
		gboolean _tmp1402_;
		gboolean _tmp1403_;
		ValaDataType* _tmp1404_;
		ValaDataType* _tmp1405_;
		gboolean _tmp1406_ = FALSE;
		ValaExpression* _tmp1407_;
		ValaExpression* _tmp1408_;
		ValaSymbol* _tmp1421_;
		ValaSymbol* _tmp1422_;
		if (instance) {
			ValaExpression* _tmp1252_;
			ValaExpression* _tmp1253_;
			_tmp1252_ = vala_member_access_get_inner (self);
			_tmp1253_ = _tmp1252_;
			_tmp1251_ = _tmp1253_ == NULL;
		} else {
			_tmp1251_ = FALSE;
		}
		if (_tmp1251_) {
			ValaSourceReference* _tmp1254_;
			ValaSourceReference* _tmp1255_;
			ValaMemberAccess* _tmp1256_;
			ValaMemberAccess* _tmp1257_;
			ValaExpression* _tmp1258_;
			ValaExpression* _tmp1259_;
			ValaParameter* _tmp1260_;
			ValaDataType* _tmp1261_;
			ValaDataType* _tmp1262_;
			ValaDataType* _tmp1263_;
			ValaDataType* _tmp1264_;
			ValaExpression* _tmp1265_;
			ValaExpression* _tmp1266_;
			ValaDataType* _tmp1267_;
			ValaDataType* _tmp1268_;
			ValaExpression* _tmp1269_;
			ValaExpression* _tmp1270_;
			ValaParameter* _tmp1271_;
			_tmp1254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = vala_member_access_new (NULL, "this", _tmp1255_);
			_tmp1257_ = _tmp1256_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1257_);
			_vala_code_node_unref0 (_tmp1257_);
			_tmp1258_ = vala_member_access_get_inner (self);
			_tmp1259_ = _tmp1258_;
			_tmp1260_ = this_parameter;
			_tmp1261_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1260_);
			_tmp1262_ = _tmp1261_;
			_tmp1263_ = vala_data_type_copy (_tmp1262_);
			_tmp1264_ = _tmp1263_;
			vala_expression_set_value_type (_tmp1259_, _tmp1264_);
			_vala_code_node_unref0 (_tmp1264_);
			_tmp1265_ = vala_member_access_get_inner (self);
			_tmp1266_ = _tmp1265_;
			_tmp1267_ = vala_expression_get_value_type (_tmp1266_);
			_tmp1268_ = _tmp1267_;
			vala_data_type_set_value_owned (_tmp1268_, FALSE);
			_tmp1269_ = vala_member_access_get_inner (self);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1270_, (ValaSymbol*) _tmp1271_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		if (!instance) {
			_tmp1275_ = !klass;
		} else {
			_tmp1275_ = FALSE;
		}
		if (_tmp1275_) {
			ValaSymbol* _tmp1276_;
			ValaSymbol* _tmp1277_;
			_tmp1276_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1277_ = _tmp1276_;
			_tmp1274_ = !VALA_IS_CREATION_METHOD (_tmp1277_);
		} else {
			_tmp1274_ = FALSE;
		}
		if (_tmp1274_) {
			_tmp1273_ = may_access_instance_members;
		} else {
			_tmp1273_ = FALSE;
		}
		if (_tmp1273_) {
			ValaExpression* _tmp1278_;
			ValaExpression* _tmp1279_;
			_tmp1278_ = vala_member_access_get_inner (self);
			_tmp1279_ = _tmp1278_;
			_tmp1272_ = _tmp1279_ != NULL;
		} else {
			_tmp1272_ = FALSE;
		}
		if (_tmp1272_) {
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaSymbol* _tmp1282_;
			ValaSymbol* _tmp1283_;
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_expression_get_symbol_reference (_tmp1281_);
			_tmp1283_ = _tmp1282_;
			if (VALA_IS_METHOD (_tmp1283_)) {
			} else {
				ValaSourceReference* _tmp1284_;
				ValaSourceReference* _tmp1285_;
				ValaSymbol* _tmp1286_;
				ValaSymbol* _tmp1287_;
				gchar* _tmp1288_;
				gchar* _tmp1289_;
				gchar* _tmp1290_;
				gchar* _tmp1291_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1292_;
				ValaSymbol* _tmp1293_;
				ValaSymbol* _tmp1294_;
				ValaSymbol* _tmp1295_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1315_;
				ValaExpression* _tmp1316_;
				_tmp1284_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1285_ = _tmp1284_;
				_tmp1286_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1287_ = _tmp1286_;
				_tmp1288_ = vala_symbol_get_full_name (_tmp1287_);
				_tmp1289_ = _tmp1288_;
				_tmp1290_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1289_);
				_tmp1291_ = _tmp1290_;
				vala_report_warning (_tmp1285_, _tmp1291_);
				_g_free0 (_tmp1291_);
				_g_free0 (_tmp1289_);
				_tmp1292_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1293_ = _tmp1292_;
				_tmp1294_ = vala_symbol_get_parent_symbol (_tmp1293_);
				_tmp1295_ = _tmp1294_;
				inner_sym = _tmp1295_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1296_ = FALSE;
					ValaSymbol* _tmp1297_;
					ValaMemberAccess* _tmp1301_;
					ValaSymbol* _tmp1302_;
					const gchar* _tmp1303_;
					const gchar* _tmp1304_;
					ValaSourceReference* _tmp1305_;
					ValaSourceReference* _tmp1306_;
					ValaMemberAccess* _tmp1307_;
					ValaMemberAccess* _tmp1308_;
					ValaMemberAccess* _tmp1309_;
					ValaExpression* _tmp1310_;
					ValaExpression* _tmp1311_;
					ValaSymbol* _tmp1312_;
					ValaSymbol* _tmp1313_;
					ValaSymbol* _tmp1314_;
					_tmp1297_ = inner_sym;
					if (_tmp1297_ != NULL) {
						ValaSymbol* _tmp1298_;
						const gchar* _tmp1299_;
						const gchar* _tmp1300_;
						_tmp1298_ = inner_sym;
						_tmp1299_ = vala_symbol_get_name (_tmp1298_);
						_tmp1300_ = _tmp1299_;
						_tmp1296_ = _tmp1300_ != NULL;
					} else {
						_tmp1296_ = FALSE;
					}
					if (!_tmp1296_) {
						break;
					}
					_tmp1301_ = inner_ma;
					_tmp1302_ = inner_sym;
					_tmp1303_ = vala_symbol_get_name (_tmp1302_);
					_tmp1304_ = _tmp1303_;
					_tmp1305_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1306_ = _tmp1305_;
					_tmp1307_ = vala_member_access_new (NULL, _tmp1304_, _tmp1306_);
					_tmp1308_ = _tmp1307_;
					vala_member_access_set_inner (_tmp1301_, (ValaExpression*) _tmp1308_);
					_vala_code_node_unref0 (_tmp1308_);
					_tmp1309_ = inner_ma;
					_tmp1310_ = vala_member_access_get_inner (_tmp1309_);
					_tmp1311_ = _tmp1310_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1311_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1312_ = inner_sym;
					_tmp1313_ = vala_symbol_get_parent_symbol (_tmp1312_);
					_tmp1314_ = _tmp1313_;
					inner_sym = _tmp1314_;
				}
				_tmp1315_ = vala_member_access_get_inner (self);
				_tmp1316_ = _tmp1315_;
				vala_code_node_check ((ValaCodeNode*) _tmp1316_, context);
			}
		}
		_tmp1322_ = vala_code_context_get_experimental_non_null (context);
		_tmp1323_ = _tmp1322_;
		if (_tmp1323_) {
			_tmp1321_ = instance;
		} else {
			_tmp1321_ = FALSE;
		}
		if (_tmp1321_) {
			ValaExpression* _tmp1324_;
			ValaExpression* _tmp1325_;
			ValaDataType* _tmp1326_;
			ValaDataType* _tmp1327_;
			gboolean _tmp1328_;
			gboolean _tmp1329_;
			_tmp1324_ = vala_member_access_get_inner (self);
			_tmp1325_ = _tmp1324_;
			_tmp1326_ = vala_expression_get_value_type (_tmp1325_);
			_tmp1327_ = _tmp1326_;
			_tmp1328_ = vala_data_type_get_nullable (_tmp1327_);
			_tmp1329_ = _tmp1328_;
			_tmp1320_ = _tmp1329_;
		} else {
			_tmp1320_ = FALSE;
		}
		if (_tmp1320_) {
			ValaExpression* _tmp1330_;
			ValaExpression* _tmp1331_;
			ValaDataType* _tmp1332_;
			ValaDataType* _tmp1333_;
			_tmp1330_ = vala_member_access_get_inner (self);
			_tmp1331_ = _tmp1330_;
			_tmp1332_ = vala_expression_get_value_type (_tmp1331_);
			_tmp1333_ = _tmp1332_;
			_tmp1319_ = !VALA_IS_POINTER_TYPE (_tmp1333_);
		} else {
			_tmp1319_ = FALSE;
		}
		if (_tmp1319_) {
			ValaExpression* _tmp1334_;
			ValaExpression* _tmp1335_;
			ValaDataType* _tmp1336_;
			ValaDataType* _tmp1337_;
			_tmp1334_ = vala_member_access_get_inner (self);
			_tmp1335_ = _tmp1334_;
			_tmp1336_ = vala_expression_get_value_type (_tmp1335_);
			_tmp1337_ = _tmp1336_;
			_tmp1318_ = !VALA_IS_GENERIC_TYPE (_tmp1337_);
		} else {
			_tmp1318_ = FALSE;
		}
		if (_tmp1318_) {
			ValaExpression* _tmp1338_;
			ValaExpression* _tmp1339_;
			ValaDataType* _tmp1340_;
			ValaDataType* _tmp1341_;
			_tmp1338_ = vala_member_access_get_inner (self);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = vala_expression_get_value_type (_tmp1339_);
			_tmp1341_ = _tmp1340_;
			_tmp1317_ = !VALA_IS_ARRAY_TYPE (_tmp1341_);
		} else {
			_tmp1317_ = FALSE;
		}
		if (_tmp1317_) {
			ValaSourceReference* _tmp1342_;
			ValaSourceReference* _tmp1343_;
			ValaSymbol* _tmp1344_;
			ValaSymbol* _tmp1345_;
			gchar* _tmp1346_;
			gchar* _tmp1347_;
			gchar* _tmp1348_;
			gchar* _tmp1349_;
			_tmp1342_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1343_ = _tmp1342_;
			_tmp1344_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1345_ = _tmp1344_;
			_tmp1346_ = vala_symbol_get_full_name (_tmp1345_);
			_tmp1347_ = _tmp1346_;
			_tmp1348_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1347_);
			_tmp1349_ = _tmp1348_;
			vala_report_error (_tmp1343_, _tmp1349_);
			_g_free0 (_tmp1349_);
			_g_free0 (_tmp1347_);
		}
		_tmp1350_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1351_ = _tmp1350_;
		m = VALA_IS_METHOD (_tmp1351_) ? ((ValaMethod*) _tmp1351_) : NULL;
		_tmp1352_ = vala_member_access_get_inner (self);
		_tmp1353_ = _tmp1352_;
		inner_ma = VALA_IS_MEMBER_ACCESS (_tmp1353_) ? ((ValaMemberAccess*) _tmp1353_) : NULL;
		_tmp1359_ = m;
		if (_tmp1359_ != NULL) {
			ValaMethod* _tmp1360_;
			ValaMemberBinding _tmp1361_;
			ValaMemberBinding _tmp1362_;
			_tmp1360_ = m;
			_tmp1361_ = vala_method_get_binding (_tmp1360_);
			_tmp1362_ = _tmp1361_;
			_tmp1358_ = _tmp1362_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1358_ = FALSE;
		}
		if (_tmp1358_) {
			ValaMethod* _tmp1363_;
			ValaSymbol* _tmp1364_;
			ValaSymbol* _tmp1365_;
			_tmp1363_ = m;
			_tmp1364_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1363_);
			_tmp1365_ = _tmp1364_;
			_tmp1357_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1365_);
		} else {
			_tmp1357_ = FALSE;
		}
		if (_tmp1357_) {
			ValaExpression* _tmp1366_;
			ValaExpression* _tmp1367_;
			_tmp1366_ = vala_member_access_get_inner (self);
			_tmp1367_ = _tmp1366_;
			_tmp1356_ = _tmp1367_ != NULL;
		} else {
			_tmp1356_ = FALSE;
		}
		if (_tmp1356_) {
			ValaExpression* _tmp1368_;
			ValaExpression* _tmp1369_;
			ValaDataType* _tmp1370_;
			ValaDataType* _tmp1371_;
			_tmp1368_ = vala_member_access_get_inner (self);
			_tmp1369_ = _tmp1368_;
			_tmp1370_ = vala_expression_get_value_type (_tmp1369_);
			_tmp1371_ = _tmp1370_;
			_tmp1355_ = _tmp1371_ == NULL;
		} else {
			_tmp1355_ = FALSE;
		}
		if (_tmp1355_) {
			ValaMemberAccess* _tmp1372_;
			ValaList* _tmp1373_;
			gint _tmp1374_;
			gint _tmp1375_;
			_tmp1372_ = inner_ma;
			_tmp1373_ = _tmp1372_->priv->type_argument_list;
			_tmp1374_ = vala_collection_get_size ((ValaCollection*) _tmp1373_);
			_tmp1375_ = _tmp1374_;
			_tmp1354_ = _tmp1375_ > 0;
		} else {
			_tmp1354_ = FALSE;
		}
		if (_tmp1354_) {
			ValaExpression* _tmp1376_;
			ValaExpression* _tmp1377_;
			ValaMethod* _tmp1378_;
			ValaSymbol* _tmp1379_;
			ValaSymbol* _tmp1380_;
			ValaObjectType* _tmp1381_;
			ValaObjectType* _tmp1382_;
			_tmp1376_ = vala_member_access_get_inner (self);
			_tmp1377_ = _tmp1376_;
			_tmp1378_ = m;
			_tmp1379_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1378_);
			_tmp1380_ = _tmp1379_;
			_tmp1381_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1380_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1382_ = _tmp1381_;
			vala_expression_set_value_type (_tmp1377_, (ValaDataType*) _tmp1382_);
			_vala_code_node_unref0 (_tmp1382_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1383_;
				ValaList* _tmp1384_;
				ValaList* _tmp1385_;
				gint _type_argument_size = 0;
				ValaList* _tmp1386_;
				gint _tmp1387_;
				gint _tmp1388_;
				gint _type_argument_index = 0;
				_tmp1383_ = inner_ma;
				_tmp1384_ = _tmp1383_->priv->type_argument_list;
				_tmp1385_ = _vala_iterable_ref0 (_tmp1384_);
				_type_argument_list = _tmp1385_;
				_tmp1386_ = _type_argument_list;
				_tmp1387_ = vala_collection_get_size ((ValaCollection*) _tmp1386_);
				_tmp1388_ = _tmp1387_;
				_type_argument_size = _tmp1388_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1389_;
					gint _tmp1390_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1391_;
					gpointer _tmp1392_;
					ValaExpression* _tmp1393_;
					ValaExpression* _tmp1394_;
					ValaDataType* _tmp1395_;
					ValaDataType* _tmp1396_;
					ValaDataType* _tmp1397_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1389_ = _type_argument_index;
					_tmp1390_ = _type_argument_size;
					if (!(_tmp1389_ < _tmp1390_)) {
						break;
					}
					_tmp1391_ = _type_argument_list;
					_tmp1392_ = vala_list_get (_tmp1391_, _type_argument_index);
					type_argument = (ValaDataType*) _tmp1392_;
					_tmp1393_ = vala_member_access_get_inner (self);
					_tmp1394_ = _tmp1393_;
					_tmp1395_ = vala_expression_get_value_type (_tmp1394_);
					_tmp1396_ = _tmp1395_;
					_tmp1397_ = type_argument;
					vala_data_type_add_type_argument (_tmp1396_, _tmp1397_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1398_ = vala_code_context_get_analyzer (context);
		_tmp1399_ = _tmp1398_;
		_tmp1400_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1401_ = _tmp1400_;
		_tmp1402_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1403_ = _tmp1402_;
		_tmp1404_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1399_, _tmp1401_, _tmp1403_);
		_tmp1405_ = _tmp1404_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1405_);
		_vala_code_node_unref0 (_tmp1405_);
		_tmp1407_ = vala_member_access_get_inner (self);
		_tmp1408_ = _tmp1407_;
		if (_tmp1408_ != NULL) {
			ValaDataType* _tmp1409_;
			ValaDataType* _tmp1410_;
			_tmp1409_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1410_ = _tmp1409_;
			_tmp1406_ = _tmp1410_ != NULL;
		} else {
			_tmp1406_ = FALSE;
		}
		if (_tmp1406_) {
			ValaDataType* _tmp1411_;
			ValaDataType* _tmp1412_;
			ValaExpression* _tmp1413_;
			ValaExpression* _tmp1414_;
			ValaDataType* _tmp1415_;
			ValaDataType* _tmp1416_;
			ValaDataType* _tmp1417_;
			ValaDataType* _tmp1418_;
			_tmp1411_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1412_ = _tmp1411_;
			_tmp1413_ = vala_member_access_get_inner (self);
			_tmp1414_ = _tmp1413_;
			_tmp1415_ = vala_expression_get_value_type (_tmp1414_);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = vala_data_type_get_actual_type (_tmp1412_, _tmp1416_, NULL, (ValaCodeNode*) self);
			_tmp1418_ = _tmp1417_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1418_);
			_vala_code_node_unref0 (_tmp1418_);
		} else {
			ValaDataType* _tmp1419_;
			ValaDataType* _tmp1420_;
			_tmp1419_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1420_ = _tmp1419_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1420_);
		}
		_tmp1421_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1422_ = _tmp1421_;
		if (VALA_IS_METHOD (_tmp1422_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1423_;
			ValaSymbol* _tmp1424_;
			ValaDataType* _tmp1425_;
			ValaDataType* _tmp1426_;
			gboolean _tmp1433_ = FALSE;
			_tmp1423_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1424_ = _tmp1423_;
			method = G_TYPE_CHECK_INSTANCE_CAST (_tmp1424_, VALA_TYPE_METHOD, ValaMethod);
			_tmp1425_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1426_ = _tmp1425_;
			if (_tmp1426_ != NULL) {
				ValaDataType* _tmp1427_;
				ValaDataType* _tmp1428_;
				ValaDataType* _tmp1429_;
				ValaDataType* _tmp1430_;
				gboolean _tmp1431_;
				gboolean _tmp1432_;
				_tmp1427_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1428_ = _tmp1427_;
				_tmp1429_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1430_ = _tmp1429_;
				_tmp1431_ = vala_data_type_get_value_owned (_tmp1430_);
				_tmp1432_ = _tmp1431_;
				vala_data_type_set_value_owned (_tmp1428_, _tmp1432_);
			}
			if (instance) {
				ValaMethod* _tmp1434_;
				ValaSymbol* _tmp1435_;
				ValaSymbol* _tmp1436_;
				_tmp1434_ = method;
				_tmp1435_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1434_);
				_tmp1436_ = _tmp1435_;
				_tmp1433_ = VALA_IS_TYPESYMBOL (_tmp1436_);
			} else {
				_tmp1433_ = FALSE;
			}
			if (_tmp1433_) {
				ValaExpression* _tmp1437_;
				ValaExpression* _tmp1438_;
				ValaMethod* _tmp1439_;
				ValaSymbol* _tmp1440_;
				ValaSymbol* _tmp1441_;
				ValaDataType* _tmp1442_;
				ValaDataType* _tmp1443_;
				ValaExpression* _tmp1444_;
				ValaExpression* _tmp1445_;
				ValaDataType* _tmp1446_;
				ValaDataType* _tmp1447_;
				ValaMethod* _tmp1448_;
				ValaParameter* _tmp1449_;
				ValaParameter* _tmp1450_;
				ValaDataType* _tmp1451_;
				ValaDataType* _tmp1452_;
				gboolean _tmp1453_;
				gboolean _tmp1454_;
				_tmp1437_ = vala_member_access_get_inner (self);
				_tmp1438_ = _tmp1437_;
				_tmp1439_ = method;
				_tmp1440_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1439_);
				_tmp1441_ = _tmp1440_;
				_tmp1442_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1441_);
				_tmp1443_ = _tmp1442_;
				vala_expression_set_target_type (_tmp1438_, _tmp1443_);
				_vala_code_node_unref0 (_tmp1443_);
				_tmp1444_ = vala_member_access_get_inner (self);
				_tmp1445_ = _tmp1444_;
				_tmp1446_ = vala_expression_get_target_type (_tmp1445_);
				_tmp1447_ = _tmp1446_;
				_tmp1448_ = method;
				_tmp1449_ = vala_method_get_this_parameter (_tmp1448_);
				_tmp1450_ = _tmp1449_;
				_tmp1451_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1450_);
				_tmp1452_ = _tmp1451_;
				_tmp1453_ = vala_data_type_get_value_owned (_tmp1452_);
				_tmp1454_ = _tmp1453_;
				vala_data_type_set_value_owned (_tmp1447_, _tmp1454_);
			}
		} else {
			gboolean _tmp1455_ = FALSE;
			gboolean _tmp1456_ = FALSE;
			ValaSymbol* _tmp1457_;
			ValaSymbol* _tmp1458_;
			_tmp1457_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1458_ = _tmp1457_;
			if (VALA_IS_PROPERTY (_tmp1458_)) {
				_tmp1456_ = instance;
			} else {
				_tmp1456_ = FALSE;
			}
			if (_tmp1456_) {
				ValaSymbol* _tmp1459_;
				ValaSymbol* _tmp1460_;
				ValaSymbol* _tmp1461_;
				ValaSymbol* _tmp1462_;
				_tmp1459_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1460_ = _tmp1459_;
				_tmp1461_ = vala_symbol_get_parent_symbol (_tmp1460_);
				_tmp1462_ = _tmp1461_;
				_tmp1455_ = _tmp1462_ != NULL;
			} else {
				_tmp1455_ = FALSE;
			}
			if (_tmp1455_) {
				ValaExpression* _tmp1463_;
				ValaExpression* _tmp1464_;
				ValaSymbol* _tmp1465_;
				ValaSymbol* _tmp1466_;
				ValaSymbol* _tmp1467_;
				ValaSymbol* _tmp1468_;
				ValaDataType* _tmp1469_;
				ValaDataType* _tmp1470_;
				_tmp1463_ = vala_member_access_get_inner (self);
				_tmp1464_ = _tmp1463_;
				_tmp1465_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1466_ = _tmp1465_;
				_tmp1467_ = vala_symbol_get_parent_symbol (_tmp1466_);
				_tmp1468_ = _tmp1467_;
				_tmp1469_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1468_);
				_tmp1470_ = _tmp1469_;
				vala_expression_set_target_type (_tmp1464_, _tmp1470_);
				_vala_code_node_unref0 (_tmp1470_);
			} else {
				gboolean _tmp1471_ = FALSE;
				gboolean _tmp1472_ = FALSE;
				gboolean _tmp1473_ = FALSE;
				ValaSymbol* _tmp1474_;
				ValaSymbol* _tmp1475_;
				_tmp1474_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1475_ = _tmp1474_;
				if (VALA_IS_FIELD (_tmp1475_)) {
					_tmp1473_ = TRUE;
				} else {
					ValaSymbol* _tmp1476_;
					ValaSymbol* _tmp1477_;
					_tmp1476_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1477_ = _tmp1476_;
					_tmp1473_ = VALA_IS_SIGNAL (_tmp1477_);
				}
				if (_tmp1473_) {
					_tmp1472_ = instance;
				} else {
					_tmp1472_ = FALSE;
				}
				if (_tmp1472_) {
					ValaSymbol* _tmp1478_;
					ValaSymbol* _tmp1479_;
					ValaSymbol* _tmp1480_;
					ValaSymbol* _tmp1481_;
					_tmp1478_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1479_ = _tmp1478_;
					_tmp1480_ = vala_symbol_get_parent_symbol (_tmp1479_);
					_tmp1481_ = _tmp1480_;
					_tmp1471_ = _tmp1481_ != NULL;
				} else {
					_tmp1471_ = FALSE;
				}
				if (_tmp1471_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1482_;
					ValaSymbol* _tmp1483_;
					ValaSymbol* _tmp1484_;
					ValaSymbol* _tmp1485_;
					ValaDataType* _tmp1486_;
					ValaExpression* _tmp1487_;
					ValaExpression* _tmp1488_;
					ValaDataType* _tmp1489_;
					ValaExpression* _tmp1490_;
					ValaExpression* _tmp1491_;
					ValaDataType* _tmp1492_;
					ValaDataType* _tmp1493_;
					ValaDataType* _tmp1494_;
					ValaDataType* _tmp1495_;
					_tmp1482_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1483_ = _tmp1482_;
					_tmp1484_ = vala_symbol_get_parent_symbol (_tmp1483_);
					_tmp1485_ = _tmp1484_;
					_tmp1486_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1485_);
					parent_type = _tmp1486_;
					_tmp1487_ = vala_member_access_get_inner (self);
					_tmp1488_ = _tmp1487_;
					_tmp1489_ = parent_type;
					_tmp1490_ = vala_member_access_get_inner (self);
					_tmp1491_ = _tmp1490_;
					_tmp1492_ = vala_expression_get_value_type (_tmp1491_);
					_tmp1493_ = _tmp1492_;
					_tmp1494_ = vala_data_type_get_actual_type (_tmp1489_, _tmp1493_, NULL, (ValaCodeNode*) self);
					_tmp1495_ = _tmp1494_;
					vala_expression_set_target_type (_tmp1488_, _tmp1495_);
					_vala_code_node_unref0 (_tmp1495_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
	}
	_tmp1496_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp1497_ = _tmp1496_;
	if (_tmp1497_ != NULL) {
		ValaDataType* _tmp1498_;
		ValaDataType* _tmp1499_;
		_tmp1498_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp1499_ = _tmp1498_;
		vala_code_node_check ((ValaCodeNode*) _tmp1499_, context);
	}
	_tmp1500_ = self->priv->_tainted_access;
	if (!_tmp1500_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1501_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1502_ = _tmp1501_;
	result = !_tmp1502_;
	return result;
}

static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}

void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp23_ = FALSE;
	ValaExpression* _tmp24_;
	ValaExpression* _tmp25_;
	ValaSymbol* _tmp26_;
	ValaSymbol* _tmp27_;
	gboolean this_access = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp35_ = FALSE;
	ValaExpression* _tmp36_;
	ValaExpression* _tmp37_;
	ValaDataType* _tmp38_;
	ValaDataType* _tmp39_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	gboolean _tmp52_ = FALSE;
	gboolean _tmp53_ = FALSE;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	gboolean _tmp63_ = FALSE;
	gboolean _tmp64_ = FALSE;
	gboolean _tmp83_ = FALSE;
	ValaSymbol* _tmp84_;
	ValaSymbol* _tmp85_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	if (!instance) {
		gboolean _tmp9_ = FALSE;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp11_ = _tmp10_;
		if (VALA_IS_METHOD (_tmp11_)) {
			ValaSymbol* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp12_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
			_tmp15_ = _tmp14_;
			_tmp9_ = _tmp15_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp9_ = FALSE;
		}
		instance = _tmp9_;
	}
	if (!instance) {
		gboolean _tmp16_ = FALSE;
		ValaSymbol* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp18_ = _tmp17_;
		if (VALA_IS_PROPERTY (_tmp18_)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaMemberBinding _tmp21_;
			ValaMemberBinding _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp22_ = _tmp21_;
			_tmp16_ = _tmp22_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp16_ = FALSE;
		}
		instance = _tmp16_;
	}
	_tmp24_ = vala_member_access_get_inner (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_symbol_reference (_tmp25_);
	_tmp27_ = _tmp26_;
	if (VALA_IS_PARAMETER (_tmp27_)) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaSymbol* _tmp30_;
		ValaSymbol* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp28_ = vala_member_access_get_inner (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_expression_get_symbol_reference (_tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_symbol_get_name (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp23_ = g_strcmp0 (_tmp33_, "this") == 0;
	} else {
		_tmp23_ = FALSE;
	}
	this_access = _tmp23_;
	_tmp36_ = vala_member_access_get_inner (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_expression_get_value_type (_tmp37_);
	_tmp39_ = _tmp38_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp39_)) {
		ValaExpression* _tmp40_;
		ValaExpression* _tmp41_;
		ValaDataType* _tmp42_;
		ValaDataType* _tmp43_;
		gboolean _tmp44_;
		gboolean _tmp45_;
		_tmp40_ = vala_member_access_get_inner (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_expression_get_value_type (_tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_data_type_get_nullable (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp35_ = !_tmp45_;
	} else {
		_tmp35_ = FALSE;
	}
	if (_tmp35_) {
		_tmp34_ = TRUE;
	} else {
		ValaExpression* _tmp46_;
		ValaExpression* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		_tmp46_ = vala_member_access_get_inner (self);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_get_value_type (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp34_ = VALA_IS_ARRAY_TYPE (_tmp49_);
	}
	struct_or_array = _tmp34_;
	_tmp50_ = vala_member_access_get_inner (self);
	_tmp51_ = _tmp50_;
	ma = VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL;
	_tmp54_ = ma;
	if (_tmp54_ == NULL) {
		_tmp53_ = struct_or_array;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		_tmp55_ = vala_member_access_get_inner (self);
		_tmp56_ = _tmp55_;
		_tmp52_ = VALA_IS_POINTER_INDIRECTION (_tmp56_);
	} else {
		_tmp52_ = FALSE;
	}
	if (_tmp52_) {
		ValaExpression* _tmp57_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp57_ = vala_member_access_get_inner (self);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp60_ = _tmp59_;
		ma = VALA_IS_MEMBER_ACCESS (_tmp60_) ? ((ValaMemberAccess*) _tmp60_) : NULL;
	}
	if (instance) {
		_tmp64_ = struct_or_array;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		gboolean _tmp65_ = FALSE;
		ValaSymbol* _tmp66_;
		ValaSymbol* _tmp67_;
		_tmp66_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp67_ = _tmp66_;
		if (VALA_IS_METHOD (_tmp67_)) {
			_tmp65_ = TRUE;
		} else {
			gboolean _tmp68_;
			gboolean _tmp69_;
			_tmp68_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp69_ = _tmp68_;
			_tmp65_ = _tmp69_;
		}
		_tmp63_ = _tmp65_;
	} else {
		_tmp63_ = FALSE;
	}
	if (_tmp63_) {
		gboolean _tmp70_ = FALSE;
		gboolean _tmp71_ = FALSE;
		ValaMemberAccess* _tmp72_;
		_tmp72_ = ma;
		if (_tmp72_ != NULL) {
			ValaMemberAccess* _tmp73_;
			ValaSymbol* _tmp74_;
			ValaSymbol* _tmp75_;
			_tmp73_ = ma;
			_tmp74_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp73_);
			_tmp75_ = _tmp74_;
			_tmp71_ = VALA_IS_VARIABLE (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		if (_tmp71_) {
			_tmp70_ = TRUE;
		} else {
			ValaExpression* _tmp76_;
			ValaExpression* _tmp77_;
			_tmp76_ = vala_member_access_get_inner (self);
			_tmp77_ = _tmp76_;
			_tmp70_ = VALA_IS_ELEMENT_ACCESS (_tmp77_);
		}
		_tmp62_ = _tmp70_;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		_tmp61_ = !this_access;
	} else {
		_tmp61_ = FALSE;
	}
	if (_tmp61_) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		ValaMemberAccess* _tmp80_;
		_tmp78_ = vala_member_access_get_inner (self);
		_tmp79_ = _tmp78_;
		vala_expression_set_lvalue (_tmp79_, TRUE);
		_tmp80_ = ma;
		if (_tmp80_ != NULL) {
			ValaMemberAccess* _tmp81_;
			ValaMemberAccess* _tmp82_;
			_tmp81_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp81_, TRUE);
			_tmp82_ = ma;
			vala_member_access_check_lvalue_access (_tmp82_);
		}
	}
	_tmp84_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp85_ = _tmp84_;
	if (VALA_IS_METHOD (_tmp85_)) {
		ValaSymbol* _tmp86_;
		ValaSymbol* _tmp87_;
		ValaAttribute* _tmp88_;
		_tmp86_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp83_ = _tmp88_ != NULL;
	} else {
		_tmp83_ = FALSE;
	}
	if (_tmp83_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp89_;
		ValaSymbol* _tmp90_;
		ValaSymbol* _tmp91_;
		ValaSymbol* _tmp92_;
		gboolean _tmp93_ = FALSE;
		gboolean _tmp94_ = FALSE;
		ValaClass* _tmp95_;
		_tmp89_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp90_ = _tmp89_;
		_tmp91_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
		_tmp92_ = _tmp91_;
		cl = VALA_IS_CLASS (_tmp92_) ? ((ValaClass*) _tmp92_) : NULL;
		_tmp95_ = cl;
		if (_tmp95_ != NULL) {
			ValaClass* _tmp96_;
			gboolean _tmp97_;
			gboolean _tmp98_;
			_tmp96_ = cl;
			_tmp97_ = vala_class_get_is_compact (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp94_ = _tmp98_;
		} else {
			_tmp94_ = FALSE;
		}
		if (_tmp94_) {
			ValaMemberAccess* _tmp99_;
			_tmp99_ = ma;
			_tmp93_ = _tmp99_ != NULL;
		} else {
			_tmp93_ = FALSE;
		}
		if (_tmp93_) {
			ValaMemberAccess* _tmp100_;
			ValaMemberAccess* _tmp101_;
			_tmp100_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp100_, TRUE);
			_tmp101_ = ma;
			vala_member_access_check_lvalue_access (_tmp101_);
		}
	}
}

static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}

static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaLocalVariable* _tmp8_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	local = VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL;
	_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp7_ = _tmp6_;
	param = VALA_IS_PARAMETER (_tmp7_) ? ((ValaParameter*) _tmp7_) : NULL;
	_tmp8_ = local;
	if (_tmp8_ != NULL) {
		ValaLocalVariable* _tmp9_;
		_tmp9_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp9_);
	} else {
		gboolean _tmp10_ = FALSE;
		ValaParameter* _tmp11_;
		_tmp11_ = param;
		if (_tmp11_ != NULL) {
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp10_ = _tmp14_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			ValaParameter* _tmp15_;
			_tmp15_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp15_);
		}
	}
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}

static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}

static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	result = _data1_->found;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}

static void
vala_member_access_class_init (ValaMemberAccessClass * klass,
                               gpointer klass_data)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMemberAccess_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_member_access_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}

static void
vala_member_access_instance_init (ValaMemberAccess * self,
                                  gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_member_access_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}

static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}

/**
 * Represents an access to a type member in the source code.
 */
static GType
vala_member_access_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
	GType vala_member_access_type_id;
	vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
	ValaMemberAccess_private_offset = g_type_add_instance_private (vala_member_access_type_id, sizeof (ValaMemberAccessPrivate));
	return vala_member_access_type_id;
}

GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		GType vala_member_access_type_id;
		vala_member_access_type_id = vala_member_access_get_type_once ();
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}

