#include "s3virgeglx.h"

/*
 * s3virgeClear
 * perform hardware accelerated clearing of the color and/or depth
 * buffer.  Software may still clear stencil buffers.
 * If all==GL_TRUE, clear whole buffer, else just clear region defined
 * by x,y,width,height
 */
GLbitfield s3virgeClear( GLcontext *ctx, GLbitfield mask, GLboolean all,
		     GLint x, GLint y, GLint width, GLint height ) 
{
	s3virgeMsg( 10, "s3virgeClear( %i, %i, %i, %i, %i )\n", mask, x, y, width, height );

	if (!s3virgeDB) {
		s3virgeMsg(1, "No DB\n");
		return mask;
	}

	/* if we are software rendering, we must clear the buffer ourself.
	 * mesa doesn't handle it in the fallback.
	 */
	if ( !s3virgeDB->backBufferBlock ) {
		return FallbackBufferClear( ctx, mask, all, x, y, width, height );
	}

	EnsureDMAOn();
		
	if (all == GL_TRUE) {
		x = 0;
		y = 0;
		width = s3virgeDB->width;
		height = s3virgeDB->height;
	}
	
	if ( y + height > s3virgeDB->height ) {
		height = s3virgeDB->height - y;
	}
	
	if ( x + width > s3virgeDB->width ) {
		width = s3virgeDB->width - x;
	}
	if ( x < 0 ) {
		width += x;
		x = 0;
	}
	if ( y < 0 ) {
		height += y;
		y = 0;
	}

	if ( x >= s3virgeDB->width || y >= s3virgeDB->height || width < 1 || height < 1 ) {
		return 0;
	}

	/* flip top to bottom */
	y = s3virgeDB->height - y - height;
	
	/* color buffer */
	if ( mask & GL_COLOR_BUFFER_BIT ) {
		int		r, g, b;
		int		color;
		int i, j, blocks;
		int new_w, dw;
		int cmd;
		unsigned char tmp;
		
		
		r = 255 * ctx->Color.ClearColor[0];
		g = 255 * ctx->Color.ClearColor[1];
		b = 255 * ctx->Color.ClearColor[2];
		
			/* hardware accelerated clear */

			color = S3VIRGEPACKCOLOR555(r,g,b,255);

			if (s3virgeglx.dmaDriver == 0) {
				WAITFIFOEMPTY(7);
				
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_L_R), (x << 16) | (width + x));
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_T_B), (y << 16) | (y + height));

				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 0);
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_BASE), (s3virgeDB->backBufferBlock->ofs));
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_SRC_STRIDE), (((s3virgeDB->pitch * 2) << 16) | 
										(s3virgeDB->pitch * 2)));
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT0), ~(0));
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT1), ~(0));
				WAITFIFOEMPTY(4);
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_PAT_FG_COLOR), color);
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_WIDTH_HEIGHT), ((width - 1) << 16) | height );
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_DEST_X_Y), (x << 16) | y);
				OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CMDSET), 0x16000122 | 0x4 | (0xF0 << 17));

			} else {
				DMAGETPTR(15);
				DMAOUTREG((S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 15);
				DMAOUT(0);
				DMAOUT(s3virgeDB->backBufferBlock->ofs);
				DMAOUT((x << 16) | (width + x));
				DMAOUT((y << 16) | (y + height));
				DMAOUT((((s3virgeDB->pitch * 2) << 16) | (s3virgeDB->pitch * 2)));
				DMAOUT((~(0)));
				DMAOUT((~(0)));
				DMAOUT(0);
				DMAOUT(color);
				DMAOUT(0);
				DMAOUT(0);
				DMAOUT(0x16000122 | 0x5 | (0xF0 << 17));
				DMAOUT(((width - 1) << 16) | height );
				DMAOUT(0);
				DMAOUT((x << 16) | y);
				DMAFINISH();
			}	
		mask &= ~GL_COLOR_BUFFER_BIT;
	}

	/* Let's white out our lightmap buffer, if it exists. */
//	if ( s3virgeglx.lightmapHack && s3virgeDB->lightmapBufferBlock ) {
	if (0) { 
		int i, j, blocks;
		int new_w, dw;
		int cmd;
		int color;
		unsigned char tmp;
		/* hardware accelerated clear */

		color = S3VIRGEPACKCOLOR555(255,255,255,255);

		if (s3virgeglx.dmaDriver == 0) {
			WAITFIFOEMPTY(8);
			
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_L_R), (x << 16) | (width + x));
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_T_B), (y << 16) | (y + height));
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 0);
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_BASE), (s3virgeDB->lightmapBufferBlock->ofs));
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_SRC_STRIDE), (((s3virgeDB->pitch * 2) << 16) | 
										(s3virgeDB->pitch * 2)));
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT0), ~(0));
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT1), ~(0));
			WAITFIFOEMPTY(4);
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_PAT_FG_COLOR), color);
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_WIDTH_HEIGHT), ((width - 1) << 16) | height );
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_DEST_X_Y), (x << 16) | y);
			OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CMDSET), 0x16000122 | 0x4 | (0xF0 << 17));
		} else {
			DMAGETPTR(15);
			DMAOUTREG((S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 15);
			DMAOUT(0);
			DMAOUT(s3virgeDB->lightmapBufferBlock->ofs);
			DMAOUT((x << 16) | (width + x));
			DMAOUT((y << 16) | (y + height));
			DMAOUT((((s3virgeDB->pitch * 2) << 16) | (s3virgeDB->pitch * 2)));
			DMAOUT(~(0));
			DMAOUT(~(0));
			DMAOUT(0);
			DMAOUT(color);
			DMAOUT(0);
			DMAOUT(0);
			DMAOUT(0x16000122 | 0x5 | (0xF0 << 17));
			DMAOUT(((width - 1) << 16) | height );
			DMAOUT(0);
			DMAOUT((x << 16) | y);
			DMAFINISH();
		}	
	}
	

	/* depth buffer */
	if ( mask & GL_DEPTH_BUFFER_BIT ) {
		if ( 1 /* !ctx->Depth.Mask */ ) {
			s3virgeUI32	zval;
			zval = (s3virgeUI32) (ctx->Depth.Clear * DEPTH_SCALE);

				if (s3virgeglx.dmaDriver == 0) {
				
					WAITFIFOEMPTY(7);
					
					/* hardware accelerated clear */
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_L_R), (x << 16) | (width + x));
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CLIP_T_B), (y << 16) | (y + height));
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 0);
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_BASE), (s3virgeDB->depthBufferBlock->ofs));
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_DEST_SRC_STRIDE), 
							(((s3virgeDB->pitch) * 2)) |
							((s3virgeDB->pitch) * 2 << 16));
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT0), ~(0));
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_MONO_PAT1), ~(0));
					WAITFIFOEMPTY(4);
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_PAT_FG_COLOR), zval);
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_WIDTH_HEIGHT), ((width - 1) << 16) | height );
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_BITBLT_DEST_X_Y), (x << 16) | y);
					OUTREG( (S3VIRGE_BITBLT_REG | S3VIRGE_CMDSET), 0x16000120 | 0x4 | (0xF0 << 17));
				} else {
					DMAGETPTR(15);
					DMAOUTREG((S3VIRGE_BITBLT_REG | S3VIRGE_SRC_BASE), 15);
					DMAOUT(0);
					DMAOUT(s3virgeDB->depthBufferBlock->ofs);
					DMAOUT((x << 16) | (width + x));
					DMAOUT((y << 16) | (y + height));
					DMAOUT((((s3virgeDB->pitch * 2) << 16) | (s3virgeDB->pitch * 2)));
					DMAOUT(~(0));
					DMAOUT(~(0));
					DMAOUT(0);
					DMAOUT(zval);
					DMAOUT(0);
					DMAOUT(0);
					DMAOUT(0x16000122 | 0x5 | (0xF0 << 17));
					DMAOUT(((width - 1) << 16) | height );
					DMAOUT(0);
					DMAOUT((x << 16) | y);
					DMAFINISH();
				}
		}			
		mask &= ~GL_DEPTH_BUFFER_BIT;
	}
	
	s3virgeMsg(10, "Clear done.\n");
	return mask;
	
}


