/*
 * GLX Hardware Device Driver for S3 Savage3D and probably Savage/MX and
 * Savage/IX
 * Copyright (C) 2000 Dominik Behr
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Based on S3 Virge driver by Jim Duchek <jimduchek@ou.edu>
 *
 * Dominik Behr <behr@promail.pl>
 * thanks to Raja Koduri and Tim Roberts   
 */

#include "s3savglx.h"
#include "glx_symbols.h"
#include "hw_buffer.h"

extern char aS3SavRenderer[256];
/*******************************************************************************

*******************************************************************************/
const GLubyte *
s3savDDGetString(GLcontext *ctx, 
                 GLenum name )
{
 switch ( name ) {
  case GL_VENDOR:
   return "Utah GLX";
  case GL_RENDERER:
   return aS3SavRenderer;
  default:
   return 0;
 }
}


/*******************************************************************************

*******************************************************************************/
void 
s3savDDExtensionsInit(GLcontext *ctx)
{
 gl_extensions_disable( ctx, "GL_EXT_compiled_vertex_array" );
 gl_extensions_disable( ctx, "GL_EXT_shared_texture_palette");
 gl_extensions_disable( ctx, "GL_EXT_paletted_texture");
    

 gl_extensions_disable( ctx, "GL_EXT_multitexture" );
 gl_extensions_disable( ctx, "GL_SGIS_multitexture" );
 gl_extensions_disable( ctx, "GL_ARB_multitexture" );
 gl_extensions_disable( ctx, "GL_EXT_point_parameters" );
 gl_extensions_disable( ctx, "ARB_imaging" );
 gl_extensions_disable( ctx, "GL_EXT_blend_minmax" );
 gl_extensions_disable( ctx, "GL_EXT_blend_logic_op" );
 gl_extensions_disable( ctx, "GL_EXT_blend_subtract" );
 gl_extensions_disable( ctx, "GL_INGR_blend_func_separate" );
}


/*******************************************************************************

*******************************************************************************/
static GLint 
s3savGetParameteri(const GLcontext *ctx, 
                   GLint param)
{
 switch (param) {
  case DD_HAVE_HARDWARE_FOG:
   return 1; 
  default:
   return 0; 
 } // end of switch param
}

/*******************************************************************************
 wait for hardware to finish rendering
*******************************************************************************/
void
s3savFinish(void)
{
 hwUI32 uEvent;
 uEvent = s3savInsertEvent();
 s3savDMAFlush();
 s3savWaitEvent(uEvent);
}

/*******************************************************************************

*******************************************************************************/
void 
s3sav_setup_DD_pointers(GLcontext *ctx)
{
 /* let mesa setup all for software rendering */
 xsmesa_setup_DD_pointers(ctx);

 s3savDDInitStatePointers(ctx);

 ctx->Driver.GetString = s3savDDGetString;
 ctx->Driver.UpdateState = s3savDDUpdateState;
 ctx->Driver.Clear = s3savClear;
 ctx->Driver.GetParameteri = s3savGetParameteri;

 ctx->Driver.TriangleCaps = 0;
    	/* ( DD_TRI_OFFSET ); */
    	 /* FIXME: not correct! */
// FIXME	
 if (stS3Sav.pDrawBuffer->stZBuffer.p)
    SetDriverBufferFunctions(ctx, 
                             s3savFinish,
     		          stS3Sav.pDrawBuffer->stBackBuffer.p,
                          stS3Sav.pDrawBuffer->stBackBuffer.nStride / stS3Sav.pDrawBuffer->stBackBuffer.nBPP,
                          stS3Sav.pDrawBuffer->stBackBuffer.nHeight,
                          CB_16BIT,
		          stS3Sav.pDrawBuffer->stZBuffer.p, 
		          stS3Sav.pDrawBuffer->stZBuffer.nStride / stS3Sav.pDrawBuffer->stZBuffer.nBPP,
                          stS3Sav.pDrawBuffer->stZBuffer.nHeight,
                          DB_16BIT );
 else
    SetDriverBufferFunctions(ctx, 
                             s3savFinish,
     		             stS3Sav.pDrawBuffer->stBackBuffer.p,
                             stS3Sav.pDrawBuffer->stBackBuffer.nStride / stS3Sav.pDrawBuffer->stBackBuffer.nBPP,
                             stS3Sav.pDrawBuffer->stBackBuffer.nHeight,
                             CB_16BIT,
		             0, 
		             0,
                             0,
                             DB_16BIT );                         
                          
 /* Also do the normal GL state-change checks. */
 s3savDDUpdateState(ctx);
}

