#!/usr/local/bin/perl
# edit_auth.cgi
# Edit or create an authorized key

require './ssh-lib.pl';
&ReadParse();
if ($in{'new'}) {
	&ui_print_header(undef, $text{'auth_create'}, "");
	$msg = $text{'auth_desc1'};
	}
else {
	&ui_print_header(undef, $text{'auth_edit'}, "");
	@auths = &list_auths();
	$auth = $auths[$in{'idx'}];
	}

# Show main key details
print "$msg<p>\n" if ($msg);
print "<form action=save_auth.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'auth_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'auth_name'}</b></td>\n";
printf "<td colspan=3><input name=name size=40 value='%s'></td> </tr>\n",
	$auth->{'name'};

print "<tr> <td><b>$text{'auth_bits'}</b></td>\n";
printf "<td><input name=bits size=5 value='%s'></td>\n",
	$auth->{'bits'};

print "<td><b>$text{'auth_exp'}</b></td>\n";
printf "<td><input name=exp size=5 value='%s'></td> </tr>\n",
	$auth->{'exp'};

print "<tr> <td valign=top><b>$text{'auth_key'}</b></td>\n";
print "<td colspan=3><textarea name=key rows=10 cols=50 wrap=on>$auth->{'key'}",
      "</textarea></td> </tr>\n";

# Show key options
&parse_options($auth->{'opts'}, \%opts);
print "<tr> <td colspan=4><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'auth_from'}</b></td> <td colspan=3>\n";
printf "<input type=radio name=from_def value=1 %s> %s\n",
	$opts{'from'} ? '' : 'checked', $text{'auth_from_all'};
printf "<input type=radio name=from_def value=0 %s> %s<br>\n",
	$opts{'from'} ? 'checked' : '', $text{'auth_from_sel'};
print "<textarea name=from rows=3 cols=50 wrap=on>",
	join(" ", split(/,/, $opts{'from'}->[0])),"</textarea></td> </tr>\n";

print "<tr> <td><b>$text{'auth_command'}</b></td>\n";
printf "<td colspan=3><input name=command size=50 value='%s'></td> </tr>\n",
	$opts{'command'}->[0];

print "<tr> <td><b>$text{'auth_noport'}</b></td>\n";
printf "<td><input type=radio name=noport value=0 %s> %s\n",
	$opts{'no-port-forwarding'} ? '' : 'checked', $text{'yes'};
printf "<input type=radio name=noport value=1 %s> %s</td>\n",
	$opts{'no-port-forwarding'} ? 'checked' : '', $text{'no'};

print "<td><b>$text{'auth_nox11'}</b></td>\n";
printf "<td><input type=radio name=nox11 value=0 %s> %s\n",
	$opts{'no-x11-forwarding'} ? '' : 'checked', $text{'yes'};
printf "<input type=radio name=nox11 value=1 %s> %s</td> </tr>\n",
	$opts{'no-x11-forwarding'} ? 'checked' : '', $text{'no'};

print "<tr> <td><b>$text{'auth_noagent'}</b></td>\n";
printf "<td><input type=radio name=noagent value=0 %s> %s\n",
	$opts{'no-agent-forwarding'} ? '' : 'checked', $text{'yes'};
printf "<input type=radio name=noagent value=1 %s> %s</td>\n",
	$opts{'no-agent-forwarding'} ? 'checked' : '', $text{'no'};

print "<td><b>$text{'auth_nopty'}</b></td>\n";
printf "<td><input type=radio name=nopty value=0 %s> %s\n",
	$opts{'no-pty'} ? '' : 'checked', $text{'yes'};
printf "<input type=radio name=nopty value=1 %s> %s</td> </tr>\n",
	$opts{'no-pty'} ? 'checked' : '', $text{'no'};

print "</table></td></tr></table>\n";
print "<table width=100%><tr>\n";
if ($in{'new'}) {
	print "<td><input type=submit value='$text{'create'}'></td>\n";
	}
else {
	print "<td><input type=submit value='$text{'save'}'></td>\n";
	print "<td align=right><input type=submit name=delete ",
	      "value='$text{'delete'}'></td>\n";
	}
print "</tr></table></form>\n";

&ui_print_footer("list_auths.cgi", $text{'auths_return'},
	"", $text{'index_return'});


