/* File:        ops.c
 * Program:     unhtml
 * Written by:	Kevin Swan, 013639s@dragon.acadiau.ca
 * Completed: 	February 3, 1998
 * Version: 	2.3
 */



#include "ops.h"



/*
 * Checks if a given tag is an HTML script opening tag, <SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script opening tag, 0 otherwise.
 */
int isScriptOpeningTag (char *tag) {
  int i = 0;

  while (tag[i] != '\0') {
    switch (i) {
      case 0:  if (tag[i] != '<')
                 return 0;
               break;
      case 1:  if ((tag[i] != 's') && (tag[i] != 'S'))
                 return 0;
               break;
      case 2:  if ((tag[i] != 'c') && (tag[i] != 'C'))
                 return 0;
               break;
      case 3:  if ((tag[i] != 'r') && (tag[i] != 'R'))
                 return 0;
               break;
      case 4:  if ((tag[i] != 'i') && (tag[i] != 'I'))
                 return 0;
               break;
      case 5:  if ((tag[i] != 'p') && (tag[i] != 'P'))
                 return 0;
               break;
      case 6:  if ((tag[i] != 't') && (tag[i] != 'T'))
                 return 0;
               break;
      default: return 1;
    } /* switch */
    i++;
  } /* while */
  return 0;
}



/*
 * Checks if a given tag is an HTML script closing tag, </SCRIPT>.
 * It checks in a case-insensitive manner.
 *
 *   Given:   a string that is an HTML tag.
 *   Return:  1 if that tag is a script closing tag, 0 otherwise.
 */
int isScriptClosingTag (char *tag) {
  int i = 0;

  while (tag[i] != '\0') {
    switch (i) {
      case 0:  if (tag[i] != '<')
                 return 0;
               break;
      case 1:  if (tag[i] != '/')
                 return 0;
               break;
      case 2:  if ((tag[i] != 's') && (tag[i] != 'S'))
                 return 0;
               break;
      case 3:  if ((tag[i] != 'c') && (tag[i] != 'C'))
                 return 0;
               break;
      case 4:  if ((tag[i] != 'r') && (tag[i] != 'R'))
                 return 0;
               break;
      case 5:  if ((tag[i] != 'i') && (tag[i] != 'I'))
                 return 0;
               break;
      case 6:  if ((tag[i] != 'p') && (tag[i] != 'P'))
                 return 0;
               break;
      case 7:  if ((tag[i] != 't') && (tag[i] != 'T'))
                 return 0;
               break;
      default: return 1;
    } /* switch */
    i++;
  } /* while */
  return 0;
}
