/* ========================================================================== */
/* === UMF_dump ============================================================= */
/* ========================================================================== */

/* -------------------------------------------------------------------------- */
/* UMFPACK Version 3.2 (Jan. 1, 2002), Copyright (c) 2002 by Timothy A.       */
/* Davis, University of Florida, davis@cise.ufl.edu.  All Rights Reserved.    */
/* See README, umfpack.h, or type "umfpack_details" in Matlab for License.    */
/* -------------------------------------------------------------------------- */

/* Debugging definitions. */

#include <assert.h>

#ifndef NDEBUG

GLOBAL void UMF_dump_dense
(
    double *Fx,
    Int dim,
    Int m,
    Int n
) ;

GLOBAL void UMF_dump_element
(
    NumericType *Numeric,
    WorkType *Work,
    Int e
) ;

GLOBAL void UMF_dump_rowcol
(
    Int dump_which,
    NumericType *Numeric,
    WorkType *Work,
    Int dump_index,
    Int check_degree
) ;

GLOBAL void UMF_dump_matrix
(
    NumericType *Numeric,
    WorkType *Work,
    Int check_degree
) ;

GLOBAL void UMF_dump_current_front
(
    NumericType *Numeric,
    WorkType *Work,
    Int check
) ;

GLOBAL void UMF_dump_lu
(
    NumericType *Numeric
) ;

GLOBAL void UMF_dump_memory
(
    NumericType *Numeric
) ;

GLOBAL void UMF_dump_packed_memory
(
    NumericType *Numeric,
    WorkType *Work
) ;

GLOBAL void UMF_dump_col_matrix
(
    const double Ax [ ],
    const Int Ai [ ],
    const Int Ap [ ],
    Int n,
    Int nz
) ;

GLOBAL void UMF_dump_chain
(
    Int frontid,
    Int Front_parent [ ],
    Int Front_npivots [ ],
    Int Front_nrows [ ],
    Int Front_ncols [ ],
    Int nfr
) ;

GLOBAL void UMF_dump_start
(
    void
) ;


#define XTRUE(i,n) ((double) i / (double) (n) + 1)

#define UMF_DBMAX 50000
GLOBAL extern Int UMF_debug ;
GLOBAL extern Int UMF_nbug ;
GLOBAL extern Int UMF_fbug ;
GLOBAL extern Int UMF_allocfail ;
GLOBAL extern double UMF_DBrhs [UMF_DBMAX+1], UMF_gprob ;

#define DEBUGk(k,params) { if (UMF_debug >= (k)) { PRINTF (params) ; } }

#define DEBUG0(params) DEBUGk (0, params)
#define DEBUG1(params) DEBUGk (1, params)
#define DEBUG2(params) DEBUGk (2, params)
#define DEBUG3(params) DEBUGk (3, params)
#define DEBUG4(params) DEBUGk (4, params)
#define DEBUG5(params) DEBUGk (5, params)
#define DEBUG6(params) DEBUGk (6, params)
#define DEBUG7(params) DEBUGk (7, params)
#define DEBUG8(params) DEBUGk (8, params)
#define DEBUG9(params) DEBUGk (9, params)

#ifdef MATLAB_MEX_FILE
#define ASSERT(expression) (mxAssert ((expression), ""))
#else
#ifdef MATHWORKS
#define ASSERT(expression) (utAssert (expression))
#else
#define ASSERT(expression) (assert (expression))
#endif
#endif /* MATLAB_MEX_FILE */

#else

/* ========================================================================== */
/* === No debugging ========================================================= */
/* ========================================================================== */

/* turn off all debugging macros */

#define DEBUGk(k,params)

#define DEBUG0(params)
#define DEBUG1(params)
#define DEBUG2(params)
#define DEBUG3(params)
#define DEBUG4(params)
#define DEBUG5(params)
#define DEBUG6(params)
#define DEBUG7(params)
#define DEBUG8(params)
#define DEBUG9(params)

#define ASSERT(expression)

#endif /* NDEBUG */

