static const char	uget_license[] =
{
" Copyright (C) 2005-2010 by Raymond Huang"								"\n"
" plushuang at users.sourceforge.net"									"\n"
																		"\n"
"This library is free software; you can redistribute it and/or"			"\n"
"modify it under the terms of the GNU Lesser General Public"			"\n"
"License as published by the Free Software Foundation; either"			"\n"
"version 2.1 of the License, or (at your option) any later version."	"\n"
																		"\n"
"This library is distributed in the hope that it will be useful,"		"\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of"		"\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU"		"\n"
"Lesser General Public License for more details."						"\n"
																		"\n"
"You should have received a copy of the GNU Lesser General Public"		"\n"
"License along with this library; if not, write to the Free Software"	"\n"
"Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA"	"\n"
																		"\n"
"---------"																"\n"
																		"\n"
"In addition, as a special exception, the copyright holders give"		"\n"
"permission to link the code of portions of this program with the"		"\n"
"OpenSSL library under certain conditions as described in each"			"\n"
"individual source file, and distribute linked combinations"			"\n"
"including the two."													"\n"
"You must obey the GNU Lesser General Public License in all respects"	"\n"
"for all of the code used other than OpenSSL.  If you modify"			"\n"
"file(s) with this exception, you may extend this exception to your"	"\n"
"version of the file(s), but you are not obligated to do so.  If you"	"\n"
"do not wish to do so, delete this exception statement from your"		"\n"
"version.  If you delete this exception statement from all source"		"\n"
"files in the program, then also delete it here."						"\n"	"\0"
};

#include <gdk/gdkkeysyms.h>    // for GDK_key...

#include <uget.h>
#include <ug_plugin.h>
#include <ug_item.h>
#include <ug_utils.h>
#include <ug_data_app.h>
#include <ug_download_dialog.h>
#include <ug_category_dialog.h>
#include <ug_settings_dialog.h>

#include <glib/gi18n.h>


static	const	gchar*	uget_authors[] = { "Raymond Huang  (\xE9\xBB\x83\xE6\xAD\xA3\xE9\x9B\x84)", NULL };
static	const	gchar*	uget_artists[] = { "Logo designer: saf1 (linuxac.org)", "Logo improver: Skeleton_Eel (linuxac.org)", NULL };
static	const	gchar*	uget_version   = "1.5.0.2 (stable)";	// PACKAGE_VERSION "(testing)"
static	const	gchar*	uget_comments  = N_("Download Manager");
static	const	gchar*	uget_copyright = "Copyright © 2005-2010 Raymond Huang";
static	const	gchar*	translator_credits = N_("translator-credits");

static void	on_download_dialog_response (GtkDialog *dialog, gint response_id, UgDownloadDialog* ddialog);

// signal handler for window, treeview
void	uget_on_category_selection_changed (GtkTreeSelection* selection, Uget* app)
{
	GtkTreeSelection*	other_selection;
	GtkTreeModel*	model;
	GtkTreeIter		iter;
	UgCategory*		category;
	gulong*			category_signal;
	GtkTreeView*		this_time;
	static GtkTreeView*	last_time = NULL;

	// switch  app->total_list_view  and  app->category_tree_view  in left side
	this_time = gtk_tree_selection_get_tree_view (selection);
	if (last_time != this_time) {
		last_time =  this_time;
		if (this_time == app->category_tree_view) {
			other_selection = gtk_tree_view_get_selection (app->total_list_view);
			category_signal = &app->total_list_signal;
		}
		else {
			other_selection = gtk_tree_view_get_selection (app->category_tree_view);
			category_signal = &app->category_tree_signal;
		}
		g_signal_handler_disconnect (other_selection, *category_signal);
		gtk_tree_selection_unselect_all (other_selection);
		*category_signal = g_signal_connect (other_selection, "changed", G_CALLBACK (uget_on_category_selection_changed), app);
	}

	// switch current download view in right side
	if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
		gtk_tree_model_get (model, &iter, 0, &category, -1);
		if (category == app->current)
			return;
		uget_switch_category (app, category);
	}
	else {
		uget_switch_category (app, NULL);
		gtk_paned_pack1 (app->vpaned, app->label_no_selected, TRUE, FALSE);
	}

	// update widget status...
	uget_update_menu_view (app);
	uget_update_menu_move_to (app, FALSE);
	uget_update_summary (app);
	uget_update_statusbar (app);
	uget_update_category_sensitive (app);
}

void	uget_on_queue_selection_changed (GtkTreeSelection* selection, Uget* app)
{
	uget_update_summary (app);
	uget_update_statusbar (app);
	uget_update_download_sensitive (app);
}

static void	uget_on_keep_above_window_show (GtkWindow *window, gpointer  user_data)
{
	gtk_window_present (window);
	gtk_window_set_keep_above (window, FALSE);
}

// button-press-event
gboolean	uget_on_right_button_press (GtkTreeView* treeview, GdkEventButton* event, Uget* app)
{
	GtkTreeSelection*	selection;
	GtkTreePath*		path;
	GtkMenu*			menu;
	gboolean			is_selected;

	// right button press
//	if (event->type != GDK_BUTTON_PRESS)
//		return FALSE;
	if (event->button != 3)		// right mouse button
		return FALSE;
	// popup a menu
	if (treeview == app->category_tree_view || treeview == app->total_list_view)
		menu = (GtkMenu*) app->menubar.category.menu;
	else if (treeview == app->summary_view)
		menu = app->summary_menu;
	else
		menu = (GtkMenu*) app->menubar.download.menu;
	gtk_menu_popup (menu, NULL, NULL, NULL, NULL, event->button, gtk_get_current_event_time());

	if (gtk_tree_view_get_path_at_pos (treeview, (gint)event->x, (gint)event->y, &path, NULL, NULL, NULL)) {
		selection = gtk_tree_view_get_selection (treeview);
		is_selected = gtk_tree_selection_path_is_selected (selection, path);
		gtk_tree_path_free (path);
		if (is_selected)
			return TRUE;
	}
	return FALSE;
}

// key-press-event
static void menu_position_func (GtkMenu*	menu,
                                gint*		x,
                                gint*		y,
                                gboolean*	push_in,
                                gpointer	user_data)
{
	GtkRequisition	menu_requisition;
	GtkWidget*		widget;
	gint			max_x, max_y;

	widget = user_data;
	gdk_window_get_origin (widget->window, x, y);
	gtk_widget_size_request (GTK_WIDGET (menu), &menu_requisition);

	if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL)
		*x += widget->allocation.width - widget->allocation.width / 3;
	else
		*x += widget->allocation.width / 3;
	*y += widget->allocation.height / 3;

//	if (gtk_widget_get_direction (widget) == GTK_TEXT_DIR_RTL)
//		*x += widget->allocation.width - menu_requisition.width;
//	else
//		*x += widget->allocation.x;
//	*y += widget->allocation.y + widget->allocation.height;

	// Make sure we are on the screen.
	max_x = MAX (0, gdk_screen_width ()  - menu_requisition.width);
	max_y = MAX (0, gdk_screen_height () - menu_requisition.height);

	*x = CLAMP (*x, 0, max_x);
	*y = CLAMP (*y, 0, max_y);
}

gboolean	uget_on_window_key_press_event (GtkWidget *widget, GdkEventKey *event, Uget* app)
{
	GtkTreeView*	focus;
	GtkMenu*		menu;

//	g_print ("key-press : 0x%x\n", event->keyval);
	if (event->keyval != GDK_Menu)
		return FALSE;

	focus = (GtkTreeView*) gtk_window_get_focus (app->window);
	if (focus == app->total_list_view) {
		widget = (GtkWidget*) app->total_list_view;
		menu = (GtkMenu*) app->menubar.category.menu;
	}
	else if (focus == app->category_tree_view) {
		widget = (GtkWidget*) app->category_tree_view;
		menu = (GtkMenu*) app->menubar.category.menu;
	}
	else if (focus == app->summary_view) {
		widget = (GtkWidget*) app->summary_view;
		menu = app->summary_menu;
	}
	else if (app->current && focus == app->current->download_view) {
		widget = (GtkWidget*) app->current->download_view;
		menu = (GtkMenu*) app->menubar.download.menu;
	}
	else
		return FALSE;

	gtk_menu_popup (menu, NULL, NULL, menu_position_func, widget, 0, gtk_get_current_event_time());
	return TRUE;
}

gboolean	uget_on_download_key_press_event  (GtkWidget *widget, GdkEventKey *event, Uget* app)
{
	if (event->keyval==GDK_Delete && app->current) {
		uget_on_delete_download (widget, app);
		return TRUE;
	}
	return FALSE;
}

// ----------------------------------------------
// functions for uget_on_window_close()
static void	uget_window_close (Uget* app)
{
	switch (app->window_close_setting)
	{
	default:
	case 1:		// Minimize to tray.
		gtk_window_iconify (app->window);
		gtk_widget_hide ((GtkWidget*) app->window);
		break;

	case 2:		// Exit Uget.
		uget_quit (app);
		break;
	}
}

static void uget_on_close_confirmation_response (GtkDialog* dialog, gint response, Uget* app)
{
	gtk_widget_destroy ((GtkWidget*) dialog);
	app->dialog_close_confirmation = NULL;
	if (response == GTK_RESPONSE_YES)
		uget_window_close (app);
}

static void uget_on_close_setting_toggled (GtkToggleButton* button, Uget* app)
{
	if (gtk_toggle_button_get_active (button) == FALSE)
		app->window_close_setting = 1;		// Minimize to tray.
	else
		app->window_close_setting = 2;		// Exit Uget.
}

static void uget_on_close_confirmation_toggled (GtkToggleButton* button, Uget* app)
{
	if (gtk_toggle_button_get_active (button) == FALSE)
		app->window_close_confirmation = TRUE;
	else
		app->window_close_confirmation = FALSE;
}

gboolean	uget_on_window_close (Uget* app)
{
	GtkWidget*	dialog;
	GtkWidget*	button;
	GtkBox*		hbox;
	GtkBox*		vbox;
	gchar*		title;

	// show previous message dialog
	if (app->dialog_close_confirmation) {
		gtk_window_present (GTK_WINDOW (app->dialog_close_confirmation));
		return TRUE;	 // for "delete-event"
	}
	if (app->window_close_confirmation == FALSE) {
		uget_window_close (app);
		return TRUE;
	}
	if (app->window_close_setting == 0) {			// Let user decide.
		app->window_close_setting = 1;				// Minimize to tray.
		app->window_close_confirmation = FALSE;		// Remember this action.
	}

	// create confirmation dialog
	title = g_strconcat ("Uget - ", _("Really Quit?"), NULL);
	dialog = gtk_dialog_new_with_buttons (title, app->window,
	              (GTK_DIALOG_NO_SEPARATOR | GTK_DIALOG_DESTROY_WITH_PARENT),
	               GTK_STOCK_NO,     GTK_RESPONSE_NO,
	               GTK_STOCK_YES,    GTK_RESPONSE_YES,
	               NULL);
	g_free (title);
	gtk_container_set_border_width (GTK_CONTAINER (dialog), 4);
	vbox = (GtkBox*) GTK_DIALOG (dialog)->vbox;
	// image and label
	hbox = (GtkBox*) gtk_hbox_new (FALSE, 2);
	gtk_box_pack_start (hbox, gtk_image_new_from_stock (GTK_STOCK_DIALOG_QUESTION, GTK_ICON_SIZE_DIALOG),
	                    FALSE, FALSE, 8);
	gtk_box_pack_start (hbox, gtk_label_new (_("Are you sure you want to quit?")),
	                    FALSE, FALSE, 4);
	gtk_box_pack_start (vbox, GTK_WIDGET (hbox), FALSE, FALSE, 6);
	// check button
	hbox = (GtkBox*) gtk_hbox_new (FALSE, 2);
	button = gtk_check_button_new_with_label (_("Remember this action"));
	if (app->window_close_confirmation == FALSE)
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), TRUE);
	else
		gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (button), FALSE);
	gtk_box_pack_end (hbox, button, TRUE, TRUE, 12);
	gtk_box_pack_end (vbox, GTK_WIDGET (hbox), FALSE, FALSE, 6);
	app->dialog_close_confirmation = dialog;
	g_signal_connect (button, "toggled", G_CALLBACK (uget_on_close_confirmation_toggled), app);
	// radio button
	button = gtk_radio_button_new_with_label_from_widget (NULL, _("Minimize to tray"));
	gtk_box_pack_start (vbox, button, FALSE, FALSE, 1);
	if (app->window_close_setting == 1)
		gtk_toggle_button_set_active ((GtkToggleButton*)button, TRUE);
	button = gtk_radio_button_new_with_label_from_widget ((GtkRadioButton*)button, _("Exit Uget"));
	if (app->window_close_setting == 2)
		gtk_toggle_button_set_active ((GtkToggleButton*)button, TRUE);
	gtk_box_pack_start (vbox, button, FALSE, FALSE, 1);
	g_signal_connect (button, "toggled", G_CALLBACK (uget_on_close_setting_toggled), app);

	if (GTK_WIDGET_VISIBLE (app->window) == FALSE) {
		gtk_window_deiconify (app->window);
		gtk_widget_show ((GtkWidget*) app->window);
	}
	g_signal_connect (dialog, "response", G_CALLBACK (uget_on_close_confirmation_response), app);
	gtk_widget_show_all ((GtkWidget*) dialog);
	return TRUE;	// for "delete-event"
}
// functions for uget_on_window_close()
// ----------------------------------------------

static void uget_on_clipboard_text_received (GtkClipboard*	clipboard,
                                             const gchar*	text,
                                             gpointer		user_data)
{
	UgDownloadDialog*	dialog;
	Uget*		app = user_data;
	gchar*		string;
	GList*		list;
	UgItem*			item;
	GtkListStore*	item_list;
	GtkTreeIter		iter;

	if (text == NULL) {
		g_free (app->clipboard_text);
		app->clipboard_text = NULL;
		goto exit;
	}

	string = (app->clipboard_text) ? app->clipboard_text : "";
	if (g_ascii_strcasecmp (text, string) == 0)
		goto exit;
	g_free (app->clipboard_text);
	app->clipboard_text = g_strdup (text);

	list = uget_regex_get_url (app, text, -1);
	if (list == NULL)
		goto exit;
	if (list->next == NULL) {
		// only 1 url matched
		string = g_strconcat ("Uget - ", _("New from Clipboard"), " (", _("only one matched"), ")", NULL);
//		dialog = ug_download_dialog_new (string, app->window);
		dialog = ug_download_dialog_new (string, NULL);
		g_free (string);
		gtk_entry_set_text ((GtkEntry*) dialog->download.url_entry, list->data);
//		g_list_foreach (list, (GFunc) g_free, NULL);
		g_free (list->data);
	}
	else {
		string = g_strconcat ("Uget - ", _("New from Clipboard"), NULL);
//		dialog = ug_download_dialog_new_selector (string, app->window);
		dialog = ug_download_dialog_new_selector (string, NULL);
		g_free (string);
		ug_selector_hide_href (&dialog->selector);
		item_list = ug_selector_add_page (&dialog->selector, _("Clipboard"));
		// clear iter for ug_item_store_realloc_next()
		memset (&iter, 0, sizeof (GtkTreeIter));
		for (list = g_list_last (list);  list;  list = list->prev) {
			item = ug_item_store_realloc_next (item_list, &iter);
			g_free (item->value);
			item->value = list->data;
			item->mark = TRUE;
		}
	}
	g_list_free (list);
	ug_download_dialog_set_category_list (dialog, app->category_list);
	ug_download_dialog_select_category (dialog, app->current->queuing);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_dialog_response), dialog);
	g_signal_connect (dialog->self, "show", G_CALLBACK (uget_on_keep_above_window_show), NULL);
	// Make sure dilaog will show on top first time.
	// uget_on_keep_above_window_show ()  will set keep_above = FALSE
	gtk_window_set_keep_above ((GtkWindow*) dialog->self, TRUE);
	gtk_widget_show ((GtkWidget*) dialog->self);

exit:
	app->clipboard_processing = FALSE;	// uget_on_timer() set TRUE
}

gboolean	uget_on_timer (Uget* app)
{
	static gint		counts = 0;
	static gint		running_count = 0;
	guint			running_total;
	UgCategory*		category;
	GtkTreeModel*	model;
	GtkTreeIter		iter;
	gboolean		valid;
	gboolean		category_changed;
	gchar*			string;

	// check clipboard every 2 counts
	if ((counts & 1) == 0) {
		if (app->clipboard_monitor && app->clipboard_processing == FALSE) {
			// clipboard_text_received_callback() set FALSE
			app->clipboard_processing = TRUE;
			gtk_clipboard_request_text (app->clipboard, uget_on_clipboard_text_received, app);
		}
	}

	// refresh category tree and total_list
	running_total = 0;
	category_changed = FALSE;
	model = GTK_TREE_MODEL (app->category_list);
	valid = gtk_tree_model_get_iter_first (model, &iter);
	while (valid) {
		gtk_tree_model_get (model, &iter, 0, &category, -1);
		valid = gtk_tree_model_iter_next (model, &iter);
		if (ug_category_queue_refresh (category, (app->launch_app) ? app->launch_app_regex : NULL))
			category_changed = TRUE;
		if (ug_category_queue_run (category))
			category_changed = TRUE;
		if (ug_category_clear_excess (category->completed))
			category_changed = TRUE;
		if (ug_category_clear_excess (category->recycled))
			category_changed = TRUE;
		running_total += category->running_count;
	}
	// refresh category
	if (category_changed) {
		gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
		gtk_widget_queue_draw ((GtkWidget*) app->category_tree_view);
	}
	// update title
	if (running_count != running_total) {
		running_count  = running_total;
		if (running_total)
			string = g_strdup_printf ("Uget - %d %s", running_total, _("downloading"));
		else {
			string = g_strdup ("Uget");
			uget_notify_download_completed (app);	// notification
		}
		gtk_window_set_title (app->window, string);
		gtk_status_icon_set_tooltip_text (app->status_icon, string);
		g_free (string);
	}

	// refresh download list & summary
	if (app->current) {
		if ( app->current->running_count || category_changed ||
		    (app->current == app->queuing && running_total) )
		{
			gtk_widget_queue_draw ((GtkWidget*) app->current->download_view);
			uget_update_summary (app);
		}
	}

	// auto save
	if (counts >= 60 * app->auto_save_interval) {
		if (app->auto_save)
			uget_save (app);
		counts = 0;
	}
	else
		counts++;

	return TRUE;
}

// status icon in system tray
void	uget_on_status_icon_activate (GtkStatusIcon *status_icon, Uget* app)
{
	if (GTK_WIDGET_VISIBLE (app->window) == TRUE) {
		// get position and size
		gtk_window_get_position (app->window, &app->window_x, &app->window_y);
		gtk_window_get_size (app->window, &app->window_width, &app->window_height);
		// iconify
		gtk_window_iconify (app->window);
		gtk_widget_hide ((GtkWidget*) app->window);
	}
	else {
		gtk_window_deiconify (app->window);
//		gtk_widget_show ((GtkWidget*) app->window);
		gtk_window_present (GTK_WINDOW (app->window));
	}
}

void	uget_on_status_icon_popup_menu (GtkStatusIcon *status_icon, guint button, guint activate_time, Uget* app)
{
	gtk_menu_popup (app->status_icon_menu,
	                NULL, NULL,
	                NULL, NULL,
	                button, activate_time);
}

// category -------------------------------------
static void	on_category_create_dialog_response (GtkDialog *dialog, gint response_id, UgCategoryDialog* cdialog)
{
	UgCategory*	category;
	Uget*		app;

	if (response_id == GTK_RESPONSE_OK) {
		app = cdialog->user_data;
		app->folder_list = ug_download_form_get_folder_list (&cdialog->download, app->folder_list);
		category = ug_category_new (NULL, app->queuing);
		ug_category_dialog_get (cdialog, category);
		uget_append_category (app, category);
		uget_update_menu_move_to (app, TRUE);
	}
	ug_category_dialog_destroy (cdialog);
}

void	uget_on_create_category (GtkWidget* widget, Uget* app)
{
	UgCategoryDialog*	dialog;
	gchar*				title;

	title = g_strconcat ("Uget - ", _("New Category"), NULL);
	dialog = ug_category_dialog_new (title, app->window);
	g_free (title);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	ug_category_dialog_set (dialog, app->category_default);
	// show category dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_category_create_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_delete_category (GtkWidget* widget, Uget* app)
{
	GtkTreeSelection*	selection;
	GtkTreeModel*		model;
	GtkTreeIter			iter;
	UgCategory*			category;

	if (app->current == NULL || app->current == app->queuing || app->current == app->completed || app->current == app->recycled)
		return;

	category = app->current->queuing;	// get top level category in treeview
	uget_switch_category (app, NULL);

	model = GTK_TREE_MODEL (app->category_tree);
	selection = gtk_tree_view_get_selection (app->category_tree_view);
	if (gtk_tree_model_iter_n_children (model, NULL) == 1) {	// number of toplevel nodes
		// skip "changed" signal in this case
		g_signal_handler_disconnect (selection, app->category_tree_signal);
		gtk_tree_selection_unselect_all (selection);
		app->category_tree_signal = g_signal_connect (selection, "changed", G_CALLBACK (uget_on_category_selection_changed), app);
		// select "Queuing" in  app->total_list_view
		gtk_window_set_focus (app->window, (GtkWidget*) app->total_list_view);
		selection = gtk_tree_view_get_selection (app->total_list_view);
		gtk_tree_selection_select_iter (selection, &app->queuing->list_iter);
	}
	else {
		iter = category->tree_iter;
		if (gtk_tree_model_iter_next (model, &iter) == FALSE)
			gtk_tree_model_get_iter_first (model, &iter);
		gtk_tree_selection_select_iter (selection, &iter);
	}

	gtk_list_store_remove (app->category_list, &category->list_iter);
	gtk_tree_store_remove (app->category_tree, &category->tree_iter);
	ug_category_free (category);

	gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
	uget_update_menu_move_to (app, TRUE);
}

static void	on_category_config_dialog_response (GtkDialog *dialog, gint response_id, UgCategoryDialog* cdialog)
{
	Uget*		app;

	app = cdialog->user_data;
	if (response_id == GTK_RESPONSE_OK) {
		app->folder_list = ug_download_form_get_folder_list (&cdialog->download, app->folder_list);
		ug_category_dialog_get (cdialog, app->current);
	}
	gtk_widget_set_sensitive ((GtkWidget*)app->window, TRUE);
	ug_category_dialog_destroy (cdialog);
}

void	uget_on_config_category (GtkWidget* widget, Uget* app)
{
	UgCategoryDialog*	dialog;
	gchar*				title;

	title = g_strconcat ("Uget - ", _("Category Properties"), NULL);
	dialog = ug_category_dialog_new (title, app->window);
	g_free (title);
	ug_category_dialog_set (dialog, app->current);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	// show category dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_category_config_dialog_response), dialog);
	gtk_widget_set_sensitive ((GtkWidget*)app->window, FALSE);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

static void	on_category_config_default_dialog_response (GtkDialog *dialog, gint response_id, UgCategoryDialog* cdialog)
{
	Uget*		app;

	if (response_id == GTK_RESPONSE_OK) {
		app = cdialog->user_data;
		app->folder_list = ug_download_form_get_folder_list (&cdialog->download, app->folder_list);
		ug_category_dialog_get (cdialog, app->category_default);
	}
	ug_category_dialog_destroy (cdialog);
}

void	uget_on_config_category_default (GtkWidget* widget, Uget* app)
{
	UgCategoryDialog*	dialog;
	gchar*				title;

	title = g_strconcat ("Uget - ", _("Default for new Category"), NULL);
	dialog = ug_category_dialog_new (title, app->window);
	g_free (title);
	ug_category_dialog_set (dialog, app->category_default);
	ug_category_form_set_multiple (&dialog->category, TRUE);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	// show category dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_category_config_default_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

// download -------------------------------------
static void	on_download_dialog_response (GtkDialog *dialog, gint response_id, UgDownloadDialog* ddialog)
{
	UgCategory*	category;
	UgDataset*	dataset;
	Uget*		app;

	if (ug_download_dialog_response (ddialog, response_id) == TRUE)
		return;

	if (response_id == GTK_RESPONSE_OK) {
		app = ddialog->user_data;
		app->folder_list = ug_download_form_get_folder_list (&ddialog->download, app->folder_list);
		category = ug_download_dialog_get_category (ddialog);
		if (category) {
			dataset  = ug_download_dialog_get_download_list (ddialog);
			ug_category_append (category, dataset);
		}
		gtk_widget_queue_draw ((GtkWidget*) app->category_tree_view);
		gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
	}

	ug_download_dialog_destroy (ddialog);
}

void	uget_on_create_batch (GtkWidget* widget, Uget* app)
{
	UgDownloadDialog*	dialog;

	dialog = ug_download_dialog_new_batch (app->window);
	ug_download_dialog_set_category_list (dialog, app->category_list);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	if (app->current)
		ug_download_dialog_select_category (dialog, app->current->queuing);
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

static void uget_on_clipboard_no_url_response (GtkDialog* dialog, gint response, Uget* app)
{
	gtk_widget_destroy ((GtkWidget*) dialog);
	app->dialog_clipboard_no_url = NULL;
}

void	uget_on_create_from_clipboard (GtkWidget* widget, Uget* app)
{
	UgDownloadDialog*	dialog;
	GtkWidget*		mdialog;
	UgItem*			item;
	GtkListStore*	item_list;
	GtkTreeIter		iter;
	GList*			list;
	gchar*			title;

	list = uget_clipboard_get_url (app, -1);
	if (list == NULL) {
		// show previous message dialog
		if (app->dialog_clipboard_no_url) {
			gtk_window_present (GTK_WINDOW (app->dialog_clipboard_no_url));
			return;
		}
		// create new message dialog
		mdialog = gtk_message_dialog_new (app->window, GTK_DIALOG_DESTROY_WITH_PARENT,
		                                  GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
		                                  _("No URLs found in clipboard."));
		app->dialog_clipboard_no_url = mdialog;
		title = g_strconcat ("Uget - ", _("Error"), NULL);
		gtk_window_set_title (GTK_WINDOW (mdialog), title);
		g_free (title);
		if (GTK_WIDGET_VISIBLE (app->window) == FALSE)
			gtk_window_set_transient_for (GTK_WINDOW (mdialog), NULL);
//		gtk_dialog_run (GTK_DIALOG (mdialog));
//		gtk_widget_destroy (mdialog);
		g_signal_connect (mdialog, "response", G_CALLBACK (uget_on_clipboard_no_url_response), app);
		gtk_widget_show ((GtkWidget*) mdialog);
		return;
	}
	// destroy previous message dialog
	if (app->dialog_clipboard_no_url) {
		gtk_widget_destroy (app->dialog_clipboard_no_url);
		app->dialog_clipboard_no_url = NULL;
	}
	title = g_strconcat ("Uget - ", _("New from Clipboard"), NULL);
	dialog = ug_download_dialog_new_selector (title, app->window);
	g_free (title);
	if (GTK_WIDGET_VISIBLE (app->window) == FALSE)
		gtk_window_set_transient_for (GTK_WINDOW (dialog->self), NULL);
	ug_selector_hide_href (&dialog->selector);
	ug_download_dialog_set_category_list (dialog, app->category_list);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	if (app->current)
		ug_download_dialog_select_category (dialog, app->current->queuing);
	item_list = ug_selector_add_page (&dialog->selector, _("Clipboard"));
	// clear iter for ug_item_store_realloc_next()
	memset (&iter, 0, sizeof (GtkTreeIter));
	for (list = g_list_last (list);  list;  list = list->prev) {
		item = ug_item_store_realloc_next (item_list, &iter);
		g_free (item->value);
		item->value = list->data;
		item->mark = TRUE;
	}
	g_list_free (list);
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_create_download_from_ipc (Uget* app, UgDataset* dataset, UgCategory* category)
{
	UgDownloadDialog*	dialog;
	gchar*				string;

	string = g_strconcat ("Uget - ", _("New Download"), NULL);
	dialog = ug_download_dialog_new (string, NULL);
	g_free (string);
	ug_download_dialog_set_category_list (dialog, app->category_list);
	if (category)
		ug_download_dialog_select_category (dialog, category);
	ug_download_dialog_set (dialog, dataset);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	dialog->dataset = dataset;
	// show download dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_dialog_response), dialog);
	g_signal_connect (dialog->self, "show", G_CALLBACK (uget_on_keep_above_window_show), NULL);
	// Make sure dilaog will show on top first time.
	// uget_on_keep_above_window_show ()  will set keep_above = FALSE
	gtk_window_set_keep_above ((GtkWindow*) dialog->self, TRUE);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_create_download (Uget* app)
{
	UgDownloadDialog*	dialog;
	gchar*		string;
	GList*		list;

	string = g_strconcat ("Uget - ", _("New Download"), NULL);
	dialog = ug_download_dialog_new (string, app->window);
	g_free (string);
	if (GTK_WIDGET_VISIBLE (app->window) == FALSE)
		gtk_window_set_transient_for (GTK_WINDOW (dialog->self), NULL);
	ug_download_dialog_set_category_list (dialog, app->category_list);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	if (app->current)
		ug_download_dialog_select_category (dialog, app->current->queuing);
	list = uget_clipboard_get_url (app, 1);
	if (list) {
		gtk_entry_set_text ((GtkEntry*) dialog->download.url_entry, list->data);
		g_list_foreach (list, (GFunc) g_free, NULL);
		g_list_free (list);
	}
	// show download dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_delete_download (GtkWidget* widget, Uget* app)
{
	UgDataset*		dataset;
	// check shift key status
	GdkWindow*		gdk_win;
	GdkModifierType	mask;

	// check shift key status
	gdk_win = gtk_widget_get_parent_window ((GtkWidget*) app->current->download_view);
	gdk_window_get_pointer (gdk_win, NULL, NULL, &mask);

	dataset = ug_category_get_selected (app->current);
	if (app->current == app->current->recycled || mask & GDK_SHIFT_MASK)
		ug_category_delete (app->current, dataset);
	else
		ug_category_move_to (app->current, dataset, app->current->recycled);
	gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
	gtk_widget_queue_draw ((GtkWidget*) app->category_tree_view);
}

void	uget_on_delete_download_file (GtkWidget* widget, Uget* app)
{
	UgDataset*		dataset;
	UgDataset*		data_next;
	UgDataCommon*	common;
	gchar*			path;

	dataset = ug_category_get_selected (app->current);
	for (; dataset; dataset=data_next) {
		data_next = dataset->next;
		ug_data_list_unlink (dataset);
		// get file path
		common = UG_DATASET_COMMON (dataset);
		if (common->folder)
			path = g_build_filename (common->folder, common->file, NULL);
		else
			path = g_strdup (common->file);
		// delete data and file
		ug_category_delete (app->current, dataset);
		ug_delete_file (path);
		g_free (path);
	}
	// update
	gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
	gtk_widget_queue_draw ((GtkWidget*) app->category_tree_view);
}

static void	on_download_config_dialog_response (GtkDialog *dialog, gint response_id, UgDownloadDialog* ddialog)
{
	Uget*		app;
	UgDataset*	dataset;

	app = ddialog->user_data;
	if (response_id == GTK_RESPONSE_OK) {
		app->folder_list = ug_download_form_get_folder_list (&ddialog->download, app->folder_list);
		dataset = ug_category_get_selected (app->current);	// reget selected item
		for (;  dataset;  dataset = dataset->next)
			ug_download_dialog_get (ddialog, dataset);
	}
	gtk_widget_set_sensitive ((GtkWidget*)app->window, TRUE);
	ug_download_dialog_destroy (ddialog);
	uget_update_summary (app);
}

void	uget_on_config_download (GtkWidget* widget, Uget* app)
{
	UgDownloadDialog*	dialog;
	UgDataset*	dataset;
	gchar*		title;

	title = g_strconcat ("Uget - ", _("Download Properties"), NULL);
	dialog = ug_download_dialog_new (title, app->window);
	g_free (title);
	dataset = ug_category_get_selected (app->current);
	if (dataset && dataset->next)
		ug_download_form_set_multiple (&dialog->download, TRUE);
	ug_download_form_set_folder_list (&dialog->download, app->folder_list);
	ug_download_dialog_set (dialog, dataset);
	// show download dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (on_download_config_dialog_response), dialog);
	gtk_widget_set_sensitive ((GtkWidget*)app->window, FALSE);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_open_downloaded_file (GtkWidget* widget, Uget* app)
{
	UgDataCommon*	common;
	UgDataset*		dataset;
	GtkWidget*		mdialog;
	gchar*			string;

	dataset = ug_category_get_cursor (app->current);
	if (dataset == NULL)
		return;
	common = ug_dataset_get (dataset, UgDataCommonClass, 0);
	if (common->folder == NULL || common->file == NULL)
		return;

	if (ug_launch_default_app (common->folder, common->file) == FALSE) {
		string = g_strdup_printf (_("Can't launch default application for file '%s'."), common->file);
		mdialog = gtk_message_dialog_new (app->window,
		          GTK_DIALOG_DESTROY_WITH_PARENT,
	              GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
	              string);
		g_free (string);
		string = g_strconcat ("Uget - ", _("Error"), NULL);
		gtk_window_set_title (GTK_WINDOW (mdialog), string);
		g_free (string);
		g_signal_connect (mdialog, "response", G_CALLBACK (gtk_widget_destroy), NULL);
		gtk_widget_show ((GtkWidget*) mdialog);
	}
}

void	uget_on_open_downloaded_folder (GtkWidget* widget, Uget* app)
{
	UgDataCommon*	common;
	UgDataset*		dataset;
	GtkWidget*		mdialog;
	gchar*			string;

	dataset = ug_category_get_cursor (app->current);
	if (dataset == NULL)
		return;
	common = ug_dataset_get (dataset, UgDataCommonClass, 0);
	if (common->folder == NULL)
		return;

	string = g_filename_from_utf8 (common->folder, -1, NULL, NULL, NULL);
	if (g_file_test (string, G_FILE_TEST_EXISTS) == FALSE) {
		g_free (string);
		string = g_strdup_printf (_("'%s' - This folder does not exist."), common->folder);
		mdialog = gtk_message_dialog_new (app->window,
		          GTK_DIALOG_DESTROY_WITH_PARENT,
	              GTK_MESSAGE_ERROR, GTK_BUTTONS_OK,
	              string);
		g_free (string);
		string = g_strconcat ("Uget - ", _("Error"), NULL);
		gtk_window_set_title (GTK_WINDOW (mdialog), string);
		g_free (string);
		g_signal_connect (mdialog, "response", G_CALLBACK (gtk_widget_destroy), NULL);
		gtk_widget_show ((GtkWidget*) mdialog);
		return;
	}
	g_free (string);

#ifdef _WIN32
	{
		gchar*		path;
		gchar*		argument;
		gunichar2*	argument_os;

		path = g_build_filename (common->folder, common->file, NULL);
		if (g_file_test (path, G_FILE_TEST_EXISTS))
			argument = g_strconcat ("/e,/select,", path, NULL);
		else
			argument = g_strconcat ("/e,", common->folder, NULL);
		g_free (path);
		argument_os = g_utf8_to_utf16 (argument, -1, NULL, NULL, NULL);
		g_free (argument);
		ShellExecuteW (NULL, NULL, L"explorer", argument_os, NULL, SW_SHOW);
		g_free (argument_os);
	}
#else
	{
		GError*	error = NULL;
		GFile*	gfile;
		gchar*	uri;

		gfile = g_file_new_for_path (common->folder);
		uri = g_file_get_uri (gfile);
		g_object_unref (gfile);
		g_app_info_launch_default_for_uri (uri, NULL, &error);
		g_free (uri);

		if (error) {
#ifndef NDEBUG
			g_print (error->message);
#endif
			g_error_free (error);
		}
	}
#endif
}

void	uget_on_set_download_runnable (GtkWidget* widget, Uget* app)
{
	UgDataset*	dataset;
	UgDataApp*	appdata;

	dataset = ug_category_get_selected (app->current);
	for (;  dataset;  dataset = dataset->next) {
		appdata = UG_DATASET_APP (dataset);
		// If no plugin running, set download runnable.
		if (appdata->plugin == NULL);
			appdata->list_icon = UG_LIST_ICON_FILE;
	}
	gtk_widget_queue_draw ((GtkWidget*) app->current->download_view);
}

void	uget_on_set_download_to_pause (GtkWidget* widget, Uget* app)
{
	UgDataset*	dataset;
	UgDataApp*	appdata;

	dataset = ug_category_get_selected (app->current);
	for (;  dataset;  dataset = dataset->next) {
		appdata = UG_DATASET_APP (dataset);
		if (appdata->list_icon == UG_LIST_ICON_COMPLETED || appdata->list_icon == UG_LIST_ICON_ERROR)
			continue;
		// stop plugin
		if (appdata->plugin)
			ug_plugin_set_state (appdata->plugin, UG_STATE_STOP);
		appdata->list_icon = UG_LIST_ICON_PAUSED;
	}
	gtk_widget_queue_draw ((GtkWidget*) app->current->download_view);
}

void	uget_on_move_download (GtkWidget* widget, Uget* app)
{
	GPtrArray*		array;
	UgCategory*		category;
	UgDataset*		dataset;
	guint			index;

	array = app->menubar.download.move_to.array;
	category = NULL;
	for (index = 0;  index < array->len;  index += 2) {
		if (widget == g_ptr_array_index (array, index)) {
			category = g_ptr_array_index (array, index + 1);
			break;
		}
	}

	if (category == NULL || category == app->current)
		return;
	dataset = ug_category_get_selected (app->current);
	ug_category_move_to (app->current, dataset, category);
	gtk_widget_queue_draw ((GtkWidget*) app->total_list_view);
	gtk_widget_queue_draw ((GtkWidget*) app->category_tree_view);
}

void	uget_on_move_download_up (GtkWidget* widget, Uget* app)
{
	if (app->current == NULL)
		return;
	if (ug_category_move_selected_up (app->current) == FALSE) {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_up, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_top, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_up, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_top, FALSE);
	}
	else {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_down, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_bottom, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_down, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_bottom, TRUE);
	}
}

void	uget_on_move_download_down (GtkWidget* widget, Uget* app)
{
	if (app->current == NULL)
		return;
	if (ug_category_move_selected_down (app->current) == FALSE) {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_down, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_bottom, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_down, FALSE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_bottom, FALSE);
	}
	else {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_up, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_top, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_up, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_top, TRUE);
	}
}

void	uget_on_move_download_to_top (GtkWidget* widget, Uget* app)
{
	if (app->current == NULL)
		return;

	if (ug_category_move_selected_to_top (app->current) == TRUE) {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_down, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_bottom, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_down, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_bottom, TRUE);
	}
	gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_up, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_top, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_up, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_top, FALSE);
}

void	uget_on_move_download_to_bottom (GtkWidget* widget, Uget* app)
{
	if (app->current == NULL)
		return;

	if (ug_category_move_selected_to_bottom (app->current) == TRUE) {
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_up, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_top, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_up, TRUE);
		gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_top, TRUE);
	}
	gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_down, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->toolbar.move_bottom, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_down, FALSE);
	gtk_widget_set_sensitive ((GtkWidget*) app->menubar.download.move_bottom, FALSE);
}

// edit menu
void	uget_on_clipboard_monitor (GtkWidget* widget, Uget* app)
{
	app->clipboard_monitor = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) app->menubar.edit.clipboard_monitor);
}

static void	uget_on_settings_dialog_response (GtkDialog *dialog, gint response, UgSettingsDialog* sdialog)
{
	Uget*	app;

	app = sdialog->user_data;
	app->dialog_settings = NULL;
	if (response == GTK_RESPONSE_OK)
		ug_settings_dialog_get (sdialog, app);
	ug_settings_dialog_destroy (sdialog);
}

void	uget_on_clipboard_option (GtkWidget* widget, Uget* app)
{
	UgSettingsDialog*	dialog;
	gchar*				title;

	if (app->dialog_settings) {
		gtk_window_present (GTK_WINDOW (app->dialog_settings));
		return;
	}

	title = g_strconcat ("Uget - ", _("Settings"), NULL);
	dialog = ug_settings_dialog_new (title, app->window);
	g_free (title);
	app->dialog_settings = (GtkWidget*) dialog->self;
	ug_settings_dialog_set (dialog, app);
	if (widget == app->menubar.edit.settings)
		gtk_notebook_set_page (dialog->notebook, 1);
	// show dialog
	dialog->user_data = app;
	g_signal_connect (dialog->self, "response", G_CALLBACK (uget_on_settings_dialog_response), dialog);
	gtk_widget_show ((GtkWidget*) dialog->self);
}

void	uget_on_config_settings   (GtkWidget* widget, Uget* app)
{
	uget_on_clipboard_option (widget, app);
}

// summary
void	uget_on_summary_copy_selected (Uget* app)
{
	GtkTreeModel*		model;
	GtkTreePath*		path;
	GtkTreeIter			iter;
	GString*			gstr;
	UgItem*				item;

	gtk_tree_view_get_cursor (app->summary_view, &path, NULL);
	if (path == NULL)
		return;
	model = GTK_TREE_MODEL (app->summary_store);
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_path_free (path);
	gtk_tree_model_get (model, &iter, 0, &item, -1);
	// set data
	gstr = g_string_new (item->name);
	if (item->value) {
		g_string_append_c (gstr, ' ');
		g_string_append (gstr, item->value);
	}
	gtk_clipboard_set_text (app->clipboard, gstr->str, gstr->len);
	g_string_free (gstr, TRUE);
}

void	uget_on_summary_copy_all (GtkWidget* widget, Uget* app)
{
	GtkTreeModel*		model;
	GtkTreeIter			iter;
	GString*			gstr;
	UgItem*				item;
	gboolean			valid;

	model = GTK_TREE_MODEL (app->summary_store);
	valid = gtk_tree_model_get_iter_first (model, &iter);
	gstr  = g_string_sized_new (60);
	while (valid) {
		gtk_tree_model_get (model, &iter, 0, &item, -1);
		valid = gtk_tree_model_iter_next (model, &iter);
		g_string_append (gstr, item->name);
		if (item->value) {
			g_string_append_c (gstr, ' ');
			g_string_append (gstr, item->value);
		}
		g_string_append_c (gstr, '\n');
	}
	gtk_clipboard_set_text (app->clipboard, gstr->str, gstr->len);
	g_string_free (gstr, TRUE);
}

// Change visible status of toolbar/statusbar/category.
void	uget_on_change_visible_view (GtkWidget* widget, Uget* app)
{
	gboolean	visible;

	visible = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) widget);
	// Toolbar
	if (widget == app->menubar.view.toolbar) {
		app->visible.toolbar = visible;
		if (visible)
			gtk_widget_show (app->toolbar.self);
		else
			gtk_widget_hide (app->toolbar.self);
		return;
	}
	// Status Bar
	if (widget == app->menubar.view.statusbar) {
		app->visible.statusbar = visible;
		if (visible)
			gtk_widget_show ((GtkWidget*) app->statusbar);
		else
			gtk_widget_hide ((GtkWidget*) app->statusbar);
		return;
	}

	// Total List
	if (widget == app->menubar.view.total_list) {
		app->visible.total_list = visible;
		if (visible) {
			gtk_widget_show ((GtkWidget*) app->total_list_view);
			gtk_widget_show ((GtkWidget*) app->total_list_label);
		}
		else {
			gtk_widget_hide ((GtkWidget*) app->total_list_view);
			gtk_widget_hide ((GtkWidget*) app->total_list_label);
		}
	}
	// Category Tree
	else if (widget == app->menubar.view.category_tree) {
		app->visible.category_tree = visible;
		if (visible) {
			gtk_widget_show (app->category_tree_scroll);
			gtk_widget_show (app->category_tree_label);
		}
		else {
			gtk_widget_hide (app->category_tree_scroll);
			gtk_widget_hide (app->category_tree_label);
		}
	}
	// left side vbox contain total list and category tree
	if (app->visible.total_list || app->visible.category_tree)
		gtk_widget_show ((GtkWidget*) app->left_vbox);
	else
		gtk_widget_hide ((GtkWidget*) app->left_vbox);
}

// Change visible status of download columns.
void	uget_on_change_visible_column (GtkWidget* widget, Uget* app)
{
	GtkTreeViewColumn*	column;
	UgCategory*	category;
	gboolean	visible;
	gint		column_index;

	category = app->current;
	if (category == NULL)
		return;

	visible = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) widget);
	if (widget == app->menubar.view.rules_hint) {
		gtk_tree_view_set_rules_hint (category->download_view, visible);
		category->visible_column.rules_hint = visible;
		return;
	}
	else if (widget == app->menubar.view.columns.completed) {
		column_index = UG_DOWNLOAD_COLUMN_COMPLETE;
		category->visible_column.completed = visible;
	}
	else if (widget == app->menubar.view.columns.total) {
		column_index = UG_DOWNLOAD_COLUMN_TOTAL;
		category->visible_column.total = visible;
	}
	else if (widget == app->menubar.view.columns.percent) {
		column_index = UG_DOWNLOAD_COLUMN_PERCENT;
		category->visible_column.percent = visible;
	}
	else if (widget == app->menubar.view.columns.elapsed) {
		column_index = UG_DOWNLOAD_COLUMN_ELAPSED;
		category->visible_column.elapsed = visible;
	}
	else if (widget == app->menubar.view.columns.left) {
		column_index = UG_DOWNLOAD_COLUMN_LEFT;
		category->visible_column.left = visible;
	}
	else if (widget == app->menubar.view.columns.speed) {
		column_index = UG_DOWNLOAD_COLUMN_SPEED;
		category->visible_column.speed = visible;
	}
	else if (widget == app->menubar.view.columns.retry) {
		column_index = UG_DOWNLOAD_COLUMN_RETRY;
		category->visible_column.retry = visible;
	}
	else if (widget == app->menubar.view.columns.category) {
		column_index = UG_DOWNLOAD_COLUMN_CATEGORY;
		category->visible_column.category = visible;
	}
	else if (widget == app->menubar.view.columns.url) {
		column_index = UG_DOWNLOAD_COLUMN_URL;
		category->visible_column.url = visible;
	}
	else
		return;

	column = gtk_tree_view_get_column (category->download_view, column_index);
	gtk_tree_view_column_set_visible (column, visible);
}

// Change visible status of summary items.
void	uget_on_change_visible_summary (GtkWidget* widget, Uget* app)
{
	UgCategory*	category;
	gboolean	visible;

	category = app->current;
	if (category == NULL)
		return;

	visible = gtk_check_menu_item_get_active ((GtkCheckMenuItem*) widget);
	if (widget == app->menubar.view.summary) {
		category->visible_summary.self = visible;
		if (visible)
			gtk_widget_show (app->summary_scroll);
		else
			gtk_widget_hide (app->summary_scroll);
		return;
	}
	else if (widget == app->menubar.view.summary_items.name)
		category->visible_summary.name = visible;
	else if (widget == app->menubar.view.summary_items.folder)
		category->visible_summary.folder = visible;
	else if (widget == app->menubar.view.summary_items.category)
		category->visible_summary.category = visible;
//	else if (widget == app->menubar.view.summary_items.elapsed)
//		category->visible_summary.elapsed = visible;
	else if (widget == app->menubar.view.summary_items.url)
		category->visible_summary.url = visible;
	else if (widget == app->menubar.view.summary_items.message)
		category->visible_summary.message = visible;
	else
		return;

	uget_update_summary (app);
}


void	uget_on_about (GtkWidget* widget, Uget* app)
{
/*
	static	GdkPixbuf*	logo = NULL;
	extern	gchar*		uget_path_pixmaps;	// uget-main.c
	gchar*				path;

	if (logo == NULL) {
		path = g_build_filename (uget_path_pixmaps, "uget", "logo.png", NULL);
		logo = gdk_pixbuf_new_from_file (path, NULL);
		g_free (path);
	}
*/
	if (GTK_WIDGET_VISIBLE (app->window) == FALSE) {
		gtk_window_deiconify (app->window);
		gtk_widget_show ((GtkWidget*) app->window);
	}

	gtk_show_about_dialog (app->window,
//	                       "logo", logo,
	                       "logo-icon-name", UGET_ICON_NAME,
	                       "program-name", "Uget",
	                       "version", uget_version,
	                       "comments", gettext (uget_comments),
	                       "copyright", uget_copyright,
	                       "website", "http://urlget.sourceforge.net/",
	                       "license", uget_license,
	                       "authors", uget_authors,
	                       "artists", uget_artists,
	                       "translator-credits", gettext (translator_credits),
	                       NULL);
}

