/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UG_DOWNLOAD_FORM_H
#define UG_DOWNLOAD_FORM_H

#include <gtk/gtk.h>
#include <ug_dataset.h>
#include <ug_proxy_form.h>

#ifdef __cplusplus
extern "C" {
#endif


typedef struct	UgDownloadForm_		UgDownloadForm;

struct UgDownloadForm_
{
	GtkWidget*	self;	// GtkTable
	GtkWindow*	parent;	// container
	GtkWidget*	folder_dialog;

	GtkWidget*	url_label;
	GtkWidget*	url_entry;
//	GtkWidget*	url_button;

	GtkWidget*	file_label;
	GtkWidget*	file_entry;
//	GtkWidget*	file_button;

	GtkWidget*	folder_combo;
	GtkWidget*	folder_entry;
	GtkWidget*	folder_button;

	GtkWidget*	referer_label;
	GtkWidget*	referer_entry;

	// widgets for login fields
	GtkWidget*	username_label;
	GtkWidget*	username_entry;
	GtkWidget*	password_label;
	GtkWidget*	password_entry;

	// widgets for Status
	GtkWidget*	radio_runnable;
	GtkWidget*	radio_pause;

//	GtkWidget*	spin_parts;
//	GtkWidget*	spin_redirect;
	GtkWidget*	spin_retry;
	GtkWidget*	spin_delay;

	// automatically complete file entry from url
	// if auto_complete_entry == FALSE, turn off this function
	gboolean	auto_complete_entry;
	gboolean	url_entry_changed;
	gboolean	multiple;
};

void	ug_download_form_init  (UgDownloadForm* dform, UgProxyForm* proxy, GtkWindow* container);
void	ug_download_form_get   (UgDownloadForm* dform, UgDataset* dataset);
void	ug_download_form_set   (UgDownloadForm* dform, UgDataset* dataset);
void	ug_download_form_apply (UgDownloadForm* dform, UgDataset* dataset);

void	ug_download_form_set_multiple (UgDownloadForm* dform, gboolean multiple_mode);
void	ug_download_form_set_folder_list (UgDownloadForm* dform, GList* folder_list);
GList*	ug_download_form_get_folder_list (UgDownloadForm* dform, GList* folder_list_old);
gboolean	ug_download_form_complete_entry (UgDownloadForm* dform);

#ifdef __cplusplus
}
#endif

#endif  // End of UG_DOWNLOAD_FORM_H

