/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */

#include <ug_download_form.h>
#include <ug_data_app.h>
#include <ug_utils.h>
#include <ug_url.h>

#include <glib/gi18n.h>


//	signal handler
static void on_choose_directory (GtkWidget* button, UgDownloadForm* dform);
static void on_file_entry_changed (GtkEditable *editable, UgDownloadForm* dform);

void	ug_download_form_init (UgDownloadForm* dform, UgProxyForm* proxy, GtkWindow* container)
{
	GtkWidget*	button;
	GtkWidget*	entry;
	GtkWidget*	label;
	GtkTable*	top_table;
	GtkTable*	table;

	GtkWidget*	frame;
	GtkWidget*	vbox;
	GtkWidget*	hbox;

	dform->auto_complete_entry = TRUE;
	dform->parent = container;
	dform->self = gtk_table_new (7, 3, FALSE);
	top_table  = (GtkTable*) dform->self;

	// URL Label & Entry
//	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
//	gtk_container_add (GTK_CONTAINER (button), gtk_image_new_from_stock (GTK_STOCK_PASTE, GTK_ICON_SIZE_MENU));
//	gtk_table_attach (top_table, button, 2, 3, 0, 1, GTK_SHRINK, GTK_SHRINK, 2, 1);
//	dform->url_button = button;
	// entry
	entry = gtk_entry_new ();
	gtk_entry_set_width_chars (GTK_ENTRY (entry), 20);
	label = gtk_label_new_with_mnemonic (_("_URL:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), entry);
	gtk_table_attach (top_table, label,  0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 2);
	gtk_table_attach (top_table, entry,  1, 3, 0, 1, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 2);
	dform->url_label  = label;
	dform->url_entry  = entry;

	// "File" label & entry
//	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
//	gtk_container_add (GTK_CONTAINER (button), gtk_image_new_from_stock (GTK_STOCK_FILE, GTK_ICON_SIZE_MENU));
//	gtk_table_attach (top_table, button, 2, 3, 1, 2, GTK_SHRINK, GTK_SHRINK, 2, 1);
//	dform->file_button = button;
	// entry
	entry = gtk_entry_new ();
	label = gtk_label_new_with_mnemonic (_("File:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_table_attach (top_table, label,  0, 1, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, entry,  1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (GTK_EDITABLE (entry), "changed", G_CALLBACK (on_file_entry_changed), dform);
	dform->file_entry = entry;
	dform->file_label = label;

	// "Folder" label , entry & folder button
	button = gtk_button_new ();
//	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	gtk_container_add (GTK_CONTAINER (button), gtk_image_new_from_stock (GTK_STOCK_DIRECTORY, GTK_ICON_SIZE_MENU));
	gtk_table_attach (top_table, button, 2, 3, 2, 3, GTK_SHRINK, GTK_SHRINK, 2, 1);
	dform->folder_button = button;
	// entry
	dform->folder_combo = gtk_combo_box_entry_new_text ();
	dform->folder_entry = gtk_bin_get_child (GTK_BIN (dform->folder_combo));
	label = gtk_label_new_with_mnemonic (_("_Folder:"));
	gtk_label_set_mnemonic_widget(GTK_LABEL (label), dform->folder_combo);
	gtk_table_attach (top_table, label,  0, 1, 2, 3, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, dform->folder_combo,  1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	g_signal_connect (button, "clicked", G_CALLBACK (on_choose_directory), dform);

	// "Referer" label & entry
	entry = gtk_entry_new ();
	label = gtk_label_new_with_mnemonic (_("Referer:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), entry);
	gtk_table_attach (top_table, label, 0, 1, 3, 4, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (top_table, entry, 1, 3, 3, 4, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	dform->referer_entry = entry;
	dform->referer_label = label;

	// HBox for "status" and "Login"
	hbox = gtk_hbox_new (FALSE, 2);
	gtk_table_attach (top_table, hbox, 0, 3, 4, 5, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 2);

	// frame for start mode
	frame = gtk_frame_new (_("Status"));
	gtk_box_pack_start (GTK_BOX (hbox), frame, FALSE, FALSE, 0);
	vbox = gtk_vbox_new (FALSE, 2);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), 2);
	gtk_container_add (GTK_CONTAINER(frame), vbox);
	dform->radio_runnable = gtk_radio_button_new_with_mnemonic (NULL, _("_Runnable"));
	dform->radio_pause = gtk_radio_button_new_with_mnemonic_from_widget ((GtkRadioButton*)dform->radio_runnable, _("P_ause"));
	gtk_box_pack_start (GTK_BOX (vbox), dform->radio_runnable, FALSE, FALSE, 1);
	gtk_box_pack_start (GTK_BOX (vbox), dform->radio_pause, FALSE, FALSE, 1);

	// frame for login --- start ---
	frame = gtk_frame_new (_("Login"));
	gtk_box_pack_start (GTK_BOX (hbox), frame, TRUE, TRUE, 2);
	table = (GtkTable*) gtk_table_new (3, 2, FALSE);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	gtk_container_add (GTK_CONTAINER(frame), (GtkWidget*) table);
	// username
	entry = gtk_entry_new ();
	label = gtk_label_new_with_mnemonic (_("Username:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_table_attach (table, label, 0, 1, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, entry, 1, 2, 1, 2, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	dform->username_entry = entry;
	dform->username_label = label;
	// password
	entry = gtk_entry_new ();
	label = gtk_label_new_with_mnemonic (_("Password:"));
	gtk_entry_set_visibility (GTK_ENTRY (entry), FALSE);
	gtk_label_set_mnemonic_widget (GTK_LABEL (label), entry);
	gtk_table_attach (table, label, 0, 1, 2, 3, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, entry, 1, 2, 2, 3, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 1, 1);
	dform->password_entry = entry;
	dform->password_label = label;
	// frame for login --- end ---

	// frame for option
	frame = gtk_frame_new (_("Options"));
	table = (GtkTable*) gtk_table_new (3, 2, FALSE);
	gtk_container_add (GTK_CONTAINER(frame), (GtkWidget*) table);
	gtk_container_set_border_width (GTK_CONTAINER (table), 2);
	gtk_table_attach (top_table, frame, 0, 3, 5, 6, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 2);

	dform->spin_retry = gtk_spin_button_new_with_range (0.0, 99.0, 1.0);
	label = gtk_label_new_with_mnemonic (_("Retry _limit:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), dform->spin_retry);
	gtk_table_attach (table, label, 0, 1, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, dform->spin_retry, 1, 2, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 1);
	gtk_table_attach (table, gtk_label_new (_("counts")), 2, 3, 0, 1, GTK_SHRINK, GTK_SHRINK, 3, 1);

	dform->spin_delay = gtk_spin_button_new_with_range (0.0, 600.0, 1.0);
	label = gtk_label_new_with_mnemonic (_("Retry _delay:"));
	gtk_label_set_mnemonic_widget (GTK_LABEL(label), dform->spin_delay);
	gtk_table_attach (table, label, 0, 1, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 2);
	gtk_table_attach (table, dform->spin_delay, 1, 2, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 2);
	gtk_table_attach (table, gtk_label_new (_("seconds")), 2, 3, 1, 2, GTK_SHRINK, GTK_SHRINK, 3, 2);

	// proxy
//	ug_proxy_form_init (&dform->proxy_view, TRUE);
	if (proxy)
		gtk_table_attach (top_table, proxy->self, 0, 3, 6, 7, GTK_FILL | GTK_EXPAND, GTK_SHRINK, 2, 2);

	gtk_widget_show_all (dform->self);
}

void	ug_download_form_get  (UgDownloadForm* dform, UgDataset* dataset)
{
	UgDataApp*		appdata;
	UgDataCommon*	common;
	UgDataHttp*		http;
	UgUrlPart*		urlpart;
	const gchar*	referer;

	common = UG_DATASET_COMMON (dataset);
	ug_str_set (&common->folder,   gtk_entry_get_text ((GtkEntry*)dform->folder_entry),   -1);
	ug_str_set (&common->user,     gtk_entry_get_text ((GtkEntry*)dform->username_entry), -1);
	ug_str_set (&common->password, gtk_entry_get_text ((GtkEntry*)dform->password_entry), -1);
	common->retry_limit = gtk_spin_button_get_value_as_int ((GtkSpinButton*) dform->spin_retry);
	common->retry_delay = gtk_spin_button_get_value_as_int ((GtkSpinButton*) dform->spin_delay);
	if (dform->multiple == FALSE) {
		ug_str_set (&common->url,  gtk_entry_get_text ((GtkEntry*)dform->url_entry),  -1);
		ug_str_set (&common->file, gtk_entry_get_text ((GtkEntry*)dform->file_entry), -1);
		// check username & password
		urlpart = ug_url_part_new (common->url, -1);
		if (urlpart->user_len || urlpart->password_len) {
			ug_str_set (&common->user,     urlpart->user,     urlpart->user_len);
			ug_str_set (&common->password, urlpart->password, urlpart->password_len);
			memmove (common->url + urlpart->url_scheme_len + 3, (char*)urlpart->host, urlpart->url_len - (urlpart->host - urlpart->url) +1);
		}
		ug_url_part_free (urlpart);
	}

	referer = gtk_entry_get_text ((GtkEntry*) dform->referer_entry);
	if (*referer) {
		http = ug_dataset_realloc (dataset, UgDataHttpClass, 0);
		ug_str_set (&http->referer, referer, -1);
	}

	appdata = UG_DATASET_APP (dataset);
	if (gtk_toggle_button_get_active ((GtkToggleButton*) dform->radio_pause)) {
		if (appdata->list_icon != UG_LIST_ICON_COMPLETED && appdata->list_icon != UG_LIST_ICON_ERROR)
			appdata->list_icon = UG_LIST_ICON_PAUSED;
	}
	else
		appdata->list_icon = UG_LIST_ICON_FILE;
}

void	ug_download_form_set  (UgDownloadForm* dform, UgDataset* dataset)
{
	UgDataCommon*	common;

	common = UG_DATASET_COMMON (dataset);
	if (dform->multiple == FALSE) {
		gtk_entry_set_text ((GtkEntry*)dform->url_entry,  (common->url)  ? common->url  : "");
		gtk_entry_set_text ((GtkEntry*)dform->file_entry, (common->file) ? common->file : "");
	}
	ug_download_form_apply (dform, dataset);
}

void	ug_download_form_apply (UgDownloadForm* dform, UgDataset* dataset)
{
	UgDataApp*		appdata;
	UgDataCommon*	common;
	UgDataHttp*		http;

	common = UG_DATASET_COMMON (dataset);
	gtk_entry_set_text ((GtkEntry*)dform->folder_entry,   (common->folder) ? common->folder : "");
	gtk_entry_set_text ((GtkEntry*)dform->username_entry, (common->user) ? common->user : "");
	gtk_entry_set_text ((GtkEntry*)dform->password_entry, (common->password) ? common->password : "");
	gtk_spin_button_set_value ((GtkSpinButton*)dform->spin_retry, common->retry_limit);
	gtk_spin_button_set_value ((GtkSpinButton*)dform->spin_delay, common->retry_delay);

	http = ug_dataset_get (dataset, UgDataHttpClass, 0);
	if (http)
		gtk_entry_set_text ((GtkEntry*)dform->referer_entry, (http->referer) ? http->referer : "");

	appdata = UG_DATASET_APP (dataset);
	if (appdata->list_icon == UG_LIST_ICON_PAUSED || appdata->list_icon == UG_LIST_ICON_COMPLETED || appdata->list_icon == UG_LIST_ICON_ERROR)
		gtk_toggle_button_set_active ((GtkToggleButton*)dform->radio_pause, TRUE);
	else
		gtk_toggle_button_set_active ((GtkToggleButton*)dform->radio_runnable, TRUE);
}

void	ug_download_form_set_multiple (UgDownloadForm* dform, gboolean multiple_mode)
{
	dform->multiple = multiple_mode;

	if (multiple_mode) {
		gtk_widget_hide (dform->url_label);
		gtk_widget_hide (dform->url_entry);
		gtk_widget_hide (dform->file_label);
		gtk_widget_hide (dform->file_entry);
	}
	else {
		gtk_widget_show (dform->url_label);
		gtk_widget_show (dform->url_entry);
		gtk_widget_show (dform->file_label);
		gtk_widget_show (dform->file_entry);
	}

	multiple_mode = !multiple_mode;
	gtk_widget_set_sensitive (dform->url_label,  multiple_mode);
	gtk_widget_set_sensitive (dform->url_entry,  multiple_mode);
	gtk_widget_set_sensitive (dform->file_label, multiple_mode);
	gtk_widget_set_sensitive (dform->file_entry, multiple_mode);
}

void	ug_download_form_set_folder_list (UgDownloadForm* dform, GList* folder_list)
{
	GtkComboBox*	combo;

	combo = (GtkComboBox*) dform->folder_combo;
	for (;  folder_list;  folder_list = folder_list->next)
		gtk_combo_box_append_text (combo, folder_list->data);
}

GList*	ug_download_form_get_folder_list (UgDownloadForm* dform, GList* folder_list)
{
	GtkComboBox*	combo;
	const gchar*	current;
	GList*			link;
	guint			length;

	combo   = (GtkComboBox*) dform->folder_combo;
	current = gtk_entry_get_text ((GtkEntry*) dform->folder_entry);
	if (*current == 0)
		return folder_list;

	for (link = folder_list;  link;  link = link->next) {
		if (strcmp (current, link->data) == 0) {
			folder_list = g_list_remove_link (folder_list, link);
			folder_list = g_list_prepend (folder_list, link->data);
			g_list_free_1 (link);
			return folder_list;
		}
	}

	length = g_list_length (folder_list);
	if (length >= 8) {
		link = g_list_last (folder_list);
		folder_list = g_list_remove_link (folder_list, link);
		g_free (link->data);
		g_list_free_1 (link);
	}
	folder_list = g_list_prepend (folder_list, g_strdup (current));
	return folder_list;
}

gboolean	ug_download_form_complete_entry (UgDownloadForm* dform)
{
	UgUrlPart*	urlpart;
	gchar*		string;
	gboolean	result;

	if (dform->multiple)
		return TRUE;

	dform->url_entry_changed = TRUE;		// used in on_file_entry_changed()
	urlpart = ug_url_part_new (gtk_entry_get_text ((GtkEntry*) dform->url_entry), -1);
	if (urlpart->host_len) {
		if (dform->auto_complete_entry) {
			if (urlpart->file_len) {
				string = ug_url_unescape_to_utf8 (urlpart->file, urlpart->file_len);
//				string = g_strndup (urlpart->file, urlpart->file_len);
				gtk_entry_set_text ((GtkEntry*) dform->file_entry, string);
				g_free (string);
			}
			else
				gtk_entry_set_text ((GtkEntry*) dform->file_entry, "index.htm");
		}
		result = TRUE;
	}
	else
		result = FALSE;
	ug_url_part_free (urlpart);
	dform->url_entry_changed = FALSE;	// used in on_file_entry_changed()

	return result;
}

// ----------------------------------------------------------------------------
//	signal handler
static void on_file_chooser_response (GtkDialog* chooser, gint response, UgDownloadForm* dlwidget)
{
	gchar*	file;
	gchar*	path;

	if (response == GTK_RESPONSE_OK ) {
		file = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (chooser));
		path = g_filename_to_utf8 (file, -1, NULL, NULL, NULL);
		gtk_entry_set_text (GTK_ENTRY (dlwidget->folder_entry), path);
		g_free (path);
		g_free (file);
	}
	gtk_widget_destroy (GTK_WIDGET(chooser));
	dlwidget->folder_dialog = NULL;

	if (dlwidget->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dlwidget->parent, TRUE);
}

static void on_file_chooser_show (GtkWindow* window, gpointer user_data)
{
	// resize File Chooser Dialog
//	gtk_window_resize (window, 600, 400);
}

static void on_choose_directory (GtkWidget* button, UgDownloadForm* dlwidget)
{
	GtkWidget*	chooser;
	gchar*		path;
	gchar*		title;

	if (dlwidget->folder_dialog)
		return;
	// disable sensitive of parent window
	// enable sensitive in function on_file_chooser_response()
	if (dlwidget->parent)
		gtk_widget_set_sensitive ((GtkWidget*) dlwidget->parent, FALSE);

	title = g_strconcat ("Uget - ", _("Select Folder"), NULL);
	chooser = gtk_file_chooser_dialog_new (title,
	                                       dlwidget->parent,
	                                       GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
	                                       GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
	                                       GTK_STOCK_OK,     GTK_RESPONSE_OK,
	                                       NULL);
	g_free (title);
	gtk_window_set_transient_for ((GtkWindow*) chooser, dlwidget->parent);
	gtk_window_set_destroy_with_parent ((GtkWindow*) chooser, TRUE);
	dlwidget->folder_dialog = chooser;

	path = (gchar*) gtk_entry_get_text ((GtkEntry*) dlwidget->folder_entry);
	if (*path) {
		path = g_filename_from_utf8 (path, -1, NULL, NULL, NULL);
		gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (chooser), path);
		g_free (path);
	}

	g_signal_connect (chooser, "response", G_CALLBACK (on_file_chooser_response), dlwidget);
	g_signal_connect (chooser, "show",     G_CALLBACK (on_file_chooser_show),     NULL);

	if (gtk_window_get_modal (dlwidget->parent))
		gtk_dialog_run ((GtkDialog*) chooser);
	else {
		gtk_window_set_modal ((GtkWindow*) chooser, FALSE);
		gtk_widget_show (chooser);
//		gtk_window_resize ((GtkWindow*) chooser, 600, 400);
	}
}

static void on_file_entry_changed (GtkEditable *editable, UgDownloadForm* dform)
{
	if (dform->url_entry_changed == FALSE)
		dform->auto_complete_entry = FALSE;
}

