/*
 *
 *   Copyright (C) 2005-2010 by Raymond Huang
 *   plushuang at users.sourceforge.net
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *  ---
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of portions of this program with the
 *  OpenSSL library under certain conditions as described in each
 *  individual source file, and distribute linked combinations
 *  including the two.
 *  You must obey the GNU Lesser General Public License in all respects
 *  for all of the code used other than OpenSSL.  If you modify
 *  file(s) with this exception, you may extend this exception to your
 *  version of the file(s), but you are not obligated to do so.  If you
 *  do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source
 *  files in the program, then also delete it here.
 *
 */


#ifndef UG_CATEGORY_H
#define UG_CATEGORY_H

#include <gtk/gtk.h>
#include <ug_dataset.h>
#include <ug_list_view.h>

#ifdef __cplusplus
extern "C" {
#endif


#define UG_CATEGORY_STOCK				GTK_STOCK_DND_MULTIPLE
#define	UG_CATEGORY_QUEUING_STOCK		GTK_STOCK_MEDIA_PLAY
#define UG_CATEGORY_COMPLETED_STOCK		GTK_STOCK_YES
#define UG_CATEGORY_RECYCLED_STOCK		GTK_STOCK_DELETE
#define	UG_CATEGORY_QUEUING_NAME		_("Queuing")
#define	UG_CATEGORY_COMPLETED_NAME		_("Completed")
#define	UG_CATEGORY_RECYCLED_NAME		_("Recycled")

typedef struct	UgCategory_					UgCategory;
typedef struct	UgCategoryVisibleColumn_	UgCategoryVisibleColumn;	// download columns
typedef struct	UgCategoryVisibleSummary_	UgCategoryVisibleSummary;	// summary items

// visible download columns
// UgMarkup input  : ug_data_in_markup()
// UgMarkup output : ug_data_to_markup()
struct UgCategoryVisibleColumn_
{
	UgDataClass*	data_class;		// for UgMarkup input/output

	gboolean	rules_hint;
	gboolean	completed;
	gboolean	total;
	gboolean	percent;
	gboolean	elapsed;		// consuming time
	gboolean	left;			// remaining time
	gboolean	speed;
	gboolean	retry;
	gboolean	category;
	gboolean	url;
};

// visible summary items
// UgMarkup input  : ug_data_in_markup()
// UgMarkup output : ug_data_to_markup()
struct UgCategoryVisibleSummary_
{
	UgDataClass*	data_class;		// for UgMarkup input/output

	gboolean	self;
	gboolean	name;
	gboolean	folder;
	gboolean	category;
//	gboolean	elapsed;		// consuming time
	gboolean	url;
	gboolean	message;
};

// UgMarkup input  : ug_category_in_markup()
// UgMarkup output : ug_category_to_markup()
struct UgCategory_
{
	UgDataClass*	data_class;		// for UgMarkup input/output

	// UgCategory : queuing, completed, and recycled 3 in 1
	UgCategory*		queuing;
	UgCategory*		completed;
	UgCategory*		recycled;

	// if total_list == NULL, this category is in total list
	UgCategory*		total_list;			// peer category in total list
	UgDataset*		download_default;

	GtkListStore*	download_store;		// store UgDataset
	GtkTreeView*	download_view;
	GtkWidget*		download_scroll;	// (GtkScrolledWindow) container widget for download_view

	gchar*			name;
	UgListIcon		list_icon;
	guint			capacity;

	GList*			running;			// running download (UgDataset)
	guint			running_count;		// number of running download
	guint			running_limit;		// limit of running_count

	// visible download columns
	UgCategoryVisibleColumn		visible_column;
	// visible summary items
	UgCategoryVisibleSummary	visible_summary;

	// GtkTreeIter for GtkTreeStore & GtkListStore
	GtkTreeIter		tree_iter;	// Uget->category_tree
	GtkTreeIter		list_iter;	// Uget->category_list
};

UgCategory*	ug_category_new  (const gchar* name, UgCategory* peer_in_total_list);
void		ug_category_free (UgCategory* category);

gint		ug_category_count_selected	(UgCategory* category);
UgDataset*	ug_category_get_selected	(UgCategory* category);	// list
UgDataset*	ug_category_get_cursor		(UgCategory* category);

void		ug_category_append  (UgCategory* category, UgDataset* list);
void		ug_category_prepend (UgCategory* category, UgDataset* list);
void		ug_category_delete  (UgCategory* category, UgDataset* list);
void		ug_category_move_to (UgCategory* category, UgDataset* list, UgCategory* target);

// If move download successfully, return TRUE.
gboolean	ug_category_move_selected_up   (UgCategory* category);
gboolean	ug_category_move_selected_down (UgCategory* category);
gboolean	ug_category_move_selected_to_top    (UgCategory* category);
gboolean	ug_category_move_selected_to_bottom (UgCategory* category);

// If category was updated (need redraw), return TRUE.
gboolean	ug_category_queue_refresh (UgCategory* category, GRegex* file_type_regex);
gboolean	ug_category_queue_run     (UgCategory* category);
gboolean	ug_category_clear_excess  (UgCategory* category);
// stop all running job in queuing of category.
gboolean	ug_category_stop_running  (UgCategory* category);

// queuing, completed, and recycled 3 in 1 functions
void		ug_category_apply_visible  (UgCategory* category);
void		ug_category_assign_visible (UgCategory* dest, UgCategory* src);

// clear running state in queuing of category.
void		ug_category_clear_running_state	(UgCategory* category);

void		ug_category_in_markup (UgCategory** category, GMarkupParseContext* context);
void		ug_category_to_markup (UgCategory** category, UgMarkup* markup);


#ifdef __cplusplus
}
#endif

#endif  // End of UG_CATEGORY_H

