/* ==================================================== ======== ======= *
*
*  uupane.cpp
*  Ubit Project [Elc][2003]
*  Author: Eric Lecolinet
*
*  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
*
*  (C) 1999-2003 Eric Lecolinet @ ENST Paris
*  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
*
* ***********************************************************************
* COPYRIGHT NOTICE :
* THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE
* IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.
* YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU
* GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION;
* EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
* SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
* ***********************************************************************
*
* ==================================================== [Elc:03] ======= *
* ==================================================== ======== ======= */

//pragma ident	"@(#)uupane.cpp	ubit:03.05.05"
#include <ubrick.hpp>
#include <ucond.hpp>
#include <ucall.hpp>
#include <ucolor.hpp>
#include <usymbol.hpp>
#include <uborder.hpp>
#include <uevent.hpp>
#include <ubox.hpp>
#include <uboxImpl.hpp>
#include <uscrollbar.hpp>
#include <upane.hpp>
#include <ustyle.hpp>
#include <ugraph.hpp>
#include <uview.hpp>
#include <uviewImpl.hpp>
#include <ugadgets.hpp>
#include <ucall.hpp>
#include <update.hpp>

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
// UPane

UStyle *UPane::style = null;

const UStyle& UPane::makeStyle() {
  if (!style) {
    style = new UStyle();
    style->viewStyle      = &UPaneView::style;
    style->orient         = UOrient::HORIZONTAL;
    style->local.halign   = UHalign::FLEX;
    style->local.valign   = UValign::FLEX;
    style->local.hspacing = 1;
    style->local.vspacing = 1;
    //style->local.padding.set(1,1);
    // keep initial size
    style->local.height   = UHeight::KEEP_SIZE; // !!
    style->local.width    = UWidth::KEEP_SIZE;  // !!
  }
  return *style; 
}

/* ==================================================== ======== ======= */

UPane& upane(const UArgs& a) {return *new UPane(a);}

UScrollpane& uscrollpane(const UArgs& a) {
  return *(new UScrollpane(a));
}

UScrollpane& uscrollpane(int vs_mode, int hs_mode, const UArgs& a) {
  return *(new UScrollpane(vs_mode, hs_mode, a));
}

/* ==================================================== ======== ======= */

UPane::UPane(const UArgs& a): UBox(a) {
  hscrollbar = null;
  vscrollbar = null;
  addAttr(UOn::viewResize / ucall(this, &UPane::viewResized));
}

UPane::~UPane() {
  //!!Att: scrollbar pas forcement enfnats du Pane !
  // (seront automatiquement detruit via le DAG inutile de s'en charger ici)
  if (vscrollbar) vscrollbar->setPane(null); vscrollbar = null;
  if (hscrollbar) hscrollbar->setPane(null); hscrollbar = null;
}

UScrollpane::UScrollpane(int vs_mode, int hs_mode, const UArgs& a)
  : UPane() {
  constructs(vs_mode, hs_mode, a);
}

UScrollpane::UScrollpane(const UArgs& a)
  : UPane() {
  constructs(true, true, a);
}

void UScrollpane::constructs(int vs_mode, int hs_mode, const UArgs& a) {
  // are scrollbars overlaid ?
  bool overlaid = (UAppli::getDefaults().scrollpane_mode & UScrollbar::TRANSP) != 0;
  UArgs ba;

  if (vs_mode) {
    vscrollbar = new UScrollbar(UOrient::vertical);
    if (overlaid) vscrollbar->setTransparent(true);

    ba += UValign::flex + UHalign::right + vscrollbar;
    vscrollbar->setPane(this);
  }

  if (hs_mode) {
    hscrollbar = new UScrollbar(UOrient::horizontal);
    if (overlaid) hscrollbar->setTransparent(true);

    ba += UValign::bottom + UHalign::flex + hscrollbar;
    hscrollbar->setPane(this);
  }

  // ne pas mettre dans addlist sinon removeAll enleve les scrollbars
  addAttr(new UBorder(overlaid, ba));
  addlist(a);
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UScrollbar* UPane::getHScrollbar() {return hscrollbar;}
UScrollbar* UPane::getVScrollbar() {return vscrollbar;}

UBoxLink* UPane::getViewportLink() {
  for (ULink *l = getChildLinks(); l != null; l = l->getNext()) {
    //if (dynamic_cast<UBox*>(l->brick()))
    if (l->getChild()->boxCast()) return static_cast<UBoxLink*>(l);
  }
  return null;    // not found
}

UBox* UPane::getViewport() {
  UBoxLink* l = getViewportLink();
  //return (l ? dynamic_cast<UBox*>(l->brick()) : null);
  return (l ? l->getChild()->boxCast() : null);
}

UView *UPane::getViewportView(UView *pane_view) {
  UBoxLink* l = getViewportLink();
  return (l ? l->getViewInside(pane_view) : null);
}

// Set the Vertical and Horizontal Scrollbars
// Notes:
// - if 'add_to_pane' is true (default case), the scrollbar is added to
//   the Pane child list and it will appear inside the Pane.
// - otherwise, the scrollbar is NOT added to the Pane and MUST be added
//   as a child of another box. This makes it possible to CONTROL a Pane
//   by a scrollbar that is NOT included in this Pane.

/**** A REVOIR

void UPane::setVScrollbar(UScrollbar *sc, bool add_to_pane) {
  // enleve le scrollbar du Pane (s'il y est: sinon ne fait rien)
  // mais NE LE DETRUIT PAS (car on ne sait pas qui a cree ce scrollbar:
  // il n'a pas forcement ete cree par le UPane ou le Scrollpane)
  if (vscrollbar) {
    vscrollbar->setPane(null);
    remove(vscrollbar, false);
  }
  vscrollbar = sc;
  if (sc) {
    sc->setPane(this);
    if (add_to_pane) {
      add(UValign::flex);
      add(UHalign::right);
      add(sc);
      // pour que les add() suivants mettent les enfants en zone centrale
      add(UHalign::flex);
    }
  }
}

void UPane::setHScrollbar(UScrollbar *sc, bool add_to_pane) {
  // enleve le scrollbar du Pane (s'il y est: sinon ne fait rien)
  // mais NE LE DETRUIT PAS!
  if (hscrollbar) {
    hscrollbar->setPane(null);
    remove(hscrollbar, false);
  }
  hscrollbar = sc;
  if (sc) {
    sc->setPane(this);
    if (add_to_pane) {
      add(UValign::bottom);
      add(UHalign::flex);
      add(sc);
      // pour que les add() suivants mettent les enfants en zone centrale
      add(UValign::flex);
    }
  }
}
***/


/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

float UPane::getXScroll() {return xscroll;}
float UPane::getYScroll() {return yscroll;}

// synchronizes the scrollbars (att aux loops!)

void UPane::setScroll(float new_xscroll, float new_yscroll) {

  if (hscrollbar || vscrollbar) { // if associated scrollbars
    // if scrollbars attached to the pane, recompute xscroll, yscroll
    // before moving the scrollbars (3e arg false => do not update the
    // pane view as this can possibly update the scrollbar and lead
    // to incoherencies)
    scrollImpl(new_xscroll, new_yscroll, true, true, false);

    if (hscrollbar) {
      // set and correct value but do not update
      hscrollbar->setValueImpl(xscroll, false);
      // getValue() : valeur corrigee par UScrollbar::setValueImpl()
      new_xscroll = hscrollbar->getValue();
    }

    if (vscrollbar) {
      vscrollbar->setValueImpl(yscroll, false);
      new_yscroll = vscrollbar->getValue();
    }
  }

  // update pane view
  scrollImpl(new_xscroll, new_yscroll, true, true, true);

  // update scrollbars
  if (hscrollbar) hscrollbar->setValueImpl(xscroll, true);
  if (vscrollbar) vscrollbar->setValueImpl(yscroll, true);
}

void UPane::setXScroll(float new_xscroll) {
  if (hscrollbar) {
    scrollImpl(new_xscroll, -100, true, false, false);
    // set and correct value but do not update
    hscrollbar->setValueImpl(xscroll, false);
    new_xscroll = hscrollbar->getValue();
  }
  scrollImpl(new_xscroll, -100, true, false,true);

  // update scrollbar
  if (hscrollbar) hscrollbar->setValueImpl(xscroll, true);

  // must also update the other scrollbar if overlaid
  // (because the scroll of the pane excludes scrollbar areas)
  if (vscrollbar /* && vscrollbar->isTransparent()*/) 
    vscrollbar->setValueImpl(yscroll, true);
}

void UPane::setYScroll(float new_yscroll) {
  if (vscrollbar) { // if associated scrollbars
    scrollImpl(-100, new_yscroll, false, true, false);
    // set and correct value but do not update
    vscrollbar->setValueImpl(yscroll, false);
    new_yscroll = vscrollbar->getValue();
  }
  scrollImpl(-100, new_yscroll, false, true, true);

  if (vscrollbar) vscrollbar->setValueImpl(yscroll, true);
  if (hscrollbar /* && hscrollbar->isTransparent()*/) 
  hscrollbar->setValueImpl(xscroll, true);
}

/* ==================================================== ======== ======= */
// NB: does not synchronizes the scrollbars (to avoid a loop
//     when called from scrollbar->setValueImpl)
// de plus ne controle pas les valeurs des scrolls

void UPane::scrollImpl(float new_xscroll, float new_yscroll, 
		       bool upd_x, bool upd_y, bool update_pane) {

  if (new_xscroll < 0) new_xscroll = 0;
  else if (new_xscroll > 100) new_xscroll = 100;

  if (new_yscroll < 0) new_yscroll = 0;
  else if (new_yscroll > 100) new_yscroll = 100;


  // pour toutes les Views de 'pane' 
  int xoffset_max = 0, yoffset_max = 0;
  for (ULinkLink *ll = getParentList().first(); ll; ll = ll->getNext()) {

    // NB: au moins UBoxLink* par construction
    UBoxLink *link = static_cast<UBoxLink*>(ll->link());
    UView *winview = null;

    for (UView* view = link->getViews(); 
	 view != null; view = view->getNext()) {
      // UPaneView par construction
      UPaneView *pane_view  = dynamic_cast<UPaneView*>(view);
      if (pane_view && (winview = pane_view->getHardwinView())) {

	UView *viewport_view = getViewportView(pane_view);
	if (viewport_view) {

	  UEvent e(UEvent::viewPaint, null, winview, null);
	  e.locateSource(viewport_view);
	  int xoffset = 0, yoffset = 0;
	  int deltax= 0, deltay = 0;
	  
	  if (upd_x) {		// horizontal scroll
	    int viewport_w = pane_view->getWidth()
	      - pane_view->margins.left - pane_view->margins.right;

	    xoffset = int(new_xscroll 
			  * (viewport_view->getWidth() - viewport_w) / 100.0);

	    if (update_pane && xoffset >= 0) {
	      deltax = xoffset - pane_view->getXScroll() ;
	      //NB: setXScroll ne fait pas de update
	      pane_view->setXScroll(xoffset);
	    }
	  }

	  if (upd_y) {               // vertical scroll
	    int viewport_h = pane_view->getHeight()
	      - pane_view->margins.top - pane_view->margins.bottom;
	    
	    yoffset = int(new_yscroll
			  * (viewport_view->getHeight() - viewport_h) / 100.0);

	    if (update_pane && yoffset >= 0) {
	      deltay = yoffset - pane_view->getYScroll() ;
	      //NB: setYScroll ne fait pas de update
	      pane_view->setYScroll(yoffset);
	    }
	  }
	  
	  if (xoffset >= 0 && yoffset >= 0) {
	    xoffset_max = std::max(xoffset_max, xoffset);
	    yoffset_max = std::max(yoffset_max, yoffset);
	    
	    // fait une copie d'ecran et ne genere que la partie manquante
	    if (update_pane) {
	      UUpdate upd(UUpdate::SCROLL);
	      upd.setOffset(deltax, deltay);
	      viewport_view->getBox()->updateView(e, viewport_view, upd);
	    }
	  }
	}
      }
    }
  }

  // correction du scroll en fonction des contraintes du pane
  // (typiquement si le vieport est plus petit que le scrollpane)
  if (upd_x) {
    if (xoffset_max == 0) xscroll = 0;
    else xscroll = new_xscroll;
  }
  if (upd_y) {
    if (yoffset_max == 0) yscroll = 0;
    else yscroll = new_yscroll;
  }
}

/* ==================================================== ======== ======= */

void UPane::viewResized(UEvent& e) {
  UPaneView *pane_view  = dynamic_cast<UPaneView*>(e.getView());

  if (hscrollbar) {
    int viewport_w = pane_view->getWidth()
      - pane_view->margins.left - pane_view->margins.right;  // !!NEWBUG

    UView *viewport_view = getViewportView(pane_view);
    if (!viewport_view) return;

    // corrbug div by 0 [jan03]
    if (viewport_view->getWidth() == viewport_w)
      hscrollbar->setValue(0);
    else {
      int xoffset = int(hscrollbar->getValue()
			* (viewport_view->getWidth() - viewport_w) / 100.0);
      float newscroll = 
	(float)xoffset / (viewport_view->getWidth() - viewport_w) * 100.0;

      hscrollbar->setValue(newscroll);
    }
   }

  if (vscrollbar) {
    int viewport_h = pane_view->getHeight()
      - pane_view->margins.top - pane_view->margins.bottom; // !!NEWBUG

    UView *viewport_view = getViewportView(pane_view);
    if (!viewport_view) return;

    // corrbug div by 0 [jan03]
    if (viewport_view->getHeight() == viewport_h)
      vscrollbar->setValue(0);
    else {
      int yoffset = int(vscrollbar->getValue()
			* (viewport_view->getHeight() - viewport_h) / 100.0);
      float newscroll =
	(float)yoffset / (viewport_view->getHeight() - viewport_h) * 100.0;

      vscrollbar->setValue(newscroll);
    }
  }
}

/* ==================================================== ======== ======= */
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UViewStyle UPaneView::style(&UPaneView::makeView, UMode::UCONST);

UPaneView::UPaneView(UBoxLink *box_link, UView* par_view, UWinGraph *wgraph) 
  : UView(box_link, par_view, wgraph)
{
  xscroll = yscroll = 0;
  margins.set(0,0,0,0);
}

// "static" constructor used by UViewStyle to make a new view

UView* UPaneView::makeView(UBoxLink*bl, UView* parview, 
			     UWinGraph* wgraph) {
  return new UPaneView(bl, parview, wgraph);
}

UPane *UPaneView::getPane(){  // same as getBox() but with correct type
  return (boxlink ? dynamic_cast<UPane*>(boxlink->getChild()) : null);
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */

