/* ==================================================== ======== ======= *
 *
 *  udefs.hpp
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _udefs_hpp_
#define	_udefs_hpp_

#include <string>
#include <vector>
#include <list>

#define null  0
typedef signed int    u_pos;	// !!must be signed!!
typedef signed int    u_dim;	// !!must be signed!!
typedef unsigned int  u_count;	// !unsigned!
typedef unsigned long u_id;	// !unsigned!
typedef unsigned long u_time;	// !unsigned!
typedef unsigned long u_modes;	// !!must be coherent with umode.hh!!
typedef signed char   u_state;	// !!must be coherent with umode.hh!!


/** File status returned by functions that open files.
 */
struct UFilestat {
  enum {
    UnknownType   = -5,
    MiscError     = -4,
    NoMemory      = -3,
    InvalidData   = -2,
    CannotOpen    = -1,
    NotOpened     =  0,
    Opened        =  1
  };
};

// pre defs.
class UBrick;
class UIntgBase;
class UFloatBase;
class UIntg;
class UFloat;

class UProp;
class UScale;
class UColor;
class UBgcolor;
class UFont;
class UFontDesc;
class UBorder;
class UCursor;

class UElem;
class UStr;
class UPix;
class UIma;

class UCond;
class UOn;
class UFlag;

class UMode;
class UGroup;
class UBox;
class UWin;
class UArgs;
class UView;

class UDisp;
class UAppli;
class UInput;
class UTimer;

struct URegion;
struct UMargins;
class UEvent;
class UGraph;
class UWinGraph;
class ULink;
class UContext;
class UStyle;
class UContext;

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
#endif
