/* ==================================================== ======== ======= *
 *
 *  uargs.hh : class for creating argument lists (additive notation).
 *  Ubit Project  [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

#ifndef _uargs_hh
#define	_uargs_hh
//pragma ident	"@(#)uargs.hh	ubit:03.04.00"


class UArgsImpl;

/** UArgs: list of arguments that is passed to UGroups and subclasses.
 *
 *  This class makes it possible to create lists of UBricks by using
 *  the + operator. It is used as the main argument of class UGroup
 *  and its subclasses (UBox, UWin, UButton, UDialog, UMenu...)
 *
 *  Notes:
 *  - UArgs::none is the empty args list
 *  - assigment is forbidden.
 *  - the implementation of this class is based on the internal class
 *    UArgsImpl that should not be used directly by clients. 
 */
class UArgs {
  friend class UGroup;
  friend class UBox;
  friend class UArgsImpl;

  UArgs& operator=(const UArgs&);  // assigment is forbidden
  class UArgsChain* children;

public:
  static const UArgs none;

  UArgs();
  ~UArgs();
  UArgs(const UArgs&);
  UArgs(const UArgsImpl&);
  UArgs(const char*);
  UArgs(class UBrick*);
  UArgs(class UBrick&);
  UArgs(class ULink&);
  UArgs(class ULink*);

  UArgs& operator+=(const UArgs&);

  friend const UArgsImpl& operator+(const UArgsImpl&, const char*);
  friend const UArgsImpl& operator+(const UArgsImpl&, class UBrick*);
  friend const UArgsImpl& operator+(const UArgsImpl&, class UBrick&);
  friend const UArgsImpl& operator+(const UArgsImpl&, class ULink&);
  friend const UArgsImpl& operator+(const UArgsImpl&, class ULink*);
  friend const UArgsImpl& operator+(const UArgsImpl&, const UArgs&);
};

/* ==================================================== ======== ======= */

/** UArgsImpl: implementation of UArgs (should not be used directly by clients).
 */
class UArgsImpl {
  friend class UGroup;
  friend class UBox;
  friend class UArgs;

  UArgsImpl& operator=(const UArgsImpl&);  // assigment is forbidden
  class UArgsChain* children;

public:
  UArgsImpl();
  ~UArgsImpl();
  UArgsImpl(const UArgsImpl&);
  UArgsImpl(const UArgs&);
  UArgsImpl(const char*);
  UArgsImpl(class UBrick*);
  UArgsImpl(class UBrick&);
  UArgsImpl(class ULink&);
  UArgsImpl(class ULink*);

  friend const UArgsImpl& operator+(const UArgsImpl&, const char*);
  friend const UArgsImpl& operator+(const UArgsImpl&, class UBrick*);
  friend const UArgsImpl& operator+(const UArgsImpl&, class UBrick&);
  friend const UArgsImpl& operator+(const UArgsImpl&, class ULink&);
  friend const UArgsImpl& operator+(const UArgsImpl&, class ULink*);
  friend const UArgsImpl& operator+(const UArgsImpl&, const UArgs&);
};

#endif
/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:02] ======= */
